
; Define RC5 address of Remote Control

RemoteAddr	EQU	0x06

; Definition of Keys and key-codes on my remote control

NUM_0	EQU	0x00
NUM_1	EQU	0x01
NUM_2	EQU	0x02
NUM_3	EQU	0x03
NUM_4	EQU	0x04
NUM_5	EQU	0x05
NUM_6	EQU	0x06
NUM_7	EQU	0x07
NUM_8	EQU	0x08
NUM_9	EQU	0x09
FREEZE	EQU	0x5D
PAUSE	EQU	0x30
STANDBY	EQU	0x0C
MUTE	EQU	0x0D
HELP	EQU	0x2F
TEXT	EQU	0x0D	;Mute
VOL_UP	EQU	0x07	;7
VOL_DN	EQU	0x0A	;-/--
BRI_UP	EQU	0x03	;3
BRI_DN	EQU	0x06	;6
SAT_UP	EQU	0x02	;2
SAT_DN	EQU	0x05	;5
BAS_UP	EQU	0x16
BAS_DN	EQU	0x17
TRE_UP	EQU	0x18
TRE_DN	EQU	0x19
BAL_RI	EQU	0x10	;Vol+
BAL_LE	EQU	0x11	;Vol-
CON_UP	EQU	0x20	;CH+
CON_DN	EQU	0x21	;CH-
HUE_UP	EQU	0x01	;1
HUE_DN	EQU	0x04	;4
SHA_UP	EQU	0x4D
SHA_DN	EQU	0x4E
PHA_UP	EQU	0x08	;8
PHA_DN	EQU	0x00	;0
ADJUST	EQU	0x52
EXIT	EQU	0x53
ADDR	EQU	0x54
ASTRSK 	EQU	0x2D	;->.
ENTER	EQU	0x57
F1	EQU	0x32	;<<
F2	EQU	0x35	;>
F3	EQU	0x34	;>>
F4	EQU	0x3F	;CH.PIC
F5	EQU	0x36	;[]
CUR_UP	EQU	0x50
CUR_RI	EQU	0x56
CUR_DN	EQU	0x51
CUR_LE	EQU	0x55

; Definition of Functions on the Propeller clock

SEC_UP		EQU	VOL_UP
SEC_DN		EQU	VOL_DN
MIN_UP		EQU	BAL_RI
MIN_DN		EQU	BAL_LE
HOUR_UP		EQU	CON_UP
HOUR_DN		EQU	CON_DN
DAY_UP		EQU	BRI_UP
DAY_DN		EQU	BRI_DN
MON_UP		EQU	SAT_UP
MON_DN		EQU	SAT_DN
YEAR_UP		EQU	HUE_UP
YEAR_DN		EQU	HUE_DN
INDEX_UP	EQU	PHA_UP
INDEX_DN	EQU	PHA_DN

BlueLine	EQU	F1
DigiTime	EQU	F2
DigiDate	EQU	F3
AnaTime		EQU	F4
TTicks		EQU	F5

DM		EQU	ASTRSK	;Demo Mode
TextMode	EQU	TEXT
