 /*********************************************************
 FutesEmelet
 Hőmerseklet,paratartam meres DHT22 gpio12 D6
 wattos impulzus szamolas
 bekapcsolasok szamolasa
 Wifi csatlakozas, kapcsolat jelzes 
 bekapcsolas jelzes
 web szerver (82)          
 MQTT szerever (1883)
 soros port adat kiiras
 ***********************************************************
 Eredeti Rui Santos
 Complete project details at http://randomnerdtutorials.com
 En meg kokanyoltam hozza 20171222-20180102
 ***********************************************************
 bemenetek: gpio 13 D7 wattos impulzus számolás
            gpio 14 D5 bekapcsolas szamolas
            gpio 12 D6 DHT22
 kimenetek: gpio  4 D1 wifi kapcsolat
            gpio  5 D2 engedelyezes/tiltas     
 soros port baud 115200                 
************************************************************/
//#include <Wire.h> //I2C library
//#include <RtcDS3231.h> //RTC library
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
#include <PubSubClient.h>
#include <ESP8266mDNS.h>
#include "Adafruit_MQTT.h"
#include "Adafruit_MQTT_Client.h"
#include <Adafruit_Sensor.h>
#include <DHT.h >  
#define DHTPIN 12 
#define DHTTYPE DHT22              
DHT dht(DHTPIN, DHTTYPE);
MDNSResponder mdns;

const byte interruptPin = 14;
volatile byte intCount = 0;
int intCount2 = 0;

// Halozat config *******************************
const char* ssid = "NetgearSP";
const char* password = "s_1955_P";
WiFiServer server(82);
WiFiClient wifiClient;
PubSubClient client(wifiClient);
// mqtt config **********************************
const char* broker = "192.168.1.12";
const char* topic1 = "*FutesEmelet/Temp";
const char* topic2 = "*FutesEmelet/Humi";
const char* topic3 = "*FutesEmelet/Bszam";
const char* topic4 = "*FutesEmelet/Fogy";
const char* topic5 = "*FutesEmelet/All";
const char* clientName = "Raspi2";

int be_pin = 13;
int jel_pin = 5;                  //wifi kapcsolat
int fut_pin = 4;                  //futes allapota
int bszam = 0 ;                   //bekapcsolasok szama
int fszam = 0 ;                   //fogyaszatas impulzusok szama
float fogy  = 0.00 ;                 //fogyasztas 
float fogy2 =0.00;
int keres = LOW;                  //HTML keres
int fut =0;                       //impulzus szamolas
int fut2=0;                       //MQTT adatkuldes
float t,h;
float temp = 0.00 ;               //homerseklet
float humi =0.00 ;                //paratartam
String payload;                   //homerseklet
String payload2;                  //paratartam
String payload3;                  //bekapcsolasok szama
String payload4;                  //fogyasztas
String payload5;                  //futes allapota2
String be_e ="Tiltva";            //futes allapota
String be_pin2 ="Kikapcsolva";    //futes allapota

void setup(void){    //****************************************
 // gpio-k beallitas
pinMode(interruptPin, INPUT_PULLUP);
attachInterrupt(digitalPinToInterrupt(interruptPin), handleInterrupt, FALLING);

 pinMode(jel_pin, OUTPUT);
 digitalWrite(jel_pin, LOW);
 pinMode(fut_pin, OUTPUT);
 digitalWrite(fut_pin, LOW);
 
 delay(1000);
 Serial.begin(115200);
 client.setServer(broker, 1883);
 dht.begin();
 delay(10);
 
 WiFi.begin(ssid, password);
 Serial.println("");
 // Csatlakozas wifi-hez
 Serial.print("Csatlakozas a WiFi-hez");
 while (WiFi.status() != WL_CONNECTED) {
 delay(300);
 Serial.print(".");
 
 pinMode(jel_pin, OUTPUT);        //villog a led 
 digitalWrite(jel_pin, HIGH);
 delay(15);
 digitalWrite(jel_pin, LOW);
 } // while vege

 if (WiFi.status()!= WL_CONNECTED) {
 } else {                      // van kapcsolat led bekapcsolas
    pinMode(jel_pin, OUTPUT); 
    digitalWrite(jel_pin, HIGH);
    }
 
 Serial.println("");
 Serial.print("Csatlakozott: ");
 Serial.println(ssid);
 Serial.print("IP cim: ");
 Serial.println(WiFi.localIP());
 IPAddress atjaro = WiFi.gatewayIP();
 Serial.print("Atjaro: ");
 Serial.println(atjaro);
 
 if (mdns.begin("NODEMCU", WiFi.localIP())) {
 Serial.println("MDNS responder started");
 }

if (client.connect(clientName)) {
        Serial.print("Csatlakozas az MQTT brokerhez ");
        Serial.print(broker);
        Serial.print(" ");
        Serial.println(clientName);
        Serial.print("Hely: ");
        Serial.println(topic1);
    }
    else {
        Serial.println("MQTT csatlakozasi hiba");
        abort();
    }
 
 server.begin();
 Serial.println("HTTP server indult a 82 porton");
 
}                                      //setup void vege

void mqttReConnect() {
    while (!client.connected()) {
        Serial.print("Attempting MQTT connection...");
        // Attempt to connect
        if (client.connect(clientName)) {
            Serial.println("csatlakozas");
            client.subscribe(topic1);
        } else {
            Serial.print("failed, rc=");
            Serial.print(client.state());
            Serial.println(" try again in 5 seconds");
            delay(5000);
        }
    }
}

void mqtt(){    //adat kuldes *************************************
client.connect(clientName);
//client.setServer(broker, 1883);
payload= (String) temp;
payload2= (String) humi;
payload3= (String) bszam;
payload4= (String) fogy2;
payload5= (String) be_pin2;
if (client.connected()) {
  if (client.publish(topic1, (char*) payload.c_str())) {
      Serial.print("TempAdatkuldes OK (");
      Serial.print(payload);
      Serial.println(")");
  } else {
          Serial.println("Ugyfel HIBA!");
        }
   if (client.publish(topic2, (char*) payload2.c_str())) {
      Serial.print("HumiAdatkuldes OK (");
      Serial.print(payload2);
      Serial.println(")");
   } else {
          Serial.println("Ugyfel HIBA!");
        }
    if (client.publish(topic3, (char*) payload3.c_str())) {
        Serial.print("BszamAdatkuldes OK (");
       Serial.print(payload3);
       Serial.println(")");
    } else {
          Serial.println("Ugyfel HIBA!");
        }

    if (client.publish(topic4, (char*) payload4.c_str())) {
       Serial.print("FogyAdatkuldes OK (");
       Serial.print(payload4);
       Serial.println(")");
    } else {
       Serial.println("Ugyfel HIBA!");
        }
 
     if (client.publish(topic5, (char*) payload5.c_str())) {
       Serial.print("AllapotKuldes OK (");
       Serial.print(payload5);
       Serial.println(")");
     } else {
       Serial.println("Ugyfel HIBA!");
        }
  
   } else {
        mqttReConnect();
   }
   fut2=0;
}

void handleInterrupt() {
  intCount++;               //megszakitas szamlalo
}

void meres(){    //dht meres ***************************
// Reading temperature or humidity takes about 250 milliseconds!
  // Sensor readings may also be up to 2 seconds 'old' (its a very slow sensor)
  float h = dht.readHumidity();
  // Read temperature as Celsius (the default)
  float t = dht.readTemperature();
  // Read temperature as Fahrenheit (isFahrenheit = true)
  float f = dht.readTemperature(true);

  // Check if any reads failed and exit early (to try again).
  if (isnan(h) || isnan(t) || isnan(f)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }
  temp=t;
  humi=h;
// Compute heat index in Fahrenheit (the default)
  float hif = dht.computeHeatIndex(f, h);
  // Compute heat index in Celsius (isFahreheit = false)
  float hic = dht.computeHeatIndex(t, h, false);
fut=0;
}
      
void loop () {      //*********************** Fociklus ***************** 
 if(intCount>0){         //megszakitas van
  delay(5);              //pergesmentesites
    intCount=0;
    intCount2++;
    fogy=fogy+2.5;       //Wh1 impulzus 2,5Wh, 400impulzus 1KWh
    fogy2=fogy/1000;     //KWH
      
  }
fut=fut+1;               //meres gyakorisag szamlalo
  if (fut>=2){
      meres();
  }
//meres();  

fut2=fut2+1;      
  if (fut2>=100){          //adatkuldes szamlalo
      mqtt();
  }

// futes allapo valtozas figyeles *******************************
if (digitalRead(13)==0){
      if (be_pin2=="Kikapcsolva") {
      bszam=bszam+1;
      be_pin2="Bekapcsolva";
      }    
  }
  if (digitalRead(13)==1) {
     if (be_pin2=="Bekapcsolva"){
      be_pin2="Kikapcsolva";
     }  
  }      
// kapcsolat ellenorzes, LED villogtatas *********
 if (WiFi.status()!= WL_CONNECTED) {
     Serial.println("Nincs kapcsolat, ujra cstlakozas");
     client.loop(); 
 }
    else {                             // van kapcsolat led villog
    delay(300);
    pinMode(jel_pin, OUTPUT); 
    digitalWrite(jel_pin, LOW);
    delay(300);
    pinMode(jel_pin, OUTPUT); 
    digitalWrite(jel_pin, HIGH);
    }

// Varakozas az ugyfel csatlakozasa ************
  WiFiClient client = server.available();
  if (!client) {
    return;
  }
 
// Varakozas adat elkuldesre ***********
  Serial.println("uj kliens");
  while(!client.available()){
    delay(1);
  }
 
// Elso sor olvasasa ************
  String request = client.readStringUntil('\r');
  Serial.println(request);
  client.flush();
 
// Keres kivalasztasa *********
  if (request.indexOf("/Engedelyezes") != -1)  {
     digitalWrite(fut_pin, HIGH);
     keres = HIGH;
     be_e= "Engedelyezve";
  }
  if (request.indexOf("/Tiltas") != -1)  {
     digitalWrite(fut_pin, LOW);
     keres = LOW;
     be_e="Tiltva";
  }
 if (request.indexOf("/Nullazas") != -1)  {
     //digitalWrite(fut_pin, LOW);
     //value = LOW;
     bszam=0;
  }

  // HTML********************************************
  client.println("HTTP/1.1 200 OK");
  client.println("Content-Type: text/html");
  client.println(""); 
  client.println("<!DOCTYPE HTML>");
  client.println("<html>");
  client.println("<body bgcolor = aqua >"); 
  client.println("<h1>FutesEmelet (c) Pepeba</h1>");
  client.print("<b>FutesAllapota: ");
  client.print(be_e);
  client.print(" /  ");
  client.print(be_pin2);
  client.print("<p>BekapcsolasokSzama: ");
  client.print(bszam);
  client.print("<p>Impuzus szam: ");
  client.print(intCount2);
  client.print("<p>Fogyasztas: ");
  client.print(fogy2);
  client.print(" KWh <p>Homerseklet: ");
  client.print(temp);
  client.print(" *C <p>Paratartam: ");
  client.print(humi);
  // client.println("<br><br>");
  client.print(" % <p>Futes: ");
  client.println("<a href=\"/Engedelyezes\"\"><button>Engedelyezes </button></a>");
  client.println("<a href=\"/Tiltas\"\"><button>Tiltas </button></a>"); 
  client.println("<a href=\"/Nullazas\"\"><button>Nullazas </button></a>"); 
  client.println("<a href=\"/Frissites\"\"><button>Frissites </button></a><br />"); 
  client.println("</html>");
  delay(1);
  Serial.println("Cliens lecsatlakozott");
  Serial.println("");
} // fociklus vége ************************************


