/************************************************************
* Thermometer und Hygrometer mit SHT 21 und Nixie Rhren
************************************************************/
#include <16F876A.h>
#fuses HS,NOWDT,NOPROTECT,NOLVP,NOBROWNOUT
#use delay(clock=6000000)
#use fast_io(A)
#use fast_io(B)
#use fast_io(C)

#use rs232(baud=9600,xmit=PIN_A2)	// Pin 4
//#use i2c(master,sda=PIN_C4,scl=PIN_C3,SLOW,FORCE_HW)

//#include "I2C_HAL.c"
#include "i2c_bb.c"
#include "SHT2x.c"

char bcdtab[10] = {8,0,9,1,14,6,10,2,12,4};

u8t  error = 0;              //variable for error code. For codes see system.h
u8t  userRegister;           //variable for user register

nt16 sRH;                    //variable for raw humidity ticks
ft   humidityRH;             //variable for relative humidity[%RH] as float
nt16 sT;                     //variable for raw temperature ticks
ft   temperatureC;           //variable for temperature[&#65533;C] as float
u8t  SerialNumber_SHT2x[8];  //64bit serial number
char hum_str[5];
char temp_str[5];

#define on 1
#define off 0

//RTC variables
#define XTAL_FREQUENCY  6000000
#define TIMER1_FREQUENCY (XTAL_FREQUENCY / 4)      // 1 clock tick = 1 instr. cycle = crystal frequency / 4
int32 Ticker;
int8 Seconds=0;
int8 Year=0,Month=0,Days=0,Hours=0,Minutes=0;

////////////////////////////////////////////////////////////////////////////////
// Test whether a given year is a leap year.
// This optimized version only works for the period 2001 - 2099
////////////////////////////////////////////////////////////////////////////////
#define IS_LEAP(year) (year%4 == 0)
/*************************************************************************************************/
////////////////////////////////////////////////////////////////////////////////
//    Initialize RTC
////////////////////////////////////////////////////////////////////////////////
void Initialize_RTC(void)
{
  Ticker = TIMER1_FREQUENCY;                  // initialize clock counter to number of clocks per second
  setup_timer_1( T1_INTERNAL | T1_DIV_BY_1 ); // initialize 16-bit Timer1 to interrupt
                                              // exactly every 65536 clock cycles
                                              // (about 76 times per second)
  enable_interrupts( INT_TIMER1 );            // Start RTC
}

////////////////////////////////////////////////////////////////////////////////
//  -=Process Zero Drift Real Time Clock Information=-
//
// Most algorithms configure the timer to generate an interrupt every 100ms, and
// then count the number of interrupts. The problem in that approach is that most
// clock frequencies can't be divided by 256 and you don't get an exact 100ms.
// The small errors will add up to an error of several seconds a day.
//
// The algorithm presented here is exact in the long run because it doesn't
// count the number of interrupts but counts the number of clock cycles.
////////////////////////////////////////////////////////////////////////////////
#int_TIMER1                               
void TIMER1_isr()                         
{
  byte i;
  Ticker -= 65536;                        // Decrement ticker by clocks per interrupt
  if ( Ticker < 65536 )                   // If second has expired
  {  Ticker += TIMER1_FREQUENCY;          //   Increment ticker by clocks per second
     seconds++;                           //   Increment number of seconds
  }

  /* --- Optional part start ---*/
  if(Seconds == 60) {Minutes++; Seconds=0;
    if(Minutes == 60) {Hours++; Minutes=0;
      if(Hours == 24) {Days++; Hours=0; 
        if (  (Days == 29 && Month==2 && !IS_LEAP(Year))
           || (Days == 30 && Month==2)
           || (Days == 31 && (Month==4 || Month==6 || Month==9 || Month==11 ))
           || (Days == 32)
           ) {Month++;Days=0;}
        if(Month == 13) {Year++; Month=0;}
  }}}
   /*--- Optional part end ---  */
}

void SHT21_init ()
{
	u8t i;

    I2c_Init();		// Init ports

    // --- Reset sensor by command ---
    error |= SHT2x_SoftReset();

   // --- Set Resolution e.g. RH 10bit, Temp 13bit ---
    error |= SHT2x_ReadUserRegister(&userRegister);  //get actual user reg
    userRegister = (userRegister & ~SHT2x_RES_MASK) | SHT2x_RES_10_13BIT;
    error |= SHT2x_WriteUserRegister(&userRegister); //write changed user reg
    error |= SHT2x_ReadUserRegister(&userRegister);  //get modified user reg
    //printf("UserReg: %02X\n\r",userRegister);
/*
	SHT2x_GetSerialNumber(SerialNumber_SHT2x);
    for (i=0; i<8; i++) {
       printf("%02X",SerialNumber_SHT2x[i]);
    }
    printf("\n");   
*/
}

void SHT21_measure()
{
    // --- measure temperature with "Hold Master Mode (HM)"  ---
    error |= SHT2x_MeasureHM(TEMP, &sT);
    // --- measure humidity with "Hold Master Mode (HM)"  ---
    error |= SHT2x_MeasureHM(HUMIDITY, &sRH);
    printf("%lu,%lu\r\n",sT.u16,sRH.u16);

    //-- calculate humidity and temperature --
    temperatureC = SHT2x_CalcTemperatureC(sT.u16);
    humidityRH   = SHT2x_CalcRH(sRH.u16);

    //-- write humidity and temperature values into string buffer --
    sprintf(temp_str,"%04.1f",temperatureC);
    sprintf(hum_str,"%04.1f",humidityRH);
}

void show_digit1(char x)		// left most tube
{
    u8t digit,port;

	digit = bcdtab[x - 0x30] << 4;
	port = input_b() & 0x0f;
	output_b(port | digit);
}

void show_digit2(char x)	// second tube
{
    u8t digit,port;

	digit = bcdtab[x - 0x30];
	port = input_b() & 0xf0;
	output_b(port | digit);
}

void show_digit3(char x)	// third tube
{
    u8t digit;
// done this way in order to let the i2c ports alone
	digit = bcdtab[x - 0x30];
    output_bit(PIN_C2,(digit & 1));
    digit = digit >> 1;
    output_bit(PIN_C5,(digit & 1));
    digit = digit >> 1;
    output_bit(PIN_C6,(digit & 1));
    digit = digit >> 1;
    output_bit(PIN_C7,(digit & 1));
}

void show_unit(char x)		// right most tube
{
    u8t digit,port;

    digit = 0;
    if (x == '%')  digit = 4;
	digit = bcdtab[digit] << 4;
	port = input_a() & 0x0f;
	output_a(port | digit);
}

void dimm(u8t onoff)	// dimming of the tubes
{
    i8t i;

    if (onoff) {
      for (i=0; i<127; i++) {	// dimm on
        set_pwm2_duty(i);
	    delay_ms(10);
      }
    } else {
      for (i=127; i>=0; i--) {	// dimm off
        set_pwm2_duty(i);
	    delay_ms(10);
      }
    }
}

void switch_light(u8t onoff)
{
    if (onoff) {
        set_pwm2_duty(0);
	} else {
        set_pwm2_duty(127);
	}
}


void main(void)
{
    u8t i;

    set_tris_a(0b00001011);
    set_tris_b(0);			// all output
    set_tris_c(0);			// all output
    output_a(0);
    setup_adc_ports( RA0_RA1_RA3_ANALOG );
    output_b(0);
    output_c(0);			// also I2C output pins are 0 !!!!!
	setup_ccp2(CCP_PWM);   	// setup PWM for dimmer
	setup_timer_2(T2_DIV_BY_16, 127, 1);
	set_pwm2_duty(0);		// dimmer off
    puts("TermHygro:" __DATE__);

    SHT21_Init();
  
    Initialize_RTC();
   enable_interrupts(GLOBAL);
  while(1)
  { 
     I2c_Init();		// Init ports
	 SHT21_measure();	// measure temperature and humidity
     printf("%02d:%02d:%02d ",Hours,Minutes,Seconds);
     printf("%04.1f ",temperatureC);
     printf("%04.1f\r\n",humidityRH);
     printf("SHT21_measurement done\r\n");

     dimm(on);			// dimm the tubes		
     show_digit1(hum_str[0]);
     show_digit2(hum_str[1]);
     show_digit3(hum_str[3]);
	 show_unit('%');
     dimm(off);			// undimm the tubes

     delay_ms(5000);

     dimm(on);
     show_digit1(temp_str[0]);
     show_digit2(temp_str[1]);
     show_digit3(temp_str[3]);
	 show_unit('C');
     dimm(off);			// undimm the tubes

	 for (i=0; i<10; i++) {
	    I2c_Init();			// Init ports
	 	SHT21_measure();	// measure temperature and humidity
     	show_digit1(temp_str[0]);
     	show_digit2(temp_str[1]);
     	show_digit3(temp_str[3]);
     	delay_ms(5000);
	 }
  }
}