#include <string.h>
#include <fs.h>
String configfile = "";     //The setup.txt goes into it
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//Wifi stuff
#include <ESP8266WiFi.h>
  WiFiClient wifiClient; 
  String mac, wifissid, wifipass, ipaddress, gatewayaddress, subnetmask;
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//WebServer
#include <ESP8266WebServer.h>
  ESP8266WebServer server(80);
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//MQTT
#include <PubSubClient.h>
PubSubClient client(wifiClient);
String MqttClient, brokeraddress, brokerport, brokerid, brokerpassword, topicprefix;
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//SETUP PART
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void setup() {
  //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  //0:Start up the serial port
  Serial.begin(115200);
  Serial.println();
  //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  //1: Let's read all presistent datas and try to use it. Because of rear test "storage" gona consist the NULL termination
        //1.1 Activate SPIFFS the file system
        if (SPIFFS.begin())
            { Serial.println("SPIFFS Active");  Serial.println();
            }
            else 
            { Serial.println("File System Error");
              ReSetup("File System Error");
            }
        //1.2 Open the setup.txt file
        File f = SPIFFS.open("/setup.txt", "r"); 
        if (!f) 
           {  Serial.println("File open error or not exist");
              f.close();
              ReSetup("File open error or not exist");
            }
        //1.3 move the content of the file to the configfile string for further processing        
        configfile = f.readStringUntil('\0');        //Read till EOF
        f.close();
  //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  //2: Move all values out from the config file to the global variables
        wifissid        = ValueOfParameter ("wifissid", &configfile);
        wifipass        = ValueOfParameter ("wifipass", &configfile);
        ipaddress       = ValueOfParameter ("ipaddress", &configfile);
        gatewayaddress  = ValueOfParameter ("gatewayaddress", &configfile);
        subnetmask      = ValueOfParameter ("subnetmask", &configfile);
        brokeraddress   = ValueOfParameter ("brokeraddress", &configfile);
        //brokerport      = ValueOfParameter ("brokerport", &configfile);
        brokerid        = ValueOfParameter ("brokerid", &configfile);
        brokerpassword  = ValueOfParameter ("brokerpassword", &configfile);
        topicprefix     = ValueOfParameter ("topicprefix", &configfile);

        Serial.println("Érték a helyén: "); 
        Serial.print("\t");         Serial.print("wifissid");       Serial.print("\t"); Serial.println(wifissid);
        Serial.print("\t\t\t");     Serial.print("wifipass");       Serial.print("\t"); Serial.println(wifipass);
        Serial.print("\t\t\t");     Serial.print("ipaddress");      Serial.print("\t"); Serial.println(ipaddress);
        Serial.print("\t\t\t");     Serial.print("gatewayaddress"); Serial.print("\t"); Serial.println(gatewayaddress);
        Serial.print("\t\t\t");     Serial.print("subnetmask");     Serial.print("\t"); Serial.println(subnetmask);
        Serial.print("\t\t\t");     Serial.print("brokeraddress");  Serial.print("\t"); Serial.println(brokeraddress);
        //Serial.print("\t\t\t");   Serial.print("brokerport");     Serial.print("\t"); Serial.println(brokerport);
        Serial.print("\t\t\t");     Serial.print("brokerid");       Serial.print("\t"); Serial.println(brokerid);
        Serial.print("\t\t\t");     Serial.print("brokerpassword"); Serial.print("\t"); Serial.println(brokerpassword);
        Serial.print("\t\t\t");     Serial.print("topicprefix");    Serial.print("\t"); Serial.println(topicprefix);
          
  //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  //3: Try to connect to the wifi network
       if (WiFiConnect() != 0)
          {  ReSetup("Wifi");   
          }//3
  //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  //4: If you are here, you are on the wifi network. Let's test the MQTT server.
       //4.1: Pre-Setup the MQTT connection
              MqttClient = WiFi.macAddress();
              client.setServer(brokeraddress.c_str(), 1883);
              client.setCallback(callback);
       //brokerid, brokerpassword, topicprefix;
       //4.2: Try to connect
              if (client.connect(MqttClient.c_str(), brokerid.c_str(), brokerpassword.c_str()) == 0)
                  { Serial.println("MQTT broker connection failed");
                    ReSetup("MQTT broker connection failed");
                  }
              Serial.println("Connected to MQTT broker");

       //4.3: Connected: Try to publish
              if (client.publish("cptzoltansimon/feeds/heather.monitor", "hello from ESP8266") == 0)
                  { Serial.println("MQTT Publish failed");
                    ReSetup("MQTT Publish failed");
                  }
              Serial.println("Publish ok");
   
      //4.4:  Incoimng subscriptions: (JUST FOR TEST PURPOSES!
              client.subscribe("cptzoltansimon/feeds/heather.pumpstate",1);
              client.subscribe("cptzoltansimon/feeds/heather.pumpontemp",1);
              client.subscribe("cptzoltansimon/feeds/heather.pumpofftemp",1);
              client.subscribe("cptzoltansimon/feeds/heather.pumpmode",1);
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void loop() {
  // put your main code here, to run repeatedly:
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//Implement your incoming related MQTT code here
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void callback(viod)
      {
      }

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//Internal Functions:
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
int WiFiConnect(void) {
  unsigned char     Counter = 0;
  WiFi.mode(WIFI_STA);
  Serial.println(); Serial.print("Connecting to "); Serial.println(wifissid);
  WiFi.begin(wifissid.c_str(), wifipass.c_str());
    //Wait the connection to be ready
      Counter = 0;
         while (WiFi.status() != WL_CONNECTED) { Counter ++; delay(500); Serial.print(".");
                                                  if (Counter == 20) {  Serial.println();              Serial.println("Connection FAIL");
                                                                        return 1;                 //Was unable to connect
                                                                        //abort();  
                                                                     }
                                               }
    //Connected!
     Serial.println();              Serial.println("Connection successfull");
    //Reqest some connection related datas
     Serial.print("Local IP: ");    Serial.println(WiFi.localIP());                                 //Local IP of the node
     Serial.print("MAC Address: "); Serial.println(WiFi.macAddress());                              //MAC address of the node
    return 0;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//Phase 3, or 4 (Wifi or MQTT faliure)
void ReSetup (String FaliureLevel)
     {    //Connection was a faliure. Lets make an AP, and provide a DNS.
          //3.1: Set Up an access point wit IP: 192,168.1.1 etc. Name gona be the MAC address, wo passworld
            IPAddress local_IP(192,168,2,1); IPAddress gateway(192,168,2,1); IPAddress subnet(255,255,255,0);               //Prepare the IP's
            WiFi.softAPConfig(local_IP, gateway, subnet);                                                                   //Set up the IP's of the AP
            mac = WiFi.softAPmacAddress();                                                                                  //Get the MAC address from the module
            WiFi.softAP((char*)mac.c_str());                                                                                //Start the AP: SSID gona be the MAC address

          //3.2: Start the webserver and print out infos we need: IP + the MAC
            server.begin();
              Serial.println("Webserver started...");                                                                         // Start the webserver
              Serial.print("Use this URL to connect: http://"); Serial.println(WiFi.softAPIP());                              // Print the IP address
              Serial.print("Server's MAC address is: "); Serial.println(mac);                                                 //Print the MAC address
    
          //3.3 Next define what the server should do when a client connects
              server.on("/", MainPage);                                                                                       //Main Page

          //3.4 Wait for setup If we got it, restart gona be fullfilled from outside of this routine
              while (1) { server.handleClient();
                         }//3.4

     }//Phase 3 or 4



void MainPage (void)
     {//Gather the datas we need for connection
        String IPaddress = WiFi.softAPIP().toString();
      //Read the webpage from SPIFFS
        String webpage;   //Webpage we send to the client
        String s;         //Temporary
        File f2 = SPIFFS.open("/main.html", "r"); webpage=f2.readStringUntil('\0'); f2.close();
      // Send a response to the client asking for input
        server.send(200, "text/html", webpage);
        
      //If any arguments recieved:         
          if (server.args() > 0 ) 
             { // Arguments were received
               Serial.print("Number of arguments recieved: "); Serial.println(server.args());
               for ( uint8_t i = 0; i < server.args(); i++ )
                   {  //Print it out:
                        Serial.print(i); Serial.print(".: "); Serial.print(server.argName(i)); Serial.print(" ");Serial.println(server.arg(i));
                      //Save to the temporary string
                        s += server.argName(i); s += ':'; s += server.arg(i);  s += '\n';
                   }
            
              File f3 = SPIFFS.open("/setup.txt", "w"); f3.print(s); f3.close();
              Serial.println();
               
              Serial.println("Configuration saved, restarting module & it tries to use new configurations");
              Serial.println("If WiFi, or MQTT related datas are not correct, you gona get back the AP mode for re-setup");
              Serial.println("The error message caused, the re-setup, you'll see on the webpage error-log");
              //ESP.restart();
              }
    }//MainPage
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//Witch parameter we search, and in witch string
//The return is the value of the parameter we search for                        
String ValueOfParameter (String witch, String *pString)
    {   //Witch parameter we search:
        int from      = ((*pString).indexOf(':',   (*pString).indexOf(witch)) + 1);        //+1 mert az elválasztó karakter
        int to        = ((*pString).indexOf('\n',  (*pString).indexOf(witch)) - 0);        //LC + CR miatt
        return          ((*pString).substring(from, to));
    }
