
; Define RC5 address of Remote Control

;RemoteAddr	EQU	0x06
RemoteAddr	EQU	0x00	;URC22B, Cod: 0026

; Definition of Keys and key-codes on my remote control

STANDBY	EQU	0x0C
NUM_1	EQU	0x01	; Year Up	
NUM_2	EQU	0x02	; Year Dn 
NUM_3	EQU	0x03	; Hour Up  
NUM_4	EQU	0x04	; Hour Dn
ASTRSK 	EQU	0x0B	; WDay Up           
NUM_5	EQU	0x05	; Month Up
NUM_6	EQU	0x06	; Month Dn
NUM_7	EQU	0x07	; Minute Up
NUM_8	EQU	0x08	; Minute Dn 
ADJUST	EQU	0x26	; WDay Dn
NUM_9	EQU	0x09	; Day Up  	
NUM_0	EQU	0x00	; Day Dn 	
NUM_10	EQU	0x0A	; Seconds Up
ENTER	EQU	0x28	; Seconds Dn 
TEXT	EQU	0x0F	; TextMode On/Off
EXIT	EQU	0x24	; Alarm sound Off 	Base	
BAL_RI	EQU	0x1A	; Transformer On	Base	
BRI_UP	EQU	0x12	; PWM width Up		Base	
SAT_UP	EQU	0x14	; PWM period Up		Base	
CON_UP	EQU	0x20	; Index Up  		
NUM_E	EQU 0x0E	; TINDEX			Base	
BAL_LE	EQU	0x1B	; Transformer Off	Base	
BRI_DN	EQU	0x13	; PWM width Dn		Base	
SAT_DN	EQU	0x15	; PWM period Dn		Base	
CON_DN	EQU	0x21	; Index Dn			
PHA_UP	EQU	0x2A	; Digi time display
HUE_DN	EQU	0x22	; Analogue time	display 
PHA_DN	EQU	0x2B	; Demo mode
HUE_UP	EQU	0x38	; Ticks display
F3		EQU	0x35	; Digi date display
F5		EQU	0x37	; clear seconds	
F4		EQU	0x36	; Week days display
F2		EQU	0x32	; Rotor R/min display	
F1		EQU	0x34	; Outer led On/Off
VOL_UP	EQU	0x10	; Relay On
SHA_UP	EQU	0x2C	;	
SHA_DN	EQU	0x2D	;	
ADDR	EQU	0x3F	; SET_SP ???
MUTE	EQU	0x0D	; Index LED On/Off
VOL_DN	EQU	0x11	; Relay Dn
PAUSE	EQU	0x3C	; TSecMode

FREEZE	EQU	0x29	;TStaticText



BAS_UP	EQU	0x16
BAS_DN	EQU	0x17
TRE_UP	EQU	0x18
TRE_DN	EQU	0x19
HELP	EQU	0x2F
CUR_UP	EQU	0x50
CUR_DN	EQU	0x51
CUR_LE	EQU	0x55
CUR_RI	EQU	0x56


; Definition of Functions on the Propeller clock
;Clear second
SEC_CL		EQU	F5
;Increment second
SEC_UP		EQU	NUM_10
;Decrement second
SEC_DN		EQU	ENTER
;Increment minute
MIN_UP		EQU	NUM_7
;Decrement minute
MIN_DN		EQU	NUM_8
;Increment hour
HOUR_UP		EQU	NUM_3
;Decrement hour
HOUR_DN		EQU	NUM_4
;Increment day
DAY_UP		EQU NUM_9	
;Decrement day
DAY_DN		EQU	NUM_0
;Increment day of week
WDAY_UP		EQU	ASTRSK
;Decrement day of week
WDAY_DN		EQU	ADJUST
;Increment month
MON_UP		EQU	NUM_5
;Decrement month
MON_DN		EQU	NUM_6
;Increment year
YEAR_UP		EQU	NUM_1
;Decrement year
YEAR_DN		EQU	NUM_2
;Increment display offset
INDEX_UP	EQU	CON_UP
;Decrement display offset
INDEX_DN	EQU	CON_DN

;Toggle outer led
BlueLine	EQU	F1
;Toggle digital time display
DigiTime	EQU	PHA_UP
;Toggle digital date display
DigiDate	EQU	F3
;Toggle analogue colck's hands
AnaTime		EQU	HUE_DN
;Toggle analogue colck's ticks
TTicks		EQU	HUE_UP
;Toggle dot/arc second hand mode
TSecMode	EQU PAUSE

;Toggel demo mode
; on 16F628(A)	  - Scrolling text1 - time - Scrolling text1 - time -
; on 16F684A 	  - Scrolling text1 - time - Scrolling text2 - time -
DemoM		EQU	PHA_DN	;Demo Mode
;Toggle scrolling text mode
TextMode	EQU	TEXT
;Toggle rotation speed display
TRotation	EQU F2
;Toggle static text mode
TStaticText	EQU FREEZE
;New commands -------------------------------j parancsok
;Toggle day of week and rotation display
TWDay		EQU F4
; Set scrolling speed
SET_SP		EQU	ADDR

;===============================================
; Definition of Functions on the Propeller clock's Base
; .10 commands
 ; Toggle index
TINDEX		EQU	MUTE		  ; HALL!
; PWM pulse width up
WIDTH_UP	EQU	BRI_UP
; PWM pulse width down
WIDTH_DN	EQU	BRI_DN
; PWM period up
PER_UP		EQU	SAT_UP
; PWM period down
PER_DN		EQU	SAT_DN
 ; Relais ON			Not instaled!
REL_ON		EQU	VOL_UP
 ; Relais OFF
REL_OFF		EQU	VOL_DN
; Alarm sound off
ALM_SND		EQU EXIT
; Power up coil
POWUPCOIL	EQU	BAL_RI
; Power down coil
POWDNCOIL	EQU	BAL_LE
