
_buzzer:

;PIC16F628A_Relay_Timer.c,40 :: 		void buzzer(unsigned int duration) {   // duration in ms.
;PIC16F628A_Relay_Timer.c,42 :: 		n = (duration << 1) + (duration >> 1);
	MOVF       FARG_buzzer_duration+0, 0
	MOVWF      R3+0
	MOVF       FARG_buzzer_duration+1, 0
	MOVWF      R3+1
	RLF        R3+0, 1
	RLF        R3+1, 1
	BCF        R3+0, 0
	MOVF       FARG_buzzer_duration+0, 0
	MOVWF      R0+0
	MOVF       FARG_buzzer_duration+1, 0
	MOVWF      R0+1
	RRF        R0+1, 1
	RRF        R0+0, 1
	BCF        R0+1, 7
	MOVF       R0+0, 0
	ADDWF      R3+0, 1
	MOVF       R0+1, 0
	BTFSC      STATUS+0, 0
	ADDLW      1
	ADDWF      R3+1, 1
;PIC16F628A_Relay_Timer.c,43 :: 		while (n) {
L_buzzer0:
	MOVF       R3+0, 0
	IORWF      R3+1, 0
	BTFSC      STATUS+0, 2
	GOTO       L_buzzer1
;PIC16F628A_Relay_Timer.c,44 :: 		SND = 1;
	BSF        RB6_bit+0, 6
;PIC16F628A_Relay_Timer.c,45 :: 		Delay_us(206);
	MOVLW      68
	MOVWF      R13+0
L_buzzer2:
	DECFSZ     R13+0, 1
	GOTO       L_buzzer2
	NOP
;PIC16F628A_Relay_Timer.c,46 :: 		SND = 0;
	BCF        RB6_bit+0, 6
;PIC16F628A_Relay_Timer.c,47 :: 		Delay_us(206);
	MOVLW      68
	MOVWF      R13+0
L_buzzer3:
	DECFSZ     R13+0, 1
	GOTO       L_buzzer3
	NOP
;PIC16F628A_Relay_Timer.c,48 :: 		n--;
	MOVLW      1
	SUBWF      R3+0, 1
	BTFSS      STATUS+0, 0
	DECF       R3+1, 1
;PIC16F628A_Relay_Timer.c,49 :: 		}
	GOTO       L_buzzer0
L_buzzer1:
;PIC16F628A_Relay_Timer.c,50 :: 		}
L_end_buzzer:
	RETURN
; end of _buzzer

_interrupt:
	MOVWF      R15+0
	SWAPF      STATUS+0, 0
	CLRF       STATUS+0
	MOVWF      ___saveSTATUS+0
	MOVF       PCLATH+0, 0
	MOVWF      ___savePCLATH+0
	CLRF       PCLATH+0

;PIC16F628A_Relay_Timer.c,55 :: 		void interrupt() {
;PIC16F628A_Relay_Timer.c,56 :: 		cnt++;
	INCF       _cnt+0, 1
	BTFSC      STATUS+0, 2
	INCF       _cnt+1, 1
;PIC16F628A_Relay_Timer.c,57 :: 		if (cnt > OneSecond) {
	MOVLW      128
	XORWF      _OneSecond+1, 0
	MOVWF      R0+0
	MOVLW      128
	XORWF      _cnt+1, 0
	SUBWF      R0+0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__interrupt66
	MOVF       _cnt+0, 0
	SUBWF      _OneSecond+0, 0
L__interrupt66:
	BTFSC      STATUS+0, 0
	GOTO       L_interrupt4
;PIC16F628A_Relay_Timer.c,58 :: 		cnt = 0;
	CLRF       _cnt+0
	CLRF       _cnt+1
;PIC16F628A_Relay_Timer.c,59 :: 		if (start) {
	BTFSS      _start+0, BitPos(_start+0)
	GOTO       L_interrupt5
;PIC16F628A_Relay_Timer.c,60 :: 		if (seconds > 0) seconds--;
	MOVLW      128
	XORLW      0
	MOVWF      R0+0
	MOVLW      128
	XORWF      _seconds+0, 0
	SUBWF      R0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_interrupt6
	DECF       _seconds+0, 1
	GOTO       L_interrupt7
L_interrupt6:
;PIC16F628A_Relay_Timer.c,62 :: 		if (minutes > 0) {
	MOVLW      128
	XORLW      0
	MOVWF      R0+0
	MOVLW      128
	XORWF      _minutes+0, 0
	SUBWF      R0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_interrupt8
;PIC16F628A_Relay_Timer.c,63 :: 		seconds = 59;
	MOVLW      59
	MOVWF      _seconds+0
;PIC16F628A_Relay_Timer.c,64 :: 		minutes--;
	DECF       _minutes+0, 1
;PIC16F628A_Relay_Timer.c,65 :: 		}
	GOTO       L_interrupt9
L_interrupt8:
;PIC16F628A_Relay_Timer.c,67 :: 		LED = 0;                  // Lights the LED on.
	BCF        RA4_bit+0, 4
;PIC16F628A_Relay_Timer.c,68 :: 		OUT = 0;                  // Sets the output off;
	BCF        RB7_bit+0, 7
;PIC16F628A_Relay_Timer.c,69 :: 		start = 0;                // clear 'start' status flag
	BCF        _start+0, BitPos(_start+0)
;PIC16F628A_Relay_Timer.c,70 :: 		buzzer(500);              // sound alert: 3 short and 1 long beep
	MOVLW      244
	MOVWF      FARG_buzzer_duration+0
	MOVLW      1
	MOVWF      FARG_buzzer_duration+1
	CALL       _buzzer+0
;PIC16F628A_Relay_Timer.c,71 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_interrupt10:
	DECFSZ     R13+0, 1
	GOTO       L_interrupt10
	DECFSZ     R12+0, 1
	GOTO       L_interrupt10
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,72 :: 		buzzer(500);
	MOVLW      244
	MOVWF      FARG_buzzer_duration+0
	MOVLW      1
	MOVWF      FARG_buzzer_duration+1
	CALL       _buzzer+0
;PIC16F628A_Relay_Timer.c,73 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_interrupt11:
	DECFSZ     R13+0, 1
	GOTO       L_interrupt11
	DECFSZ     R12+0, 1
	GOTO       L_interrupt11
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,74 :: 		buzzer(500);
	MOVLW      244
	MOVWF      FARG_buzzer_duration+0
	MOVLW      1
	MOVWF      FARG_buzzer_duration+1
	CALL       _buzzer+0
;PIC16F628A_Relay_Timer.c,75 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_interrupt12:
	DECFSZ     R13+0, 1
	GOTO       L_interrupt12
	DECFSZ     R12+0, 1
	GOTO       L_interrupt12
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,76 :: 		buzzer(1000);
	MOVLW      232
	MOVWF      FARG_buzzer_duration+0
	MOVLW      3
	MOVWF      FARG_buzzer_duration+1
	CALL       _buzzer+0
;PIC16F628A_Relay_Timer.c,77 :: 		}
L_interrupt9:
;PIC16F628A_Relay_Timer.c,78 :: 		}
L_interrupt7:
;PIC16F628A_Relay_Timer.c,79 :: 		}
L_interrupt5:
;PIC16F628A_Relay_Timer.c,80 :: 		}
L_interrupt4:
;PIC16F628A_Relay_Timer.c,81 :: 		INTCON.T0IF = 0;               //clear the interrupt flag
	BCF        INTCON+0, 2
;PIC16F628A_Relay_Timer.c,82 :: 		}
L_end_interrupt:
L__interrupt65:
	MOVF       ___savePCLATH+0, 0
	MOVWF      PCLATH+0
	SWAPF      ___saveSTATUS+0, 0
	MOVWF      STATUS+0
	SWAPF      R15+0, 1
	SWAPF      R15+0, 0
	RETFIE
; end of _interrupt

_main:

;PIC16F628A_Relay_Timer.c,85 :: 		void main() {
;PIC16F628A_Relay_Timer.c,87 :: 		CMCON = 0b11111111;            // disable comparator
	MOVLW      255
	MOVWF      CMCON+0
;PIC16F628A_Relay_Timer.c,88 :: 		OPTION_REG = 0b11010001;       // configure timer0( prescaler 1:4 )
	MOVLW      209
	MOVWF      OPTION_REG+0
;PIC16F628A_Relay_Timer.c,89 :: 		INTCON = 0b10100000;           // enable interrupt of timer0
	MOVLW      160
	MOVWF      INTCON+0
;PIC16F628A_Relay_Timer.c,90 :: 		TMR0 = 0;                      // clear TMR0
	CLRF       TMR0+0
;PIC16F628A_Relay_Timer.c,91 :: 		TRISA = 0b11101111;            // sets all pins of PORTA as inputs except RA4
	MOVLW      239
	MOVWF      TRISA+0
;PIC16F628A_Relay_Timer.c,92 :: 		TRISB = 0b00000000;            // sets all pins of PORTA as outputs
	CLRF       TRISB+0
;PIC16F628A_Relay_Timer.c,93 :: 		LED = 1;                       // LED off
	BSF        RA4_bit+0, 4
;PIC16F628A_Relay_Timer.c,94 :: 		OUT = 0;                       // OUT off
	BCF        RB7_bit+0, 7
;PIC16F628A_Relay_Timer.c,97 :: 		seconds = 0;
	CLRF       _seconds+0
;PIC16F628A_Relay_Timer.c,98 :: 		minutes = 0;
	CLRF       _minutes+0
;PIC16F628A_Relay_Timer.c,99 :: 		start = 0;
	BCF        _start+0, BitPos(_start+0)
;PIC16F628A_Relay_Timer.c,100 :: 		cnt = 0;
	CLRF       _cnt+0
	CLRF       _cnt+1
;PIC16F628A_Relay_Timer.c,101 :: 		oldF1 = 0;
	BCF        _oldF1+0, BitPos(_oldF1+0)
;PIC16F628A_Relay_Timer.c,102 :: 		str1[4] = ' ';
	MOVLW      32
	MOVWF      _str1+4
;PIC16F628A_Relay_Timer.c,103 :: 		str1[5] = 0;
	CLRF       _str1+5
;PIC16F628A_Relay_Timer.c,112 :: 		OneSecond = OneSecondDefault;
	MOVLW      209
	MOVWF      _OneSecond+0
	MOVLW      3
	MOVWF      _OneSecond+1
;PIC16F628A_Relay_Timer.c,113 :: 		if (EEPROM_Read(0x00) == 1) {        // if the flag is set then read OneSecond from EEPROM
	CLRF       FARG_EEPROM_Read_Address+0
	CALL       _EEPROM_Read+0
	MOVF       R0+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_main13
;PIC16F628A_Relay_Timer.c,114 :: 		Delay_ms(30);
	MOVLW      39
	MOVWF      R12+0
	MOVLW      245
	MOVWF      R13+0
L_main14:
	DECFSZ     R13+0, 1
	GOTO       L_main14
	DECFSZ     R12+0, 1
	GOTO       L_main14
;PIC16F628A_Relay_Timer.c,115 :: 		Lo(OneSecond) = EEPROM_Read(0x01);  // read the low byte of OneSecond
	MOVLW      1
	MOVWF      FARG_EEPROM_Read_Address+0
	CALL       _EEPROM_Read+0
	MOVF       R0+0, 0
	MOVWF      _OneSecond+0
;PIC16F628A_Relay_Timer.c,116 :: 		Delay_ms(30);
	MOVLW      39
	MOVWF      R12+0
	MOVLW      245
	MOVWF      R13+0
L_main15:
	DECFSZ     R13+0, 1
	GOTO       L_main15
	DECFSZ     R12+0, 1
	GOTO       L_main15
;PIC16F628A_Relay_Timer.c,117 :: 		Hi(OneSecond) = EEPROM_Read(0x02);  // read the high byte of OneSecond
	MOVLW      2
	MOVWF      FARG_EEPROM_Read_Address+0
	CALL       _EEPROM_Read+0
	MOVF       R0+0, 0
	MOVWF      _OneSecond+1
;PIC16F628A_Relay_Timer.c,118 :: 		}
L_main13:
;PIC16F628A_Relay_Timer.c,119 :: 		Delay_ms(30);
	MOVLW      39
	MOVWF      R12+0
	MOVLW      245
	MOVWF      R13+0
L_main16:
	DECFSZ     R13+0, 1
	GOTO       L_main16
	DECFSZ     R12+0, 1
	GOTO       L_main16
;PIC16F628A_Relay_Timer.c,122 :: 		Lcd_Init();
	CALL       _Lcd_Init+0
;PIC16F628A_Relay_Timer.c,123 :: 		Lcd_Cmd(_LCD_CLEAR);
	MOVLW      1
	MOVWF      FARG_Lcd_Cmd_out_char+0
	CALL       _Lcd_Cmd+0
;PIC16F628A_Relay_Timer.c,124 :: 		Lcd_Cmd(_LCD_CURSOR_OFF);
	MOVLW      12
	MOVWF      FARG_Lcd_Cmd_out_char+0
	CALL       _Lcd_Cmd+0
;PIC16F628A_Relay_Timer.c,125 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_main17:
	DECFSZ     R13+0, 1
	GOTO       L_main17
	DECFSZ     R12+0, 1
	GOTO       L_main17
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,126 :: 		Lcd_Out(1,1,"DIYfan.");
	MOVLW      1
	MOVWF      FARG_Lcd_Out_row+0
	MOVLW      1
	MOVWF      FARG_Lcd_Out_column+0
	MOVLW      ?lstr1_PIC16F628A_Relay_Timer+0
	MOVWF      FARG_Lcd_Out_text+0
	CALL       _Lcd_Out+0
;PIC16F628A_Relay_Timer.c,127 :: 		Lcd_Out(2,1,"blogspot.com");
	MOVLW      2
	MOVWF      FARG_Lcd_Out_row+0
	MOVLW      1
	MOVWF      FARG_Lcd_Out_column+0
	MOVLW      ?lstr2_PIC16F628A_Relay_Timer+0
	MOVWF      FARG_Lcd_Out_text+0
	CALL       _Lcd_Out+0
;PIC16F628A_Relay_Timer.c,128 :: 		Delay_ms(2000);
	MOVLW      11
	MOVWF      R11+0
	MOVLW      38
	MOVWF      R12+0
	MOVLW      93
	MOVWF      R13+0
L_main18:
	DECFSZ     R13+0, 1
	GOTO       L_main18
	DECFSZ     R12+0, 1
	GOTO       L_main18
	DECFSZ     R11+0, 1
	GOTO       L_main18
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,129 :: 		Lcd_Cmd(_LCD_CLEAR);
	MOVLW      1
	MOVWF      FARG_Lcd_Cmd_out_char+0
	CALL       _Lcd_Cmd+0
;PIC16F628A_Relay_Timer.c,130 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_main19:
	DECFSZ     R13+0, 1
	GOTO       L_main19
	DECFSZ     R12+0, 1
	GOTO       L_main19
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,132 :: 		while(1) {
L_main20:
;PIC16F628A_Relay_Timer.c,138 :: 		while (!PORTA.F0) {
L_main22:
	BTFSC      PORTA+0, 0
	GOTO       L_main23
;PIC16F628A_Relay_Timer.c,139 :: 		tmp = OneSecond;
	MOVF       _OneSecond+0, 0
	MOVWF      _tmp+0
	MOVF       _OneSecond+1, 0
	MOVWF      _tmp+1
;PIC16F628A_Relay_Timer.c,140 :: 		str1[3] = tmp%10 + '0';
	MOVLW      10
	MOVWF      R4+0
	MOVLW      0
	MOVWF      R4+1
	MOVF       _OneSecond+0, 0
	MOVWF      R0+0
	MOVF       _OneSecond+1, 0
	MOVWF      R0+1
	CALL       _Div_16x16_S+0
	MOVF       R8+0, 0
	MOVWF      R0+0
	MOVF       R8+1, 0
	MOVWF      R0+1
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      _str1+3
;PIC16F628A_Relay_Timer.c,141 :: 		tmp = tmp/10;
	MOVLW      10
	MOVWF      R4+0
	MOVLW      0
	MOVWF      R4+1
	MOVF       _tmp+0, 0
	MOVWF      R0+0
	MOVF       _tmp+1, 0
	MOVWF      R0+1
	CALL       _Div_16x16_S+0
	MOVF       R0+0, 0
	MOVWF      _tmp+0
	MOVF       R0+1, 0
	MOVWF      _tmp+1
;PIC16F628A_Relay_Timer.c,142 :: 		str1[2] = tmp%10 + '0';
	MOVLW      10
	MOVWF      R4+0
	MOVLW      0
	MOVWF      R4+1
	CALL       _Div_16x16_S+0
	MOVF       R8+0, 0
	MOVWF      R0+0
	MOVF       R8+1, 0
	MOVWF      R0+1
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      _str1+2
;PIC16F628A_Relay_Timer.c,143 :: 		tmp = tmp/10;
	MOVLW      10
	MOVWF      R4+0
	MOVLW      0
	MOVWF      R4+1
	MOVF       _tmp+0, 0
	MOVWF      R0+0
	MOVF       _tmp+1, 0
	MOVWF      R0+1
	CALL       _Div_16x16_S+0
	MOVF       R0+0, 0
	MOVWF      _tmp+0
	MOVF       R0+1, 0
	MOVWF      _tmp+1
;PIC16F628A_Relay_Timer.c,144 :: 		str1[1] = tmp%10 + '0';
	MOVLW      10
	MOVWF      R4+0
	MOVLW      0
	MOVWF      R4+1
	CALL       _Div_16x16_S+0
	MOVF       R8+0, 0
	MOVWF      R0+0
	MOVF       R8+1, 0
	MOVWF      R0+1
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      _str1+1
;PIC16F628A_Relay_Timer.c,145 :: 		tmp = tmp/10;
	MOVLW      10
	MOVWF      R4+0
	MOVLW      0
	MOVWF      R4+1
	MOVF       _tmp+0, 0
	MOVWF      R0+0
	MOVF       _tmp+1, 0
	MOVWF      R0+1
	CALL       _Div_16x16_S+0
	MOVF       R0+0, 0
	MOVWF      _tmp+0
	MOVF       R0+1, 0
	MOVWF      _tmp+1
;PIC16F628A_Relay_Timer.c,146 :: 		str1[0] = tmp%10 + '0';
	MOVLW      10
	MOVWF      R4+0
	MOVLW      0
	MOVWF      R4+1
	CALL       _Div_16x16_S+0
	MOVF       R8+0, 0
	MOVWF      R0+0
	MOVF       R8+1, 0
	MOVWF      R0+1
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      _str1+0
;PIC16F628A_Relay_Timer.c,147 :: 		Lcd_Out(1,1,str1);                    // OneSecond is showed on LCD.
	MOVLW      1
	MOVWF      FARG_Lcd_Out_row+0
	MOVLW      1
	MOVWF      FARG_Lcd_Out_column+0
	MOVLW      _str1+0
	MOVWF      FARG_Lcd_Out_text+0
	CALL       _Lcd_Out+0
;PIC16F628A_Relay_Timer.c,148 :: 		if (!PORTA.F1) {                      // START/PAUSE buton is pressed
	BTFSC      PORTA+0, 1
	GOTO       L_main24
;PIC16F628A_Relay_Timer.c,149 :: 		EEPROM_Write(0x00, 0xFF);            // clears the flag of change
	CLRF       FARG_EEPROM_Write_Address+0
	MOVLW      255
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;PIC16F628A_Relay_Timer.c,150 :: 		OneSecond = OneSecondDefault;        // sets the default value for OneSecond
	MOVLW      209
	MOVWF      _OneSecond+0
	MOVLW      3
	MOVWF      _OneSecond+1
;PIC16F628A_Relay_Timer.c,151 :: 		Delay_ms(30);
	MOVLW      39
	MOVWF      R12+0
	MOVLW      245
	MOVWF      R13+0
L_main25:
	DECFSZ     R13+0, 1
	GOTO       L_main25
	DECFSZ     R12+0, 1
	GOTO       L_main25
;PIC16F628A_Relay_Timer.c,152 :: 		}
L_main24:
;PIC16F628A_Relay_Timer.c,153 :: 		if (!PORTA.F2) {                      // MIN buton is pressed
	BTFSC      PORTA+0, 2
	GOTO       L_main26
;PIC16F628A_Relay_Timer.c,154 :: 		OneSecond++;                         // increasing the value of OneSecond
	INCF       _OneSecond+0, 1
	BTFSC      STATUS+0, 2
	INCF       _OneSecond+1, 1
;PIC16F628A_Relay_Timer.c,155 :: 		EEPROM_Write(0x00, 1);               // sets the flag of change
	CLRF       FARG_EEPROM_Write_Address+0
	MOVLW      1
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;PIC16F628A_Relay_Timer.c,156 :: 		Delay_ms(50);
	MOVLW      65
	MOVWF      R12+0
	MOVLW      238
	MOVWF      R13+0
L_main27:
	DECFSZ     R13+0, 1
	GOTO       L_main27
	DECFSZ     R12+0, 1
	GOTO       L_main27
	NOP
;PIC16F628A_Relay_Timer.c,157 :: 		EEPROM_Write(0x01, Lo(OneSecond));   // write the low byte of OneSecond value
	MOVLW      1
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVF       _OneSecond+0, 0
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;PIC16F628A_Relay_Timer.c,158 :: 		Delay_ms(50);
	MOVLW      65
	MOVWF      R12+0
	MOVLW      238
	MOVWF      R13+0
L_main28:
	DECFSZ     R13+0, 1
	GOTO       L_main28
	DECFSZ     R12+0, 1
	GOTO       L_main28
	NOP
;PIC16F628A_Relay_Timer.c,159 :: 		EEPROM_Write(0x02, Hi(OneSecond));   // write the high byte of OneSecond value
	MOVLW      2
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVF       _OneSecond+1, 0
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;PIC16F628A_Relay_Timer.c,160 :: 		Delay_ms(50);
	MOVLW      65
	MOVWF      R12+0
	MOVLW      238
	MOVWF      R13+0
L_main29:
	DECFSZ     R13+0, 1
	GOTO       L_main29
	DECFSZ     R12+0, 1
	GOTO       L_main29
	NOP
;PIC16F628A_Relay_Timer.c,161 :: 		}
L_main26:
;PIC16F628A_Relay_Timer.c,162 :: 		if (!PORTA.F3) {                      // SEC buton is pressed
	BTFSC      PORTA+0, 3
	GOTO       L_main30
;PIC16F628A_Relay_Timer.c,163 :: 		OneSecond--;                         // decreasing the value of OneSecond
	MOVLW      1
	SUBWF      _OneSecond+0, 1
	BTFSS      STATUS+0, 0
	DECF       _OneSecond+1, 1
;PIC16F628A_Relay_Timer.c,164 :: 		EEPROM_Write(0x00, 1);               // sets the flag of change
	CLRF       FARG_EEPROM_Write_Address+0
	MOVLW      1
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;PIC16F628A_Relay_Timer.c,165 :: 		Delay_ms(50);
	MOVLW      65
	MOVWF      R12+0
	MOVLW      238
	MOVWF      R13+0
L_main31:
	DECFSZ     R13+0, 1
	GOTO       L_main31
	DECFSZ     R12+0, 1
	GOTO       L_main31
	NOP
;PIC16F628A_Relay_Timer.c,166 :: 		EEPROM_Write(0x01, Lo(OneSecond));   // write the low byte of OneSecond value
	MOVLW      1
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVF       _OneSecond+0, 0
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;PIC16F628A_Relay_Timer.c,167 :: 		Delay_ms(50);
	MOVLW      65
	MOVWF      R12+0
	MOVLW      238
	MOVWF      R13+0
L_main32:
	DECFSZ     R13+0, 1
	GOTO       L_main32
	DECFSZ     R12+0, 1
	GOTO       L_main32
	NOP
;PIC16F628A_Relay_Timer.c,168 :: 		EEPROM_Write(0x02, Hi(OneSecond));   // write the high byte of OneSecond value
	MOVLW      2
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVF       _OneSecond+1, 0
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;PIC16F628A_Relay_Timer.c,169 :: 		Delay_ms(50);
	MOVLW      65
	MOVWF      R12+0
	MOVLW      238
	MOVWF      R13+0
L_main33:
	DECFSZ     R13+0, 1
	GOTO       L_main33
	DECFSZ     R12+0, 1
	GOTO       L_main33
	NOP
;PIC16F628A_Relay_Timer.c,170 :: 		}
L_main30:
;PIC16F628A_Relay_Timer.c,171 :: 		}
	GOTO       L_main22
L_main23:
;PIC16F628A_Relay_Timer.c,173 :: 		if (PORTA.F1 != oldF1) {
	BTFSC      PORTA+0, 1
	GOTO       L__main68
	BTFSS      _oldF1+0, BitPos(_oldF1+0)
	GOTO       L_main34
	GOTO       L__main69
L__main68:
	BTFSS      _oldF1+0, BitPos(_oldF1+0)
	GOTO       L__main69
	GOTO       L_main34
L__main69:
;PIC16F628A_Relay_Timer.c,174 :: 		if (oldF1) {                          // START/STOP buton is PRESSED
	BTFSS      _oldF1+0, BitPos(_oldF1+0)
	GOTO       L_main35
;PIC16F628A_Relay_Timer.c,175 :: 		if (!start && !seconds && !minutes)  // switch the LED off if timer is not running
	BTFSC      _start+0, BitPos(_start+0)
	GOTO       L_main38
	MOVF       _seconds+0, 0
	BTFSS      STATUS+0, 2
	GOTO       L_main38
	MOVF       _minutes+0, 0
	BTFSS      STATUS+0, 2
	GOTO       L_main38
L__main62:
;PIC16F628A_Relay_Timer.c,176 :: 		LED = 1;
	BSF        RA4_bit+0, 4
	GOTO       L_main39
L_main38:
;PIC16F628A_Relay_Timer.c,178 :: 		start = !start;                     // change the status of the timer
	MOVLW
	XORWF      _start+0, 1
;PIC16F628A_Relay_Timer.c,179 :: 		OUT = start;
	BTFSC      _start+0, BitPos(_start+0)
	GOTO       L__main70
	BCF        RB7_bit+0, 7
	GOTO       L__main71
L__main70:
	BSF        RB7_bit+0, 7
L__main71:
;PIC16F628A_Relay_Timer.c,180 :: 		if (start) {
	BTFSS      _start+0, BitPos(_start+0)
	GOTO       L_main40
;PIC16F628A_Relay_Timer.c,181 :: 		LED = 1;                           // switch the LED off if timer is starting
	BSF        RA4_bit+0, 4
;PIC16F628A_Relay_Timer.c,182 :: 		cnt = 0;
	CLRF       _cnt+0
	CLRF       _cnt+1
;PIC16F628A_Relay_Timer.c,183 :: 		}
L_main40:
;PIC16F628A_Relay_Timer.c,184 :: 		}
L_main39:
;PIC16F628A_Relay_Timer.c,185 :: 		}
L_main35:
;PIC16F628A_Relay_Timer.c,186 :: 		oldF1 = PORTA.F1;
	BTFSC      PORTA+0, 1
	GOTO       L__main72
	BCF        _oldF1+0, BitPos(_oldF1+0)
	GOTO       L__main73
L__main72:
	BSF        _oldF1+0, BitPos(_oldF1+0)
L__main73:
;PIC16F628A_Relay_Timer.c,187 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_main41:
	DECFSZ     R13+0, 1
	GOTO       L_main41
	DECFSZ     R12+0, 1
	GOTO       L_main41
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,188 :: 		}
L_main34:
;PIC16F628A_Relay_Timer.c,191 :: 		if (!PORTA.F2 && !PORTA.F3) { // simultaneously pressing SEC and MIN butons
	BTFSC      PORTA+0, 2
	GOTO       L_main44
	BTFSC      PORTA+0, 3
	GOTO       L_main44
L__main61:
;PIC16F628A_Relay_Timer.c,192 :: 		start = 0;                   // resets the timer.
	BCF        _start+0, BitPos(_start+0)
;PIC16F628A_Relay_Timer.c,193 :: 		minutes = 0;
	CLRF       _minutes+0
;PIC16F628A_Relay_Timer.c,194 :: 		seconds = 0;
	CLRF       _seconds+0
;PIC16F628A_Relay_Timer.c,195 :: 		LED = 1;
	BSF        RA4_bit+0, 4
;PIC16F628A_Relay_Timer.c,196 :: 		OUT = 0;
	BCF        RB7_bit+0, 7
;PIC16F628A_Relay_Timer.c,197 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_main45:
	DECFSZ     R13+0, 1
	GOTO       L_main45
	DECFSZ     R12+0, 1
	GOTO       L_main45
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,198 :: 		}
	GOTO       L_main46
L_main44:
;PIC16F628A_Relay_Timer.c,200 :: 		if (!start) {
	BTFSC      _start+0, BitPos(_start+0)
	GOTO       L_main47
;PIC16F628A_Relay_Timer.c,201 :: 		if (!PORTA.F3) {            // SEC buton is PRESSED
	BTFSC      PORTA+0, 3
	GOTO       L_main48
;PIC16F628A_Relay_Timer.c,202 :: 		LED = 1;                   // LED off
	BSF        RA4_bit+0, 4
;PIC16F628A_Relay_Timer.c,203 :: 		if (seconds < 59)
	MOVLW      128
	XORWF      _seconds+0, 0
	MOVWF      R0+0
	MOVLW      128
	XORLW      59
	SUBWF      R0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_main49
;PIC16F628A_Relay_Timer.c,204 :: 		seconds++;
	INCF       _seconds+0, 1
	GOTO       L_main50
L_main49:
;PIC16F628A_Relay_Timer.c,206 :: 		seconds = 0;
	CLRF       _seconds+0
L_main50:
;PIC16F628A_Relay_Timer.c,207 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_main51:
	DECFSZ     R13+0, 1
	GOTO       L_main51
	DECFSZ     R12+0, 1
	GOTO       L_main51
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,208 :: 		}
L_main48:
;PIC16F628A_Relay_Timer.c,209 :: 		if (!PORTA.F2) {            // MIN buton is PRESSED
	BTFSC      PORTA+0, 2
	GOTO       L_main52
;PIC16F628A_Relay_Timer.c,210 :: 		LED = 1;
	BSF        RA4_bit+0, 4
;PIC16F628A_Relay_Timer.c,211 :: 		if (minutes < 99)
	MOVLW      128
	XORWF      _minutes+0, 0
	MOVWF      R0+0
	MOVLW      128
	XORLW      99
	SUBWF      R0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_main53
;PIC16F628A_Relay_Timer.c,212 :: 		minutes++;
	INCF       _minutes+0, 1
	GOTO       L_main54
L_main53:
;PIC16F628A_Relay_Timer.c,214 :: 		minutes = 0;
	CLRF       _minutes+0
L_main54:
;PIC16F628A_Relay_Timer.c,215 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_main55:
	DECFSZ     R13+0, 1
	GOTO       L_main55
	DECFSZ     R12+0, 1
	GOTO       L_main55
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,216 :: 		}
L_main52:
;PIC16F628A_Relay_Timer.c,217 :: 		}
L_main47:
L_main46:
;PIC16F628A_Relay_Timer.c,220 :: 		if (start)
	BTFSS      _start+0, BitPos(_start+0)
	GOTO       L_main56
;PIC16F628A_Relay_Timer.c,221 :: 		Lcd_Out(1, 1, "Time left:    ");
	MOVLW      1
	MOVWF      FARG_Lcd_Out_row+0
	MOVLW      1
	MOVWF      FARG_Lcd_Out_column+0
	MOVLW      ?lstr3_PIC16F628A_Relay_Timer+0
	MOVWF      FARG_Lcd_Out_text+0
	CALL       _Lcd_Out+0
	GOTO       L_main57
L_main56:
;PIC16F628A_Relay_Timer.c,223 :: 		if (!LED) {
	BTFSC      RA4_bit+0, 4
	GOTO       L_main58
;PIC16F628A_Relay_Timer.c,224 :: 		Lcd_Out(1, 1, "Finished!     ");
	MOVLW      1
	MOVWF      FARG_Lcd_Out_row+0
	MOVLW      1
	MOVWF      FARG_Lcd_Out_column+0
	MOVLW      ?lstr4_PIC16F628A_Relay_Timer+0
	MOVWF      FARG_Lcd_Out_text+0
	CALL       _Lcd_Out+0
;PIC16F628A_Relay_Timer.c,225 :: 		}
	GOTO       L_main59
L_main58:
;PIC16F628A_Relay_Timer.c,227 :: 		Lcd_Out(1, 1, "Adjusting time");
	MOVLW      1
	MOVWF      FARG_Lcd_Out_row+0
	MOVLW      1
	MOVWF      FARG_Lcd_Out_column+0
	MOVLW      ?lstr5_PIC16F628A_Relay_Timer+0
	MOVWF      FARG_Lcd_Out_text+0
	CALL       _Lcd_Out+0
;PIC16F628A_Relay_Timer.c,228 :: 		}
L_main59:
;PIC16F628A_Relay_Timer.c,229 :: 		}
L_main57:
;PIC16F628A_Relay_Timer.c,230 :: 		Lcd_Chr(2, 1, minutes/10 + '0');
	MOVLW      2
	MOVWF      FARG_Lcd_Chr_row+0
	MOVLW      1
	MOVWF      FARG_Lcd_Chr_column+0
	MOVLW      10
	MOVWF      R4+0
	MOVF       _minutes+0, 0
	MOVWF      R0+0
	CALL       _Div_8x8_S+0
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      FARG_Lcd_Chr_out_char+0
	CALL       _Lcd_Chr+0
;PIC16F628A_Relay_Timer.c,231 :: 		Lcd_Chr_CP(minutes%10 + '0');
	MOVLW      10
	MOVWF      R4+0
	MOVF       _minutes+0, 0
	MOVWF      R0+0
	CALL       _Div_8x8_S+0
	MOVF       R8+0, 0
	MOVWF      R0+0
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      FARG_Lcd_Chr_CP_out_char+0
	CALL       _Lcd_Chr_CP+0
;PIC16F628A_Relay_Timer.c,232 :: 		Lcd_Chr_CP(':');
	MOVLW      58
	MOVWF      FARG_Lcd_Chr_CP_out_char+0
	CALL       _Lcd_Chr_CP+0
;PIC16F628A_Relay_Timer.c,233 :: 		Lcd_Chr_CP(seconds/10 + '0');
	MOVLW      10
	MOVWF      R4+0
	MOVF       _seconds+0, 0
	MOVWF      R0+0
	CALL       _Div_8x8_S+0
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      FARG_Lcd_Chr_CP_out_char+0
	CALL       _Lcd_Chr_CP+0
;PIC16F628A_Relay_Timer.c,234 :: 		Lcd_Chr_CP(seconds%10 + '0');
	MOVLW      10
	MOVWF      R4+0
	MOVF       _seconds+0, 0
	MOVWF      R0+0
	CALL       _Div_8x8_S+0
	MOVF       R8+0, 0
	MOVWF      R0+0
	MOVLW      48
	ADDWF      R0+0, 0
	MOVWF      FARG_Lcd_Chr_CP_out_char+0
	CALL       _Lcd_Chr_CP+0
;PIC16F628A_Relay_Timer.c,235 :: 		Delay_ms(100);
	MOVLW      130
	MOVWF      R12+0
	MOVLW      221
	MOVWF      R13+0
L_main60:
	DECFSZ     R13+0, 1
	GOTO       L_main60
	DECFSZ     R12+0, 1
	GOTO       L_main60
	NOP
	NOP
;PIC16F628A_Relay_Timer.c,236 :: 		}
	GOTO       L_main20
;PIC16F628A_Relay_Timer.c,237 :: 		}
L_end_main:
	GOTO       $+0
; end of _main
