// TIMER project at DIYfan.blogspot.com

#define Lo(param) ((char *)&param)[0]
#define Hi(param) ((char *)&param)[1]
#define OneSecondDefault 977 // default value for OneSecond

// LCD pins
sbit LCD_RS at RB5_bit;
sbit LCD_EN at RB4_bit;
sbit LCD_D7 at RB0_bit;
sbit LCD_D6 at RB1_bit;
sbit LCD_D5 at RB2_bit;
sbit LCD_D4 at RB3_bit;
sbit LCD_RS_Direction at TRISB5_bit;
sbit LCD_EN_Direction at TRISB4_bit;
sbit LCD_D7_Direction at TRISB0_bit;
sbit LCD_D6_Direction at TRISB1_bit;
sbit LCD_D5_Direction at TRISB2_bit;
sbit LCD_D4_Direction at TRISB3_bit;

// define sound, LED and OUT pins.
sbit SND at RB6_bit;
// As the LED in the schematic is connected to VDD, 
// LED = 1 will switch the light OFF
// and LED = 0 will switch the light ON
sbit LED at RA4_bit;
sbit OUT at RB7_bit;

// Variables
int cnt, OneSecond, tmp;
short minutes, seconds;
bit start, oldF1;
char str1[6];

// sount output with buzzer
// the optimal frequency for the buzzer is 2400Hz
// cycle lenght is 0.417 mS so number of cycles will be roughly 2.5 x duration
// converting ms to cycles: n = 2 x duration + duration/2
// this is not accurate, just approximation for easier calculations
void buzzer(unsigned int duration) {   // duration in ms.
 unsigned int n;
 n = (duration << 1) + (duration >> 1);
 while (n) {
  SND = 1;
  Delay_us(206);
  SND = 0;
  Delay_us(206);
  n--;
 }
}



// inerrupt procedure
void interrupt() {
  cnt++;
 if (cnt > OneSecond) {
  cnt = 0;
  if (start) {
   if (seconds > 0) seconds--;
    else {
     if (minutes > 0) {
      seconds = 59;
      minutes--;
     }
     else {                     // Finish.
      LED = 0;                  // Lights the LED on.
      OUT = 0;                  // Sets the output off;
      start = 0;                // clear 'start' status flag
      buzzer(500);              // sound alert: 3 short and 1 long beep
      Delay_ms(100);
      buzzer(500);
      Delay_ms(100);
      buzzer(500);
      Delay_ms(100);
      buzzer(1000);
     }
    }
  }
 }
 INTCON.T0IF = 0;               //clear the interrupt flag
}


void main() {
 // registers and ports configuration
 CMCON = 0b11111111;            // disable comparator
 OPTION_REG = 0b11010001;       // configure timer0( prescaler 1:4 )
 INTCON = 0b10100000;           // enable interrupt of timer0
 TMR0 = 0;                      // clear TMR0
 TRISA = 0b11101111;            // sets all pins of PORTA as inputs except RA4
 TRISB = 0b00000000;            // sets all pins of PORTA as outputs
 LED = 1;                       // LED off
 OUT = 0;                       // OUT off

 // setting the variables
 seconds = 0;
 minutes = 0;
 start = 0;
 cnt = 0;
 oldF1 = 0;
 str1[4] = ' ';
 str1[5] = 0;

 // default value for OneSecond: 4000000/4/4/256/
 // The main frequency is set 4MHz which is divided internaly by 4 resulting 1MHz
 // Prescaler is 1:4 so the frequency for timer0 will be 250kHz
 // timer0 itself divide by 256, so the frequency of interupt will be
 // 976.56 Hz. So for 1 second we will count 977 interupts.
 // if OneSecond is changed it will be written in EEPROM and read from there
 // First byte of EEPROM is used as flag, indicating is there changed value of OneSecond
 OneSecond = OneSecondDefault;
 if (EEPROM_Read(0x00) == 1) {        // if the flag is set then read OneSecond from EEPROM
  Delay_ms(30);
  Lo(OneSecond) = EEPROM_Read(0x01);  // read the low byte of OneSecond
  Delay_ms(30);
  Hi(OneSecond) = EEPROM_Read(0x02);  // read the high byte of OneSecond
 }
 Delay_ms(30);

 // initializing the LCD display
 Lcd_Init();
 Lcd_Cmd(_LCD_CLEAR);
 Lcd_Cmd(_LCD_CURSOR_OFF);
 Delay_ms(100);
 Lcd_Out(1,1,"DIYfan.");
 Lcd_Out(2,1,"blogspot.com");
 Delay_ms(2000);
 Lcd_Cmd(_LCD_CLEAR);
 Delay_ms(100);
 
 while(1) {
  //              Adjusting the timer accuracy
  // shorting the jumper J1 sets the timer in tunning mode
  // pressing the MIN buton will increase the value of OneSecond
  // pressing the SEC buton will decrease the value of OneSecond
  // pressing the START/PAUSE buton will return the default value of OneSecond
  while (!PORTA.F0) {
   tmp = OneSecond;
   str1[3] = tmp%10 + '0';
   tmp = tmp/10;
   str1[2] = tmp%10 + '0';
   tmp = tmp/10;
   str1[1] = tmp%10 + '0';
   tmp = tmp/10;
   str1[0] = tmp%10 + '0';
   Lcd_Out(1,1,str1);                    // OneSecond is showed on LCD.
   if (!PORTA.F1) {                      // START/PAUSE buton is pressed
    EEPROM_Write(0x00, 0xFF);            // clears the flag of change
    OneSecond = OneSecondDefault;        // sets the default value for OneSecond
    Delay_ms(30);
   }
   if (!PORTA.F2) {                      // MIN buton is pressed
    OneSecond++;                         // increasing the value of OneSecond
    EEPROM_Write(0x00, 1);               // sets the flag of change
    Delay_ms(50);
    EEPROM_Write(0x01, Lo(OneSecond));   // write the low byte of OneSecond value
    Delay_ms(50);
    EEPROM_Write(0x02, Hi(OneSecond));   // write the high byte of OneSecond value
    Delay_ms(50);
   }
   if (!PORTA.F3) {                      // SEC buton is pressed
    OneSecond--;                         // decreasing the value of OneSecond
    EEPROM_Write(0x00, 1);               // sets the flag of change
    Delay_ms(50);
    EEPROM_Write(0x01, Lo(OneSecond));   // write the low byte of OneSecond value
    Delay_ms(50);
    EEPROM_Write(0x02, Hi(OneSecond));   // write the high byte of OneSecond value
    Delay_ms(50);
   }
  }

  if (PORTA.F1 != oldF1) {
   if (oldF1) {                          // START/STOP buton is PRESSED
    if (!start && !seconds && !minutes)  // switch the LED off if timer is not running
     LED = 1;
    else {
     start = !start;                     // change the status of the timer
     OUT = start;
     if (start) {
      LED = 1;                           // switch the LED off if timer is starting
      cnt = 0;
     }
    }
   }
   oldF1 = PORTA.F1;
   Delay_ms(100);
  }
  

  if (!PORTA.F2 && !PORTA.F3) { // simultaneously pressing SEC and MIN butons
   start = 0;                   // resets the timer.
   minutes = 0;
   seconds = 0;
   LED = 1;
   OUT = 0;
   Delay_ms(100);
  }
  else
   if (!start) {
    if (!PORTA.F3) {            // SEC buton is PRESSED
     LED = 1;                   // LED off
     if (seconds < 59)
      seconds++;
     else
      seconds = 0;
     Delay_ms(100);
    }
    if (!PORTA.F2) {            // MIN buton is PRESSED
     LED = 1;
     if (minutes < 99)
      minutes++;
     else
      minutes = 0;
     Delay_ms(100);
    }
   }


  if (start)
   Lcd_Out(1, 1, "Time left:    ");
  else {
   if (!LED) {
    Lcd_Out(1, 1, "Finished!     ");
   }
   else {
    Lcd_Out(1, 1, "Adjusting time");
   }
  }
  Lcd_Chr(2, 1, minutes/10 + '0');
  Lcd_Chr_CP(minutes%10 + '0');
  Lcd_Chr_CP(':');
  Lcd_Chr_CP(seconds/10 + '0');
  Lcd_Chr_CP(seconds%10 + '0');
  Delay_ms(100);
 }
}