
; Define RC5 address of Remote Control

RemoteAddr	EQU	0x00	;URC22B, Cod: 0026

; Definition of Keys and key-codes on my remote control

NUM_0	EQU	0x00	; Num-0
NUM_1	EQU	0x01	; Num-1
NUM_2	EQU	0x02	; Num-2
NUM_3	EQU	0x03	; Num-3
NUM_4	EQU	0x04	; Num-4
NUM_5	EQU	0x05	; Num-5
NUM_6	EQU	0x06	; Num-6
NUM_7	EQU	0x07	; Num-7
NUM_8	EQU	0x08	; Num-8
NUM_9	EQU	0x09	; Num-9
NUM_10	EQU	0x0A	; 1-/11
NUM_20	EQU	0x0B	; CH.P/C
MUTE	EQU	0x0D	; Mute
NUM_E	EQU	0x0E	; -->.<--
TEXT	EQU	0x0F	; ->|_| 
VOL_UP	EQU	0x10	; Vol +
VOL_DN	EQU	0x11	; Vol -
BRI_UP	EQU	0x12	; Bright +
BRI_DN	EQU	0x13	; Bright -
SAT_UP	EQU	0x14	; Saturation +
SAT_DN	EQU	0x15	; Saturation -
BAL_RI	EQU	0x1A	; Contrast +
BAL_LE	EQU	0x1B	; Contrast -
CMD_20	EQU	0x20	; CH +
CMD_21	EQU	0x21	; CH -
CMD_22	EQU	0x22	; << Left
CMD_24	EQU	0x24	; Memo
CMD_26	EQU	0x26	; PR <>
CMD_28	EQU	0x28	; 2-/12
CMD_29	EQU	0x29	; STOP |_|
CMD_2A	EQU	0x2A	; TP |>
CMD_2B	EQU	0x2B	; Play >
CMD_2C	EQU	0x2C	; REC
CMD_2D	EQU	0x2D	; Eject
CMD_32	EQU	0x32	; G - yellow button
CMD_34	EQU	0x34	; H - blue button
CMD_35	EQU	0x35	; 100 - i -  <|
CMD_36	EQU	0x36	; F - green button
CMD_37	EQU	0x37	; E - red button
CMD_38	EQU	0x38	; >> Right
CMD_3C	EQU	0x3C	; Pause  ||
CMD_3F	EQU	0x3F	; TV/Sat


;Mnemonic		Code		; Function						; Funkci

YEAR_UP			EQU	0x00	; Year up						;- v nvelse
HOUR_UP			EQU	0x01	; Hour up						;- ra nvelse
MIN_UP			EQU	0x02	; Minutes up					;- Perc nvelse
SEC_UP			EQU	0x03	; Seconds up					;- Msodperc nvelse
BRIGHT_UP		EQU	0x04	; Actual brigthness up			;- Aktulis fnyer nvelse
HOUR_DN			EQU	0x05	; Hour down						;- ra cskkentse
MIN_DN			EQU	0x06	; Minutes down					;- Perc cskkentse
SEC_DN			EQU	0x07	; Seconds down					;- Msodperc cskkentse
BRIGHT_DN		EQU	0x08	; Actual brigthness down		;- Aktulis fnyer cskkentse
CENT_UP			EQU	0x09	; Century up					;- vszzad nvelse
MON_UP			EQU	0x0A	; Month up						;- Hnap nvelse
INDEX_UP		EQU	0x0B	; Offset up						;- Offszet nvelse
TLANGUAGE		EQU	0x0D	; LANGUAGE						; Nyelv kivlasztsa,		NEM KELL!
LIGHTLIM_UP		EQU	0x0E	; Light limit up				; Megvilgts hatr nvelse
BRIGHT_MD		EQU	0x0F	; Change brigthness mode		;- Fnyer zemmd prgetse
SAVE0			EQU	0x10	; Save settings 	#0			; Bellts mentse 0. helyre
RESTORE0		EQU	0x11	; Restore settings	#0			; Bellts visszalltsa 0. helyrl
MON_DN			EQU	0x12	; Month down					;- Hnap cskkentse
TPICT			EQU	0x13	;Picture number up				; Kpszm lptetse felfel
DAY_DN			EQU	0x14	; Day down						;- Nap cskkentse
TPICTDN			EQU	0x15	;Picture number down			; Kpszm lptetse lefel
YEAR_DN			EQU	0x1A	; Year down						;- v cskkentse
LIGHTLIM_DN		EQU	0x1B	; Light limit down				; Megvilgts hatr cskkentse
SET_SP			EQU	0x20	;Inc Scroll speed				; Scroll sebessg nvelse
SET_SP_DN		EQU	0x21	;Dec Scroll speed				; Scroll sebessg cskkentse
AnalogueMode	EQU	0x22	;Change analog hands displaying	; Analg mutatk lltsa
CENT_DN			EQU	0x24	; Century down					;- vszzad cskkentse
INDEX_DN		EQU	0x26	; Offset down					;- Offszet cskkentse
DAY_UP			EQU	0x28	; Day up						;- Nap nvelse
TStaticText		EQU 0x29	;Static picture					; Statikus kp zemmd,			BE/KI
DigitalMode		EQU	0x2A	;Change digital mode			; Digitlis kijelzs zemmd vltsa
TWDayName		EQU 0x2B	;Toggle Day of week name		; Ht napja szvegesen, VAGY HFOK, HT NAPJA SZMMAL,VAGY 12 RS MD
DemoM			EQU	0x2C	;Demo Mode						; Demo md vltsa,     DEM BE/KI
BRIGHT_ST		EQU	0x2D	; Bright setting step 			; Fnyer llts lpse : 1 / 16
TScrollMode		EQU	0x32	; Change scroll mode			; Scroll zemmd vltsa
TSlideShow		EQU	0x34	; Toggle slide show mode		; Slide show zemmd vltsa
AnalogClk		EQU	0x35	;Toggle analog clock with inner leds; A bels ledeken megjelen ra kijelzs vltsa
							;- overrides other hand settings; - fellbrlja a msik analg kijelzst, HROM MUTAT!
TTicks			EQU	0x36	; Toggle ticks					; raoszts vltsa,		12 RNL 2 VONS VAGY EGY!
TOuterLine		EQU	0x37	;Toggle outer led				; Kls led llapotvlts
AnalogueHands	EQU	0x38	;Change analog hands mode		; lptets: digital, 12 analg(sec vagy perc vagy ra vagy mindhrom mutatval, ue. 24rs)
TextMode		EQU	0x3C	;Scrolling text					; Mozg szveg zemmd,			BE/KI
TBinMode		EQU	0x3F	; Toggle binary mode			; Binris kijelzsre vlts, NEM KELL!!

; URC22B-n nem jutott nekik billenty

SAVE1			EQU	0x41	; Save settings  	#1			; Bellts mentse 1. helyre
RESTORE1		EQU	0x51	; Restore settings	#1			; Bellts visszalltsa 1. helyrl
SAVE2			EQU	0x42	; Save settings    	#2			; Bellts mentse 2. helyre
RESTORE2		EQU	0x52	; Restore settings	#2			; Bellts visszalltsa 2. helyrl
SAVE3			EQU	0x43	; Save settings    	#3			; Bellts mentse 3. helyre
RESTORE3		EQU	0x53	; Restore settings	#3			; Bellts visszalltsa 3. helyrl
SAVE4			EQU	0x44	; Save settings 	#4			; Bellts mentse 4. helyre
RESTORE4		EQU	0x54	; Restore settings	#4			; Bellts visszalltsa 4. helyrl
SAVE5			EQU	0x45	; Save settings  	#5			; Bellts mentse 5. helyre
RESTORE5		EQU	0x55	; Restore settings	#5			; Bellts visszalltsa 5. helyrl
SAVE6			EQU	0x46	; Save settings    	#6			; Bellts mentse 6. helyre
RESTORE6		EQU	0x56	; Restore settings	#6			; Bellts visszalltsa 6. helyrl
SAVE7			EQU	0x47	; Save settings    	#7			; Bellts mentse 7. helyre
RESTORE7		EQU	0x57	; Restore settings	#7			; Bellts visszalltsa 7. helyrl

SEC_CL			EQU	0x60	; Clear seconds NO!					; Msodperc trlse

; Definition of Functions on the Propeller clock's Base
; address: 0x14, URC22B, cod:0552

STANDBY		EQU	0x0C	; POWER
POWUPCOIL	EQU	0x10	; Power up coil					; Traf bekapcsolsa
POWDNCOIL	EQU	0x11	; Power down coil				; Traf kikapcsolsa
REL_ON		EQU	0x20	; Relais ON						; Rel kimenet bekapcsolsa
REL_OFF		EQU	0x21	; Relais OFF					; Rel kimenet kikapcsolsa
TINDEX		EQU	0x30	; Toggle index					; Index led ki / bekapcsolsa
ALM_SND		EQU 0x36	; Alarm sound off				; bresztsi hangjelzs kikapcsolsa

WIDTH_UP	EQU	0x70	; PWM pulse width up			; Impulzus szlessg nvelse,		NEM TUDOM AKAROM-E?
WIDTH_DN	EQU	0x71	; PWM pulse width down			; Impulzus szlessg cskkentse,	NEM TUDOM AKAROM-E? 




