//I am Using a 128 x 64 Graphics LCD for ths project.
//Very Cool and perfect result
//Pictures are attached.


#include <U8glib.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>
#define reed A0//pin connected to read switch
#define tank A1
#define fok A2
Adafruit_PCD8544 display = Adafruit_PCD8544(3, 4, 5, 7, 6);
//calculations
//tire radius ~ 13.5 inches
//circumference = pi*2*r =~85 inches
//max speed of 35mph =~ 616inches/second
//max rps =~7.25
//storage variables

long timer;// time between one full rotation (in ms)
float radius = 9.25;// tire radius (in inches)
float circumference;

float maxReedCounter = 90;//min time (in ms) of one rotation (for debouncing)
float reedCounter;
float liter;
float temp;
int reedVal;
int kph;
int rpm;
int mph;

void setup(void) {
  pinMode(reed, INPUT);
  pinMode(tank, INPUT);
  pinMode(fok, INPUT);
  display.begin();  
  
  display.setContrast(50);
   // bemásolni egy voltmérö részét.
  reedCounter = maxReedCounter;
  circumference = 2*3.14*radius;
  
  // TIMER SETUP- the timer interrupt allows precise timed measurements of the reed switch
  //for more info about configuration of arduino timers see http://arduino.cc/playground/Code/Timer1
  cli();//stop interrupts

  //set timer1 interrupt at 1kHz
  TCCR1A = 0;// set entire TCCR1A register to 0
  TCCR1B = 0;// same for TCCR1B
  TCNT1  = 0;
  // set timer count for 1khz increments
  OCR1A = 1999;// = (1/1000) / ((1/(16*10^6))*8) - 1
  // turn on CTC mode
  TCCR1B |= (1 << WGM12);
  // Set CS11 bit for 8 prescaler
  TCCR1B |= (1 << CS11);   
  // enable timer compare interrupt
  TIMSK1 |= (1 << OCIE1A);
  
  sei();//allow interrupts
  //END TIMER SETUP
  
}


ISR(TIMER1_COMPA_vect) {//Interrupt at freq of 1kHz to measure reed switch
  reedVal = digitalRead(reed);//get val of A0
  if (reedVal){//if reed switch is closed
    if (reedCounter == 0){//min time between pulses has passed
      mph = (58.09*float(circumference))/float(timer);//calculate miles per hour
      rpm = (float(60000))/(float(timer));
      timer = 0;//reset timer
      reedCounter = maxReedCounter;//reset reedCounter
      kph = mph * 1.609344;
    }
    else{
      if (reedCounter > 0){//don't let reedCounter go negative
        //reedCounter -= 1;//decrement reedCounter
      }
    }
  }
  else{//if reed switch is open
    if (reedCounter > 0){//don't let reedCounter go negative
      reedCounter -= 1;//decrement reedCounter
    }
  }
  if (timer > 1000){
    mph = 00.00;
  kph = 00.00;//if no new pulses from reed switch- tire is still, set mph, rpm and kph to 0
  rpm=0;
  }
  else{
    timer += 1;//increment timer
  } 
  
}

 
void loop(void) { 
   
 
  display.clearDisplay();
  liter = (analogRead(tank) * 5.0) / 1024.0;
   temp = (1.1 * analogRead(fok) * 100.0) / 1024.0;
  
  display.setRotation(0);  // rotate 90 degrees counter clockwise, can also use values of 2 and 3 to go further.
  display.setTextSize(1);  // szöveg mérete 1, 2, 3, 4
  display.setTextColor(BLACK); // szöveg szine
  display.setCursor(0,0);
  display.println("Temp:");
  display.setCursor(30, 0);
  display.println(temp);
  display.setCursor(68,0);
  display.println("C");
  display.setTextSize(4);
  display.println(kph);
  display.setTextSize(1);
  display.setCursor(45, 10);
  display.println("Speed"); 
  display.setTextSize(2);
  display.setCursor(45, 18);
  display.println("KmH");
  display.setTextSize(1);
  display.setCursor(0, 40);
  display.println("Benzin:");
  display.setCursor(45, 40);
  display.setTextSize(1);
  display.println(liter);
  display.setCursor(70, 40);
  display.print("L");
  display.display();
  delay(10);               // várakozás
  
              }