/*********************************************************************************************************
*
* File                : main.c
* Hardware Environment: 
* Build Environment   : RealView MDK-ARM  Version: 4.20
* Version             : V1.0
* By                  : 
*
*                                  (c) Copyright 2005-2011, WaveShare
*                                       http://www.waveshare.net
*                                          All Rights Reserved
*
*********************************************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx.h"
//#include "stdlib.h"
#include "sdcard.h"
#include "string.h"
#include "diskio.h"
#include "ff.h"

/* Private functions ---------------------------------------------------------*/
FATFS FatFs;            // Work area (file system object) for logical drive
FIL MyFile;      // file objects
BYTE buffer[512]; // file copy buffer
FRESULT res;         // FatFs function common result code
UINT br, bw;         // File R/W count
  
#if _USE_LFN
char Fs_LongFileName[_MAX_LFN * (_DF1S ? 2 : 1) + 1];
#endif
/*******************************************************************************
* Function Name  : NVIC_Config
* Description    : Configures SDIO IRQ channel.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NVIC_Configuration(void)
{
  NVIC_InitTypeDef NVIC_InitStructure;

  /* Configure the NVIC Preemption Priority Bits */
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_1);

  NVIC_InitStructure.NVIC_IRQChannel = SDIO_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
}

/*******************************************************************************
* Function Name  : main
* Description    : Main program.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{    
  char buff[200] = {0};
  SystemInit();/* Clock Config */
  
  NVIC_Configuration();/* Interrupt Config */ 

  disk_initialize(0);
  
 /* f_mount(0, &FatFs);
  res = f_open(&MyFile, "ecco.md", FA_OPEN_EXISTING | FA_READ);
  res = f_read(&MyFile, buffer, sizeof(buffer), &br);
  f_close(&MyFile);   
  f_mount(NULL, &FatFs); */ 
  
  char MyNewFile[] = "valami6.txt";
  
  f_mount(0, &FatFs);
  res = f_open(&MyFile, MyNewFile, FA_CREATE_ALWAYS | FA_WRITE);
  char SzBuff[] = "Mindent bele fik...";
  sprintf(buff, "Teszt file: \nzenet: %s \nFile neve: %s", SzBuff, MyNewFile);
  res = f_write(&MyFile, buff, sizeof(buff), &bw);
  f_close(&MyFile);     
  f_mount(NULL, &FatFs);
  
  f_mount(0, &FatFs);
  res = f_open(&MyFile, MyNewFile, FA_OPEN_EXISTING | FA_READ);
  res = f_read(&MyFile, buffer, sizeof(buffer), &br);
  f_close(&MyFile);   
  f_mount(NULL, &FatFs);  
      
  
  /* Infinite loop */
  while (1)
  {}
}


/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
