// RC5 Sender
// Alle Routinen zur Phasenmodulation
//
// Copyright 2000 by Holger Klabunde
// 30.04.2001
// Compiler CC5x

#include "prozess.h"      /* Der verwendete Prozessor */

#include "rc5send.h" //Pindefinitionen
#include "protos.h"

//Eine 0 senden
void SendBit0()
{
 unsigned char i;

 //890us Impuls mit 36kHz senden
 //Bei 28us Periodendauer ergibt das 32 Impulse
 //Die Befehle unten ergeben nur 18us*32 = 576us
 //Der Rest wird mit dem Schleifenoverhead verbraten
 //Deshalb sieht die Nullphase auch krzer aus als sie
 //tatschlich ist !
 for(i=0; i<32; i++)
  {
   LED_ON();
   NOP; NOP; NOP; NOP; NOP; NOP;
   NOP; NOP; NOP; NOP; NOP; NOP;
   LED_OFF();
   NOP; NOP; NOP; NOP; NOP; NOP;
  }

//890us Pause
 for(i=0; i<32; i++)
  {
   NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
   NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
  }

}

//Eine 1 senden
void SendBit1()
{
 unsigned char i;

//890us Pause
 for(i=0; i<32; i++)
  {
   NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
   NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
  }

 //890us Impuls mit 36kHz senden
 for(i=0; i<32; i++)
  {
   LED_ON();
   NOP; NOP; NOP; NOP; NOP; NOP;
   NOP; NOP; NOP; NOP; NOP; NOP;
   LED_OFF();
   NOP; NOP; NOP; NOP; NOP; NOP;
  }
}

void PhaseMod()
{
 unsigned char mask;     
 unsigned char i;
 
 SendBit1(); //Erstes Startbit=1
 SendBit1(); //Zweites Startbit=1

//Togglebit
   if(toggle==0)
    {
     SendBit0();
    }
   else
    {
     SendBit1();
    }  
//Ende Togglebit

//5 Bit Gertecode
   mask=0x10; //Beginn bei MSB
   
   for(i=0; i<5; i++)
    {
     if(SUBCODE&mask) //Send 1
      {
       SendBit1();
      }
     else //Send 0
      {
       SendBit0();
      }
      
     mask>>=1;   //Nchstes Bit
    }
//Ende Gertecode

//6 Bit Kommandocode
   mask=0x20; //Beginn bei MSB
   
   for(i=0; i<6; i++)
    {
     if(comcode&mask) //Send 1
      {
       SendBit1();
      }
     else //Send 0
      {
       SendBit0();
      }
     mask>>=1;  //Nchstes Bit
    }
//Ende Kommandocode

//bertragung komplett
   LED_OFF(); //IR-LED abschalten
   Delay1ms(113); //Totzeit 64Bits a 1,78ms
}

