// Hauptprogramm
// RC5 Sender
// Sendet 16 verschiedene Codes
//
// Das Programm kann nur einen Taster zur Zeit auswerten !!
//
// Copyright 2000 by Holger Klabunde
// 19.05.2001
// Compiler CC5x

#include "prozess.h"      /* Der verwendete Prozessor */

#include "rc5send.h" //Pindefinitionen
#include "protos.h"

#include "delay.c"
#include "phasemod.c"

//Globale Flags und Rckgabevariablen

unsigned char toggle;   //Togglebit
unsigned char togglemask0; //Merkt sich die Togglbits der Tasten
unsigned char togglemask1; //Merkt sich die Togglbits der Tasten
unsigned char comcode;  //Kommandocode

void FindRow(); //Nur ein Prototyp

/* Hauptprogramm */
void main()
{
 unsigned char i,buf,buf1;
 
 CLRWDT;         //Laut Datenblatt vor ndern Prescaler fr TMR0
 OPTION=0b10000001;	 //Pullups off,Prescaler 1:4 und int. Clock	
                       
//Ein TimerClock = 1us * 4 = 4us

 TRISA=0x00; // PortA alles Ausgnge
 TRISB=0xF0; // PortB4..7 Eingnge, PORTB0..3 Ausgnge

 PORTB=0xF0;    //Definierten Zustand einstellen
 PORTA=0;

 togglemask0=0; //Toggle Bits 0..7
 togglemask1=0; //Toggle Bits 7..15

 while(1) // Anfang Programm Endlosschleife
  {
   RBIE=1; //Port Change Int erlauben
   RBIF=0; //Port Change Int Flag lschen

   SLEEP;  //Schlafen bis Taste gedrckt wird
   NOP;    //Beim aufwachen erstmal nix tun
   
   comcode=0x40; //Letzten Tastencode mit Wert >15 lschen

   RBIE=0; //Port Change Int verbieten, sonst geht nix weil PORTB
           //beim scannen der Matrix verndert wird
   RBIF=0; //Port Change Int Flag lschen

   //Spalten der Tastermatrix checken
   if(PORTB.4==0) { comcode=0; FindRow(); }   //Taster 0..3 
   if(PORTB.5==0) { comcode=4; FindRow(); }   //Taster 4..7
   if(PORTB.6==0) { comcode=8; FindRow(); }   //Taster 8..11
   if(PORTB.7==0) { comcode=12; FindRow(); }  //Taster 12..15
    
   if(comcode<8)
    {

     //Togglebit der Taste merken bzw. verndern
     buf=0x01<<comcode; //Togglebit auf richtige Position schieben
     if(togglemask0&buf) //Togglebit Gesetzt ?
      {
       togglemask0&=~buf; //Dann lschen
       toggle=0;         //Neues Togglebit
      }
     else //War nicht gesetzt
      {
       togglemask0|=buf; //Dann setzen
       toggle=1;        //Neues Togglebit
      }

     for(i=0; i<5; i++) PhaseMod(); //Codes 5x phasenmoduliert senden

     //Warten bis Taste losgelassen wird
     do
      {
       buf=PORTB&0xF0; //Portb nochmal lesen
      } while(buf!=0xF0);
     Delay1ms(50); //Tasterprellen abwarten

    }//if comcode
      
   if(comcode>7 && comcode<16)
    {
     buf1=comcode-8;

     //Togglebit der Taste merken bzw. verndern
     buf=0x01<<buf1; //Togglebit auf richtige Position schieben
     if(togglemask1&buf) //Togglebit Gesetzt ?
      {
       togglemask1&=~buf; //Dann lschen
       toggle=0;         //Neues Togglebit
      }
     else //War nicht gesetzt
      {
       togglemask1|=buf; //Dann setzen
       toggle=1;        //Neues Togglebit
      }

     for(i=0; i<5; i++) PhaseMod(); //Codes 5x phasenmoduliert senden

     //Warten bis Taste losgelassen wird
     do
      {
       buf=PORTB&0xF0; //Portb nochmal lesen
      } while(buf!=0xF0);
     Delay1ms(50); //Tasterprellen abwarten

    }//if comcode
 
  } // Ende Programm Endlosschleife
}

//Zeilen der Schaltermatrix checken
//PORTB0..3 nacheinander einzeln auf 1 legen bis die 0 an PORTB4..7 verschwindet
void FindRow()
{
 unsigned char i,buf,mask;

 mask=1;
 for(i=0; i<4; i++)
  {
   PORTB=mask;     //Ausgang auf 1 setzen
   buf=PORTB&0xF0; //PORTB lesen und PORTB0..3 ausblenden
   PORTB=0xF0;        //nicht vergessen Ausgnge wieder auf 0 zu legen !
   if(buf==0xF0) return; //Alle Eingnge wieder 1 ? Dann Schalter gefunden
   comcode++; //einen Schalter weiterzhlen
   mask<<=1;  //nchstes Portbit
  }
}