#include "stm32f4xx_hal.h"
#include "tim.h"
#include "gpio.h"

#include "myVariables.h"
#include "myFunctions.h"


void motorSetDuty(uint32_t Channel, int Duty){
	int Compare;
	Compare=2099*Duty/100;
	if(Compare>2090)Compare=2090;	// limited, because FET driver needs continuous toggling
	if(Compare<10)Compare=10;		// for bootstrapping high-side FETs

	if(Channel==MOTOR_A){
		__HAL_TIM_SET_COMPARE(&htim2, TIM_CHANNEL_1, Compare);
	}
	if(Channel==MOTOR_B){
		__HAL_TIM_SET_COMPARE(&htim2, TIM_CHANNEL_2, 2099-Compare); // direction reversed for opposite motor
	}
}

void motorSetVoltage(uint32_t Channel, double Voltage){
	int Compare;
	Compare=(int)(2099.0*Voltage/batteryVoltage/2.0+1050.0);
	if(Compare>2090)Compare=2090;	// limited, because FET driver needs continuous toggling
	if(Compare<10)Compare=10;		// for bootstrapping high-side FETs

	if(Channel==MOTOR_A){
		__HAL_TIM_SET_COMPARE(&htim2, TIM_CHANNEL_1, Compare);
	}
	if(Channel==MOTOR_B){
		__HAL_TIM_SET_COMPARE(&htim2, TIM_CHANNEL_2, 2099-Compare); // direction reversed for opposite motor
	}
}

void motorEnable(uint8_t Enable){
	if(Enable==TRUE){
		HAL_GPIO_WritePin(MOTOR_ENABLE_GPIO_Port,MOTOR_ENABLE_Pin,GPIO_PIN_SET);
	}
	if(Enable==FALSE){
		HAL_GPIO_WritePin(MOTOR_ENABLE_GPIO_Port,MOTOR_ENABLE_Pin,GPIO_PIN_RESET);
	}
}
