import pyb , time, array

asize=100 ; ai=0 ; arr=array.array("I") # gyűrűs buffer
bsize=37 ; bi=0 ; buf=array.array("I")  # segéd buffer a debughoz
for i in range(asize): # micropythonban így lehet initializálni ezt a tömb tipust
    arr.append(0)
for i in range(bsize):
    buf.append(0)
# az időzítések tartományként vannak meghatározva
AEP=range(8200,9700) ; ASP=range(1700,2100) ; ALP=range(3700,4200) ; protwidth=37
s="" ; ert=None ; temp=humy=ch=0 ; elozo=time.ticks_us()
# a module adat lába ide csatlakozik
rfpin = pyb.Pin('Y12', pyb.Pin.IN , pyb.Pin.PULL_NONE)
def f():
    global elozo,ert, rfpin
    up=rfpin()==1 
    a = time.ticks_us() - elozo
    elozo=time.ticks_us()
    if up:  # csak a felfutó ágat vizsgálom
        ert = a # így tudtam megoldani, mert a megszakítást gyorsan le kell tudni

T_SER = T_WRK = time.ticks_ms()
# az adat láb megszakításának beállítása az előbb megadott funkcióra, fel és lefutó ág is kell
ext = pyb.ExtInt(rfpin, pyb.ExtInt.IRQ_RISING_FALLING, pyb.Pin.PULL_NONE, lambda t: f() )
while True:
    if ert!=None:
        arr[ai]=ert ; ai+=1 ; ai%=asize
        if ert in AEP:
            if ai<protwidth:
                i=asize-(protwidth-ai)
            else:
                i=ai-protwidth
            s=""
            bi=0
            err=False
            for x in range(protwidth-1): # mert nem kell bele az AEP
                if arr[i] in ASP:
                    s+='0'
                elif arr[i] in ALP:
                    s+='1'
                else:
                    s+='_'
                    err=True
                buf[bi]=arr[i]
                i+=1 ; i%=asize ; bi+=1
            if s[0:4]!="0101": #fejléc ellenőrzése
                err=True
            
            if err:
                print("ERR:" + s)
                print( buf )
            else:
                temp=int( s[16:28] ,2 )    # bináris adat számmá alakítása a megadott poz.-ban
                if (temp > 3840): temp -= 4096; # negatív hőmérséklet lekezelése
                temp/=10 # 293 = 29.3 
                humy = int( s[29:36] , 2)  # a páratartalom szimplán egészként van átadva
        ert=None
    
    if time.ticks_ms()-T_SER>1000: # másodpercenként kiírja ha van dekódolt adat
        T_SER=time.ticks_ms()
        if temp!=0:
            print("temp: %.1fC, humy: %d%%" % (temp, humy))
            print(s)
            temp=0
        print("*")
