/*
 * DPTP SYSTEM - PWM, ADC
 * Dtum:   2018 aug. 30. Cstrtk
 * Email:	don_peter@freemail.hu
 * Processor: PIC16F684
 * Frdt:  HI-TECH C for PIC10/12/16
 */

#include <htc.h>			// 10,12,16-os PIC definicik
#include <pic16f684.h>		// Mikrokontroller kivlasztsa
#include <stdio.h>			// Alap fggvnyek
#include <stdlib.h>
#include <string.h>
#include "header.h"			// Configurcis belltsok
#include "lcd.h"	

#define LED3	RC4			// Piros

volatile unsigned int ADC = 0;
volatile unsigned int Count = 0;

// ---------------------------- //
//  Prototpusok			    //
// ---------------------------- //
void init();
void delay(short int ms);
unsigned char PWMDuty(unsigned char duty);
unsigned int read_ADC(unsigned char channel);

// ---------------------------- //
//  Interrupt				    //
// ---------------------------- //
void interrupt ISR(void) {

	if(INTF && INTE){
		//ADC		= read_ADC(3);
		LED3	= !LED3;
		Count++;
		INTF	= 0;
	}

	/*if(TMR1IF==1){
		ADC		= (read_ADC(3) + ADC *7) >> 3;
		TMR1H	 = 0x0B;
    	TMR1L	 = 0xDB;
		LED3	= !LED3;
		TMR1IF	= 0;
	}*/

}

void main(void){
	unsigned int i = 0;
	unsigned char x = 0, tomb[10] = {0};
	float temp = 0;

	init();

	Lcd4_Init();
	
	Lcd4_Set_Cursor(1,0);
    Lcd4_Write_String("DPTP System");
	__delay_ms(1000);

	//ADC = read_ADC(3);
	//Lcd4_Set_Cursor(2,0);
	//lcd_bcd_digit(ADC, 4);

	CCPR1L	= PWMDuty(50);

	while (1){
		
		//LED3 = !LED3;

		Lcd4_Clear();
		Lcd4_Set_Cursor(1,0);
    	lcd_bcd_digit(i++, 4);
		Lcd4_Set_Cursor(1,6);
    	lcd_bcd_digit(Count, 5);
		//ADC = read_ADC(3);
		//temp = 0;
		//for(x=0; x<10; x++) temp += read_ADC(3);
		//ADC = (int)temp/10; 
		//__delay_ms(1000);
		Lcd4_Set_Cursor(2,0);
    	lcd_bcd_digit(ADC, 4);
		__delay_ms(500);
	}//while
	
}//main

// ---------------------------- //
//  Fggvnyek				    //
// ---------------------------- //
void init(){

	TRISC	= 0x00;				// kimenet
	TRISA	= 0x14;				// A4 bemenet
	ANSEL	= 0b00001000;		// AN3 analog tbbi lb digitlis
	CMCON0	= 7;				// Comparator kikapcsolva
	PEIE	= 1;				// Peripheral interrupt engedlyezse
	GIE		= 1;				// Globlis interrupt engedlyezse
	OSCCON	= 0b01000001;		// 1MHz-es bels rajel belltva

	CCPR1L 	= 0b01111100;		// 124
	CCP1CON = 0b00111100;

	INTEDG	= 1;				// Felfut lre
	INTF	= 0;				// INT flag
	INTE	= 1;				// INT engedlyezse

	/*
	 * PWM registers configuration
	 * Fosc = 1000000 Hz
	 * Fpwm = 1000.00 Hz (Requested : 1000 Hz)
	 * Duty Cycle = 50 %
	 * Resolution is 9 bits
	 * Prescaler is 1
	 * Ensure that your PWM pin is configured as digital output
	 * see more details on http://www.micro-examples.com/
	 * this source code is provided 'as is',
	 * use it at your own risks
	*/
	PR2 	= 0b11111001;		// 249
	T2CON	= 0b00000100;
		
	ADCON0	= 0b10001100;		// Right justified, VDD Ref, A3 chanel, A/D enabled
	ADCON1	= 0x00;				// FOSC/2
	ADON	= 0;				// AD enabled

	/*T1CON	 = 0x01;			// 1:1 Prescale, T1 enabled
    TMR1IF	 = 0;
	// 25Hz (1mp/4)
    TMR1H	 = 0x0B;
    TMR1L	 = 0xDB;
	// 100Hz
	//TMR1H	 = 0xF6;
    //TMR1L	 = 0x3B;
	TMR1IE	 = 0;				// Interrupt engedlyezve*/

	
}

 //---- ksleltet fggvny
 void delay(short int ms){
	short int i;
	for(i=0; i<=ms; i++);
}

// Kitlts belltsa
unsigned char PWMDuty(unsigned char duty){
	float temp = 0;
	temp = 255 / 100+0.5;
	return (unsigned char)(temp*duty);
}

/* Return an 16 bit result */
unsigned int read_ADC(unsigned char channel){
	//channel&=0x07;	// truncate channel to 3 bits
	//ADCON0&=0xC5;	// clear current channel select
	//ADCON0|=(channel<<3);	// apply the new channel select
	GODONE=1;	// initiate conversion on the selected channel
	while(GODONE)continue;
	return(((ADRESH<<8)+(ADRESL)));
}
