;__________________________________________________________________________________________________
;|-------------------------------------------------------------------------------------------------|
;| :    
;|-------------------------------------------------------------------------------------------------|
;| :      picmaniac (picmaniac@rambler.ru)  : 0.1b   : 23  2006 .   FREEWARE |
;|-------------------------------------------------------------------------------------------------|
;|-------------------------------------------------------------------------------------------------|
;|  :										   |
;|-------------------------------------------------------------------------------------------------|
;|    : 
;|-------------------------------------------------------------------------------------------------|
;|   :    MPLAB 5.70.40  WINDOWS 98SE                          |
;|_________________________________________________________________________________________________|

                 LIST P=16F84A  
                 #include <P16F84A.inc>           ;    MPLAB
                 __CONFIG _CP_OFF & _PWRTE_ON & _WDT_ON & _XT_OSC
		 radix    hex

;                          ---   ---

;                         ---  ---

jnz	MACRO	metka1             ;  ,
	btfss	STATUS,Z           ;   0
	goto	metka1
	endm
jz	MACRO	metka2             ;  ,
	btfsc	STATUS,Z           ;  0
	goto	metka2
	endm
jnc	MACRO	metka3             ;  ,
	btfss	STATUS,C	   ;   
	goto	metka3
	endm
jc	MACRO	metka4             ;  ,
	btfsc	STATUS,C	   ;  
	goto	metka4
	endm
mov     MACRO   DEST1,SOURCE1      ;  -
	movf    SOURCE1,W
	movwf   DEST1
	endm
mvi     MACRO   DEST2,CONST2       ;    
	movlw   CONST2
	movwf   DEST2
	endm

;                         ---   ---
W_copy		EQU	020h			;     
ST_copy		EQU	021h			;  
FSR_copy	EQU	022h

ADDRESS		EQU	023h			;   ,   
SELECTOR	EQU	024h			;    (.  )

TH		EQU	025h			;  -  
TL		EQU 	026h			;  -  
CRCPIC		EQU	027h			;  ,  
TRY		EQU	028h			;    1-Wire
COUNTER		EQU	029h			;  (     1-Wire)

FIGX000		EQU	02Ah			;    
FIG000X		EQU	02Bh			; 
FIG00X0		EQU	02Ch			; - ,
FIG0X00		EQU	02Dh			;   

OUTA		EQU	02Eh			;    


TEMP1            EQU      03Ch              ;  
TEMP2            EQU      03Dh              ;  
FLAGS		 EQU      03Fh		    ; 


SCALE		 EQU	  032h		    ;      DELETE
DIGITS		 EQU	  033h		    ;      DELETE


;				---  ---
		ORG 0				; 
Reset		bcf	STATUS,RP0		;   0
		bcf	STATUS,RP1
		goto    Begin			;    
;--------------------------------------------------------------------------------------------------
;			---   ---
;--------------------------------------------------------------------------------------------------
		ORG 4				; 
Interrupt	movwf	W_copy			; 
		mov	ST_copy,STATUS
		mov	FSR_copy,FSR

		movlw	B'00010000'		;     4
		andwf	OUTA,F			; ,   (PORTA)
		movf	OUTA,W			;
		movwf	PORTA			;
		movf	SELECTOR,W		;   
		iorwf	OUTA,F			; 

		movf	ADDRESS,W		;       
		movwf	FSR			;  FSR ( )
		movf	INDF,W			;        W
		movwf	PORTB			;   PORTB   

		movf	OUTA,W			; 
		movwf	PORTA			; 

		bcf	STATUS,C
		rrf	SELECTOR,F
						; ,      (a,b)
		btfss	STATUS,C		;     ,   (1)
		goto	Int_label		;   ,  (2a) / nop(1b)

		movlw	FIGX000			;    (1b)
		movwf	ADDRESS			;  ADDRESS -    (1b)
		movlw	B'00001000'		;        (1b)
		movwf	SELECTOR		;   (1b)
		goto	End_int			;(2b)    b: 1b+1b+1b+1b+1b+2b = 7 

Int_label	incf      ADDRESS,F             ;       (1a)
		nop
		nop
		goto      End_int               ;(2a)    : 2a+1a+1a+1a+2a = 7 

End_int		bcf	INTCON,T0IF		;       TMR0
		mov	FSR,FSR_copy
		mov	STATUS,ST_copy		; 
		swapf	W_copy,F		;  ,    Z  STATUS
		swapf	W_copy,W		;(movf   ,  swapf - )
		retfie				;      GIE
;--------------------------------------------------------------------------------------------------
;                          ---  ---
;--------------------------------------------------------------------------------------------------
		;   7-. 

DC7		 clrwdt
		 clrf      PCLATH
		 addwf     PCL,F		 ; 
		 retlw     B'00100100'		 ; 0
		 retlw     B'11100111'		 ; 1
		 retlw     B'01001100'		 ; 2
		 retlw     B'01000101'		 ; 3
		 retlw     B'10000111'		 ; 4
		 retlw     B'00010101'		 ; 5
		 retlw     B'00010100'		 ; 6
		 retlw     B'01100111'		 ; 7
		 retlw     B'00000100'		 ; 8
		 retlw     B'00000101'		 ; 9
		 retlw     B'00010101'           ; 
						 ;    7-. 
;--------------------------------------------------------------------------------------------------
                ;  (  TEMP1)

Pause            clrwdt
		 movwf     TEMP1            ;     W (  )
		 movf      TEMP1,F          ;  0
		 btfsc     STATUS,Z         ;    0,  Z=0   return
		 return                     ;    0,   
		 clrw                       ; W
P_label          addlw     01h              ;   W
		 jnz       P_label
                 decfsz    TEMP1,F          ;   TEMP1
                 goto      P_label          ;
		 clrwdt  
		 return                     ;  
;--------------------------------------------------------------------------------------------------
		;   DS18B20 (  TEMP1)

TestDS		 movlw     038h			 ;
		 btfss     PORTA,4               ;   ?
		 goto      Test4_label		 ;,  - , 

		 bcf       OUTA,4                ; 1-Wire
		 movf      OUTA,W
		 movwf     PORTA                 ;  (  480 )
		 movlw     050h
Test1_label      addlw     01h
                 btfss     STATUS,Z              ;(    3  
                 goto      Test1_label           ;   TMR0)
		 bsf       OUTA,4
		 movf      OUTA,W
		 movwf     PORTA                 ; 1-Wire 

		 movlw     D'239'
Test2_label      addlw     01h                   ;   DS18B20 ( ~70 )
                 btfss     STATUS,Z
                 goto      Test2_label

		 clrf      TEMP1
		 movlw     D'252'
Test3_label      btfss     PORTA,4               ;  (0) ?
		 incf      TEMP1,F		 ; -  TEMP1
		 addlw     01h                   ;
                 btfss     STATUS,Z
                 goto      Test3_label

		 goto      Testend_label         ;

Test4_label      addlw     01h                   ;   
                 jnz       Test4_label
		 movlw     0

Testend_label	 movlw     075h
		 addlw     01h                   ;   DS18B20
                 jnz       Testend_label+1

		 movlw     04h			 ;  DS18B20 ,  TEMP1 = 4
		 xorwf     TEMP1,W
		 btfsc     STATUS,Z              ;TEMP1 = 4 ? 
		 movlw     0FFh                  ;  -    (W=0FFh)

Stop_label	 return                          ;  
;--------------------------------------------------------------------------------------------------
		; /   1-Wire (   W=0FFh).  TEMP1
RW_1Wire	 
		 movwf     TEMP1		 ;   W
		 movlw     08h                   ;8 
		 movwf     COUNTER
RWLoop		 bcf       INTCON,GIE            ;  
		 bcf       OUTA,4                ;0 --> 1-Wire
		 mov       PORTA,OUTA
		 btfsc     TEMP1,0
		 bsf       OUTA,4                ;,   TEMP1 = 1
		 mov       PORTA,OUTA
		 rrf       TEMP1,F               ;  
		 movlw     0FDh			 ; ~12 
RW_1label        addlw     01h
		 jnz       RW_1label

		 bcf       TEMP1,7               ;    TEMP1
		 btfsc     PORTA,4
		 bsf       TEMP1,7
.
		 movlw     D'220'                ;    
RW_2label        addlw     01h
		 jnz       RW_2label

		 bsf       OUTA,4                ; 
		 mov       PORTA,OUTA
		 bsf       INTCON,GIE            ; 

		 decfsz    COUNTER,F		 ;8  ?
		 goto      RWLoop                ;  - 

		 movf      TEMP1,W               ;   W

		 return				 ;  /   1-Wire
;--------------------------------------------------------------------------------------------------
		;  CRC.   W.   TEMP1, TEMP2

NewCRC		 clrwdt
		 movwf     TEMP2                 ; W
		 movlw     08h
		 movwf     COUNTER               ;8 --> COUNTER
		 movf      TEMP2,W               ;  W
CRC_label	 xorwf     CRCPIC,W              ;. CRCPIC  W,   W
		 movwf     TEMP1                 ;   TEMP1
		 rrf       TEMP1,W               ; TEMP1   1,   W,    
		 movf      CRCPIC,W              ;CRCPIC --> W (   )
		 btfsc     STATUS,0
		 xorlw     018h                  ; =0,     
		 movwf     TEMP1                 ;  TEMP1
		 rrf       TEMP1,W               ; ,   W
		 movwf     CRCPIC                ;   CRCPIC
		 bcf       STATUS,0              ;0 --> C
		 rrf       TEMP2,F               ; TEMP2   1
		 movf      TEMP2,W               ;     W
		 clrwdt
		 decfsz    COUNTER,F
		 goto      CRC_label
 		 return				 ;   CRC
;__________________________________________________________________________________________________
;
;                ---    ---
;__________________________________________________________________________________________________

Begin
		movf	PORTA,F			;  
		movf	PORTB,F			; 

		clrf	INTCON

		mvi	OUTA,B'00010000'	; 
		movwf	PORTA
		mvi	PORTB,B'11111111'	;

		clrwdt
		clrf	TMR0
		bsf	STATUS,RP0		;   1    TRIS  OPTION_REG
		clrf	TRISA			;     'OOOOOOOO' (I-in, O-out)
		clrf	TRISB			;   B  'OOOOOOOO'
		mvi	OPTION_REG,B'00000111'	;  TMR0  =256  OSC
		clrwdt
		mvi	OPTION_REG,B'00001101'	;  32  WDT, TMR0 - 
		bcf	STATUS,RP0		;   0

		mvi	ADDRESS,FIGX000		;  ADDRESS     
		mvi	SELECTOR,B'00001000'	;    

		mvi	FIGX000,B'11111111'	; "_OFF"
		mvi	FIG0X00,B'00100100'
		mvi	FIG00X0,B'00011110'
		mvi	FIG000X,B'00011110'

		bsf	INTCON,T0IE		;   TMR0
		bsf	INTCON,GIE		;  

;------------------------------------------------
Online_label     clrwdt		                 ;   DS18B20

		 clrf      TMR0

		 call      TestDS		 ;   
		 xorlw     0FFh
		 jnz       Begin		 ; -    

		 movlw     0CCh			 ; "Skip ROM"
		 call      RW_1Wire
		 movlw     044h			 ; "Convert T"
		 call      RW_1Wire

		 movlw     0FFh 		 ;  
		 call      Pause
		 movlw     0FFh
		 call      Pause
		 movlw     0FFh
		 call      Pause

		 mvi       TRY,08h               ;8  

Newtry_label	 clrwdt                 	 ;    DS18B20
		 clrf      TMR0
		 call      TestDS		 ;   
		 xorlw     0FFh
		 jnz       Begin		 ; -    

		 movlw     0CCh			 ; "Skip ROM"
		 call      RW_1Wire
		 movlw     0BEh			 ; "Read Scratchpad"
		 call      RW_1Wire

		 clrf      CRCPIC
		 movlw     0FFh
		 call      RW_1Wire
		 movwf     TL                    ;  
		 call      NewCRC
		 movlw     0FFh
		 call      RW_1Wire
		 movwf     TH                    ;  
		 call      NewCRC
		 movlw     0FFh                  ;  
		 call      RW_1Wire
		 call      NewCRC
		 movlw     0FFh
		 call      RW_1Wire
		 call      NewCRC
		 movlw     0FFh
		 call      RW_1Wire
		 call      NewCRC
		 movlw     0FFh
		 call      RW_1Wire
		 call      NewCRC
		 movlw     0FFh
		 call      RW_1Wire
		 call      NewCRC
		 movlw     0FFh
		 call      RW_1Wire
		 call      NewCRC

		 movlw     0FFh
		 call      RW_1Wire
		 xorwf     CRCPIC,W              ;  CRC
		 jz        OKCRC_label           ; - 

		 decfsz    TRY,F
		 goto	   Newtry_label          ; -  
		 goto      Begin                 ; 

OKCRC_label	 clrwdt
		 rrf	   TH,F
		 rrf	   TL,F
		 rrf	   TH,F
		 rrf	   TL,F
		 rrf	   TH,F
		 rrf	   TL,F			; 64 | 32 | 16 | 8 || 4 | 2 | 1 | 0.5

		 movlw	   0FFh
		 movwf	   FIGX000		 ;  
		 movwf	   FIG0X00
		 movwf	   FIG00X0
		 movwf	   FIG000X

;------------------------------------------------

		 btfss	   TH,0			 ; ?
		 goto	   T100_label		 ; -    "/ 100"

		 mvi	   FIGX000,B'11011111'	 ; -  "-"   
		 comf	   TL,F			 ;  
		 incf	   TL,F			 ;  
		 goto	   Tshow_label		 ;

;------------------------------------------------

T100_label	 bcf	   STATUS,C
		 rrf	   TL,W			 ; W = <0> | 64 | 32 | 16 || 8 | 4 | 2 | 1 
		 addlw	   D'156'
		 jnc	   Tshow_label		 ;   100  - 

		 movlw	   D'200'		 ;
		 subwf	   TL,F			 ;   100  -  
		 mvi	   FIG0X00,B'11100111'	 ; "1"   

;------------------------------------------------

Tshow_label	 bcf	  STATUS,C
		 rrf	  TL,W		 	 ;W = <0> | 64 | 32 | 16 || 8 | 4 | 2 | 1
		 movwf	  TEMP2

Divide		 bcf	   INTCON,GIE
		 clrf	   FIG00X0
		 movf      TEMP2,W		 ; TEMP2  10 -     
		 movwf     TEMP1                 ;  TL  1  W
		 bsf       STATUS,C              ;  
Div_label	 movf      TEMP1,W
		 movwf     FIG000X               ;     W  
		 incf      FIG00X0,F             ;      1
		 movlw     D'10'                 ;10 -> W                       W
		 subwf     TEMP1,F               ;(TEMP1 - W) -> TEMP1           
		 jc        Div_label             ; 1    <0,     ..
		 decf      FIG00X0,F		

		 movlw	   B'11100111'
		 xorwf	   FIG0X00,W		 ; ?
		 jnz	   High_label		 ; - 

		 movf	   FIG00X0,W		 ; -     
		 call	   DC7
		 movwf	   FIG00X0
		 movf	   FIG000X,W
		 call	   DC7
		 movwf	   FIG000X
		 goto	   Finish_label
;------------------------------------------------
High_label	 movf	   FIG00X0,W		 ;    
		 call	   DC7
		 movwf	   FIG0X00
		 movf	   FIG000X,W
		 call	   DC7
		 movwf	   FIG00X0
		 bcf	   FIG00X0,2		 ; 
		 mvi	   FIG000X,B'00100100'	 ;     "0"
		 movlw	   B'00010101'
		 btfsc	   TL,0
		 movwf	   FIG000X		 ;    "0,5 " -  "5"


Finish_label	 bsf	   INTCON,GIE
		 goto      Online_label

                 end

