SparkFun Electronics Eagle Libraries
====================================

SparkFun Electronics' preferred foot prints using Eagle v6.0 or greater. 
We've spent an enormous amount of time creating and checking these footprints and parts. 
If you enjoy using this library, please buy one of our products at [SparkFun](http://www.sparkfun.com). 
Please also note that we guarantee that there are some messed up footprints in this library. 
We've tried to note which are proven and tested, but by downloading these files, you acknowledge that you are using the files at your own risk. 

**We cannot be held responsible for faulty PCBs.  Always check your parts against a 1:1 printout.**

This is the complete SparkFun Electronics default foot prints for Eagle 6.0+. 

Library Descriptions
----------------

We've grouped the various parts into individual libraries to make it as easy as possible to locate the part you need:

* **LilyPad-Wearables** - Button holes, sewtaps and petals used on our LilyPad boards. 
* **Aesthetics** - Non-functional items such as logos, build/ordering notes, frame blocks, etc. 
* **Batteries** - Battery clips, connectors, and appropriately sized silk outlines for LiPo batteries. 
* **Boards** - SparkFun breakout boards, microcontrollers (Arduino, Particle, Teensy, etc.), breadboards, non-RF modules, etc. 
* **Capacitors** - An sortment of paint swatches. Just kidding, it's various capacitor types, sizes, and values.
* **Clocks** - Real-time clocks, oscillators, resonators, and crystals.
* **Coils** - Inductors, ferrites, transformers, etc.
* **Connectors** - Various PTH (Audio jacks, ATX, USB, ZIF, RJ45, etc) and SMD connectors (USB, SD, Edison, SIM, etc). Useful for adding a 4-pin empty 0.1" footprint to a board (for example). 
* **Discrete** - Diodes, optoisolators, TRIACs, MOSFETs, transistors, etc. 
* **Displays** - LCDs, OLEDs, etc. 
* **Electromechanical** - Motors, speakers, servos, and relays. 
* **Fuses** - Resettable fuses, IE PTCs.
* **GPS** - Various SMD and connector pinouts for GPS modules and GPS antennas sold by SparkFun
* **Hardware** - Stand offs, heatsinks, etc.
* **IC-Amplifiers** - Mostly operational amplifiers but also has some headphone and audio amps with more specific applications
* **IC-Comms** - USB to serial conversion ICs, like the FTDI line, plus high speed line drivers, level shifters, bus drivers, CAN transceivers and ethernet PHYs. 
* **IC-Conversion** - Analog to digital conversion, as well as digital to analog. This includes not only strict ADCs, but audio in and out converters, decoders, thermocouple measurement ics the like. Anything that is a single part that works between the two domains goes here. 
* **IC-Logic** - Standard logic IC families.
* **IC-Memory** - SPI, FLASH and EEPROM based memories
* **IC-Microcontroller** - Various micros including ATMega, ATTiny, PICs, and PSOC families
* **IC-Power** - Anything that has to do with power delivery, or making power supplies. 
* **IC-Special-Function** - 555 timers, LED drivers, Motor Control, etc. ICs that do not really fit into the other, more generic categories. Basically, anything that serves some function but has a bunch of brains or special bias circuitry that prevents it from being used as a general part qualifies for this category. 
* **Jumpers** - Semipermanent means of changing current paths. The least permanent form is the solder jumper. These can be changed by adding, removing, or moving solder. In cases that are less likely to be changed we have jumpers that are connected with traces. These can be cut with a razor, or reconnected with solder. Reference designator JP. 
* **LED** - Illumination or indication, but no displays. 
* **PowerSymbols** - Power, ground, and voltage-supply symbols. 
* **Resistors** - More color swatches.
* **Retired** - All manner of retired footprints for resistors, capacitors, board names, ICs, etc., that are no longer used in our catalog. 
* **RF** - Devices that send or receive RF -- cellular modules, Bluetooth, WiFi, etc. 
* **Sensors** - Accelerometers, gyros, compasses, magnetometers, light sensors, imagers, temp sensors, etc. 
* **Switches** - Switches, buttons, joysticks, and anything that moves to create or disrupt an electrical connection. 
* **User-Submitted** - Parts submitted from SparkFun users everywhere!

How to Use Eagle
----------------

If you need more information about how to use Eagle, checkout our Eagle Tutorials: 

* [Installing an Eagle Library](https://learn.sparkfun.com/tutorials/how-to-install-and-setup-eagle#using-the-sparkfun-libraries)
* [Installing Eagle](https://learn.sparkfun.com/tutorials/how-to-install-and-setup-eagle)
* [Creating Schematics](https://learn.sparkfun.com/tutorials/using-eagle-schematic)
* [Creating Boards](https://learn.sparkfun.com/tutorials/using-eagle-board-layout)
* [Designing Custom Footprints](https://learn.sparkfun.com/tutorials/designing-pcbs-smd-footprints)
* [Creating Footprints from Digital Imagery](https://learn.sparkfun.com/tutorials/making-custom-footprints-in-eagle)
* [Other SparkFun/Eagle Resources](https://www.sparkfun.com/eagle)

How to use GitHub
-----------------

If you need help getting started using git/GitHub, check out our GitHub tutorials:
* [Using GitHub](https://learn.sparkfun.com/tutorials/using-github)
* [Using GitHub to Share with SparkFun](https://learn.sparkfun.com/tutorials/using-github-to-share-with-sparkfun)

Want to Contribute?
-------------------

Check out our [Library Guidelines](https://github.com/sparkfun/SparkFun-Eagle-Libraries/wiki), create your part, and add it to our [UserSubmitted](https://github.com/sparkfun/SparkFun-Eagle-Libraries/blob/master/User-Submitted.lbr) library.

If you discover a bug with an existing component, please submit an issue or pull request.

Library Versions
----------------

The library associated with Eagle v5.11 and earlier is found [here](https://github.com/sparkfun/Old-SparkFun-Eagle-Library).
If you would like to reference the library as it related to a particular version of Eagle, please check our tagged versions [here](https://github.com/sparkfun/SparkFun-Eagle-Libraries/releases). 


License Information
-------------------

This library is released under the [Creative Commons ShareAlike 4.0 International](https://creativecommons.org/licenses/by-sa/4.0/) license. 
**You are welcome to use this library for commercial purposes.**
For attribution, we ask that when you begin to sell your device using our footprint, you email us with a link to the product being sold. 
We want bragging rights that we helped (in a very small part) to create your 8th world wonder. 
We would like the opportunity to feature your device on our homepage.

Please consider contributing back to this library or others to help the open-source hardware community continue to thrive and grow! 
