
/*
Led selection
statusonoff 
            1 = led 1
			2 = led 3
			3 = led 5
			4 = led 7

coloronoff 0 = Blue
           1 = Red
		   2 = Green  


*/



#include<avr/io.h>
#include<avr/interrupt.h>
#include<util/delay.h>

typedef unsigned char u08;

volatile u08 i=1,statusonoff[5],colouronoff[3],l;
volatile u08 a[12] = {1,1,1,2,2,2,3,3,3,4,4,4};
volatile u08 b[12] = {4,2,3,4,1,3,4,1,2,3,1,2};
volatile u08 c[12] = {0,1,2,0,1,2,0,1,2,0,1,2};


void switchpressed(void);
void switchreleased(void);
u08 call(u08 n,u08 m);



int main(void)
{


SPL = 0x9F;//Initialise stack pointer

sei();

//Timer settings
TCCR0A = 0x00;
TCCR0B = 0x02;
TIMSK0 = 0x02;

DDRB = DDRB&(~(1<<0));
PORTB = 0xff;
for(;;)
{
 switchpressed();
 switchreleased();
}

return 0;
}


//subroutine for switch pressed
void switchpressed(void)
{
u08 b;
u08 c;

l:
b=7;

k:
c=PINB;
b--;

if(b==0)
{
goto l;
}

c &=1<<0;

if(c!=0)
{
goto k;
}

_delay_loop_2(20000);//to prevent debounce
if(b==1)
{
statusonoff[4]=1;
statusonoff[1]=0;
statusonoff[2]=0;
statusonoff[3]=0;
}
else if(b==2)
{
statusonoff[4]=0;
statusonoff[1]=0;
statusonoff[2]=0;
statusonoff[3]=1;
}
else if(b==3)
{
statusonoff[4]=1;
statusonoff[1]=0;
statusonoff[2]=1;
statusonoff[3]=0;
}
else if(b==4)
{
statusonoff[4]=0;
statusonoff[1]=1;
statusonoff[2]=1;
statusonoff[3]=0;
}
else if(b==5)
{
statusonoff[4]=1;
statusonoff[1]=1;
statusonoff[2]=1;
statusonoff[3]=0;
}
else if(b==6)
{
statusonoff[4]=0;
statusonoff[1]=1;
statusonoff[2]=1;
statusonoff[3]=1;
}
}

//subroutine for switch released
void switchreleased(void)
{
u08 b;
u08 c;

l:
b=7;

k:
c=PINB;
b--;

if(b==0)
{
goto l;
}

c &=1<<0;

if(c==0)
{
goto k;
}

_delay_loop_2(20000);//to prevent debounce
if(b==1) //green
{
colouronoff[0]=0;
colouronoff[1]=0;
colouronoff[2]=1;
}
else if(b==2) //blue
{
colouronoff[0]=1;
colouronoff[1]=0;
colouronoff[2]=0;
}
else if(b==3) //Red
{
colouronoff[0]=0;
colouronoff[1]=1;
colouronoff[2]=0;
}
else if(b==4) //Blue + Red
{
colouronoff[0]=1;
colouronoff[1]=1;
colouronoff[2]=0;
}
else if(b==5) // Red + Green
{
colouronoff[0]=0;
colouronoff[1]=1;
colouronoff[2]=1;
}
else if(b==6) // Blue + Green
{
colouronoff[0]=1;
colouronoff[1]=0;
colouronoff[2]=1;
}

}


ISR(TIM0_OVF_vect) //Interrupt Subroutine
{
DDRB = 0;
l = call(a[i-1],c[i-1]);

PORTB = 1<<a[i-1]|l<<b[i-1]|1<<0;
DDRB = 1<<a[i-1]|1<<b[i-1];

i++;
if(i==13)
i=1;
}


u08 call(u08 n,u08 m)
{
u08 j,k;
j = statusonoff[n]&colouronoff[m];
k = ~j;
k = k&0b00000001; //Extract LSB
return k;
}
