/*****************************************************************************

 - UART in simple polled-mode
 - UART-Test with reduced printf (rprintf)
 - Test for vector remapping
 
 by Martin Thomas 

 ******************************************************************************/

/* 
 20060726 - mt 
 preserve MEMMAP and restore startup-value after memory-dump 
 20060727 - mt
 - modified Makfile to enable gcc 4 "remove unused code"-feature
 added (.bss.*) to linker-scripts
 - demo for stdio: new file syscalls.c, USR stack-size had to be 
 increased for floating-points -> startup.S)
 */

/* 
 some "statistics" for this demo-application in revision 20060727 when 
 using the tools from WinARM 6/06 (gcc 4.1.1 et al)
 
 r.u.c.(*) DEMO_STDIO   DEMO_STDIO_FP     .text    .data    .bss [bytes]

 no        not defined  not defined        2908      360       8
 yes       not defined  not defined        2700       "        "
 diff:   208

 no        defined      not defined       12156     2444      64
 yes       defined      not defined       11976       "        "
 diff:   180

 no        defined      defined           27172     2444      64
 yes       defined      defined           26992       "        " (#)
 diff:   180
 
 "OPT"-settings for configuration (#) (stdio/FP)
 OPT  .text    .data    .bss [bytes]
 s    26992     2444      64
 0    29108       "        "
 1    27296       "        "
 2    27272       "        "
 3    29360       "        "

 (*) r.u.c = remove unused code with -ffunction-sections -fdata-sections for
 the compilation and --gc-section for linking
 yes : -ffunction-sections -fdata-sections used in CLFAGS
 no  : -ffunction-sections -fdata-sections not used in CFLAGS
 */

//#define DEMO_STDIO    0
//#define DEMO_STDIO_FP 0

#include "LPC214x.h"                        /* LPC21xx definitions */
#include "type.h"
#include "irq.h"
#include "swi.h"
#include "timer.h"
#include "serial.h"
#include "rprintf.h"

#ifdef DEMO_STDIO
#include <stdio.h>
#endif

static const char Hello[]="Hello World!!!\n";
static const char Hello_rprintf[]="Hello from rprintf\n";

#ifdef DEMO_STDIO
static void demo_stdio(void) {
	const char Hello_stdio[] = "Hello from stdio printf\n";
	iprintf("\nstdio-Demo\n");
	iprintf("%s", Hello_stdio);
	iprintf("%i+%i=%i\n", 1, 2, (1+2));
#ifdef DEMO_STDIO_FP
	double r = 9.8765;
	printf("r = %lf\n\n", r);
#endif
}
#endif

static void dump_mem(unsigned long startaddress, int n) {
	volatile unsigned long *p;

	p = (unsigned long*)startaddress;
	int i;

	for (i=0; i<n; i++) {
		rprintf("Addr:0x%08lx = 0x%08lx (0x%04x:0x%04x)\n", p, *p, (*p)>>16, (*p)&0xffff);
		p++;
	}
}

static void dump_interrupt_state(void) {
	unsigned long cpsr;

	cpsr = IntGetCPSR();

	rprintf("State : stat-reg 0x%08x -> ", cpsr);

	if (cpsr & I_Bit) {
		rprintf("IRQ disabled, ");
	} else {
		rprintf("IRQ enabled, ");
	}

	if (cpsr & F_Bit) {
		rprintf("FIQ disabled\n");
	} else {
		rprintf("FIQ enabled\n");
	}
}

int main(void) {
	int flip = 0;
	unsigned long memmapsave;

	volatile unsigned long c, is;

	init_VIC();
	init_serial0(115200); /* baud rate setting */

	putstring_serial0(Hello); /* write welcome thru putstring */

	rprintf_devopen(putc_serial0); /* init rprintf */
	rprintf("rprintf: %s", Hello_rprintf);

#ifdef DEMO_STDIO
	demo_stdio();
#endif

#if 1
	memmapsave = MEMMAP;
	MEMMAP = 1; // Vectors in FLASH
	rprintf("Dump for MEMMAP = 1 / Flash\n");
	dump_mem(0x00000000, 16);
	dump_mem(0x40000000, 16);

	MEMMAP = 2; // Vectors in RAM
	rprintf("Dump for MEMMAP = 2 / RAM\n");
	dump_mem(0x00000000, 16);
	dump_mem(0x40000000, 16);
	rprintf("dump done\n");
	MEMMAP = memmapsave;
	rprintf("Using MEMMAP %i\n", memmapsave);
#endif

	c = IntGetCPSR();
	is = c;
	rprintf("\nCPSR from startup: 0x%08lx\n", c);
	dump_interrupt_state();

	rprintf("Disable IRQ:\n");
	c = IntDisable();
	rprintf("returned prev. state :0x%08lx\n", c);
	dump_interrupt_state();

#if 0
	rprintf("Enable:\n");
	c = IntEnable();
	rprintf("retval:0x%08lx\n", c);
	dump_interrupt_state();
#endif

	rprintf("Restore startup-condition:\n");
	IntRestore(is);
	dump_interrupt_state();

	rprintf("\nTesting Timer-Interrupt\n");

	IODIR0 = 0x00030000;
	IOCLR0 = 0x00030000;
	init_timer();
	enable_timer( 0);

	while (1) {
		if (timer_counter > 0x64) {
			timer_counter = 0;
			flip = !flip;
			if (flip) {
				IOSET0 = 0x00010000;
				IOCLR0 = 0x00020000;
				rprintf("P0.16=ON , P0.17=OFF\r");
			} else {
				IOSET0 = 0x00020000;
				IOCLR0 = 0x00010000;
				rprintf("P0.16=OFF, P0.17=ON \r");
			}
		}
	}
	return 0; /* never reached */
}
