#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "fatfs.h"

// Krnyezet: 1 = HAL, 2 = FreeRtos
#define  ENVIRONMENT   1

// ----------------------------------------------------------------------------
#if     ENVIRONMENT == 1
#define Delay(t)     HAL_Delay(t)
#define GetTime()    HAL_GetTick()
#elif   ENVIRONMENT == 2
#define Delay(t)     osDelay(t)
#define GetTime()    osKernelSysTick()
#endif

//-----------------------------------------------------------------------------
// Rekurziv modon vgigjrja a teljes fjl listt
FRESULT scan_files(char* path)
{
  FRESULT res;
  DIR dir;
  UINT i;
  static FILINFO fno;

  res = f_opendir(&dir, path);                       /* Open the directory */
  if (res == FR_OK) {
    for (;;) {
      res = f_readdir(&dir, &fno);                   /* Read a directory item */
      if (res != FR_OK || fno.fname[0] == 0) break;  /* Break on error or end of dir */
      if (fno.fattrib & AM_DIR) {                    /* It is a directory */
        i = strlen(path);
        sprintf(&path[i], "/%s", fno.fname[0] ? fno.fname : fno.fname);
        printf("%s <DIR>\r\n", path);
        res = scan_files(path);                    /* Enter the directory */
        if (res != FR_OK) break;
        path[i] = 0;
      } else {                                       /* It is a file. */
        printf("%s/%s  (%d byte)\r\n", path, fno.fname, (unsigned int)fno.fsize);
      }
    }
    f_closedir(&dir);
  }
  return res;
}

//-----------------------------------------------------------------------------
void mainApp(void)
{
  char buff[256];

  printf("SDPath:%s\r\n", SDPath);

  if(f_mount(&SDFatFS, SDPath, 1) == FR_OK)
  {
    // flashspeed = 100;
    printf("FatFs ok\r\n");
    strcpy(buff, SDPath);
    scan_files(buff);             // komplett fjllista
  }
  else
    printf("FatFs error !!!\r\n");

  while(1)
  {
    Delay(100);
  }
}
