#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "fatfs.h"

// Krnyezet: 1 = HAL, 2 = FreeRtos
#define  ENVIRONMENT   1

// ----------------------------------------------------------------------------
#if      ENVIRONMENT == 1
#define  Delay(t)     HAL_Delay(t)
#define  GetTime()    HAL_GetTick()
#elif    ENVIRONMENT == 2
#define  Delay(t)     osDelay(t)
#define  GetTime()    osKernelSysTick()
#endif

#define  BMP_HEADERSIZE  0x36
#define  BMP_FILENAMEEXT ".bmp"

uint16_t Color888to565(uint8_t r, uint8_t g, uint8_t b)
{
  uint16_t c; c = r >> 3; c <<= 6; c |= g >> 2; c <<= 5; c |= b >> 3;
  return c;
}

// ----------------------------------------------------------------------------
// 24bites (RGB888) bmp fjl 16bites (RGB565) C forrsra konvertlsa
void bmpfile_processing(char* pth, char* fn)
{
  struct __packed BMP_PIXEL
  {
    unsigned char blue;
    unsigned char green;
    unsigned char red;
  }rgb888;
  uint16_t rgb565;
  unsigned int r, i, x;
  FIL sfile, tfile;

  char f[256];
  sprintf(f, "%s/%s", pth, fn);
  if(f_open(&sfile, f, FA_READ) == FR_OK)
  {
    for(i = strlen(f); i > 0; i--)
      if(f[i] == '.')
        {f[i] = 0; break;}
    strcat(f, ".c");
    if(f_open(&tfile, f, FA_CREATE_ALWAYS | FA_WRITE) == FR_OK)
    {
      printf("processing:%s/%s -> %s\r\n", pth, fn, f);
      f_printf(&tfile, "static const unsigned short bitmap[] = {\n");

      for(i = 0; i < BMP_HEADERSIZE; i++)
      {
        f_read(&sfile, &rgb888.red, 1, &r);
      }

      f_read(&sfile, &rgb888, sizeof(rgb888), &r);
      rgb565 = Color888to565(rgb888.red, rgb888.green, rgb888.blue);
      f_printf(&tfile, "  0x%04x", rgb565);
      f_read(&sfile, &rgb888, sizeof(rgb888), &r);
      rgb565 = Color888to565(rgb888.red, rgb888.green, rgb888.blue);
      x = 1;
      for(;;)
      {
        if(!r)
        {
          f_printf(&tfile, "}\n");
          f_sync(&tfile);
          break;
        }
        if(!x)
          f_printf(&tfile, "  0x%04x", rgb565);
        else
          f_printf(&tfile, ", 0x%04x", rgb565);
        if(x >= 7)
        {
          f_printf(&tfile, ",\n");
          x = 0;
        }
        else
          x++;
        f_read(&sfile, &rgb888, sizeof(rgb888), &r);
        rgb565 = Color888to565(rgb888.red, rgb888.green, rgb888.blue);
      }
      f_close(&tfile);
    }

    f_close(&sfile);
  }
}

// ----------------------------------------------------------------------------
// vgigkeresi a 'path'-ban megadott helytl kezdve az 'ext'-ben megadott kiterjeszts fjlokat
// s meghvja az 'fp'-ben megadott fggvnyt
FRESULT scan_files(char* path, char* ext, void (*fp)(char* pth, char* fn))
{
  FRESULT res;
  DIR dir;
  UINT i;
  static FILINFO fno;

  UINT el = strlen(ext);                // kiterjeszts hossza
  res = f_opendir(&dir, path);          // kutats kezdete
  if (res == FR_OK)
  {
    for (;;)
    {
      res = f_readdir(&dir, &fno);
      if (res != FR_OK || fno.fname[0] == 0) break;  // vge?
      if (fno.fattrib & AM_DIR)         // DIR ?
      {
        i = strlen(path);
        sprintf(&path[i], "/%s", fno.fname);
        res = scan_files(path, ext, fp);// alknyvtr tartalmnak felkutatsa
        if (res != FR_OK) break;
        path[i] = 0;                    // kilpnk az alknyvtrbol
      }
      else
      {                                 // file ?
        if(!strcmp(ext, (char *)fno.fname + strlen(fno.fname) - el))
          fp(path, fno.fname);
      }
    }
    f_closedir(&dir);
  }
  return res;
}

//-----------------------------------------------------------------------------
void mainApp(void)
{
  char buff[256];

  Delay(500);
  printf("Start\r\n");
  printf("SDPath:%s\r\n", SDPath);

  if(f_mount(&SDFatFS, SDPath, 1) == FR_OK)
  {
    printf("FatFs ok\r\n");
    strcpy(buff, SDPath);
    if(buff[strlen(buff) - 1] == '/')
      buff[strlen(buff) - 1] = 0; // utolso / jelet lecsapjuk, mert egybknt duplzva lesz
    scan_files(buff, BMP_FILENAMEEXT, bmpfile_processing); // bmp konverzio
  }
  else
    printf("FatFs error !!!\r\n");

  printf("End\r\n");

  while(1)
  {
    Delay(100);
  }
}
