#include "washmachine.h"

#int_RDA
void serial_isr()
{
   int t;
   uart_buffer[rx_in_ptr]=RCREG;
#asm
   bcf CREN
   bsf CREN
#endasm

   if(echo_on) putc(uart_buffer[rx_in_ptr]); 
   
   t=rx_in_ptr;
   rx_in_ptr=(rx_in_ptr+1) % max_uart_buffer_length;
   if(rx_in_ptr==rx_out_ptr)
     {
     rx_in_ptr=t;           // Buffer full !!
     buffer_overrun=TRUE;
     }
}



#int_TIMER2
void  TIMER2_isr(void) 
{

}

//prototypes
int1 water_low();
void forgat(int8 cycles, int16 t_forgat, int16 t_szunet);
void pump(int8 time);
void spin(int8 time);


//implementation



void toggle_cmd(int8 karcsi) 
{
unsigned int8 v;
      switch(karcsi)
         {
         case '0' :output_toggle(PIN_B0);
            break;

         case '1' :output_toggle(PIN_B1);
            break;
            
         case '2' :output_toggle(PIN_B2);
            break;
            
         case '3' :output_toggle(PIN_B3);
            break;
            
         case '4' :output_toggle(PIN_B4);
            break;
            
         case '5' :output_toggle(PIN_B5);
            break;
            
         case '6' :output_toggle(PIN_B6);
            break;
            
         case '7' :output_toggle(PIN_B7);
            break;
         default : printf("FAIL\r\n");
                  break;
            
         }
         if(input_state(PIN_B0)) printf(" 1"); else printf(" 0");
         if(input_state(PIN_B1)) printf(" 1"); else printf(" 0");
         if(input_state(PIN_B2)) printf(" 1"); else printf(" 0");
         if(input_state(PIN_B3)) printf(" 1"); else printf(" 0");
         if(input_state(PIN_B4)) printf(" 1"); else printf(" 0");
         if(input_state(PIN_B5)) printf(" 1"); else printf(" 0");
         if(input_state(PIN_B6)) printf(" 1"); else printf(" 0");
         if(input_state(PIN_B7)) printf(" 1"); else printf(" 0");
         printf("\r\n");
         
         
}


void demo()
{
output_high(pin_wvalve_switch);
delay_ms(1500);
output_low(pin_wvalve_switch);
delay_ms(1500);
output_high(pin_rvalve_switch);
delay_ms(1500);
output_low(pin_rvalve_switch);
pump(5);
forgat(1,4000,4000);
delay_ms(2000);
spin(10);
}




void prewash(int8 cycles)
{

}

void steep(int8 cycles,time)
{

}


void rinse()
{
int8 count1;

   if(water_low())
      {
      if(debug) printf("Open wash valve...\r\n");
      output_high(pin_wvalve_switch);
      }
   delay_ms(t_wait_for_water);
   forgat(1,t_rinse_rotate,t_rinse_pause);
   count1=0;
   while(water_low())
      {
       if(debug) printf("Waiting for rinse water %u\r\n",count1++);
       delay_ms(t_read_level);
      }
   if(debug) printf("Close valve\r\n");
   output_low(pin_wvalve_switch);
   if(debug) printf("Rotating - rinse...\r\n");
   forgat(c_rinse,t_rinse_rotate,t_rinse_pause);
   if(debug) printf("Drain water\r\n");
   pump(t_pump_rinse);

}

void spin(int8 time)
{
int8 secs;
  if(debug) printf("spin starts...\r\n");
  output_high(pin_pump_switch);
  output_low(pin_motor_direction);
  delay_ms(t_rele);
  output_high(pin_motor_switch);
  delay_ms(t_help_spin);
  output_low(pin_motor_switch);
  delay_ms(t_rele);
  output_high(pin_motor_speed);
  delay_ms(t_rele);
  output_high(pin_motor_switch);
  for(secs=0;secs<time;secs++)
   {
    if(debug) printf("Still spinning, %u seconds to elapse...\r\n",time-secs);
    delay_ms(1000);
   }
  output_low(pin_pump_switch);
  output_low(pin_motor_switch);
  delay_ms(t_rele);
  output_low(pin_motor_speed);
  delay_ms(t_rele);
  output_high(pin_motor_switch); //lassts
  delay_ms(t_slow_down);
  output_low(pin_motor_switch);
 if(debug) printf("Spinning is ready\r\n");

}

void pump(int8 time)
{
int16 secs;
   if(debug) printf("Switch on drain pump\r\n");
   output_high(pin_pump_switch);
   for(secs=0;secs<time;secs++)
      {
      delay_ms(1000);
      if(debug) printf("Still pumping...\r\n");
      }
   output_low(pin_pump_switch);
   if(debug) printf("End of pumping\r\n");

}

int1 water_low()
{
if(input(pin_water_l2_sense)) return(1); else return(0);
}


void forgat(int8 cycles, int16 t_forgat, int16 t_szunet)
{
int8 cycle_count;
   for(cycle_count=0;cycle_count<cycles;cycle_count++)
      {
      if(debug) printf("Rotate forward %u\r\n",cycle_count);      
      output_high(pin_motor_switch);
      delay_ms(t_forgat);
      if(debug) printf("Pause after forward  %u\r\n",cycle_count);
      output_low(pin_motor_switch);
      delay_ms(t_rele);
      output_high(pin_motor_direction);
      delay_ms(t_szunet);
      if(debug) printf("Rotate reverse %u\r\n",cycle_count);      
      output_high(pin_motor_switch);
      delay_ms(t_forgat);
      if(debug) printf("Pause after reverse %u\r\n",cycle_count);
      output_low(pin_motor_switch);
      delay_ms(t_szunet);
      output_low(pin_motor_direction);
      delay_ms(t_rele);
      }
}

void probamosas()
{

int8 rinse_count, count1;
   if(debug)printf("Program 1 started...\r\n");
   if(water_low()) 
      {
      output_high(pin_wvalve_switch);
      if(debug) printf("Open wash valve\r\n");
      if(debug) printf("Waiting for %Lu ms\r\n",t_wait_for_water);
      delay_ms(t_wait_for_water);
      }
   if(debug) printf("Heater switch on\r\n");
   output_high(pin_heat_switch);
   forgat(1,t_normal_forgat,t_normal_szunet);
   count1=0;
   while(water_low())
      {
       if(debug) printf("VWaiting for water %u \r\n",count1++);
       delay_ms(t_read_level);
      }
   output_low(pin_wvalve_switch);
   if(debug) printf("Water level OK, larger part of washing comes...\r\n");
   forgat(c_main_wash,t_intenziv_forgat,t_intenziv_szunet);
   if(debug) printf("Heater switch off\r\n");
   output_low(pin_heat_switch);
   if(debug) printf("Next part of washing\r\n");
   forgat(c_no_heat_wash,t_intenziv_forgat,t_intenziv_szunet);
   if(debug) printf("Drain washing water\r\n");   
   pump(t_pump_rinse);
   for(rinse_count=0;rinse_count<n_rinse;rinse_count++)
      {
         if(debug) printf("Rinsing No.%u starts\r\n",rinse_count);
       rinse();
      }
   if(debug) printf("Drain last rinsing water\r\n");   
   pump(t_pump_rinse);
   output_high(pin_pump_switch);
   if(debug) printf("Main spinning starts\r\n");   
   spin(t_fullspin);
   if(debug) printf("Washing is over, open door\r\n");   
}

void full_rinse()
{
int8 rinse_count;

   pump(t_pump_rinse);
   for(rinse_count=0;rinse_count<n_rinse;rinse_count++)
      {
         if(debug) printf("Rinsing No.%u starts\r\n",rinse_count);
         rinse();
      }
   output_high(pin_pump_switch);
   spin(t_fullspin);
   output_low(pin_pump_switch);
   
}

void main()
{
int8 kar;
   setup_adc_ports(NO_ANALOGS);
   setup_adc(ADC_OFF);
   setup_psp(PSP_DISABLED);
   setup_spi(SPI_SS_DISABLED);
   setup_timer_0(RTCC_INTERNAL|RTCC_DIV_1);
   setup_timer_1(T1_INTERNAL|T1_DIV_BY_1);
   setup_timer_2(T2_DIV_BY_16,95,10);
//   kbd_init();
   disable_interrupts(INT_RDA);
   enable_interrupts(INT_TIMER2);
   enable_interrupts(GLOBAL);

output_low(pin_motor_direction);
output_low(pin_motor_switch);
output_low(pin_wvalve_switch);
output_low(pin_rvalve_switch);
output_low(pin_heat_switch);
output_low(pin_latch_switch);
output_low(pin_motor_speed);
output_low(pin_pump_switch);


   // TODO: USER CODE!!
//rinse(0);
//output_high(pin_pump_switch);
//delay_ms(5000);
//spin(40000);
//delay_ms(2000);
//output_low(pin_pump_switch);

//while(1);
//demo();
probamosas();

while(1)
   {
   kar=getc();
   toggle_cmd(kar);
//demo();

   }

}
