#include <16F877.h>
#device adc=8

#FUSES NOWDT                    //No Watch Dog Timer
#FUSES HS                       //High speed Osc (> 4mhz for PCM/PCH) (>10mhz for PCD)
#FUSES PUT                      //Power Up Timer
#FUSES NOPROTECT                //Code not protected from reading
#FUSES BROWNOUT                 //Reset when brownout detected
#FUSES NOLVP                    //No low voltage prgming, B3(PIC16) or B5(PIC18) used for I/O
#FUSES NOCPD                    //No EE protection
#FUSES NOWRT                    //Program memory not write protected
#FUSES NODEBUG                  //No Debug mode for ICD

#use delay(clock=6144000)
#use rs232(baud=9600,parity=N,xmit=PIN_C6,rcv=PIN_C7,bits=8)

//PIC16f877 specific registers/flags
#byte RCREG = 0x1a
#byte RCSTA = 0x18
#bit CREN = RCSTA.4


// Constant definitions
#define motor_on 1
#define motor_off 0
#define hi_speed 1
#define lo_speed 0
#define forward 1
#define reverse 0
#define on 1
#define off 0



// PIN DEFINITIONS
#define pin_motor_direction PIN_B0
#define pin_motor_switch PIN_B1
#define pin_wvalve_switch PIN_B2
#define pin_rvalve_switch PIN_B3
#define pin_heat_switch PIN_B4
#define pin_latch_switch PIN_B5
#define pin_motor_speed PIN_B6
#define pin_pump_switch PIN_B7

#define pin_level0_sense PIN_A0
#define pin_level1_sense PIN_A1
#define pin_level2_sense PIN_A2
#define pin_level3_sense PIN_A3
#define pin_level4_sense PIN_A4
#define pin_level5_sense PIN_A5

#define pin_rpm_sense PIN_D0
#define pin_door_sense PIN_D1
#define pin_water_l1_sense PIN_E1
#define pin_water_l2_sense PIN_E2

#define  STRING_SIZE    63             // The number of characters allowed to input
#define max_uart_buffer_length 64 // 128 volt FRB 
#define max_cm_length 60
#define command_header '#'

// Timing (minden rtk millisec!)
#define t_rele 25 //ksleltets irnyvlts/centrifuga s bekapcs kztt 
#define t_normal_forgat 12000 //norml elre forgats ideje 37,5%
#define t_normal_szunet 20000  

#define t_kimelo_forgat 10000 //kml forgats ideje 80s 25%
#define t_kimelo_szunet 30000  

#define t_intenziv_forgat 10000 //intenzv forgats ideje 30s 66%
#define t_intenziv_szunet 5000 

#define t_wait_for_water 10000  //kezdeti vzengedskor vr, csak utna forgat
                                //hogy a mospor vzbe pottyanjon
#define t_shortspin_to_pump 5000   //szvatty bekapcsolsa utn ennyi ms a rvid centrifughoz  
#define t_shortspin 10 //rvid centrifugls szvattyzs kzben [s]
#define t_midspin  30 // kzepes centrifugls ideje [s]
#define t_fullspin 120 // teljes centrifugzs [s]
#define t_help_spin 2000  //centrifuga eltt pr mp-re elindtjuk a dobot, hogy mozgsbl vltson [ms]
#define t_slow_down 2000  //centrifugls utn lassts [ms]
#define t_pump_rinse 45 //bltsek kztti szvattyzs ideje [s]
#define t_pump_all   60 //teljes szvattyzs [s]
#define t_rinse_rotate 10000 //forgats ideje bltskor [ms]
#define t_rinse_pause 5000 //sznet ideje bltskor [ms]
#define t_read_level 1000  //1 msodpercenknt lessk, hogy van-e elg vz

#define c_rinse 16 //blts ciklusszma -ennyiszer forog a dob ide-oda
#define c_main_wash 80 //Fmoss ciklusszma
#define c_no_heat_wash 40 //mosciklusok kikapcsolt ftssel

#define n_rinse 4 //bltsek szma

#define debug 1 //ha debuggolni akarunk

//vltozk, paramterek

static char cm_string[max_cm_length+1];
static int8 cm_start_from=0;
static char uart_buffer[max_uart_buffer_length+1];
static int8 rx_in_ptr=0;
static int8 rx_out_ptr=0;
static int8 cm_string_ptr;
static int1 cm_started=0;
static int1 buffer_overrun=0;
static int1 lo_trig=0;
static int1 hi_trig=0;
static int1 echo_on=0; // set this to 1 if you use this board with a serial terminal#define  STRING_SIZE    63             // The number of characters allowed to input


