#include <Arduino.h>
#include <WiFiClient.h>
#include <WiFiServer.h>
#include <ESP8266WebServer.h>
#include <WiFiUdp.h>
#include "StreamString.h"
#include "ESP8266HTTPUpdateServer.h"

#include <EEPROM.h>

static const char serverIndex[] PROGMEM =  R"(
<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='hu' lang='hu'>  
<head>
<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'> 
<style>
body, input { font-size:30pt; text-align:center; }
</style>
</head>
<body bgcolor='#95f9cb'>
<br>
<form method='POST' action='' enctype='multipart/form-data'>
<input type='file' accept='.bin' name='update' value='Fájl'>
<input type='submit' value='Frissít'>
</form>
</body>
</html>
)";


static const char successResponse[] PROGMEM = "<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='hu' lang='hu'><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8'><script language='javascript' type='text/javascript'>var sz=46; function szamol(){ if(sz>0){ sz--; document.getElementById('vsz').innerHTML = sz; setTimeout('szamol()',1000); if(sz==0){ window.location.href='/'}}}</script><style>body { font-size:30pt; text-align:center; }</style></head><body bgcolor='#95f9cb' onLoad='szamol();'><br>Frissítés sikerült!<br><span id='vsz'></span> sec<br>Ujraindítás ...</body></html>";

/*
static const char successResponse[] PROGMEM = "<META http-equiv=\"refresh\" content=\"15;URL=/\">Update Success! Rebooting...\n";
*/

ESP8266HTTPUpdateServer::ESP8266HTTPUpdateServer(bool serial_debug){
  _serial_output = serial_debug;
  _server = NULL;
  _username = NULL;
  _password = NULL;
  _authenticated = false;
}

void ESP8266HTTPUpdateServer::setup(ESP8266WebServer *server, const char * path, const char * username, const char * password){
    _server = server;
    _username = (char *)username;
    _password = (char *)password;

    // handler for the /update form page
    _server->on(path, HTTP_GET, [&](){
      if(_username != NULL && _password != NULL && !_server->authenticate(_username, _password))
        return _server->requestAuthentication();
      _server->send_P(200, PSTR("text/html"), serverIndex);
    });

    // handler for the /update form POST (once file upload finishes)
    _server->on(path, HTTP_POST, [&](){
      if(!_authenticated)
        return _server->requestAuthentication();
      if (Update.hasError()) {
        _server->send(200, F("text/html"), String(F("Update error: ")) + _updaterError);
      } else {
        //EEPROM.begin(1024);  delay(5);
        EEPROM.put(1000, 1);  EEPROM.commit();
        _server->client().setNoDelay(true);
        _server->send_P(200, PSTR("text/html"), successResponse);
        delay(100);
        _server->client().stop();
        ESP.restart();
      }
    },[&](){
      // handler for the file upload, get's the sketch bytes, and writes
      // them through the Update object
      HTTPUpload& upload = _server->upload();

      if(upload.status == UPLOAD_FILE_START){
        _updaterError = String();
        if (_serial_output)
          Serial.setDebugOutput(true);

        _authenticated = (_username == NULL || _password == NULL || _server->authenticate(_username, _password));
        if(!_authenticated){
          if (_serial_output)
            Serial.printf("Unauthenticated Update\n");
          return;
        }

        WiFiUDP::stopAll();
        if (_serial_output)
          Serial.printf("Update: %s\n", upload.filename.c_str());
        uint32_t maxSketchSpace = (ESP.getFreeSketchSpace() - 0x1000) & 0xFFFFF000;
        if(!Update.begin(maxSketchSpace)){//start with max available size
          _setUpdaterError();
        }
      } else if(_authenticated && upload.status == UPLOAD_FILE_WRITE && !_updaterError.length()){
        if (_serial_output) Serial.printf(".");
        if(Update.write(upload.buf, upload.currentSize) != upload.currentSize){
          _setUpdaterError();
        }
      } else if(_authenticated && upload.status == UPLOAD_FILE_END && !_updaterError.length()){
        if(Update.end(true)){ //true to set the size to the current progress
          if (_serial_output) Serial.printf("Update Success: %u\nRebooting...\n", upload.totalSize);
        } else {
          _setUpdaterError();
        }
        if (_serial_output) Serial.setDebugOutput(false);
      } else if(_authenticated && upload.status == UPLOAD_FILE_ABORTED){
        Update.end();
        if (_serial_output) Serial.println("Update was aborted");
      }
      delay(0);
    });
}

void ESP8266HTTPUpdateServer::_setUpdaterError(){
  if (_serial_output) Update.printError(Serial);
  StreamString str;
  Update.printError(str);
  _updaterError = str.c_str();
}
