#ifdef ESP8266
extern "C" { 
  #include "user_interface.h" 
  } 
  #endif
#include <stdint.h>
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include "ESP8266HTTPUpdateServer.h"
#include <WiFiClient.h> 
#include <ESP8266mDNS.h>
#include <Wire.h>
#include "Adafruit_MCP23017.h"
#include <Chrono.h>

#include <RTClib.h>
#include <FS.h> 
#include "html.h"
#include "string.h"
#define port 64169
ESP8266WebServer server(port);
ESP8266HTTPUpdateServer httpUpdater;

File f;
File fsUploadFile;
String readString; //main captured String
bool spiffsActive = false;
String fn_;
String getContentType(String filename); // convert the file extension to the MIME type
bool handleFileRead(String path);       // send the right file to the client (if it exists)
//format bytes
String formatBytes(size_t bytes){  if(bytes < 1024){ return String(bytes)+" B"; } 
                              else if(bytes < (1024 * 1024)){ return String(bytes/1024.0)+" KB"; } 
                              else if(bytes < (1024 * 1024 * 1024)){ return String(bytes/1024.0/1024.0)+" MB"; } 
                                                              else { return String(bytes/1024.0/1024.0/1024.0)+" GB"; } }
String getContentType(String filename){
  if(filename.endsWith(".htm")) return "text/html";
  else if(filename.endsWith(".txt")) return "text/html";
  else if(filename.endsWith(".css")) return "text/css";
  else if(filename.endsWith(".js")) return "application/javascript";
  return "text/plain";
}
bool handleFileRead(String path){  // send the right file to the client (if it exists)
  Serial.println("handleFileRead: " + path);
  if(path.endsWith("/")) path += "index.html";             // If a folder is requested, send the index file
  String contentType = getContentType(path);               // Get the MIME type
  String pathWithGz = path + ".gz";
  if(SPIFFS.exists(pathWithGz) || SPIFFS.exists(path)){    // If the file exists, either as a compressed archive, or normal
    if(SPIFFS.exists(pathWithGz))                          // If there's a compressed version available
      path += ".gz";                                       // Use the compressed version
    File file = SPIFFS.open(path, "r");                    // Open the file
    size_t sent = server.streamFile(file, contentType);    // Send it to the client
    file.close();                                          // Close the file again
    Serial.println(String("\tSent file: ") + path);
    return true;
  }
  Serial.println(String("\tFile Not Found: ") + path);
  return false;                                            // If the file doesn't exist, return false
}

#include <EEPROM.h>
RTC_DS3231 rtc;
Chrono myChrono;
Chrono secChrono(Chrono::SECONDS);
Adafruit_MCP23017 mcp;

const char* sta_ssid = "ssid";
const char* sta_pass = "pass";
IPAddress sta_ip(192,168,0,170);
IPAddress sta_gw(192,168,0,1);
IPAddress sta_sn(255,255,255,0);
IPAddress ap_ip(11,11,11,70);
IPAddress ap_gw(11,11,11,70);
IPAddress ap_sn(255,255,255,0);
const char* host = "futes";
const char* update_path = "/firmware";
const char* update_user = "user";
const char* update_pass = "pass";
const char* ap_ssid = "futes";
const char* ap_pass = "pass";

boolean thermostat[15]; boolean p_thermostat[15]; // parosak: 0,2,4,6,8,10,12,14 input,   paratlanok: 1,3,5,7,9,11,13,15 output
const int kazan = D4; boolean futes = false;
int thermostatok = 0;
short int lgn = 200;
boolean DST;
String web_page = "";
String F_NAP, F_ORA, F_PERC;
String IDO, ORA, EV, HO, NAP, PERC, SEC, IDOSZ;
short int ora, pr_ora, perc, pr_perc, sec; short int pr_sec = 61; 
short int ev, ho, nap, pr_nap, nap_hetbe;
String TEMPRTC = "";  double temp, temp_m, pr_temp;
boolean indul = false;
boolean formate = false;
 short int crt = 0; 
 



void setup() {  
  Serial.begin(115200); Serial.println(" --- *** ---");
 // ESP.wdtEnable(10000);
 // mcp.begin();
  pinMode(kazan, OUTPUT); digitalWrite(kazan, futes);
  mcp.begin();      // use default address 0
  mcp.pinMode(0, INPUT);   mcp.pullUp(0, HIGH);   mcp.pinMode(1, OUTPUT);     // nappali
  mcp.pinMode(2, INPUT);   mcp.pullUp(2, HIGH);   mcp.pinMode(3, OUTPUT);     // elso szoba
  mcp.pinMode(4, INPUT);   mcp.pullUp(4, HIGH);   mcp.pinMode(5, OUTPUT);     // Andyka
  mcp.pinMode(6, INPUT);   mcp.pullUp(6, HIGH);   mcp.pinMode(7, OUTPUT);     // furdo
  mcp.pinMode(8, INPUT);   mcp.pullUp(8, HIGH);   mcp.pinMode(9, OUTPUT);     // konyha
  mcp.pinMode(10, INPUT);  mcp.pullUp(10, HIGH);  mcp.pinMode(11, OUTPUT);    // hatso konyha
  mcp.pinMode(12, INPUT);  mcp.pullUp(12, HIGH);  mcp.pinMode(13, OUTPUT);    // halo sz
  mcp.pinMode(14, INPUT);  mcp.pullUp(14, HIGH);  mcp.pinMode(15, OUTPUT);    // szabad pin
////////////////////////////////////////////////////////////////////////////////////////////////////////////
  EEPROM.begin(1024); delay(10); 
  EEPROM.get(1, DST); delay(10);
////////////////////////////////////////////////////////////////////////////////////////////////////////////
   ESP.eraseConfig();  // WiFi.mode(m): set mode to WIFI_AP, WIFI_STA, WIFI_AP_STA or WIFI_OFF                //  beginSmartConfig();
   WiFi.mode(WIFI_STA);  WiFi.hostname(host);  Serial.printf("New hostname: %s\n", WiFi.hostname().c_str());
   WiFi.config(sta_ip, sta_gw, sta_sn);  WiFi.begin(sta_ssid, sta_pass);
   int x = 0;
   while((WiFi.waitForConnectResult() != WL_CONNECTED) && (x < 3)){ WiFi.config(sta_ip, sta_gw, sta_sn); WiFi.begin(sta_ssid, sta_pass);
                                                                    delay(1000);
                                                                    Serial.print("Csatlakozna "); Serial.print(x); Serial.println(" -szor"); 
                                                                    x++; }
    const char * const connect_mode[]{ "sikeres kapcsolat létrejött",
                                       "az állomás nem érhető el",
                                       "a jelszó helytelen",
                                       "wi-fi állapotok közötti váltás",
                                       "modul nem állomás üzemmódban van konfigurálva"     };                                     
    Serial.printf("Connection status: %d", WiFi.status()); Serial.print(" - "); Serial.println(connect_mode[WiFi.status()]); 
   
    if(WiFi.status() == WL_CONNECTED){ Serial.printf("Connecting to %s\n", WiFi.SSID().c_str());
                                       WiFi.gatewayIP(); Serial.printf("Gataway IP: %s\n", WiFi.gatewayIP().toString().c_str());
                                       WiFi.localIP(); Serial.printf("Local_STA IP: %s\n", WiFi.localIP().toString().c_str()); Serial.print(":"); Serial.println(port); 
                                       Serial.printf("RSSI: %d dBm\n", WiFi.RSSI());
                                       //WiFi.macAddress(); Serial.printf("MAC_STA IP: %s\n", WiFi.macAddress().toString().c_str()); 
                                       Serial.print("MAC: ");  Serial.println(WiFi.macAddress());                                       }
   delay(10);
   if(WiFi.status() != WL_CONNECTED){ ESP.eraseConfig();  Serial.println("STA nem sikerult, lessz AP"); 
                                      WiFi.mode(WIFI_AP);  WiFi.softAPConfig(ap_ip,ap_gw,ap_sn); WiFi.softAP(ap_ssid, ap_pass, 8);
                                      WiFi.softAPIP(); Serial.printf("Local_AP IP: %s", WiFi.softAPIP().toString().c_str()); Serial.print(":"); Serial.println(port); 
                                       }    
////////////////////////////////////////////////////////////////////////////////////////////////////////////

  
  delay(10);
  Wire.begin(); delay(10);
  rtc.begin();  delay(10); 
  int y = 0;
  while(rtc.lostPower() && y < 3){ delay(375); Serial.println("RTC indul"); rtc.begin(); delay(425); y++;  } 
  // rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  // if(y >= 24){ delay(5000); ESP.restart(); }
  delay(10); 
  DateTime now = rtc.now();         sec = now.second(); perc = now.minute(); ora = now.hour(); nap = now.day(); nap_hetbe = now.dayOfTheWeek(); ho = now.month(); ev = now.year(); delay(10); 
   temp_m = rtc.getTemperature();   pr_temp = temp_m;
  /////////////////////////////////////////////////////////////////////////
  // atteres a TELI idoszamitasra - setub-ba is // nyari: DST = 1, teli: DST = 0,
   if(nap_hetbe == 0 && ho >= 10 && ho < 3 && nap >= 25 && ora >= 4 && DST==1){ ora -= 1;
                                                                                rtc.adjust(DateTime(ev, ho, nap, ora, perc, sec)); 
                                                                                DST = 0;
                                                                                EEPROM.put(1, DST); EEPROM.commit();
                                                                                Serial.print("Atteres a TELI idoszamitasra -> "); Serial.println(DST);
                                                                                delay(500); }
  // atteres a NYARI idoszamitasra - setub-ba is // nyari: DST = 1, teli: DST = 0,
   if(nap_hetbe == 0 && ho >= 3 && ho < 10 && nap >= 25 && ora >= 3 && DST==0){ ora += 1;
                                                                                rtc.adjust(DateTime(ev, ho, nap, ora, perc, sec)); 
                                                                                DST = 1;
                                                                                EEPROM.put(1, DST); EEPROM.commit();
                                                                                Serial.print("Atteres a NYARI idoszamitasra -> "); Serial.println(DST);
                                                                                delay(500); } 
/////////////////////////////////////////////////////////////////////////
   IDO = String(ev) + "-" + printDigit(ho) + "-" + printDigit(nap) + " -- "; 
   IDOSZ = toString_IDOSZ(DST);                  
   ORA = String(ora); PERC = String(perc); SEC = String(sec); 
/////////////////////////////////////////////////////////////////////////////
  Serial.println("Thermosztatok beolvas ...");  Serial.print("Thermosztatok allapota: ");
  for(int i = 0; i < 15; i += 2){ thermostat[i] = !mcp.digitalRead(i); 
                                  thermostatok += thermostat[i];  Serial.print(thermostat[i]); Serial.print(",");
                                  }
  Serial.println();
  Serial.print("thermostatok = "); Serial.println(thermostatok);
  for(int i = 0; i < 15; i += 2){ Serial.print("thermostat_"); Serial.print(i); Serial.print(" = "); Serial.println(thermostat[i]); }
  //for(int i = 1; i < 16; i += 2){ Serial.print("radiatorok_"); Serial.print(i); Serial.print(" = "); Serial.println(radiatorok[i]); }
  
   
/////////////////////////////////////////////////////////////////////////
     if (SPIFFS.begin()) { Serial.println(" - SPIFFS Active - ");
                            //Serial.println();
                            spiffsActive = true;   }  else {  Serial.println("Unable to activate SPIFFS");    }
      delay(50); //digitalWrite(ledR, LOW); delay(50); digitalWrite(ledR, HIGH); 
      Dir dir = SPIFFS.openDir("/");  
      while (dir.next()) { String fileName = dir.fileName();
                           size_t fileSize = dir.fileSize();
                           Serial.printf("FS File: %s, size: %s\n", fileName.c_str(), formatBytes(fileSize).c_str()); 
                           }
///////////////////////////////////////////////////////////////////////////////
  
  server.on("/", handle_root);
  server.on("/login", handle_login); 
  server.on("/format", handle_format);
  server.on("/form", handle_form);
  server.on("/inline", []() { server.send(200, "text/plain", "this works as well"); });
  server.onNotFound([](){ if(!handleFileRead(server.uri()))  server.send(404, "text/plain", "FileNotFound");  });
      const char * headerkeys[] = {"User-Agent","Cookie"} ;
      size_t headerkeyssize = sizeof(headerkeys)/sizeof(char*);
      server.collectHeaders(headerkeys, headerkeyssize );
      
  if(MDNS.begin(host)){ Serial.println("mDNS responder started"); } 
                 else { Serial.println("Error setting up MDNS responder!"); }
                 
   httpUpdater.setup(&server, update_path, update_user, update_pass);
  server.begin();
  MDNS.addService("http", "tcp", port);
 delay(50); 
  secChrono.restart();
  myChrono.restart();
  Serial.println(" --- *** ---");
}

void loop() {
  Serial.println(" --- *** ---");
  while(thermostatok == 0 && indul == false && !secChrono.hasPassed(18)) { mcp.digitalWrite(7, HIGH);      Serial.print("Thermosztatok allapota: ");
                                                                           for(int i = 0; i < 15; i += 2){ thermostat[i] = !mcp.digitalRead(i); 
                                                                                                           thermostatok += thermostat[i];  Serial.print(thermostat[i]); Serial.print(",");  } 
                                                                           Serial.print("     indulo keringetes: "); Serial.print(secChrono.elapsed()); Serial.println(" mp");  
                                                                           if(thermostatok > 0){  mcp.digitalWrite(7, LOW); } }
                      
                      indul = true;
                      Serial.println("Tovabblepik ... INDUL"); }
  if(myChrono.hasPassed(1000)){ myChrono.restart(); 
  
  if(formate == true && crt >= 3){ formate = false; SPIFFS.format(); }
  
  for(int i = 0; i < 15; i += 2){  thermostat[i] = !mcp.digitalRead(i);
                                   //p_thermostat[i] = thermostat[i];
                                   thermostatok += thermostat[i];   Serial.print("thermostat_"); Serial.print(i); Serial.print(" = "); Serial.print(thermostat[i]); Serial.print(",   "); 
                                   if(thermostatok > 0){ if(thermostat[i] == true || p_thermostat[i] == true){ mcp.digitalWrite(thermostat[i+1], HIGH); }
                                                                                                        else { mcp.digitalWrite(thermostat[i+1], LOW); }
                                                         futes = true; 
                                                         secChrono.restart(); } else { futes = false; 
                                                                                       if(secChrono.hasPassed(18)){ for(int i = 0; i < 15; i += 2){ mcp.digitalWrite(thermostat[i+1], LOW); }  } 
                                                                                                                    secChrono.stop(); } 
                                   Serial.print("radiator_"); Serial.print(i); Serial.print(" = "); Serial.print(thermostat[i]); Serial.println();
                                   }
   crt++; if(crt == 10000){ crt = 200; }
   lgn++; if(lgn == 10000){ lgn = 200; }
                                   }
  Serial.print("futes = "); Serial.println(futes);
 // if(thermostatok == 5){ thermostat[2] = false; thermostatok = 0; }
  digitalWrite(kazan, futes); 
  
}
