#include <stdint.h>
#include "lcd.h"
#include "bmp.h"

#define   WIDTH    60
#define   HEIGHT  100

#if LCD_REVERSE16 == 0
#define  RC(a)   a
#endif
#if LCD_REVERSE16 == 1
#define  RC(a)   ((((a) & 0xFF) << 8) | (((a) & 0xFF00) >> 8))
#endif

// struct packing, pragma for GCC !!!
#pragma pack(push, 1)

  const BITMAPSTRUCT beer_60x100_16 __attribute__((aligned)) = {
  {
    0x4d42u,
    sizeof(BITMAPINFOHEADER) + sizeof(BITMAPFILEHEADER) + (WIDTH * HEIGHT * 2),
    0x0000u,
    0x0000u,
    sizeof(BITMAPINFOHEADER) + sizeof(BITMAPFILEHEADER)
  },
  {
    sizeof(BITMAPINFOHEADER),
    WIDTH,
    HEIGHT,
    1u,
    16,
    0x00000003u,
    (WIDTH * HEIGHT * 2),
    0x00000000ul,
    0x00000000ul,
    0x00000000ul,
    0x00000000ul
  },
  {
    RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf),
    RC(0xfabf), RC(0x5207), RC(0x5a48), RC(0x5a48), RC(0x5228), RC(0x49e7), RC(0x3985), RC(0x2903), RC(0x1881), RC(0x1860), RC(0x1860), RC(0x2060), RC(0x2080), RC(0x2880), RC(0x30a0), RC(0x38c0), RC(0x5100), RC(0x6980), RC(0x8a00), RC(0x9a80), RC(0x9aa0), RC(0x9aa0), RC(0x9281), RC(0x9280), RC(0x9aa0), RC(0xa300), RC(0xab20), RC(0x9aa0), RC(0x9240), RC(0x81e0), RC(0x5960), RC(0x4900), RC(0x30c0), RC(0x28a0), RC(0x2080), RC(0x2080), RC(0x1880), RC(0x1880), RC(0x1881), RC(0x28e2), RC(0x3944), RC(0x41c6), RC(0x5207), RC(0x5a68), RC(0x628a), RC(0x628a), RC(0x62aa), RC(0x5a69), RC(0x62aa), RC(0x6aca), RC(0x6aca), RC(0x628a), RC(0x5248), RC(0x4a07), RC(0x49e7), RC(0x4a07), RC(0x4a28), RC(0x5228), RC(0x5a89), RC(0xfabf),
    RC(0xfabf), RC(0x0841), RC(0x20e3), RC(0x3985), RC(0x5207), RC(0x49e6), RC(0x3965), RC(0x28e3), RC(0x1880), RC(0x1860), RC(0x2060), RC(0x2060), RC(0x2080), RC(0x28a0), RC(0x30a0), RC(0x40e0), RC(0x5100), RC(0x6960), RC(0x8a00), RC(0x9a80), RC(0xab00), RC(0xab41), RC(0xa2c1), RC(0x9ac0), RC(0x9aa1), RC(0x9aa0), RC(0x9a80), RC(0x9aa0), RC(0x9aa0), RC(0x79e0), RC(0x5120), RC(0x38e0), RC(0x30c0), RC(0x28a0), RC(0x2080), RC(0x1880), RC(0x1880), RC(0x1880), RC(0x1881), RC(0x20e2), RC(0x3144), RC(0x3985), RC(0x49c6), RC(0x5a48), RC(0x6289), RC(0x62aa), RC(0x62ca), RC(0x6b0b), RC(0x62ab), RC(0x5a69), RC(0x5248), RC(0x5248), RC(0x5248), RC(0x4a28), RC(0x5228), RC(0x5248), RC(0x5248), RC(0x5a68), RC(0x62aa), RC(0xfabf),
    RC(0xfabf), RC(0x3964), RC(0x1081), RC(0x0840), RC(0x0861), RC(0x20c3), RC(0x3124), RC(0x20e2), RC(0x1880), RC(0x1860), RC(0x2080), RC(0x2080), RC(0x2080), RC(0x28a0), RC(0x30c0), RC(0x38c0), RC(0x5100), RC(0x6980), RC(0x8a00), RC(0x9a80), RC(0xa2c0), RC(0xab20), RC(0xb380), RC(0xab21), RC(0xa2c0), RC(0xa2a0), RC(0xa2a1), RC(0x9a60), RC(0x8200), RC(0x69a0), RC(0x5120), RC(0x38c0), RC(0x28a0), RC(0x28a0), RC(0x20a0), RC(0x2080), RC(0x1880), RC(0x1860), RC(0x1881), RC(0x20e2), RC(0x3144), RC(0x39a6), RC(0x4a07), RC(0x5228), RC(0x5a48), RC(0x6289), RC(0x6aeb), RC(0x6aeb), RC(0x62aa), RC(0x5a8a), RC(0x5a8a), RC(0x5228), RC(0x49e7), RC(0x49e7), RC(0x5228), RC(0x5a69), RC(0x62cb), RC(0x6aeb), RC(0x6aeb), RC(0xfabf),
    RC(0xfabf), RC(0x6288), RC(0x6288), RC(0x49e6), RC(0x28e3), RC(0x1061), RC(0x0020), RC(0x0840), RC(0x1040), RC(0x1040), RC(0x1860), RC(0x2080), RC(0x30a0), RC(0x30a0), RC(0x30a0), RC(0x38c0), RC(0x4900), RC(0x6160), RC(0x79a0), RC(0x9240), RC(0xa2a0), RC(0xa2e0), RC(0xb381), RC(0xbba1), RC(0xab41), RC(0xab00), RC(0xa2c0), RC(0x9a80), RC(0x8200), RC(0x5940), RC(0x40e0), RC(0x30c0), RC(0x28c0), RC(0x20a0), RC(0x2080), RC(0x1880), RC(0x1880), RC(0x1880), RC(0x1881), RC(0x20c2), RC(0x2924), RC(0x41c6), RC(0x4a08), RC(0x5a49), RC(0x5a69), RC(0x5a89), RC(0x62aa), RC(0x6289), RC(0x6289), RC(0x5a89), RC(0x5248), RC(0x4a08), RC(0x4a08), RC(0x5228), RC(0x5228), RC(0x5248), RC(0x62ca), RC(0x732c), RC(0x7b6d), RC(0xfabf),
    RC(0xfabf), RC(0x6289), RC(0x6288), RC(0x6268), RC(0x5a27), RC(0x49c6), RC(0x2903), RC(0x1061), RC(0x0820), RC(0x0020), RC(0x0820), RC(0x1040), RC(0x2080), RC(0x28a0), RC(0x28a0), RC(0x38c0), RC(0x4900), RC(0x6980), RC(0x79e0), RC(0x79c1), RC(0xa2c0), RC(0xa2c1), RC(0xab20), RC(0xab40), RC(0xb341), RC(0xb360), RC(0xab41), RC(0xa2a0), RC(0x81e0), RC(0x5120), RC(0x38c0), RC(0x28a0), RC(0x2880), RC(0x2080), RC(0x2080), RC(0x1880), RC(0x1880), RC(0x1061), RC(0x1081), RC(0x18a2), RC(0x2904), RC(0x3986), RC(0x41e7), RC(0x4a28), RC(0x5a8a), RC(0x62aa), RC(0x5a8a), RC(0x5a89), RC(0x5a69), RC(0x5248), RC(0x5208), RC(0x5228), RC(0x5248), RC(0x5a69), RC(0x5269), RC(0x62ca), RC(0x6aeb), RC(0x6aea), RC(0x6aeb), RC(0xfabf),
    RC(0xfabf), RC(0x6aa9), RC(0x6289), RC(0x5a68), RC(0x5a27), RC(0x49e6), RC(0x3944), RC(0x20c2), RC(0x1060), RC(0x1040), RC(0x0840), RC(0x0020), RC(0x0820), RC(0x1040), RC(0x2080), RC(0x28a0), RC(0x30c0), RC(0x5940), RC(0x7a00), RC(0x8200), RC(0x9241), RC(0x9a80), RC(0x9aa1), RC(0xa301), RC(0xab20), RC(0xb360), RC(0xb341), RC(0xa2c0), RC(0x79e0), RC(0x4920), RC(0x30c0), RC(0x28a0), RC(0x2080), RC(0x2080), RC(0x1860), RC(0x1860), RC(0x1860), RC(0x1861), RC(0x1061), RC(0x1081), RC(0x20e3), RC(0x3145), RC(0x41e7), RC(0x4a28), RC(0x5249), RC(0x5249), RC(0x5a69), RC(0x5269), RC(0x5249), RC(0x5248), RC(0x4a28), RC(0x5248), RC(0x5228), RC(0x5a69), RC(0x6aeb), RC(0x732c), RC(0x732c), RC(0x732c), RC(0x7b4c), RC(0xfabf),
    RC(0xfabf), RC(0x72ea), RC(0x62a9), RC(0x6289), RC(0x5a48), RC(0x49e6), RC(0x3965), RC(0x20c2), RC(0x1060), RC(0x1040), RC(0x1860), RC(0x1860), RC(0x1040), RC(0x0840), RC(0x0020), RC(0x0820), RC(0x1040), RC(0x1060), RC(0x5140), RC(0x79c0), RC(0x8a20), RC(0xa2e0), RC(0xa301), RC(0xa2e0), RC(0xab01), RC(0xab20), RC(0xab20), RC(0x9a80), RC(0x71c0), RC(0x4100), RC(0x30c0), RC(0x28a0), RC(0x2080), RC(0x1860), RC(0x1860), RC(0x1860), RC(0x1060), RC(0x1061), RC(0x1081), RC(0x1881), RC(0x18c2), RC(0x2924), RC(0x3186), RC(0x41e7), RC(0x4a28), RC(0x5249), RC(0x5249), RC(0x4a28), RC(0x5249), RC(0x5269), RC(0x5a8a), RC(0x5a8a), RC(0x62aa), RC(0x62ca), RC(0x6b0b), RC(0x730c), RC(0x7b6d), RC(0x83ae), RC(0x83ae), RC(0xfabf),
    RC(0xfabf), RC(0x72ea), RC(0x6aca), RC(0x62a9), RC(0x5a68), RC(0x5207), RC(0x3985), RC(0x18a2), RC(0x1040), RC(0x1040), RC(0x1040), RC(0x1840), RC(0x1860), RC(0x1880), RC(0x1860), RC(0x1060), RC(0x1040), RC(0x0820), RC(0x2080), RC(0x69a0), RC(0x9260), RC(0xa2e1), RC(0xab20), RC(0xb361), RC(0xb360), RC(0xb341), RC(0xab00), RC(0x9260), RC(0x6160), RC(0x38e0), RC(0x28a0), RC(0x20a0), RC(0x1880), RC(0x1860), RC(0x1860), RC(0x1060), RC(0x1060), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1081), RC(0x20e3), RC(0x2945), RC(0x39c7), RC(0x4208), RC(0x4208), RC(0x4a28), RC(0x5249), RC(0x5a8a), RC(0x5aaa), RC(0x62cb), RC(0x62cb), RC(0x732c), RC(0x734d), RC(0x734d), RC(0x7b4d), RC(0x7b6d), RC(0x83ad), RC(0x838d), RC(0xfabf),
    RC(0xfabf), RC(0x732b), RC(0x6aca), RC(0x6aea), RC(0x6289), RC(0x5207), RC(0x3985), RC(0x18a2), RC(0x1040), RC(0x1060), RC(0x1040), RC(0x1040), RC(0x1860), RC(0x1860), RC(0x2080), RC(0x28a0), RC(0x30c0), RC(0x30c0), RC(0x30c0), RC(0x1860), RC(0x28a1), RC(0x5980), RC(0x8a61), RC(0xab20), RC(0xb360), RC(0xc3c1), RC(0xbba0), RC(0x9280), RC(0x5960), RC(0x30e0), RC(0x28a0), RC(0x2080), RC(0x1880), RC(0x1880), RC(0x1060), RC(0x1060), RC(0x1060), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1082), RC(0x18c3), RC(0x2924), RC(0x39a6), RC(0x39c7), RC(0x4a29), RC(0x526a), RC(0x5aaa), RC(0x6b0c), RC(0x734d), RC(0x734d), RC(0x7b8e), RC(0x7b8e), RC(0x7bae), RC(0x83cf), RC(0x8bcf), RC(0x83ae), RC(0x83ae), RC(0xfabf),
    RC(0xfabf), RC(0x730b), RC(0x7b2b), RC(0x72ea), RC(0x6289), RC(0x5228), RC(0x3965), RC(0x18a2), RC(0x1040), RC(0x1060), RC(0x1060), RC(0x1040), RC(0x1060), RC(0x1860), RC(0x1880), RC(0x2080), RC(0x28a0), RC(0x40e0), RC(0x8200), RC(0xa2e0), RC(0x7201), RC(0x4101), RC(0x2081), RC(0x38e1), RC(0x69e1), RC(0xa2e1), RC(0xab20), RC(0x9260), RC(0x5941), RC(0x30e1), RC(0x20a0), RC(0x1881), RC(0x1880), RC(0x1060), RC(0x1060), RC(0x1061), RC(0x1060), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1082), RC(0x18c2), RC(0x2104), RC(0x2924), RC(0x3145), RC(0x41c7), RC(0x5269), RC(0x6b0c), RC(0x734d), RC(0x734d), RC(0x736d), RC(0x83cf), RC(0x83cf), RC(0x8bf0), RC(0x8c10), RC(0x83cf), RC(0x8bef), RC(0x8bef), RC(0xfabf),
    RC(0xfabf), RC(0x6289), RC(0x5a69), RC(0x5a69), RC(0x6289), RC(0x5228), RC(0x3165), RC(0x1881), RC(0x1040), RC(0x1040), RC(0x1040), RC(0x1040), RC(0x1060), RC(0x1060), RC(0x1860), RC(0x2080), RC(0x20a0), RC(0x4100), RC(0x8200), RC(0xab01), RC(0xbba0), RC(0xbbc0), RC(0xa300), RC(0x69c1), RC(0x38e1), RC(0x2881), RC(0x4101), RC(0x5960), RC(0x4100), RC(0x28c0), RC(0x20a1), RC(0x18a1), RC(0x1881), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x0841), RC(0x1061), RC(0x1081), RC(0x18a2), RC(0x20e3), RC(0x2924), RC(0x3165), RC(0x39a6), RC(0x41c7), RC(0x4a08), RC(0x5a69), RC(0x6aeb), RC(0x7baf), RC(0x9431), RC(0x8c10), RC(0x8bf0), RC(0x8c10), RC(0x8c10), RC(0x9430), RC(0x9431), RC(0x8c10), RC(0xfabf),
    RC(0xfabf), RC(0x7b2b), RC(0x6aea), RC(0x5a69), RC(0x4a07), RC(0x39a6), RC(0x2924), RC(0x1061), RC(0x1040), RC(0x1040), RC(0x1040), RC(0x1060), RC(0x1060), RC(0x1060), RC(0x1860), RC(0x2080), RC(0x20a0), RC(0x3900), RC(0x8220), RC(0xa300), RC(0xbb80), RC(0xbbc1), RC(0xbbc1), RC(0xbbe1), RC(0xc3e1), RC(0x9b21), RC(0x61a1), RC(0x2081), RC(0x1061), RC(0x1060), RC(0x1860), RC(0x1881), RC(0x1881), RC(0x1081), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x0861), RC(0x0861), RC(0x1061), RC(0x1082), RC(0x18c3), RC(0x2924), RC(0x39a6), RC(0x4a08), RC(0x5269), RC(0x5a69), RC(0x62aa), RC(0x62ca), RC(0x6aeb), RC(0x732c), RC(0x7b6d), RC(0x83ae), RC(0x9410), RC(0x9c72), RC(0x9471), RC(0x9451), RC(0x9451), RC(0x9431), RC(0xfabf),
    RC(0xfabf), RC(0x730b), RC(0x730b), RC(0x6aeb), RC(0x6289), RC(0x49e7), RC(0x2103), RC(0x0841), RC(0x0840), RC(0x1040), RC(0x1060), RC(0x1060), RC(0x1060), RC(0x1060), RC(0x1860), RC(0x2080), RC(0x28c0), RC(0x4100), RC(0x8a40), RC(0xab41), RC(0xbba1), RC(0xb3a0), RC(0xbba1), RC(0xbbc1), RC(0xc420), RC(0xc420), RC(0xb3a1), RC(0x8241), RC(0x30e1), RC(0x1060), RC(0x0820), RC(0x0840), RC(0x1060), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x0861), RC(0x0861), RC(0x0861), RC(0x1082), RC(0x18c3), RC(0x2944), RC(0x4a08), RC(0x62eb), RC(0x734d), RC(0x734d), RC(0x734d), RC(0x734d), RC(0x7b6d), RC(0x7b4c), RC(0x7b4c), RC(0x83ad), RC(0x83ae), RC(0x8bcf), RC(0x8c10), RC(0x9c72), RC(0x9cb3), RC(0x9492), RC(0xfabf),
    RC(0xfabf), RC(0x7b4c), RC(0x7b4c), RC(0x6aea), RC(0x6289), RC(0x4a07), RC(0x2924), RC(0x0841), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x1060), RC(0x1060), RC(0x1060), RC(0x1880), RC(0x20a0), RC(0x28c1), RC(0x4941), RC(0x9280), RC(0xab60), RC(0xbbe0), RC(0xc401), RC(0xbbc1), RC(0xbbc0), RC(0xbbc1), RC(0xbbc1), RC(0xb361), RC(0x9281), RC(0x5961), RC(0x30e1), RC(0x2080), RC(0x1060), RC(0x0820), RC(0x0020), RC(0x0840), RC(0x0841), RC(0x0861), RC(0x0861), RC(0x0861), RC(0x1081), RC(0x1082), RC(0x18e3), RC(0x3165), RC(0x5228), RC(0x6b0c), RC(0x83ae), RC(0x8c10), RC(0x8c30), RC(0x8c10), RC(0x9410), RC(0x8bef), RC(0x8bce), RC(0x8bce), RC(0x8bae), RC(0x838d), RC(0x838d), RC(0x8bce), RC(0x83cf), RC(0x9431), RC(0xfabf),
    RC(0xfabf), RC(0x7b4b), RC(0x7b2b), RC(0x72ea), RC(0x62a9), RC(0x5208), RC(0x2904), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x0860), RC(0x1060), RC(0x1060), RC(0x1880), RC(0x20a1), RC(0x28e1), RC(0x5181), RC(0x92a0), RC(0xab41), RC(0xbbc1), RC(0xc401), RC(0xc401), RC(0xc401), RC(0xc3e1), RC(0xbba1), RC(0xab20), RC(0x8a40), RC(0x5980), RC(0x3101), RC(0x20c1), RC(0x18a1), RC(0x1881), RC(0x1061), RC(0x0840), RC(0x0020), RC(0x0020), RC(0x0840), RC(0x0841), RC(0x1061), RC(0x10a2), RC(0x20e3), RC(0x3165), RC(0x4a08), RC(0x6aeb), RC(0x83ae), RC(0x9450), RC(0x9c71), RC(0x9c71), RC(0x9cb2), RC(0xa4b2), RC(0x9c71), RC(0x9c71), RC(0x9410), RC(0x8bce), RC(0x7b6d), RC(0x836d), RC(0x7b4d), RC(0x7b6d), RC(0xfabf),
    RC(0xfabf), RC(0x7b6c), RC(0x7b4c), RC(0x730b), RC(0x6aa9), RC(0x4a07), RC(0x20e3), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x1060), RC(0x1060), RC(0x1060), RC(0x1881), RC(0x18a0), RC(0x28e1), RC(0x5181), RC(0x9ae1), RC(0xb380), RC(0xbbc1), RC(0xc3e0), RC(0xc401), RC(0xc3e1), RC(0xbbe1), RC(0xbba0), RC(0xab21), RC(0x9280), RC(0x5981), RC(0x28e1), RC(0x20a1), RC(0x18a1), RC(0x1881), RC(0x1081), RC(0x1081), RC(0x1061), RC(0x0841), RC(0x0020), RC(0x0020), RC(0x0020), RC(0x1082), RC(0x2924), RC(0x3986), RC(0x4a08), RC(0x62aa), RC(0x732c), RC(0x83ce), RC(0x9c71), RC(0xa4b2), RC(0xa4b2), RC(0xa4d3), RC(0xa4d2), RC(0xa4b2), RC(0x9c71), RC(0x9410), RC(0x8bcf), RC(0x83ae), RC(0x7b4c), RC(0x732c), RC(0xfabf),
    RC(0xfabf), RC(0x7b4c), RC(0x730b), RC(0x6aea), RC(0x6aca), RC(0x4a07), RC(0x20c2), RC(0x0840), RC(0x0820), RC(0x0840), RC(0x0840), RC(0x1061), RC(0x1061), RC(0x1881), RC(0x18a1), RC(0x28e1), RC(0x3121), RC(0x59a1), RC(0x8a81), RC(0xab40), RC(0xbbe0), RC(0xcc60), RC(0xd4a0), RC(0xd4a1), RC(0xcc40), RC(0xbbc1), RC(0xab41), RC(0x9ac0), RC(0x71e1), RC(0x3921), RC(0x20c1), RC(0x18a1), RC(0x1081), RC(0x1081), RC(0x1081), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x0841), RC(0x0020), RC(0x0841), RC(0x2104), RC(0x4a08), RC(0x62cb), RC(0x7b4c), RC(0x8bce), RC(0x9430), RC(0x9c50), RC(0x9450), RC(0x9c71), RC(0x9c51), RC(0x9450), RC(0x9451), RC(0x9430), RC(0x9430), RC(0x8bcf), RC(0x838d), RC(0x7b4d), RC(0xfabf),
    RC(0xfabf), RC(0x7b4c), RC(0x730b), RC(0x6aca), RC(0x5a89), RC(0x41c6), RC(0x18a2), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x0861), RC(0x1060), RC(0x1881), RC(0x20c1), RC(0x3921), RC(0x4981), RC(0x8a81), RC(0xab61), RC(0xbbc1), RC(0xbbe0), RC(0xc441), RC(0xd4e0), RC(0xdd21), RC(0xd4e0), RC(0xcc81), RC(0xc420), RC(0xb381), RC(0x8a60), RC(0x4941), RC(0x28e1), RC(0x18a1), RC(0x1081), RC(0x1061), RC(0x0861), RC(0x0860), RC(0x0861), RC(0x0841), RC(0x0861), RC(0x0841), RC(0x1082), RC(0x20e3), RC(0x20c3), RC(0x1061), RC(0x20e3), RC(0x5228), RC(0x836d), RC(0x9c50), RC(0xa470), RC(0xa471), RC(0x9c71), RC(0x9430), RC(0x8bef), RC(0x8bef), RC(0x83ce), RC(0x8bef), RC(0x83cf), RC(0x83ce), RC(0x838e), RC(0xfabf),
    RC(0xfabf), RC(0x7b4c), RC(0x730b), RC(0x6b0b), RC(0x5a69), RC(0x39a6), RC(0x1061), RC(0x0820), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x1061), RC(0x1061), RC(0x1880), RC(0x28e1), RC(0x4960), RC(0x7a41), RC(0xbc00), RC(0xcc80), RC(0xd4a0), RC(0xd4a1), RC(0xcc80), RC(0xbc20), RC(0xc420), RC(0xcc80), RC(0xd4c0), RC(0xd4c0), RC(0xcc60), RC(0xb380), RC(0x7a20), RC(0x4100), RC(0x20c1), RC(0x1881), RC(0x1081), RC(0x0861), RC(0x0861), RC(0x0841), RC(0x0861), RC(0x1061), RC(0x0861), RC(0x1082), RC(0x3965), RC(0x6268), RC(0x6ac9), RC(0x5227), RC(0x3944), RC(0x18a1), RC(0x3965), RC(0x6aeb), RC(0x940f), RC(0x9c30), RC(0x9c30), RC(0x9450), RC(0x942f), RC(0x83ae), RC(0x838e), RC(0x838d), RC(0x7b8d), RC(0x838d), RC(0xfabf),
    RC(0xfabf), RC(0x7b2b), RC(0x730b), RC(0x730b), RC(0x62aa), RC(0x3986), RC(0x1061), RC(0x0820), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x1061), RC(0x28c0), RC(0x4940), RC(0x61a0), RC(0x8a60), RC(0x9ae0), RC(0x8260), RC(0x7a00), RC(0x69a0), RC(0x5160), RC(0x4120), RC(0x4120), RC(0x5160), RC(0x61c0), RC(0x6a00), RC(0x8280), RC(0x92e0), RC(0x92a0), RC(0x69a0), RC(0x38e0), RC(0x1880), RC(0x1081), RC(0x1061), RC(0x1081), RC(0x1081), RC(0x1082), RC(0x1082), RC(0x1881), RC(0x2903), RC(0x41a5), RC(0x5a48), RC(0x732b), RC(0x93ef), RC(0xa491), RC(0x942f), RC(0x62aa), RC(0x2923), RC(0x18a2), RC(0x41c6), RC(0x732b), RC(0x940f), RC(0x940f), RC(0x9430), RC(0x8bef), RC(0x83ae), RC(0x7b6d), RC(0x732c), RC(0xfabf),
    RC(0xfabf), RC(0x7b4c), RC(0x732b), RC(0x730b), RC(0x62aa), RC(0x3986), RC(0x0841), RC(0x0821), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x0840), RC(0x1060), RC(0x28c0), RC(0x38e0), RC(0x38e0), RC(0x38e0), RC(0x4100), RC(0x38e0), RC(0x4120), RC(0x5140), RC(0x61a1), RC(0x71e1), RC(0x7200), RC(0x69e1), RC(0x59a0), RC(0x5160), RC(0x4940), RC(0x4120), RC(0x38e0), RC(0x30e0), RC(0x30c0), RC(0x28c0), RC(0x20a0), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1082), RC(0x1082), RC(0x18c2), RC(0x3986), RC(0x4a07), RC(0x5a48), RC(0x72ea), RC(0x8bad), RC(0xa470), RC(0xacb2), RC(0xacb1), RC(0xa4b1), RC(0x83ce), RC(0x4a27), RC(0x20c2), RC(0x20e3), RC(0x5228), RC(0x7b4c), RC(0x93ef), RC(0x9410), RC(0x83ae), RC(0x7b6d), RC(0xfabf),
    RC(0xfabf), RC(0x7b4c), RC(0x7b4c), RC(0x6aeb), RC(0x5228), RC(0x3144), RC(0x0841), RC(0x0820), RC(0x0821), RC(0x0841), RC(0x0840), RC(0x0840), RC(0x1060), RC(0x1880), RC(0x20a0), RC(0x20c0), RC(0x3941), RC(0x6244), RC(0x8b44), RC(0xb485), RC(0xc506), RC(0xd589), RC(0xcda9), RC(0xc54a), RC(0xcd4a), RC(0xd5a9), RC(0xcd68), RC(0xac24), RC(0x8302), RC(0x51c2), RC(0x30e1), RC(0x20a1), RC(0x1880), RC(0x1060), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1082), RC(0x1082), RC(0x18a2), RC(0x3165), RC(0x5a89), RC(0x6b0b), RC(0x83ae), RC(0x8bce), RC(0x8bce), RC(0x940f), RC(0xa491), RC(0xacb1), RC(0xacd1), RC(0xacd1), RC(0x9c90), RC(0x734c), RC(0x3985), RC(0x1882), RC(0x2924), RC(0x5a89), RC(0x7b6d), RC(0x83ad), RC(0xfabf),
    RC(0xfabf), RC(0x836c), RC(0x836c), RC(0x72eb), RC(0x5a69), RC(0x2924), RC(0x0020), RC(0x0020), RC(0x0020), RC(0x0841), RC(0x0840), RC(0x1060), RC(0x1881), RC(0x20c1), RC(0x5244), RC(0x6ac7), RC(0x83a9), RC(0x7b49), RC(0x7b07), RC(0x7284), RC(0x7264), RC(0x7223), RC(0x7202), RC(0x7a42), RC(0x7222), RC(0x7242), RC(0x7262), RC(0x7ac3), RC(0x8324), RC(0x8b87), RC(0x8368), RC(0x5a66), RC(0x3143), RC(0x1881), RC(0x1061), RC(0x1040), RC(0x1061), RC(0x1061), RC(0x1061), RC(0x1081), RC(0x2944), RC(0x6aeb), RC(0x83ce), RC(0x9c92), RC(0x9471), RC(0x9430), RC(0x9430), RC(0x940f), RC(0x9430), RC(0x9c50), RC(0x9c70), RC(0xa4b1), RC(0xa4b1), RC(0xa4b1), RC(0x940f), RC(0x62aa), RC(0x2103), RC(0x1081), RC(0x3165), RC(0xfabf),
    RC(0xfabf), RC(0x5a68), RC(0x730b), RC(0x72ea), RC(0x5a68), RC(0x20e3), RC(0x0021), RC(0x0020), RC(0x0841), RC(0x0841), RC(0x1060), RC(0x20c2), RC(0x5246), RC(0x6b2a), RC(0x734a), RC(0x72e8), RC(0x51c3), RC(0x4121), RC(0x59c1), RC(0x5a02), RC(0x7261), RC(0x82e3), RC(0x7ae4), RC(0x7b05), RC(0x7ae4), RC(0x7b03), RC(0x6a63), RC(0x6202), RC(0x51c2), RC(0x51e3), RC(0x5a24), RC(0x6286), RC(0x6b09), RC(0x5a88), RC(0x3984), RC(0x1881), RC(0x1061), RC(0x0861), RC(0x0861), RC(0x1061), RC(0x2924), RC(0x734c), RC(0x9430), RC(0xa4b2), RC(0xa4d2), RC(0xa4b2), RC(0x9c71), RC(0x9c71), RC(0x9c91), RC(0x9c92), RC(0x9c91), RC(0xa491), RC(0x9c71), RC(0xa491), RC(0xa491), RC(0x9c70), RC(0x9c50), RC(0x7b6c), RC(0x41e7), RC(0xfabf),
    RC(0xfabf), RC(0x41a5), RC(0x20c2), RC(0x3124), RC(0x3986), RC(0x18a2), RC(0x0020), RC(0x0840), RC(0x1061), RC(0x1881), RC(0x3164), RC(0x5aa9), RC(0x6b0a), RC(0x6ac7), RC(0x5a04), RC(0x51a1), RC(0xa487), RC(0xacc9), RC(0xbd2a), RC(0xbd6c), RC(0xdeb4), RC(0xd632), RC(0xe6f7), RC(0xe6f7), RC(0xde74), RC(0xe716), RC(0xce0e), RC(0xcdce), RC(0xc5cd), RC(0xc567), RC(0x6263), RC(0x6286), RC(0x5a24), RC(0x62c8), RC(0x6b0a), RC(0x5268), RC(0x20c2), RC(0x1061), RC(0x0841), RC(0x0861), RC(0x18c3), RC(0x732c), RC(0x9c71), RC(0xacf3), RC(0xacf3), RC(0x9cb2), RC(0xa4b2), RC(0xa4d2), RC(0xa4b2), RC(0xa4d2), RC(0xa4d2), RC(0xa4b2), RC(0xa4b2), RC(0x9c71), RC(0x9c71), RC(0x9c50), RC(0x942f), RC(0x942f), RC(0x940f), RC(0xfabf),
    RC(0xfabf), RC(0x8b8c), RC(0x7b2b), RC(0x49e6), RC(0x18a2), RC(0x0840), RC(0x0020), RC(0x0861), RC(0x1881), RC(0x39a5), RC(0x5aa9), RC(0x6ac9), RC(0x5a05), RC(0x6243), RC(0xb50b), RC(0xa48a), RC(0xce10), RC(0xbdd2), RC(0xdeb5), RC(0xdeb6), RC(0xded6), RC(0xe6f6), RC(0xe718), RC(0xe718), RC(0xe6f7), RC(0xe717), RC(0xe6f7), RC(0xded5), RC(0xce13), RC(0xd673), RC(0xad0e), RC(0xbd8c), RC(0x5a23), RC(0x49c4), RC(0x5226), RC(0x62ea), RC(0x5288), RC(0x18a2), RC(0x1081), RC(0x1061), RC(0x18a2), RC(0x62cb), RC(0x8c10), RC(0xa4b2), RC(0x9c92), RC(0xacf3), RC(0xacf3), RC(0xa4d3), RC(0xa4d3), RC(0xa4d2), RC(0xa4d3), RC(0xa4d3), RC(0xa4b2), RC(0xa4b2), RC(0xa491), RC(0x9450), RC(0x9c30), RC(0x940f), RC(0x8bee), RC(0xfabf),
    RC(0xfabf), RC(0x8bad), RC(0x8bac), RC(0x7b4b), RC(0x5a68), RC(0x1081), RC(0x1041), RC(0x1081), RC(0x3165), RC(0x62ca), RC(0x41c6), RC(0x5226), RC(0x944e), RC(0x7328), RC(0xbdd1), RC(0xa50f), RC(0xb592), RC(0xce32), RC(0xce52), RC(0xdeb4), RC(0xe6f5), RC(0xdeb4), RC(0xdeb4), RC(0xe6d4), RC(0xe6d5), RC(0xdef6), RC(0xe6d6), RC(0xded7), RC(0xd6b5), RC(0xce34), RC(0xbdd2), RC(0xc613), RC(0x83ec), RC(0xa4ce), RC(0x51e5), RC(0x3985), RC(0x5269), RC(0x5aea), RC(0x20e2), RC(0x1881), RC(0x18a1), RC(0x732c), RC(0x9c71), RC(0xa4d3), RC(0x9cb2), RC(0x9451), RC(0x9451), RC(0xa4d3), RC(0xa4f3), RC(0xa4d3), RC(0xa4f3), RC(0x9cb2), RC(0xa4b2), RC(0xa4d2), RC(0xa4b2), RC(0x9c91), RC(0x9c71), RC(0x9430), RC(0x940f), RC(0xfabf),
    RC(0xfabf), RC(0x8bcd), RC(0x93cd), RC(0x836c), RC(0x6289), RC(0x1881), RC(0x1881), RC(0x3144), RC(0x5aca), RC(0x5aaa), RC(0x6ae9), RC(0x6267), RC(0xa4cf), RC(0x840c), RC(0xa510), RC(0xc5f2), RC(0xce54), RC(0xce75), RC(0xd653), RC(0xdeb5), RC(0xe6f7), RC(0xdeb7), RC(0xe6f7), RC(0xe718), RC(0xdef7), RC(0xdeb7), RC(0xef5a), RC(0xe6f6), RC(0xd696), RC(0xd6b8), RC(0xd676), RC(0xbd90), RC(0xa510), RC(0xad2e), RC(0x6b4a), RC(0x83cc), RC(0x4a07), RC(0x5289), RC(0x4a49), RC(0x1881), RC(0x20c2), RC(0x6aeb), RC(0x9c92), RC(0xa4b2), RC(0xacf3), RC(0xacf3), RC(0xa4b2), RC(0x8c10), RC(0x8bef), RC(0x9c71), RC(0xa4d3), RC(0xa4d3), RC(0xa4d3), RC(0xa4b2), RC(0x9c92), RC(0x9c92), RC(0x9c71), RC(0x9430), RC(0x9430), RC(0xfabf),
    RC(0xfabf), RC(0x8bcd), RC(0x8bcd), RC(0x838c), RC(0x6289), RC(0x18a1), RC(0x20e2), RC(0x5289), RC(0x41e7), RC(0x49e6), RC(0x944e), RC(0x630a), RC(0xbd8e), RC(0xa4f1), RC(0xad51), RC(0xdeb7), RC(0xd697), RC(0xce55), RC(0xd655), RC(0xb52e), RC(0xacca), RC(0xacc8), RC(0xac86), RC(0xa445), RC(0xa425), RC(0xa467), RC(0xb4ea), RC(0xc5f0), RC(0xe6f9), RC(0xded7), RC(0xe6f9), RC(0xce76), RC(0xa533), RC(0xad0f), RC(0x738c), RC(0x840d), RC(0x6b0a), RC(0x4a48), RC(0x39e7), RC(0x3165), RC(0x18c2), RC(0x5aaa), RC(0x9c92), RC(0xa4f3), RC(0xa4f3), RC(0x9c92), RC(0x9c92), RC(0xad14), RC(0xa4b3), RC(0x8bef), RC(0x83ae), RC(0x8bef), RC(0x9c92), RC(0x9c92), RC(0xa4d2), RC(0x9c92), RC(0x9c71), RC(0x9450), RC(0x9430), RC(0xfabf),
    RC(0xfabf), RC(0x93cd), RC(0x93cd), RC(0x838c), RC(0x5a47), RC(0x18a1), RC(0x41e7), RC(0x4a48), RC(0x942e), RC(0x7bad), RC(0x736c), RC(0x8c6e), RC(0xbd93), RC(0xad53), RC(0xe6f6), RC(0xd675), RC(0xce11), RC(0xcdef), RC(0xbd05), RC(0xd5a2), RC(0xde01), RC(0xde01), RC(0xdde1), RC(0xd5a1), RC(0xd581), RC(0xcd82), RC(0xcd85), RC(0xbd05), RC(0xc5cb), RC(0xce0f), RC(0xd676), RC(0xce33), RC(0xc613), RC(0x9cd0), RC(0xc611), RC(0x842e), RC(0x736c), RC(0x83ec), RC(0x3986), RC(0x39e7), RC(0x18a2), RC(0x5a8a), RC(0x9430), RC(0x9c51), RC(0xa492), RC(0xa4b2), RC(0x9c92), RC(0x9c71), RC(0xa4b3), RC(0xa4d3), RC(0x9c71), RC(0x9451), RC(0x83cf), RC(0x83cf), RC(0x8c10), RC(0x9471), RC(0x9c92), RC(0x9c92), RC(0x9430), RC(0xfabf),
    RC(0xfabf), RC(0x93ee), RC(0x93ee), RC(0x8bcd), RC(0x5a48), RC(0x20e2), RC(0x528a), RC(0x5268), RC(0x62ca), RC(0x7bcd), RC(0x73ac), RC(0xad51), RC(0x9cd0), RC(0xc615), RC(0xc5f0), RC(0xd651), RC(0xd62d), RC(0xc587), RC(0xd5c3), RC(0xd561), RC(0xd560), RC(0xd580), RC(0xd580), RC(0xd5a0), RC(0xdde0), RC(0xdde0), RC(0xde01), RC(0xe663), RC(0xd607), RC(0xde90), RC(0xde8e), RC(0xce0e), RC(0xad30), RC(0xbd6f), RC(0x9cad), RC(0x946d), RC(0x736b), RC(0x4a48), RC(0x62a8), RC(0x4a48), RC(0x3165), RC(0x5a69), RC(0x9451), RC(0x9430), RC(0x940f), RC(0x9c92), RC(0x9410), RC(0x8c0f), RC(0x9451), RC(0x9c92), RC(0xad14), RC(0x9c72), RC(0x9471), RC(0x9c71), RC(0x9430), RC(0x8bef), RC(0x7b8e), RC(0x83cf), RC(0x9430), RC(0xfabf),
    RC(0xfabf), RC(0x8bad), RC(0x93ee), RC(0x940f), RC(0x6289), RC(0x39a6), RC(0x5aca), RC(0x83ed), RC(0x5289), RC(0x5aaa), RC(0x9cce), RC(0x9caf), RC(0xa510), RC(0xbd6c), RC(0xd66e), RC(0xde4a), RC(0x93e4), RC(0x9c02), RC(0xeea5), RC(0xf74e), RC(0xf772), RC(0xf792), RC(0xf791), RC(0xf770), RC(0xf76f), RC(0xf76e), RC(0xf72e), RC(0xde69), RC(0xa402), RC(0xbce3), RC(0xde8b), RC(0xd60b), RC(0xd62b), RC(0xad2d), RC(0x9c8e), RC(0x946d), RC(0x62ea), RC(0x62ea), RC(0x62ea), RC(0x41c6), RC(0x41e7), RC(0x62eb), RC(0x9451), RC(0x8bce), RC(0x8bce), RC(0x8bef), RC(0x9430), RC(0x83ad), RC(0x838e), RC(0x83ae), RC(0x9430), RC(0xa4b3), RC(0x9430), RC(0x9451), RC(0x9c72), RC(0x9451), RC(0x9451), RC(0x83ae), RC(0x6b0c), RC(0xfabf),
    RC(0xfabf), RC(0x8bce), RC(0x838d), RC(0x7b6c), RC(0x6289), RC(0x6b4c), RC(0x5248), RC(0x41e7), RC(0x5aca), RC(0x62e9), RC(0x8c4e), RC(0xa4ce), RC(0xc567), RC(0xcd85), RC(0xd5e4), RC(0xbcc1), RC(0xa3e1), RC(0x9321), RC(0x9b81), RC(0xac41), RC(0xb481), RC(0xac41), RC(0xb481), RC(0xb440), RC(0xbc80), RC(0xc500), RC(0xcd40), RC(0xc4e0), RC(0xbca1), RC(0xbd01), RC(0xde02), RC(0xde87), RC(0xde87), RC(0xc5a6), RC(0x9c8b), RC(0x7bcb), RC(0x62ea), RC(0x4a27), RC(0x3165), RC(0x5268), RC(0x6b4c), RC(0x736c), RC(0x9c51), RC(0x838d), RC(0x7b4c), RC(0x7b6d), RC(0x838e), RC(0x7b4c), RC(0x7b4c), RC(0x734c), RC(0x7b6d), RC(0x9c71), RC(0x9431), RC(0x8bef), RC(0x9451), RC(0x9471), RC(0x8c10), RC(0x8c10), RC(0x8bf0), RC(0xfabf),
    RC(0xfabf), RC(0x8bae), RC(0x93ee), RC(0x93ee), RC(0x7b4c), RC(0x736d), RC(0x62ca), RC(0x4a69), RC(0x5269), RC(0x7bac), RC(0x9c8c), RC(0xad09), RC(0xcdc5), RC(0xcd82), RC(0xbce1), RC(0xb4c0), RC(0xc541), RC(0xac40), RC(0xc500), RC(0xbcc0), RC(0xc520), RC(0xbcc1), RC(0xc521), RC(0xc4e1), RC(0xc541), RC(0xd5a0), RC(0xd5c0), RC(0xdde1), RC(0xcd60), RC(0xcda2), RC(0xd5c2), RC(0xd5c3), RC(0xd625), RC(0xc585), RC(0x9c26), RC(0x9c67), RC(0x6b0a), RC(0x5ac8), RC(0x4a48), RC(0x5268), RC(0x5aaa), RC(0x8c10), RC(0x7b4c), RC(0x7b6d), RC(0x730b), RC(0x6aaa), RC(0x6aeb), RC(0x6aaa), RC(0x6289), RC(0x6289), RC(0x732b), RC(0x83ae), RC(0x83ae), RC(0x838e), RC(0x83cf), RC(0x8bef), RC(0x8c10), RC(0x8c10), RC(0x8c10), RC(0xfabf),
    RC(0xfabf), RC(0x93ee), RC(0x8bee), RC(0x8bce), RC(0x83ae), RC(0x6b0b), RC(0x39a5), RC(0x5228), RC(0x5289), RC(0x83a8), RC(0x9c46), RC(0xac84), RC(0xbd03), RC(0xbd22), RC(0xb4c2), RC(0xac21), RC(0xc542), RC(0xb4a0), RC(0xb481), RC(0xc501), RC(0xb441), RC(0xbca1), RC(0xc520), RC(0xa3c0), RC(0xcd20), RC(0xc501), RC(0xcd61), RC(0xc4e0), RC(0xbce1), RC(0xc521), RC(0xc521), RC(0xbce2), RC(0xc522), RC(0xb4e3), RC(0xa464), RC(0xa4a7), RC(0x8387), RC(0x73ac), RC(0x41e6), RC(0x3185), RC(0x7bcd), RC(0x9450), RC(0x836d), RC(0x6ac9), RC(0x6289), RC(0x62a9), RC(0x6269), RC(0x5228), RC(0x5208), RC(0x5a48), RC(0x62aa), RC(0x6aeb), RC(0x7b6d), RC(0x8bef), RC(0x8c30), RC(0x8c30), RC(0x83ef), RC(0x83ae), RC(0x7bae), RC(0xfabf),
    RC(0xfabf), RC(0x838d), RC(0x8bad), RC(0x8bce), RC(0x8bef), RC(0x6b2b), RC(0x41c7), RC(0x6b2a), RC(0x62c8), RC(0x8be7), RC(0xa486), RC(0x93a3), RC(0xac82), RC(0xa401), RC(0xac62), RC(0xc502), RC(0x9bc0), RC(0x9ba1), RC(0xb480), RC(0xc502), RC(0xd5e8), RC(0xb442), RC(0xc523), RC(0xb482), RC(0xd5c6), RC(0xd5c5), RC(0xb481), RC(0x9381), RC(0xb4a4), RC(0xc546), RC(0xcd61), RC(0x93a2), RC(0xac41), RC(0xbce2), RC(0x7282), RC(0x6aa3), RC(0x72e4), RC(0x5a85), RC(0x4a48), RC(0x4a27), RC(0x5a69), RC(0x83cf), RC(0x8bef), RC(0x83ae), RC(0x6289), RC(0x5a48), RC(0x6289), RC(0x5a48), RC(0x5a48), RC(0x5227), RC(0x5228), RC(0x5a69), RC(0x62ca), RC(0x734d), RC(0x8bf0), RC(0x9431), RC(0x8c10), RC(0x83cf), RC(0x83cf), RC(0xfabf),
    RC(0xfabf), RC(0x8bce), RC(0x8bad), RC(0x838d), RC(0x8bae), RC(0x5228), RC(0x5a88), RC(0x5aa9), RC(0x6ac5), RC(0x7b45), RC(0x9c02), RC(0x93e4), RC(0xac22), RC(0x7241), RC(0xaca5), RC(0xd5a8), RC(0xd5e9), RC(0xac43), RC(0x9381), RC(0xb480), RC(0xa3e1), RC(0x9322), RC(0xde29), RC(0x9b81), RC(0x9300), RC(0xbca1), RC(0x9341), RC(0xb463), RC(0xde43), RC(0xc505), RC(0xe668), RC(0xbd48), RC(0x6201), RC(0x8b01), RC(0x9be3), RC(0x49a1), RC(0x59c1), RC(0x51c3), RC(0x62a9), RC(0x7bab), RC(0x5aaa), RC(0x838e), RC(0x83ae), RC(0x83ae), RC(0x83ae), RC(0x7b2c), RC(0x5228), RC(0x6289), RC(0x49e7), RC(0x49c6), RC(0x41c6), RC(0x49e7), RC(0x5a49), RC(0x6aeb), RC(0x6b0c), RC(0x7b6d), RC(0x7b8d), RC(0x7b8e), RC(0x7b8e), RC(0xfabf),
    RC(0xfabf), RC(0x8bad), RC(0x8bad), RC(0x8bce), RC(0x8bee), RC(0x6aeb), RC(0x5a47), RC(0x6287), RC(0x5a23), RC(0x6242), RC(0x6241), RC(0x8b02), RC(0x7a80), RC(0x6a41), RC(0xc545), RC(0x9ba0), RC(0xa3c2), RC(0x7200), RC(0x5960), RC(0x5960), RC(0x5960), RC(0x6180), RC(0x6980), RC(0x6180), RC(0x6980), RC(0x69a0), RC(0x6180), RC(0x6160), RC(0x69a0), RC(0x7200), RC(0x7a81), RC(0x82e1), RC(0x61c1), RC(0x82a1), RC(0xc543), RC(0xa443), RC(0x51c1), RC(0x41a3), RC(0x5a68), RC(0x6b4c), RC(0x4a69), RC(0x7b8e), RC(0xa4d2), RC(0x9410), RC(0x83ae), RC(0x838e), RC(0x730c), RC(0x5a28), RC(0x6269), RC(0x5207), RC(0x41a6), RC(0x49c7), RC(0x5228), RC(0x62ca), RC(0x734d), RC(0x7b8e), RC(0x7bae), RC(0x7bae), RC(0x7b6d), RC(0xfabf),
    RC(0xfabf), RC(0x838d), RC(0x838d), RC(0x838d), RC(0x8bae), RC(0x6aca), RC(0x8c2d), RC(0x5a04), RC(0x61e1), RC(0x7b24), RC(0xd5c2), RC(0x9382), RC(0x5140), RC(0x4920), RC(0x5140), RC(0x5960), RC(0x6180), RC(0x6980), RC(0x71a0), RC(0x79c0), RC(0x71a0), RC(0x79a0), RC(0x71a0), RC(0x79a0), RC(0x6980), RC(0x6980), RC(0x71a0), RC(0x71a0), RC(0x71a0), RC(0x69a0), RC(0x6180), RC(0x6180), RC(0x6180), RC(0x5140), RC(0x5960), RC(0x7aa0), RC(0xb525), RC(0xa444), RC(0x5a25), RC(0x840e), RC(0x4208), RC(0x9c91), RC(0xb534), RC(0xad13), RC(0x9c71), RC(0x8c10), RC(0x8bf0), RC(0x7b6d), RC(0x5a48), RC(0x5228), RC(0x5207), RC(0x41a6), RC(0x39a6), RC(0x5248), RC(0x62aa), RC(0x732c), RC(0x732c), RC(0x734c), RC(0x7b6e), RC(0xfabf),
    RC(0xfabf), RC(0x838d), RC(0x83ae), RC(0x8bce), RC(0x8bae), RC(0x730b), RC(0x8bed), RC(0x8302), RC(0x5aa6), RC(0x7b23), RC(0x5980), RC(0x4120), RC(0x5140), RC(0x6160), RC(0x6980), RC(0x5960), RC(0x4900), RC(0x40e0), RC(0x38c0), RC(0x38c0), RC(0x30c0), RC(0x30c0), RC(0x38c0), RC(0x38e0), RC(0x38e0), RC(0x30c0), RC(0x30c0), RC(0x28a0), RC(0x28a0), RC(0x28a0), RC(0x30c0), RC(0x4101), RC(0x5140), RC(0x5960), RC(0x5160), RC(0x4920), RC(0x4920), RC(0x6a82), RC(0x5224), RC(0x8c0c), RC(0x5266), RC(0x6b0a), RC(0x8bce), RC(0xad13), RC(0xbdb6), RC(0xc5b6), RC(0xbd96), RC(0xa4d3), RC(0x8bef), RC(0x6acb), RC(0x5a48), RC(0x5227), RC(0x4a07), RC(0x49e7), RC(0x5248), RC(0x62cb), RC(0x732c), RC(0x7b6d), RC(0x7b8e), RC(0xfabf),
    RC(0xfabf), RC(0x838d), RC(0x8bce), RC(0x8bce), RC(0x8bae), RC(0x7b4c), RC(0x8c0c), RC(0x7306), RC(0x3922), RC(0x4100), RC(0x5140), RC(0x5960), RC(0x4900), RC(0x30c0), RC(0x28c0), RC(0x28a0), RC(0x28a0), RC(0x28a0), RC(0x28a0), RC(0x3900), RC(0x4120), RC(0x30c0), RC(0x6a20), RC(0x7a80), RC(0x69e0), RC(0x59a0), RC(0x6a00), RC(0x30e0), RC(0x20a0), RC(0x20a0), RC(0x20a0), RC(0x28c0), RC(0x28c1), RC(0x20c1), RC(0x28c0), RC(0x3901), RC(0x4920), RC(0x4162), RC(0x6265), RC(0x6b26), RC(0x5267), RC(0x8c0f), RC(0xacf2), RC(0x942f), RC(0x83ce), RC(0x9471), RC(0xad34), RC(0xc5b6), RC(0xbd96), RC(0xacf3), RC(0x736d), RC(0x5a48), RC(0x7b4c), RC(0x7b4c), RC(0x6aeb), RC(0x62ca), RC(0x6b0b), RC(0x732c), RC(0x734d), RC(0xfabf),
    RC(0xfabf), RC(0x7b4c), RC(0x836c), RC(0x838d), RC(0x8bae), RC(0x8bae), RC(0xa48b), RC(0x49e5), RC(0x4101), RC(0x5140), RC(0x3900), RC(0x28a0), RC(0x2080), RC(0x2080), RC(0x20a0), RC(0x28c0), RC(0x30c0), RC(0x4100), RC(0x5120), RC(0x6160), RC(0x6160), RC(0x6160), RC(0x71a0), RC(0x71a0), RC(0x6980), RC(0x5960), RC(0x5940), RC(0x5120), RC(0x4100), RC(0x38e0), RC(0x28c0), RC(0x28e0), RC(0x20c1), RC(0x20c0), RC(0x20a0), RC(0x20a0), RC(0x30e0), RC(0x49a3), RC(0x4163), RC(0x4184), RC(0x4206), RC(0x62a8), RC(0xa491), RC(0xb554), RC(0xc5b6), RC(0xc5b6), RC(0xad34), RC(0x9451), RC(0x9450), RC(0x9450), RC(0xa491), RC(0x5a89), RC(0x5aa9), RC(0x730b), RC(0x8bee), RC(0x940f), RC(0x83ce), RC(0x734d), RC(0x6b0c), RC(0xfabf),
    RC(0xfabf), RC(0x93ef), RC(0x8bae), RC(0x7b6d), RC(0x7b6d), RC(0x838d), RC(0x83ca), RC(0x4142), RC(0x4940), RC(0x30c0), RC(0x28c0), RC(0x2080), RC(0x20a0), RC(0x28a0), RC(0x30e0), RC(0x4920), RC(0x5940), RC(0x6180), RC(0x6980), RC(0x69a0), RC(0x71a0), RC(0x79c0), RC(0x79c0), RC(0x79e0), RC(0x79c0), RC(0x71a0), RC(0x6980), RC(0x6180), RC(0x6160), RC(0x6160), RC(0x5120), RC(0x4900), RC(0x30e0), RC(0x28c0), RC(0x20c0), RC(0x20a0), RC(0x20a1), RC(0x41e6), RC(0x3922), RC(0x41a4), RC(0x6b0a), RC(0x62c9), RC(0x62aa), RC(0x62aa), RC(0x7b6d), RC(0x9471), RC(0xb534), RC(0xbd95), RC(0xb513), RC(0x9430), RC(0x7b6c), RC(0x6aea), RC(0x62ca), RC(0x4a28), RC(0x18c2), RC(0x39a6), RC(0x730b), RC(0x8bae), RC(0x838d), RC(0xfabf),
    RC(0xfabf), RC(0x8bce), RC(0x8bee), RC(0x942f), RC(0x940f), RC(0x8bce), RC(0x7309), RC(0x4962), RC(0x30e0), RC(0x20a0), RC(0x28a0), RC(0x28a0), RC(0x30a0), RC(0x4900), RC(0x5940), RC(0x6160), RC(0x6980), RC(0x71a0), RC(0x79c0), RC(0x8200), RC(0x9240), RC(0x9261), RC(0x9a60), RC(0x9a60), RC(0x9a60), RC(0x9240), RC(0x8a00), RC(0x79e0), RC(0x71c0), RC(0x69a0), RC(0x6160), RC(0x5940), RC(0x5120), RC(0x40e0), RC(0x28c0), RC(0x20a0), RC(0x28c0), RC(0x4207), RC(0x2943), RC(0x4984), RC(0x940f), RC(0xa4b2), RC(0xacd2), RC(0x9c91), RC(0x8bef), RC(0x83ae), RC(0x730c), RC(0x6b0c), RC(0x7b6c), RC(0x7b4c), RC(0x7b4c), RC(0x8c0f), RC(0x8c0f), RC(0x5a89), RC(0x62a9), RC(0x49e7), RC(0x18c2), RC(0x20e3), RC(0x41e7), RC(0xfabf),
    RC(0xfabf), RC(0x62cb), RC(0x8bcf), RC(0x93ef), RC(0x93ef), RC(0x940f), RC(0x730a), RC(0x3921), RC(0x28c1), RC(0x30e0), RC(0x30c0), RC(0x28a0), RC(0x4100), RC(0x5920), RC(0x5940), RC(0x6980), RC(0x79e0), RC(0x8a40), RC(0x9a60), RC(0x9a80), RC(0xa2a0), RC(0xa2c0), RC(0xaae1), RC(0xaac1), RC(0xa2c0), RC(0xa2a1), RC(0x9a60), RC(0x8a20), RC(0x8a00), RC(0x81e0), RC(0x71a0), RC(0x6980), RC(0x5940), RC(0x4900), RC(0x38e0), RC(0x28c0), RC(0x28c1), RC(0x4a07), RC(0x5227), RC(0x49e6), RC(0x9c91), RC(0xa4b1), RC(0xa491), RC(0xa471), RC(0xa4b2), RC(0xa4b2), RC(0x9c71), RC(0x8c10), RC(0x7b6d), RC(0x5207), RC(0x732b), RC(0x9c91), RC(0xb575), RC(0x8c0f), RC(0x6aea), RC(0x8bee), RC(0x83ae), RC(0x62ca), RC(0x3985), RC(0xfabf),
    RC(0xfabf), RC(0x2903), RC(0x18a2), RC(0x39c7), RC(0x6b0c), RC(0x9410), RC(0x6aca), RC(0x20a1), RC(0x30e0), RC(0x30c0), RC(0x28a0), RC(0x40e0), RC(0x5100), RC(0x5940), RC(0x6980), RC(0x81e0), RC(0x8a20), RC(0x9260), RC(0x9a80), RC(0xa2c1), RC(0x9aa1), RC(0x8a60), RC(0x8a40), RC(0x8241), RC(0x7a20), RC(0x71e1), RC(0x69c0), RC(0x69c0), RC(0x71e0), RC(0x79e0), RC(0x79e0), RC(0x71c0), RC(0x6180), RC(0x5960), RC(0x4900), RC(0x30c0), RC(0x28e2), RC(0x4a07), RC(0x41c5), RC(0x49c6), RC(0xa492), RC(0xa492), RC(0x9c71), RC(0x9c71), RC(0xa491), RC(0xa491), RC(0x9c70), RC(0x9c71), RC(0x9c50), RC(0x6aca), RC(0x6aea), RC(0x8c2f), RC(0xb555), RC(0xa4d2), RC(0x62ca), RC(0x8bce), RC(0x8bae), RC(0x83ae), RC(0x83ae), RC(0xfabf),
    RC(0xfabf), RC(0x836c), RC(0x730b), RC(0x5227), RC(0x2903), RC(0x18a2), RC(0x3965), RC(0x3101), RC(0x28c0), RC(0x28c0), RC(0x30c0), RC(0x4900), RC(0x5120), RC(0x6960), RC(0x71c0), RC(0x79e0), RC(0x8a21), RC(0x8221), RC(0x61c1), RC(0x4960), RC(0x5981), RC(0x7201), RC(0x92a1), RC(0x9280), RC(0x92a1), RC(0x9280), RC(0x8a40), RC(0x7201), RC(0x69e1), RC(0x59c0), RC(0x4981), RC(0x4981), RC(0x5140), RC(0x5140), RC(0x5120), RC(0x38e0), RC(0x3102), RC(0x41e6), RC(0x3144), RC(0x49c5), RC(0xa492), RC(0x9c71), RC(0x9c71), RC(0x9c71), RC(0x9c51), RC(0x9c30), RC(0x9c71), RC(0x9c70), RC(0x9c2f), RC(0x836c), RC(0x6289), RC(0x942f), RC(0xbd95), RC(0xb534), RC(0x734d), RC(0x838d), RC(0x8bce), RC(0x838d), RC(0x838d), RC(0xfabf),
    RC(0xfabf), RC(0x838d), RC(0x838d), RC(0x838d), RC(0x836c), RC(0x730b), RC(0x5a27), RC(0x3921), RC(0x28c0), RC(0x30c0), RC(0x4100), RC(0x4900), RC(0x5940), RC(0x6980), RC(0x71c0), RC(0x69c1), RC(0x4960), RC(0x5160), RC(0x8220), RC(0xab00), RC(0xbb80), RC(0xc3a1), RC(0xc3a1), RC(0xc3a1), RC(0xc380), RC(0xbb41), RC(0xb300), RC(0xaac1), RC(0xa2c0), RC(0x9a80), RC(0x8a40), RC(0x7a00), RC(0x5161), RC(0x3900), RC(0x30e0), RC(0x38e0), RC(0x3901), RC(0x3984), RC(0x3123), RC(0x4184), RC(0xa471), RC(0xa492), RC(0xa492), RC(0xa4b2), RC(0x9c71), RC(0x9451), RC(0x9451), RC(0x9410), RC(0x9410), RC(0x942f), RC(0x5a48), RC(0x8bee), RC(0xbd95), RC(0xb554), RC(0x83ae), RC(0x7b4c), RC(0x8bce), RC(0x83ae), RC(0x838d), RC(0xfabf),
    RC(0xfabf), RC(0x838d), RC(0x8bce), RC(0x8bce), RC(0x8bad), RC(0x8bae), RC(0x7b2b), RC(0x3921), RC(0x30c0), RC(0x30e0), RC(0x4900), RC(0x5100), RC(0x6160), RC(0x6980), RC(0x4940), RC(0x4140), RC(0x7a21), RC(0xab20), RC(0xbb80), RC(0xc3a1), RC(0xc3c1), RC(0xc3c1), RC(0xcbe1), RC(0xcc01), RC(0xcc01), RC(0xc3c1), RC(0xbb60), RC(0xb321), RC(0xab01), RC(0xa2c0), RC(0x9aa0), RC(0x8a40), RC(0x79e0), RC(0x6180), RC(0x4920), RC(0x28e0), RC(0x3101), RC(0x3943), RC(0x3143), RC(0x4184), RC(0x9430), RC(0x9c50), RC(0x9c71), RC(0x9c91), RC(0xa492), RC(0x9c71), RC(0x9451), RC(0x9450), RC(0x9430), RC(0x9410), RC(0x5a69), RC(0x838d), RC(0xb575), RC(0xb575), RC(0x83ae), RC(0x6b0b), RC(0x8bce), RC(0x8bad), RC(0x838d), RC(0xfabf),
    RC(0xfabf), RC(0x838d), RC(0x836d), RC(0x8bae), RC(0x93ef), RC(0x9c30), RC(0x834b), RC(0x3921), RC(0x30c0), RC(0x40e0), RC(0x4900), RC(0x5120), RC(0x6160), RC(0x4100), RC(0x5160), RC(0x9280), RC(0xab00), RC(0xb341), RC(0xbb81), RC(0xcc01), RC(0xd481), RC(0xdca1), RC(0xdc80), RC(0xd480), RC(0xd420), RC(0xcbe1), RC(0xc3a1), RC(0xbb60), RC(0xb320), RC(0xaae1), RC(0xa2c1), RC(0x9260), RC(0x8200), RC(0x71a0), RC(0x5960), RC(0x4920), RC(0x30e1), RC(0x3901), RC(0x3102), RC(0x3963), RC(0x9c72), RC(0x9c72), RC(0x9c71), RC(0x9451), RC(0x9430), RC(0x9c50), RC(0x9430), RC(0x9c51), RC(0x9430), RC(0x8bef), RC(0x6aca), RC(0x732b), RC(0xb554), RC(0xb555), RC(0x838d), RC(0x6aeb), RC(0x8bce), RC(0x838d), RC(0x838d), RC(0xfabf),
    RC(0xfabf), RC(0x83ad), RC(0x8bae), RC(0x8bae), RC(0x8bce), RC(0x8bce), RC(0x834b), RC(0x3901), RC(0x38c0), RC(0x40e0), RC(0x4900), RC(0x5920), RC(0x4100), RC(0x5140), RC(0x9280), RC(0xa2c1), RC(0xaae0), RC(0xb321), RC(0xbb81), RC(0xc3e1), RC(0xcc01), RC(0xcc01), RC(0xcc01), RC(0xd401), RC(0xcbe1), RC(0xcbc0), RC(0xcbc1), RC(0xc381), RC(0xbb40), RC(0xb301), RC(0xa2c0), RC(0x9a80), RC(0x8200), RC(0x71a0), RC(0x6140), RC(0x5120), RC(0x4100), RC(0x30c1), RC(0x30e1), RC(0x3943), RC(0x9451), RC(0xa4d3), RC(0xa4d3), RC(0x9c92), RC(0x9430), RC(0x8c0f), RC(0x8bef), RC(0x940f), RC(0x93ef), RC(0x93ef), RC(0x732c), RC(0x62ca), RC(0xad13), RC(0xad34), RC(0x7b6d), RC(0x5a89), RC(0x7b6d), RC(0x838d), RC(0x83ad), RC(0xfabf),
    RC(0xfabf), RC(0x83ad), RC(0x8bae), RC(0x8bce), RC(0x8bae), RC(0x8bae), RC(0x7b0a), RC(0x3901), RC(0x40e0), RC(0x40e0), RC(0x5100), RC(0x5100), RC(0x38e0), RC(0x8200), RC(0x9260), RC(0x9aa0), RC(0xa2e0), RC(0xb341), RC(0xbb80), RC(0xc3a1), RC(0xcbe1), RC(0xcc01), RC(0xcc21), RC(0xd421), RC(0xd441), RC(0xd421), RC(0xcbe1), RC(0xc381), RC(0xbb41), RC(0xaac0), RC(0xaae1), RC(0x9a80), RC(0x8200), RC(0x71a0), RC(0x6160), RC(0x5120), RC(0x4100), RC(0x38e0), RC(0x28e1), RC(0x3943), RC(0x8bce), RC(0x9430), RC(0x9c92), RC(0xa4b2), RC(0xa4d3), RC(0x9c92), RC(0x9430), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x7b4c), RC(0x6289), RC(0xa4b2), RC(0xacf3), RC(0x7b6d), RC(0x5269), RC(0x7b6d), RC(0x7b6d), RC(0x734c), RC(0xfabf),
    RC(0xfabf), RC(0x8bcf), RC(0x8bce), RC(0x8bce), RC(0x8bce), RC(0x8bcf), RC(0x7b0a), RC(0x3901), RC(0x38e0), RC(0x40e0), RC(0x5100), RC(0x30c0), RC(0x6980), RC(0x81e0), RC(0x8a40), RC(0x9aa0), RC(0xab01), RC(0xb341), RC(0xbb81), RC(0xc3c1), RC(0xcbe1), RC(0xcc01), RC(0xd441), RC(0xd461), RC(0xd461), RC(0xcbe1), RC(0xcbc0), RC(0xc381), RC(0xbb41), RC(0xb2e1), RC(0xa2c1), RC(0x9a80), RC(0x8220), RC(0x71c0), RC(0x6160), RC(0x5920), RC(0x4900), RC(0x4100), RC(0x30e1), RC(0x3922), RC(0x83ae), RC(0x9430), RC(0x9430), RC(0x9430), RC(0x9471), RC(0x9c71), RC(0x9c71), RC(0x9c92), RC(0x9c71), RC(0x9430), RC(0x7b8d), RC(0x5227), RC(0x9450), RC(0x9c91), RC(0x734c), RC(0x5248), RC(0x7b6d), RC(0x7b4d), RC(0x7b4c), RC(0xfabf),
    RC(0xfabf), RC(0x9410), RC(0x9410), RC(0x9410), RC(0x93ef), RC(0x93ef), RC(0x7b0a), RC(0x4101), RC(0x40e0), RC(0x48e0), RC(0x38e0), RC(0x5120), RC(0x71a0), RC(0x79c0), RC(0x8a40), RC(0x9aa0), RC(0xab01), RC(0xb361), RC(0xbb81), RC(0xc3c1), RC(0xcc00), RC(0xd461), RC(0xdca1), RC(0xd481), RC(0xd441), RC(0xcbe1), RC(0xcbc1), RC(0xc3a1), RC(0xbb61), RC(0xb301), RC(0xa2c1), RC(0x9a81), RC(0x8a20), RC(0x79c0), RC(0x6160), RC(0x5120), RC(0x4900), RC(0x4100), RC(0x30e0), RC(0x4122), RC(0x838d), RC(0x9410), RC(0x9430), RC(0x9430), RC(0x9430), RC(0x8c10), RC(0x8c10), RC(0x8c10), RC(0x9430), RC(0x9450), RC(0x8bef), RC(0x49e6), RC(0x8bef), RC(0x940f), RC(0x730c), RC(0x4a07), RC(0x7b6d), RC(0x7b6d), RC(0x7b4c), RC(0xfabf),
    RC(0xfabf), RC(0x9410), RC(0x9430), RC(0x9430), RC(0x9430), RC(0x9c30), RC(0x7b2a), RC(0x5921), RC(0x4100), RC(0x4900), RC(0x30c0), RC(0x6960), RC(0x6980), RC(0x79e0), RC(0x8a20), RC(0x9aa0), RC(0xab00), RC(0xb341), RC(0xbb80), RC(0xcbe1), RC(0xd461), RC(0xd480), RC(0xdc81), RC(0xd461), RC(0xd441), RC(0xd420), RC(0xcbe0), RC(0xc3c1), RC(0xbb61), RC(0xb321), RC(0xaac0), RC(0x9a80), RC(0x8a20), RC(0x79c0), RC(0x6160), RC(0x5120), RC(0x4100), RC(0x38e0), RC(0x30e0), RC(0x4121), RC(0x836d), RC(0x9410), RC(0x940f), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8c0f), RC(0x83ae), RC(0x41c6), RC(0x7b8d), RC(0x83ae), RC(0x6b0c), RC(0x4a07), RC(0x730c), RC(0x732c), RC(0x732c), RC(0xfabf),
    RC(0xfabf), RC(0x9410), RC(0x9430), RC(0x9430), RC(0x9430), RC(0x9c51), RC(0x832a), RC(0x4901), RC(0x40e0), RC(0x48e0), RC(0x40e0), RC(0x6160), RC(0x6980), RC(0x79c0), RC(0x8a20), RC(0x9a60), RC(0xa2c0), RC(0xb340), RC(0xc3a0), RC(0xcc01), RC(0xcc20), RC(0xd440), RC(0xd461), RC(0xd461), RC(0xd441), RC(0xd421), RC(0xcc01), RC(0xc3c1), RC(0xbb60), RC(0xb320), RC(0xaac0), RC(0x9a60), RC(0x8a20), RC(0x79c0), RC(0x6160), RC(0x5120), RC(0x40e0), RC(0x38e0), RC(0x30e0), RC(0x3921), RC(0x7b4c), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8bcf), RC(0x8bef), RC(0x83ce), RC(0x83ae), RC(0x83ae), RC(0x8bef), RC(0x83cf), RC(0x41a6), RC(0x730b), RC(0x7b4c), RC(0x62eb), RC(0x4a07), RC(0x7b8d), RC(0x7b4c), RC(0x730b), RC(0xfabf),
    RC(0xfabf), RC(0x9430), RC(0x9430), RC(0x9c51), RC(0x9c51), RC(0x9c51), RC(0x832b), RC(0x4100), RC(0x40e0), RC(0x38e0), RC(0x4900), RC(0x6140), RC(0x6960), RC(0x71a0), RC(0x8a00), RC(0x9260), RC(0xa2c0), RC(0xb320), RC(0xc3c0), RC(0xcc01), RC(0xd420), RC(0xd441), RC(0xd461), RC(0xd481), RC(0xdc81), RC(0xd441), RC(0xcc00), RC(0xcbc0), RC(0xc381), RC(0xb320), RC(0xaac0), RC(0x9a80), RC(0x8a20), RC(0x79a0), RC(0x6160), RC(0x5120), RC(0x40e0), RC(0x40e0), RC(0x30e0), RC(0x3901), RC(0x7b2b), RC(0x9c50), RC(0x9451), RC(0x8c10), RC(0x83cf), RC(0x83ae), RC(0x83ce), RC(0x83ce), RC(0x83ae), RC(0x83ae), RC(0x7b6d), RC(0x41a6), RC(0x6289), RC(0x6aaa), RC(0x5aaa), RC(0x49e7), RC(0x732c), RC(0x732c), RC(0x7b4c), RC(0xfabf),
    RC(0xfabf), RC(0x9c30), RC(0x9c50), RC(0x9c50), RC(0x9c71), RC(0x9c51), RC(0x7b0a), RC(0x4100), RC(0x48e0), RC(0x38e0), RC(0x5920), RC(0x6140), RC(0x6960), RC(0x71a0), RC(0x8200), RC(0x9260), RC(0xa2c0), RC(0xb320), RC(0xc3a1), RC(0xcbe1), RC(0xd441), RC(0xd460), RC(0xd461), RC(0xdc81), RC(0xd461), RC(0xd400), RC(0xcbe0), RC(0xc3a0), RC(0xbb40), RC(0xb300), RC(0xa2a0), RC(0x9a60), RC(0x8a20), RC(0x71a0), RC(0x6160), RC(0x5120), RC(0x4900), RC(0x40e0), RC(0x38e0), RC(0x3101), RC(0x732b), RC(0x9430), RC(0x940f), RC(0x8c0f), RC(0x9430), RC(0x9410), RC(0x8bcf), RC(0x838e), RC(0x838e), RC(0x7b8d), RC(0x732c), RC(0x41a6), RC(0x5a28), RC(0x5a48), RC(0x5a69), RC(0x49e7), RC(0x7b4d), RC(0x6b0c), RC(0x6aeb), RC(0xfabf),
    RC(0xfabf), RC(0x9c30), RC(0x9c70), RC(0xa471), RC(0x9c71), RC(0x9c71), RC(0x7b2a), RC(0x5140), RC(0x4100), RC(0x38c0), RC(0x5920), RC(0x5920), RC(0x6140), RC(0x7180), RC(0x81e0), RC(0x9240), RC(0xa2c0), RC(0xb320), RC(0xbb80), RC(0xcbe1), RC(0xd421), RC(0xd440), RC(0xd440), RC(0xd461), RC(0xd460), RC(0xd420), RC(0xcbc0), RC(0xc380), RC(0xbb40), RC(0xb2e0), RC(0xa2a0), RC(0x9a40), RC(0x8200), RC(0x71a0), RC(0x6140), RC(0x5100), RC(0x48e0), RC(0x40e0), RC(0x38c0), RC(0x3901), RC(0x3964), RC(0x3165), RC(0x62ca), RC(0x8bef), RC(0x8bef), RC(0x8bce), RC(0x8bef), RC(0x8c0f), RC(0x8bcf), RC(0x83ae), RC(0x732c), RC(0x41a6), RC(0x5207), RC(0x49e6), RC(0x5248), RC(0x49e7), RC(0x7b6d), RC(0x7b4d), RC(0x7b4d), RC(0xfabf),
    RC(0xfabf), RC(0xa491), RC(0xa491), RC(0xa471), RC(0xa471), RC(0xa491), RC(0x8349), RC(0x4920), RC(0x40e0), RC(0x38c0), RC(0x5920), RC(0x5920), RC(0x6140), RC(0x7180), RC(0x81e0), RC(0x9240), RC(0xa2c0), RC(0xb320), RC(0xc380), RC(0xc3c0), RC(0xcc01), RC(0xd420), RC(0xd440), RC(0xd440), RC(0xd420), RC(0xcc00), RC(0xcbc0), RC(0xc360), RC(0xbb20), RC(0xb2e0), RC(0xa280), RC(0x9240), RC(0x81e0), RC(0x71a0), RC(0x6140), RC(0x5100), RC(0x40e0), RC(0x38e0), RC(0x30c0), RC(0x38e0), RC(0x72c9), RC(0x7b8e), RC(0x4a48), RC(0x2104), RC(0x2945), RC(0x5a8a), RC(0x7b8e), RC(0x8bce), RC(0x83ae), RC(0x8bcf), RC(0x732c), RC(0x3986), RC(0x49c6), RC(0x41a6), RC(0x5248), RC(0x49e7), RC(0x732c), RC(0x7b4d), RC(0x732c), RC(0xfabf),
    RC(0xfabf), RC(0xa4b1), RC(0xa4b2), RC(0xacb2), RC(0xacb2), RC(0xa492), RC(0x7b2a), RC(0x3900), RC(0x40e0), RC(0x40e0), RC(0x5920), RC(0x5920), RC(0x6140), RC(0x6980), RC(0x81c0), RC(0x9220), RC(0xa280), RC(0xb300), RC(0xbb40), RC(0xc380), RC(0xc3c0), RC(0xcbe0), RC(0xcbe0), RC(0xcbe0), RC(0xcc00), RC(0xcbe0), RC(0xcba0), RC(0xbb60), RC(0xb320), RC(0xaac0), RC(0xa280), RC(0x9240), RC(0x81e0), RC(0x71a0), RC(0x6140), RC(0x5100), RC(0x48e0), RC(0x40e0), RC(0x38c0), RC(0x30e0), RC(0x6aa9), RC(0x9c92), RC(0xa492), RC(0x9c71), RC(0x7bae), RC(0x4a08), RC(0x2104), RC(0x2924), RC(0x5228), RC(0x730c), RC(0x62aa), RC(0x39a6), RC(0x49a6), RC(0x3986), RC(0x5a49), RC(0x4a07), RC(0x62aa), RC(0x6aeb), RC(0x730c), RC(0xfabf),
    RC(0xfabf), RC(0xa491), RC(0xacb2), RC(0xacf2), RC(0xacf2), RC(0xacd3), RC(0x7b0a), RC(0x3900), RC(0x40e0), RC(0x4900), RC(0x5100), RC(0x5920), RC(0x6140), RC(0x6980), RC(0x79c0), RC(0x8a00), RC(0x9a60), RC(0xa2a0), RC(0xaac0), RC(0xab00), RC(0xb320), RC(0xbb40), RC(0xbb60), RC(0xbb60), RC(0xc380), RC(0xc360), RC(0xb320), RC(0xb2e0), RC(0xaac0), RC(0x9a60), RC(0x9240), RC(0x89e0), RC(0x79c0), RC(0x7180), RC(0x6140), RC(0x5100), RC(0x48e0), RC(0x40e0), RC(0x40e0), RC(0x30c0), RC(0x5a68), RC(0xa4b3), RC(0xa4b3), RC(0xa4b3), RC(0x9c92), RC(0x9c92), RC(0x9451), RC(0x7b8e), RC(0x5249), RC(0x2124), RC(0x2944), RC(0x41a6), RC(0x41a6), RC(0x39a6), RC(0x5228), RC(0x5a69), RC(0x7b4c), RC(0x6b0b), RC(0x62aa), RC(0xfabf),
    RC(0xfabf), RC(0xa471), RC(0xacb1), RC(0xacd2), RC(0xacd2), RC(0xacf3), RC(0x72e9), RC(0x4100), RC(0x5100), RC(0x5100), RC(0x5100), RC(0x5920), RC(0x5940), RC(0x6960), RC(0x79a0), RC(0x81e0), RC(0x8a00), RC(0x9240), RC(0x8a21), RC(0x8221), RC(0x7201), RC(0x69e1), RC(0x61e1), RC(0x61e1), RC(0x69e1), RC(0x69e1), RC(0x6a01), RC(0x7201), RC(0x7a01), RC(0x81e0), RC(0x81e0), RC(0x79a0), RC(0x7180), RC(0x6960), RC(0x5920), RC(0x5100), RC(0x48e0), RC(0x40e0), RC(0x38c0), RC(0x30e0), RC(0x5a47), RC(0xad14), RC(0xa4d3), RC(0xa4b3), RC(0x9cb3), RC(0x9c92), RC(0x9c72), RC(0x9c72), RC(0x9c71), RC(0x9451), RC(0x5269), RC(0x41a6), RC(0x41a6), RC(0x41e7), RC(0x49e7), RC(0x5a69), RC(0x730c), RC(0x730b), RC(0x6aeb), RC(0xfabf),
    RC(0xfabf), RC(0x8bcf), RC(0x9c71), RC(0xa4b1), RC(0xacd2), RC(0xacd2), RC(0x6a88), RC(0x48e0), RC(0x40e0), RC(0x4900), RC(0x5100), RC(0x5120), RC(0x6140), RC(0x6960), RC(0x6980), RC(0x69a1), RC(0x59a1), RC(0x4981), RC(0x4162), RC(0x4163), RC(0x4183), RC(0x4183), RC(0x4183), RC(0x4183), RC(0x4183), RC(0x4183), RC(0x4183), RC(0x4183), RC(0x49a3), RC(0x49a3), RC(0x51c3), RC(0x51a2), RC(0x5141), RC(0x4900), RC(0x5100), RC(0x48e0), RC(0x40e0), RC(0x40e0), RC(0x40e0), RC(0x38e0), RC(0x59e5), RC(0xb514), RC(0xb555), RC(0xa4d3), RC(0x9cb3), RC(0x9c92), RC(0x9c92), RC(0x9c72), RC(0x9472), RC(0x9451), RC(0x4a07), RC(0x41a6), RC(0x41a6), RC(0x41c7), RC(0x41a6), RC(0x2103), RC(0x2103), RC(0x41e7), RC(0x5a8a), RC(0xfabf),
    RC(0xfabf), RC(0x1082), RC(0x20e3), RC(0x4a28), RC(0x7b6d), RC(0x9c71), RC(0x6a88), RC(0x5100), RC(0x40e0), RC(0x5100), RC(0x5120), RC(0x5100), RC(0x5920), RC(0x4941), RC(0x4162), RC(0x3963), RC(0x3963), RC(0x3964), RC(0x3964), RC(0x4184), RC(0x4184), RC(0x4185), RC(0x4185), RC(0x4184), RC(0x4184), RC(0x41a4), RC(0x41a4), RC(0x4184), RC(0x4184), RC(0x4184), RC(0x4184), RC(0x4184), RC(0x4183), RC(0x4163), RC(0x3922), RC(0x30c0), RC(0x38c0), RC(0x40e0), RC(0x40e0), RC(0x40e0), RC(0x59a4), RC(0xa492), RC(0xa4b3), RC(0xa4b2), RC(0x9c92), RC(0xa4b3), RC(0xa4b3), RC(0x9c93), RC(0x9472), RC(0x8c10), RC(0x3985), RC(0x3985), RC(0x3986), RC(0x5249), RC(0x4a07), RC(0x8bef), RC(0x7b8e), RC(0x5249), RC(0x2904), RC(0xfabf),
    RC(0xfabf), RC(0x7b4d), RC(0x5228), RC(0x2924), RC(0x18a2), RC(0x20e3), RC(0x61c4), RC(0x6920), RC(0x40e0), RC(0x5100), RC(0x5120), RC(0x4921), RC(0x3942), RC(0x3943), RC(0x3964), RC(0x3964), RC(0x3984), RC(0x3985), RC(0x41a5), RC(0x41a5), RC(0x41c6), RC(0x41c5), RC(0x41c5), RC(0x41a5), RC(0x41c5), RC(0x41a5), RC(0x41c6), RC(0x41e6), RC(0x41c6), RC(0x41c6), RC(0x41a5), RC(0x41a5), RC(0x4184), RC(0x3964), RC(0x3964), RC(0x3963), RC(0x28e2), RC(0x30c0), RC(0x38e0), RC(0x40e0), RC(0x59a3), RC(0x9c51), RC(0x9c72), RC(0x9c71), RC(0x9c92), RC(0x9c92), RC(0xa4b3), RC(0xa4d3), RC(0x9c92), RC(0x6b4d), RC(0x31a6), RC(0x31a6), RC(0x3165), RC(0x5a69), RC(0x5a69), RC(0x7b8e), RC(0x83cf), RC(0x83ce), RC(0x838e), RC(0xfabf),
    RC(0xfabf), RC(0x93ef), RC(0x940f), RC(0x93ce), RC(0x836d), RC(0x5a69), RC(0x69c4), RC(0x5100), RC(0x40e0), RC(0x4900), RC(0x4121), RC(0x3943), RC(0x3943), RC(0x3964), RC(0x3965), RC(0x3985), RC(0x41c6), RC(0x41c5), RC(0x3985), RC(0x49c5), RC(0x5247), RC(0x5a68), RC(0x5a68), RC(0x6287), RC(0x5206), RC(0x41a4), RC(0x3984), RC(0x41a4), RC(0x41a4), RC(0x41c5), RC(0x41c6), RC(0x41e6), RC(0x41c5), RC(0x39a5), RC(0x3985), RC(0x3985), RC(0x39a5), RC(0x3122), RC(0x38e0), RC(0x40e0), RC(0x4183), RC(0x62eb), RC(0xb555), RC(0xad54), RC(0xa4f3), RC(0xad55), RC(0xa534), RC(0x9cf3), RC(0x7bef), RC(0x5269), RC(0x41c6), RC(0x39a6), RC(0x5269), RC(0x5a48), RC(0x736d), RC(0x734d), RC(0x6aec), RC(0x6aeb), RC(0x730c), RC(0xfabf),
    RC(0xfabf), RC(0x940f), RC(0x940f), RC(0x940f), RC(0x9430), RC(0x9c30), RC(0x82c7), RC(0x4901), RC(0x38e0), RC(0x4142), RC(0x3943), RC(0x3964), RC(0x3985), RC(0x41a5), RC(0x39c6), RC(0x41a5), RC(0x5227), RC(0x5228), RC(0x5269), RC(0x5269), RC(0x5249), RC(0x41e7), RC(0x41e7), RC(0x4207), RC(0x41e7), RC(0x4207), RC(0x4a28), RC(0x4a69), RC(0x62eb), RC(0x4a28), RC(0x41c6), RC(0x41a5), RC(0x41a5), RC(0x41c6), RC(0x41c6), RC(0x41c6), RC(0x41c6), RC(0x41a5), RC(0x3943), RC(0x3901), RC(0x4983), RC(0x41e7), RC(0x8410), RC(0x8c10), RC(0x8c30), RC(0x9451), RC(0x9451), RC(0x9451), RC(0x9430), RC(0x7b8d), RC(0x730c), RC(0x5a69), RC(0x7b8d), RC(0x5a69), RC(0x83ef), RC(0x83d0), RC(0x83ae), RC(0x7b8e), RC(0x7b6d), RC(0xfabf),
    RC(0xfabf), RC(0x9c50), RC(0x9c50), RC(0x9c30), RC(0x9c50), RC(0x9c51), RC(0x7aa8), RC(0x7140), RC(0x4142), RC(0x3964), RC(0x3964), RC(0x3985), RC(0x41c6), RC(0x41e7), RC(0x5289), RC(0x5aaa), RC(0x41e7), RC(0x41e7), RC(0x4228), RC(0x4a28), RC(0x4a48), RC(0x528a), RC(0x630b), RC(0x738e), RC(0x7bcf), RC(0x8430), RC(0x8c51), RC(0x7bef), RC(0x7bef), RC(0x6b6d), RC(0x5acb), RC(0x5aca), RC(0x4228), RC(0x4207), RC(0x4a48), RC(0x41e7), RC(0x4a07), RC(0x41e7), RC(0x41c6), RC(0x49a4), RC(0x69a2), RC(0x39e6), RC(0x62ca), RC(0x9451), RC(0x9471), RC(0x9471), RC(0x9451), RC(0x9451), RC(0x9431), RC(0x83cf), RC(0x6aeb), RC(0x83ae), RC(0x6b0b), RC(0x7b8d), RC(0x83ae), RC(0x7b6d), RC(0x732c), RC(0x734c), RC(0x7b6d), RC(0xfabf),
    RC(0xfabf), RC(0x9c51), RC(0x9430), RC(0x9c50), RC(0x9c71), RC(0xa4b2), RC(0x9307), RC(0x79a2), RC(0x3984), RC(0x39a5), RC(0x39a6), RC(0x5aaa), RC(0x7bae), RC(0x6b6d), RC(0x5aeb), RC(0x4a49), RC(0x52aa), RC(0x6b4d), RC(0x7bcf), RC(0x73ae), RC(0x8410), RC(0x9cf3), RC(0xa534), RC(0xb5b6), RC(0xc618), RC(0xce59), RC(0xc618), RC(0xbdf7), RC(0xb596), RC(0xad75), RC(0xa534), RC(0x94b2), RC(0x7bef), RC(0x6b6d), RC(0x630c), RC(0x6b6d), RC(0x4a69), RC(0x4207), RC(0x4a27), RC(0x4a07), RC(0x7a04), RC(0x41e6), RC(0x5248), RC(0x9c92), RC(0x9cb2), RC(0x9c92), RC(0x9471), RC(0x9431), RC(0x83ef), RC(0x7b8e), RC(0x732c), RC(0x734d), RC(0x83cf), RC(0x8bcf), RC(0x83ae), RC(0x838e), RC(0x7b4c), RC(0x732c), RC(0x730c), RC(0xfabf),
    RC(0xfabf), RC(0x9c71), RC(0x9c71), RC(0x9c91), RC(0xa492), RC(0x9c92), RC(0x92c7), RC(0x51e6), RC(0x41c6), RC(0x41c6), RC(0x5289), RC(0x6b6d), RC(0x52aa), RC(0x5aeb), RC(0x6b6d), RC(0x8430), RC(0x94b2), RC(0xa534), RC(0xb596), RC(0xbdd7), RC(0xce59), RC(0xce59), RC(0xce79), RC(0xd69a), RC(0xce59), RC(0xc638), RC(0xbdf7), RC(0xc618), RC(0xc638), RC(0xce79), RC(0xc618), RC(0xad55), RC(0x9cf3), RC(0xa534), RC(0x8430), RC(0x528a), RC(0x39e7), RC(0x39c6), RC(0x5269), RC(0x4a28), RC(0x6247), RC(0x49c4), RC(0x3144), RC(0x7bae), RC(0x8c30), RC(0x83ef), RC(0x83cf), RC(0x7bae), RC(0x7bae), RC(0x83ae), RC(0x8bef), RC(0x8c0f), RC(0x8bcf), RC(0x83ae), RC(0x838e), RC(0x838e), RC(0x7b6d), RC(0x7b4c), RC(0x732c), RC(0xfabf),
    RC(0xfabf), RC(0x9410), RC(0x9450), RC(0x9c71), RC(0xa492), RC(0xa492), RC(0x7ac9), RC(0x4a07), RC(0x41e6), RC(0x39c6), RC(0x52aa), RC(0x4a69), RC(0x528a), RC(0x630c), RC(0x8430), RC(0x9cf3), RC(0xbdf7), RC(0xc638), RC(0xce79), RC(0xd69a), RC(0xdedb), RC(0xd69a), RC(0xc638), RC(0xc638), RC(0xce79), RC(0xc618), RC(0xc638), RC(0xce59), RC(0xc638), RC(0xbdd7), RC(0xb596), RC(0xbdd7), RC(0x9cd3), RC(0x73ae), RC(0x73ae), RC(0x738e), RC(0x6b4d), RC(0x4a69), RC(0x52a9), RC(0x4a68), RC(0x5aaa), RC(0x5a47), RC(0x9430), RC(0x9c92), RC(0x9c71), RC(0x9450), RC(0x8bef), RC(0x83ad), RC(0x838d), RC(0x8c10), RC(0x9431), RC(0x8c10), RC(0x8bef), RC(0x83ae), RC(0x7b8e), RC(0x7b6d), RC(0x7b4d), RC(0x732c), RC(0x730c), RC(0xfabf),
    RC(0xfabf), RC(0x8c0f), RC(0x9410), RC(0x9430), RC(0x9450), RC(0x9c92), RC(0x730b), RC(0x4a28), RC(0x39c6), RC(0x738e), RC(0x73ae), RC(0x8410), RC(0x8c51), RC(0x9492), RC(0xad75), RC(0xbdd7), RC(0xc618), RC(0xb596), RC(0xb5b6), RC(0xc618), RC(0xad55), RC(0xbdf7), RC(0xd69a), RC(0xd69a), RC(0xce59), RC(0xd6ba), RC(0xd69a), RC(0xce79), RC(0xce59), RC(0xbdf7), RC(0xc638), RC(0xd69a), RC(0xce79), RC(0xc618), RC(0xb5b6), RC(0xad75), RC(0x94b2), RC(0x6b4d), RC(0x4a48), RC(0x3985), RC(0x5aca), RC(0x8bef), RC(0xa4b3), RC(0x9c92), RC(0x9c72), RC(0x9451), RC(0x9410), RC(0x72eb), RC(0x6289), RC(0x7b6d), RC(0x8bf0), RC(0x8c10), RC(0x8c0f), RC(0x8bcf), RC(0x83ae), RC(0x7b8d), RC(0x7b4d), RC(0x732c), RC(0x730b), RC(0xfabf),
    RC(0xfabf), RC(0x9430), RC(0x9c51), RC(0x9c71), RC(0x9c71), RC(0x9c51), RC(0x734c), RC(0x4207), RC(0x738e), RC(0x8c51), RC(0x9cd3), RC(0xad75), RC(0xb5b6), RC(0xce79), RC(0xce79), RC(0xce59), RC(0xc618), RC(0xc618), RC(0xc618), RC(0xbdd7), RC(0xb5b6), RC(0xc618), RC(0xd69a), RC(0xd69a), RC(0xd6ba), RC(0xdedb), RC(0xd6ba), RC(0xd6ba), RC(0xce79), RC(0xc618), RC(0xc638), RC(0xce59), RC(0xd6ba), RC(0xd69a), RC(0xc618), RC(0xad55), RC(0xad55), RC(0x8c51), RC(0x5aeb), RC(0x4a07), RC(0x5268), RC(0x8c30), RC(0xa4b3), RC(0x9cb3), RC(0x9c72), RC(0x8c31), RC(0x83af), RC(0x6aeb), RC(0x7b2c), RC(0x6b0c), RC(0x83cf), RC(0x8c10), RC(0x9430), RC(0x8bef), RC(0x83ce), RC(0x7b8e), RC(0x7b4d), RC(0x732c), RC(0x730c), RC(0xfabf),
    RC(0xfabf), RC(0x940f), RC(0x9410), RC(0x9c51), RC(0x9c71), RC(0xa492), RC(0x734d), RC(0x4a48), RC(0x9cd3), RC(0xad75), RC(0x9cd3), RC(0xb596), RC(0xbdd7), RC(0xce79), RC(0xdefb), RC(0xdedb), RC(0xd6ba), RC(0xd6ba), RC(0xdefb), RC(0xe71c), RC(0xdefb), RC(0xdefb), RC(0xd69a), RC(0xd6ba), RC(0xd6ba), RC(0xd69a), RC(0xd6ba), RC(0xce59), RC(0xce79), RC(0xce59), RC(0xad75), RC(0xbdd7), RC(0xbdf7), RC(0xd69a), RC(0xc638), RC(0xbdd7), RC(0x9cd3), RC(0xad55), RC(0x94b2), RC(0x5269), RC(0x3185), RC(0x7bae), RC(0xa4d4), RC(0xa4d3), RC(0xa4d3), RC(0x9472), RC(0x8c11), RC(0x8bf0), RC(0x7b4c), RC(0x732c), RC(0x83cf), RC(0x8c10), RC(0x8c10), RC(0x8bf0), RC(0x8bcf), RC(0x838d), RC(0x7b4c), RC(0x732c), RC(0x730b), RC(0xfabf),
    RC(0xfabf), RC(0x940f), RC(0x940f), RC(0x9c30), RC(0x9c51), RC(0x9c51), RC(0x5aaa), RC(0x9491), RC(0xb596), RC(0xad55), RC(0xbdd7), RC(0xce59), RC(0xd69a), RC(0xce59), RC(0xb596), RC(0xc638), RC(0xd69a), RC(0xdefb), RC(0xe73c), RC(0xef5d), RC(0xe71c), RC(0xdedb), RC(0xd6ba), RC(0xce79), RC(0xbdf7), RC(0xb5b6), RC(0xb5b6), RC(0xbdf7), RC(0xc618), RC(0xc618), RC(0xce79), RC(0xd69a), RC(0xce59), RC(0xc638), RC(0xce59), RC(0xd6ba), RC(0xce79), RC(0xb596), RC(0xad55), RC(0x94b2), RC(0x5aeb), RC(0x5aaa), RC(0x9c93), RC(0xa4d3), RC(0xa4d3), RC(0xa4b3), RC(0x9cb3), RC(0x9c71), RC(0x734c), RC(0x734c), RC(0x8bef), RC(0x8bef), RC(0x8bcf), RC(0x8bef), RC(0x83ce), RC(0x838e), RC(0x7b6d), RC(0x732c), RC(0x6b0b), RC(0xfabf),
    RC(0xfabf), RC(0x93ee), RC(0x940f), RC(0x940f), RC(0x9430), RC(0x9430), RC(0x5289), RC(0xad75), RC(0xb5b7), RC(0xb596), RC(0xbdd7), RC(0xc618), RC(0xb596), RC(0xb5b6), RC(0xbdf7), RC(0xbdd7), RC(0xce59), RC(0xdefb), RC(0xe71c), RC(0xe71c), RC(0xe73c), RC(0xd6ba), RC(0xd6ba), RC(0xd6ba), RC(0xd6ba), RC(0xce59), RC(0xce59), RC(0xc638), RC(0xbdd7), RC(0xce59), RC(0xce79), RC(0xd6ba), RC(0xce59), RC(0xc618), RC(0xc618), RC(0xbdf7), RC(0xce59), RC(0xce59), RC(0xce79), RC(0xc638), RC(0x94b2), RC(0x4a49), RC(0x8c31), RC(0xa4b3), RC(0xa4b3), RC(0xa4b3), RC(0xa4b2), RC(0xa4b2), RC(0x9c71), RC(0x9450), RC(0x9430), RC(0x942f), RC(0x93ef), RC(0x8bee), RC(0x83ce), RC(0x838e), RC(0x7b6d), RC(0x732c), RC(0x732b), RC(0xfabf),
    RC(0xfabf), RC(0x940f), RC(0x940f), RC(0x940f), RC(0x9430), RC(0x940f), RC(0x5269), RC(0xb596), RC(0xa514), RC(0xa514), RC(0x8c71), RC(0x9cf3), RC(0xb596), RC(0xc618), RC(0xd69a), RC(0xdedb), RC(0xdefb), RC(0xdedb), RC(0xbdb6), RC(0xa534), RC(0xc617), RC(0xb596), RC(0xce79), RC(0xd69a), RC(0xc618), RC(0xce59), RC(0xd69a), RC(0xce79), RC(0xce79), RC(0xce79), RC(0xc638), RC(0xbdf7), RC(0xc638), RC(0xce79), RC(0xce79), RC(0xc638), RC(0xbdf7), RC(0xbdd7), RC(0xce59), RC(0xce59), RC(0x9cd3), RC(0x31a6), RC(0x2124), RC(0x526a), RC(0x83f0), RC(0xa4b3), RC(0xa4d3), RC(0xa4b2), RC(0xa4b2), RC(0xa491), RC(0x9c71), RC(0x9c50), RC(0x9c50), RC(0x940f), RC(0x8bce), RC(0x83ad), RC(0x836d), RC(0x7b4c), RC(0x730b), RC(0xfabf),
    RC(0xfabf), RC(0x940f), RC(0x940f), RC(0x942f), RC(0x9430), RC(0x9430), RC(0x5aca), RC(0xad55), RC(0xa514), RC(0xa514), RC(0x9cf3), RC(0xa534), RC(0xb5b6), RC(0xbdf7), RC(0xc638), RC(0xc638), RC(0xc618), RC(0xb575), RC(0x9cf3), RC(0x8c71), RC(0xad74), RC(0xbdd6), RC(0xb596), RC(0xad55), RC(0xbdf7), RC(0xc618), RC(0xc618), RC(0xce59), RC(0xd6ba), RC(0xdedb), RC(0xdedb), RC(0xce59), RC(0xbdf7), RC(0xbdf7), RC(0xce59), RC(0xdedb), RC(0xd6ba), RC(0xce79), RC(0xc638), RC(0xbdf7), RC(0xa534), RC(0x6b2c), RC(0x6b0c), RC(0x41e7), RC(0x2104), RC(0x2945), RC(0x4a49), RC(0x83cf), RC(0x9c92), RC(0xa4b2), RC(0x9c71), RC(0x9c51), RC(0x9c50), RC(0x9430), RC(0x940f), RC(0x8bce), RC(0x838d), RC(0x7b6c), RC(0x7b2c), RC(0xfabf),
    RC(0xfabf), RC(0x940f), RC(0x9c50), RC(0x9c50), RC(0xa471), RC(0x9c70), RC(0x62ea), RC(0xb596), RC(0xbdd7), RC(0xc618), RC(0xce59), RC(0xce59), RC(0xce59), RC(0xc638), RC(0xc638), RC(0xad75), RC(0xa534), RC(0x9cf3), RC(0xb596), RC(0xa513), RC(0x8c30), RC(0x8c0f), RC(0xa514), RC(0xb5b6), RC(0xce79), RC(0xc638), RC(0xce59), RC(0xd6ba), RC(0xd69a), RC(0xbdf7), RC(0xce79), RC(0xd69a), RC(0xce59), RC(0xce79), RC(0xd6ba), RC(0xdefb), RC(0xd6ba), RC(0xce59), RC(0xc638), RC(0xc638), RC(0x9cb2), RC(0x8c10), RC(0x9451), RC(0x9410), RC(0x83ae), RC(0x6b0c), RC(0x4a28), RC(0x2124), RC(0x2104), RC(0x41e7), RC(0x6b0c), RC(0x8c0f), RC(0x9430), RC(0x940f), RC(0x93ef), RC(0x8bce), RC(0x83ae), RC(0x838d), RC(0x7b4c), RC(0xfabf),
    RC(0xfabf), RC(0x940f), RC(0x9c50), RC(0x9c70), RC(0xa491), RC(0xa471), RC(0x7b8d), RC(0xa513), RC(0xbdf7), RC(0xc638), RC(0xc618), RC(0xdefb), RC(0xd6ba), RC(0xce59), RC(0xc618), RC(0xb596), RC(0xad75), RC(0xb596), RC(0xad75), RC(0xa534), RC(0x9cf3), RC(0x94b2), RC(0xa513), RC(0xa534), RC(0x9cf3), RC(0xbdf7), RC(0xce58), RC(0xce58), RC(0xd6ba), RC(0xbdf7), RC(0xc638), RC(0xd69a), RC(0xce59), RC(0xce79), RC(0xc638), RC(0xbdd7), RC(0xd6ba), RC(0xd69a), RC(0xce59), RC(0xce59), RC(0x8410), RC(0x9c92), RC(0x9c92), RC(0x9471), RC(0x9451), RC(0x9430), RC(0x8bef), RC(0x83ae), RC(0x6b0b), RC(0x49e7), RC(0x2104), RC(0x18c2), RC(0x3165), RC(0x5a8a), RC(0x7b6d), RC(0x83ae), RC(0x838d), RC(0x836c), RC(0x7b4c), RC(0xfabf),
    RC(0xfabf), RC(0x8bcf), RC(0x9430), RC(0x9c71), RC(0x9c71), RC(0xa491), RC(0x9c71), RC(0x7bae), RC(0xbdf7), RC(0xce59), RC(0xce59), RC(0xa534), RC(0xa534), RC(0xb596), RC(0xbdf7), RC(0xa534), RC(0xb596), RC(0xc618), RC(0xce59), RC(0xce79), RC(0xce79), RC(0xc638), RC(0xbdf7), RC(0xbdf7), RC(0xbdd7), RC(0xa513), RC(0x9cd2), RC(0xa534), RC(0xb5b6), RC(0xc638), RC(0xc638), RC(0xd6ba), RC(0xdedb), RC(0xd69a), RC(0xce79), RC(0xb5b6), RC(0xad75), RC(0xce79), RC(0xce59), RC(0x8c71), RC(0x9c71), RC(0xad13), RC(0xacf3), RC(0xa4d2), RC(0x9c92), RC(0x9451), RC(0x9430), RC(0x8bef), RC(0x8bce), RC(0x83ae), RC(0x7b6d), RC(0x62ca), RC(0x41e7), RC(0x2924), RC(0x10a2), RC(0x2103), RC(0x41e7), RC(0x62ca), RC(0x730b), RC(0xfabf),
    RC(0xfabf), RC(0x6aca), RC(0x62aa), RC(0x6b0b), RC(0x8bce), RC(0x9c71), RC(0xa491), RC(0x8c0f), RC(0xad34), RC(0xc638), RC(0xb5b6), RC(0xb5b6), RC(0xb5b6), RC(0xbdf7), RC(0xc618), RC(0xce59), RC(0xd69a), RC(0xbdd7), RC(0xa534), RC(0xad75), RC(0xb596), RC(0xbdd7), RC(0xbdf7), RC(0xb596), RC(0xb5b6), RC(0xc618), RC(0xc638), RC(0xc638), RC(0xce79), RC(0xdefb), RC(0xc638), RC(0xb5b6), RC(0xc618), RC(0xc618), RC(0xc638), RC(0xce59), RC(0xbdf7), RC(0xbdf7), RC(0xbdd7), RC(0x83f0), RC(0x9cd3), RC(0x9cb3), RC(0xa4b3), RC(0xa4b2), RC(0xa4b2), RC(0xa4b2), RC(0xa4b2), RC(0x9c71), RC(0x9410), RC(0x8bcf), RC(0x838e), RC(0x7b8d), RC(0x7b4c), RC(0x730b), RC(0x5a89), RC(0x41e7), RC(0x2924), RC(0x10a2), RC(0x18c3), RC(0xfabf),
    RC(0xfabf), RC(0x8bce), RC(0x8bcf), RC(0x838d), RC(0x6aeb), RC(0x628a), RC(0x6aeb), RC(0x838e), RC(0x83cf), RC(0xad75), RC(0xb5b6), RC(0xc618), RC(0xd69a), RC(0xdedb), RC(0xe71c), RC(0xdedb), RC(0xd69a), RC(0xbdd7), RC(0xbdd7), RC(0xbdf7), RC(0xb596), RC(0xbdd7), RC(0xce79), RC(0xd69a), RC(0xce79), RC(0xd69a), RC(0xdedb), RC(0xce79), RC(0xc638), RC(0xbdf7), RC(0xc618), RC(0xd69a), RC(0xd6ba), RC(0xd6ba), RC(0xd6ba), RC(0xd69a), RC(0xd69a), RC(0xbdf7), RC(0x8410), RC(0x9472), RC(0x9452), RC(0x9472), RC(0x9472), RC(0x9471), RC(0x9471), RC(0x9471), RC(0x9c71), RC(0x9c71), RC(0x9c50), RC(0x9430), RC(0x8bef), RC(0x83ae), RC(0x7b6d), RC(0x732c), RC(0x6aeb), RC(0x6aca), RC(0x62aa), RC(0x5a69), RC(0x41c7), RC(0xfabf),
    RC(0xfabf), RC(0x8bcf), RC(0x8bcf), RC(0x8bef), RC(0x9410), RC(0x93f0), RC(0x8bcf), RC(0x732c), RC(0x5a8a), RC(0x5269), RC(0xad55), RC(0xd6ba), RC(0xce79), RC(0xce79), RC(0xb5b6), RC(0xad75), RC(0xbdd7), RC(0xce59), RC(0xc638), RC(0xc618), RC(0xce79), RC(0xd69a), RC(0xce59), RC(0xd69a), RC(0xd6ba), RC(0xd69a), RC(0xdedb), RC(0xe71c), RC(0xdefb), RC(0xdedb), RC(0xdefb), RC(0xd6ba), RC(0xdedb), RC(0xdefb), RC(0xce79), RC(0xce79), RC(0xb5b6), RC(0x83f0), RC(0x9430), RC(0x9451), RC(0x9451), RC(0x8c10), RC(0x8c10), RC(0x8c10), RC(0x8c10), RC(0x8c30), RC(0x8c10), RC(0x8c30), RC(0x8bef), RC(0x8bef), RC(0x83ce), RC(0x83ae), RC(0x838d), RC(0x7b4c), RC(0x732c), RC(0x6aeb), RC(0x62aa), RC(0x6289), RC(0x5a68), RC(0xfabf),
    RC(0xfabf), RC(0x8bf0), RC(0x9410), RC(0x8c10), RC(0x9430), RC(0x8c10), RC(0x9430), RC(0x9410), RC(0x8c10), RC(0x83cf), RC(0x7b8d), RC(0xad34), RC(0xce79), RC(0xd6ba), RC(0xce79), RC(0xc618), RC(0xce59), RC(0xd6ba), RC(0xce79), RC(0xc638), RC(0xce79), RC(0xce79), RC(0xd6ba), RC(0xe71c), RC(0xe73c), RC(0xe71c), RC(0xdedb), RC(0xc618), RC(0xbdd7), RC(0xce79), RC(0xd69a), RC(0xd6ba), RC(0xdedb), RC(0xe73c), RC(0xd6ba), RC(0xb596), RC(0x83cf), RC(0x8bef), RC(0x8c10), RC(0x8bef), RC(0x8bf0), RC(0x8c10), RC(0x9430), RC(0x8c10), RC(0x8bcf), RC(0x83ae), RC(0x83cf), RC(0x83ae), RC(0x83ae), RC(0x7b8e), RC(0x7b8e), RC(0x7b6d), RC(0x732c), RC(0x6b0c), RC(0x6aeb), RC(0x6aeb), RC(0x62ca), RC(0x62aa), RC(0x5a89), RC(0xfabf),
    RC(0xfabf), RC(0x83af), RC(0x83d0), RC(0x8bf0), RC(0x9431), RC(0x9451), RC(0x9451), RC(0x9431), RC(0x8c10), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0xad54), RC(0xce59), RC(0xdefb), RC(0xe71c), RC(0xdefb), RC(0xd6ba), RC(0xd6ba), RC(0xdefb), RC(0xdefb), RC(0xdefb), RC(0xc618), RC(0xc638), RC(0xd6ba), RC(0xd69a), RC(0xd69a), RC(0xd69a), RC(0xdedb), RC(0xdefb), RC(0xdedb), RC(0xce79), RC(0xd6ba), RC(0xce79), RC(0xa4f3), RC(0x8c0f), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x83cf), RC(0x83cf), RC(0x83ae), RC(0x83cf), RC(0x83ae), RC(0x83ae), RC(0x7b6d), RC(0x734d), RC(0x734d), RC(0x734d), RC(0x732c), RC(0x6b0c), RC(0x6aeb), RC(0x62eb), RC(0x62cb), RC(0x62aa), RC(0x5a8a), RC(0x5a8a), RC(0xfabf),
    RC(0xfabf), RC(0x8c11), RC(0x9431), RC(0x8c31), RC(0x9452), RC(0x9452), RC(0x9492), RC(0x9431), RC(0x9431), RC(0x8c11), RC(0x9431), RC(0x8c10), RC(0x8bf0), RC(0x83cf), RC(0x9472), RC(0xce38), RC(0xdedb), RC(0xd6ba), RC(0xe6fb), RC(0xe73c), RC(0xe71c), RC(0xd6ba), RC(0xd6ba), RC(0xdedb), RC(0xdedb), RC(0xe71c), RC(0xe71c), RC(0xe71c), RC(0xd6bb), RC(0xce79), RC(0xdefb), RC(0xce59), RC(0xad34), RC(0x9430), RC(0x8c10), RC(0x8bef), RC(0x8bcf), RC(0x8bce), RC(0x83ae), RC(0x83ae), RC(0x83ae), RC(0x83ae), RC(0x838e), RC(0x7b8e), RC(0x7b8e), RC(0x7b6d), RC(0x734d), RC(0x734d), RC(0x7b6d), RC(0x734d), RC(0x6b0c), RC(0x6aeb), RC(0x62cb), RC(0x62ca), RC(0x62cb), RC(0x62aa), RC(0x5a8a), RC(0x62aa), RC(0x5a89), RC(0xfabf),
    RC(0xfabf), RC(0x83b0), RC(0x83f0), RC(0x8c51), RC(0x9492), RC(0x9493), RC(0x9492), RC(0x9cb3), RC(0x9472), RC(0x9472), RC(0x8c31), RC(0x9451), RC(0x8c11), RC(0x83d0), RC(0x6aeb), RC(0x5249), RC(0x7bae), RC(0xa4f4), RC(0xce59), RC(0xdf1b), RC(0xe73c), RC(0xef5d), RC(0xef5d), RC(0xef7d), RC(0xef5d), RC(0xef5d), RC(0xe71c), RC(0xd6ba), RC(0xc618), RC(0xb555), RC(0x9cb2), RC(0x9c71), RC(0x9c51), RC(0x9c51), RC(0x9430), RC(0x9410), RC(0x8bef), RC(0x8bef), RC(0x8bcf), RC(0x83ae), RC(0x838d), RC(0x7b8d), RC(0x7b6d), RC(0x7b4d), RC(0x7b6d), RC(0x734d), RC(0x732c), RC(0x732c), RC(0x730c), RC(0x6b0c), RC(0x6b0b), RC(0x6aeb), RC(0x6acb), RC(0x62aa), RC(0x5a69), RC(0x5a69), RC(0x5a69), RC(0x5a8a), RC(0x5a69), RC(0xfabf),
    RC(0xfabf), RC(0x6b0c), RC(0x7b6e), RC(0x83af), RC(0x8bf1), RC(0x8c52), RC(0x9472), RC(0x94b3), RC(0x94b2), RC(0x94b3), RC(0x9cb3), RC(0x9472), RC(0x8c31), RC(0x83f0), RC(0x83d0), RC(0x83f0), RC(0x83f0), RC(0x736e), RC(0x7b8f), RC(0x83cf), RC(0x83af), RC(0x8c10), RC(0x8c31), RC(0x9451), RC(0x83cf), RC(0x630c), RC(0x6b0c), RC(0x83ae), RC(0x9451), RC(0x9c71), RC(0x9c71), RC(0x9c71), RC(0x9c71), RC(0x9c71), RC(0x9451), RC(0x9451), RC(0x9430), RC(0x8c10), RC(0x8bef), RC(0x8bcf), RC(0x83ae), RC(0x838e), RC(0x7b6d), RC(0x7b6d), RC(0x7b4c), RC(0x730c), RC(0x6b0b), RC(0x6aeb), RC(0x6aeb), RC(0x6acb), RC(0x6acb), RC(0x62aa), RC(0x628a), RC(0x5a89), RC(0x5a69), RC(0x5a69), RC(0x5249), RC(0x5269), RC(0x5228), RC(0xfabf),
    RC(0xfabf), RC(0x7b6e), RC(0x732c), RC(0x734d), RC(0x838e), RC(0x83cf), RC(0x8c10), RC(0x8c31), RC(0x8c31), RC(0x9472), RC(0x9cd3), RC(0x9452), RC(0x8c11), RC(0x8c31), RC(0x8c52), RC(0x9452), RC(0x9472), RC(0x9472), RC(0x9452), RC(0x8c11), RC(0x8c31), RC(0x8c51), RC(0x8c31), RC(0x8bf0), RC(0x83cf), RC(0x83cf), RC(0x7b8e), RC(0x6aeb), RC(0x5269), RC(0x5269), RC(0x6b0c), RC(0x83cf), RC(0x9430), RC(0x9430), RC(0x9430), RC(0x9451), RC(0x9430), RC(0x9430), RC(0x940f), RC(0x8bef), RC(0x8bce), RC(0x83ae), RC(0x838e), RC(0x7b6d), RC(0x734c), RC(0x730c), RC(0x6aeb), RC(0x6aca), RC(0x62ca), RC(0x62aa), RC(0x6289), RC(0x5a89), RC(0x5a69), RC(0x5a69), RC(0x5a48), RC(0x5228), RC(0x5248), RC(0x5228), RC(0x5207), RC(0xfabf),
    RC(0xfabf), RC(0x7b6d), RC(0x7b8e), RC(0x7b8e), RC(0x7b6e), RC(0x7b8e), RC(0x83af), RC(0x8bf0), RC(0x83d0), RC(0x83d0), RC(0x8c11), RC(0x9472), RC(0x9432), RC(0x8c11), RC(0x8c51), RC(0x9492), RC(0x94b3), RC(0x94d3), RC(0x94b2), RC(0x9492), RC(0x9452), RC(0x8c31), RC(0x8c31), RC(0x8c11), RC(0x8bf0), RC(0x83cf), RC(0x83af), RC(0x83ae), RC(0x83ae), RC(0x7b8e), RC(0x732c), RC(0x5a89), RC(0x5228), RC(0x5a89), RC(0x732c), RC(0x8bcf), RC(0x8c0f), RC(0x8bef), RC(0x8bef), RC(0x8bef), RC(0x8bcf), RC(0x83ce), RC(0x838e), RC(0x7b8d), RC(0x7b4d), RC(0x732c), RC(0x730b), RC(0x6aeb), RC(0x62ca), RC(0x62aa), RC(0x6289), RC(0x5a69), RC(0x5a48), RC(0x5248), RC(0x5248), RC(0x5248), RC(0x5228), RC(0x4a07), RC(0x49e7), RC(0xfabf),
    RC(0xfabf), RC(0x7b6d), RC(0x7b6d), RC(0x734d), RC(0x7b6d), RC(0x7b8e), RC(0x7b8e), RC(0x7b8e), RC(0x7b8e), RC(0x83af), RC(0x83d0), RC(0x83d0), RC(0x83d0), RC(0x8c11), RC(0x8c31), RC(0x8c31), RC(0x8c72), RC(0x9492), RC(0x94b2), RC(0x94b2), RC(0x94b2), RC(0x9492), RC(0x8c51), RC(0x8c10), RC(0x8bf0), RC(0x8bf0), RC(0x83d0), RC(0x83af), RC(0x7b8e), RC(0x7b6e), RC(0x7b6d), RC(0x7b8e), RC(0x7b6d), RC(0x6b0b), RC(0x5249), RC(0x41e7), RC(0x4a28), RC(0x62eb), RC(0x7b8d), RC(0x83cf), RC(0x83ae), RC(0x83ae), RC(0x83ae), RC(0x7b8e), RC(0x7b6d), RC(0x734c), RC(0x732c), RC(0x6b0b), RC(0x6acb), RC(0x62aa), RC(0x628a), RC(0x5a69), RC(0x5a48), RC(0x5248), RC(0x5228), RC(0x41e8), RC(0x49e7), RC(0x49e7), RC(0x49c6), RC(0xfabf),
    RC(0xfabf), RC(0x7b6d), RC(0x7b6d), RC(0x734d), RC(0x734d), RC(0x734d), RC(0x734d), RC(0x7b6d), RC(0x7b6d), RC(0x7b6e), RC(0x7b8e), RC(0x7b8e), RC(0x83af), RC(0x83af), RC(0x83d0), RC(0x8bf0), RC(0x8c11), RC(0x8411), RC(0x8431), RC(0x8c51), RC(0x8c51), RC(0x8c71), RC(0x8c51), RC(0x9492), RC(0x8c51), RC(0x83f0), RC(0x8bf0), RC(0x83d0), RC(0x7baf), RC(0x7b8e), RC(0x7b8e), RC(0x7baf), RC(0x7b6d), RC(0x734d), RC(0x732c), RC(0x732c), RC(0x6aeb), RC(0x5248), RC(0x41c6), RC(0x41c7), RC(0x5a69), RC(0x730c), RC(0x7b6d), RC(0x7b6d), RC(0x7b6d), RC(0x7b4c), RC(0x732c), RC(0x730b), RC(0x6aeb), RC(0x6aca), RC(0x62aa), RC(0x5a89), RC(0x5a69), RC(0x5248), RC(0x5227), RC(0x5207), RC(0x41e8), RC(0x49c6), RC(0x41c6), RC(0xfabf),
    RC(0xfabf), RC(0x83ae), RC(0x7b8e), RC(0x7b8e), RC(0x7b8e), RC(0x7b6d), RC(0x7b6d), RC(0x734d), RC(0x7b6d), RC(0x734d), RC(0x734d), RC(0x7b6d), RC(0x7b6d), RC(0x7b6e), RC(0x7b8e), RC(0x83af), RC(0x7baf), RC(0x7b8f), RC(0x83d0), RC(0x83d0), RC(0x7baf), RC(0x7bcf), RC(0x8410), RC(0x8c71), RC(0x8c10), RC(0x838f), RC(0x7b8f), RC(0x7b8f), RC(0x7b8f), RC(0x7b8f), RC(0x7b8e), RC(0x7b6e), RC(0x736d), RC(0x734d), RC(0x732c), RC(0x732c), RC(0x732c), RC(0x6b0c), RC(0x6b0c), RC(0x6aeb), RC(0x5a69), RC(0x41c6), RC(0x39a6), RC(0x4a07), RC(0x62aa), RC(0x730c), RC(0x732c), RC(0x730b), RC(0x6aeb), RC(0x6acb), RC(0x62aa), RC(0x6289), RC(0x5a69), RC(0x5a48), RC(0x5228), RC(0x5207), RC(0x49e6), RC(0x41e8), RC(0x41a6), RC(0xfabf),
    RC(0xfabf), RC(0x83cf), RC(0x83cf), RC(0x83cf), RC(0x83ae), RC(0x83ae), RC(0x83af), RC(0x7b8e), RC(0x7b8e), RC(0x7b8e), RC(0x7b8e), RC(0x7b6d), RC(0x7b6d), RC(0x7b6d), RC(0x7b6d), RC(0x7b4d), RC(0x734d), RC(0x732d), RC(0x732d), RC(0x734d), RC(0x7b6e), RC(0x7b6e), RC(0x736e), RC(0x738f), RC(0x7bd0), RC(0x83d0), RC(0x7baf), RC(0x7b6e), RC(0x7b6e), RC(0x7b8f), RC(0x7b6e), RC(0x7b6e), RC(0x736e), RC(0x736e), RC(0x734d), RC(0x734d), RC(0x732c), RC(0x6b2c), RC(0x6b0c), RC(0x6b0c), RC(0x6b0c), RC(0x6aeb), RC(0x62ca), RC(0x5a69), RC(0x41c6), RC(0x3165), RC(0x39a6), RC(0x5228), RC(0x62aa), RC(0x62ca), RC(0x62aa), RC(0x6289), RC(0x5a68), RC(0x5a48), RC(0x5228), RC(0x5227), RC(0x4a07), RC(0x49e6), RC(0x41e8), RC(0xfabf),
    RC(0xfabf), RC(0x83cf), RC(0x83cf), RC(0x83ef), RC(0x83cf), RC(0x83cf), RC(0x83cf), RC(0x83f0), RC(0x83cf), RC(0x83af), RC(0x83af), RC(0x7baf), RC(0x7b8e), RC(0x7b6e), RC(0x7b6e), RC(0x734d), RC(0x732c), RC(0x6b0c), RC(0x6aeb), RC(0x7baf), RC(0x7b8e), RC(0x734d), RC(0x732d), RC(0x732d), RC(0x734e), RC(0x734e), RC(0x738e), RC(0x7b8f), RC(0x736e), RC(0x736e), RC(0x7b8e), RC(0x736e), RC(0x736e), RC(0x738e), RC(0x734d), RC(0x732d), RC(0x6b0c), RC(0x6b2c), RC(0x6b2c), RC(0x6b0c), RC(0x6b0c), RC(0x62eb), RC(0x62cb), RC(0x62ca), RC(0x62aa), RC(0x628a), RC(0x5a69), RC(0x41c6), RC(0x3144), RC(0x3144), RC(0x41a6), RC(0x5228), RC(0x5a69), RC(0x5a48), RC(0x5248), RC(0x5227), RC(0x4a07), RC(0x49e6), RC(0x49c6), RC(0xfabf),
    RC(0xfabf), RC(0x6b2d), RC(0x7b6e), RC(0x83af), RC(0x83d0), RC(0x8c10), RC(0x9472), RC(0x8c51), RC(0x83cf), RC(0x7bae), RC(0x7bae), RC(0x83cf), RC(0x83af), RC(0x7b8e), RC(0x7b8e), RC(0x7b8e), RC(0x7b6d), RC(0x734d), RC(0x6aeb), RC(0x62cb), RC(0x62ec), RC(0x734d), RC(0x6aeb), RC(0x6b0c), RC(0x6b0c), RC(0x6b0c), RC(0x6b0c), RC(0x6b2d), RC(0x734e), RC(0x734d), RC(0x732d), RC(0x6b2d), RC(0x6b4d), RC(0x738e), RC(0x738f), RC(0x7b8f), RC(0x7b8f), RC(0x734d), RC(0x6b2d), RC(0x6b0c), RC(0x6b0c), RC(0x6aec), RC(0x62cb), RC(0x62aa), RC(0x62ab), RC(0x62ab), RC(0x5a8a), RC(0x5a89), RC(0x5a69), RC(0x5228), RC(0x41a6), RC(0x2924), RC(0x2903), RC(0x3164), RC(0x49c6), RC(0x5207), RC(0x5207), RC(0x49e6), RC(0x49c6), RC(0xfabf),
    RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf), RC(0xfabf)
  }
};  

// struct packing, pragma for GCC !!!
#pragma pack (pop)
