/*
 * 8 bites prhuzamos LCD GPIO driver STM32F1-re
 * 5 vezrllb (CS, RS, WR, RD, RST) + 8 adatlb + httrvilgits vezrls
 */

//=============================================================================
// Lcd vezrl lbak hozzrendelse (A..M, 0..15) (RST lb opcionlis)
#define LCD_CS            A, 2
#define LCD_RS            A, 0
#define LCD_WR            A, 1
#define LCD_RD            A, 3
#define LCD_RST           X, 0

// Lcd adat lbak hozzrendelse (A..M, 0..15)
#define LCD_D0            B, 8
#define LCD_D1            B, 9
#define LCD_D2            B, 10
#define LCD_D3            B, 11
#define LCD_D4            B, 12
#define LCD_D5            B, 13
#define LCD_D6            B, 14
#define LCD_D7            B, 15

// Httrvilgits vezrls (opcionlis, lb hozzrendels s aktiv llapot)
#define LCD_BL            X, 0
#define LCD_BLON          0

/* nsec nagysgrend vrakozs az LCD irsi s az olvassi impulzusnl
   - kezd rtknek rdemes 10, 20-bol elindulni, aztn lehet cskkenteni a sebessg nvelse rdekben
     (az rtk fgg a processzor orajeltl s az LCD kijelz sebessgtl is)
*/
#define LCD_WRITE_DELAY   1
#define LCD_READ_DELAY    2

/*=============================================================================
I/O csoport optimalizci, hogy ne bitenknt trtnjenek a GPIO mveletek:
Megj: ha az adat lbakat egy porton bell emelked sorrendben definiljuk
      automatikusan optimalizlva fognak trtnni a GPIO mveletek akkor is, ha
      itt nem definiljuk az optimalizlt mkdshez szksges eljrsokat
A lenti plda a kvetkez lbakhoz optimalizl:
      LCD_D0<-D14, LCD_D1<-D15, LCD_D2<-D0, LCD_D3<-D1
      LCD_D4<-E7,  LCD_D5<-E8,  LCD_D6<-E9, LCD_D7<-E10 */
#if 0
// datapins setting to output (data direction: STM32 -> LCD)
#define LCD_DIRWRITE { /* D0..D1, D14..D15, E7..E10 <- 0x3 */ \
GPIOD->CRH = (GPIOD->CRH & ~0xFF000000) | 0x33000000; \
GPIOD->CRL = (GPIOD->CRH & ~0x000000FF) | 0x00000033; \
GPIOE->CRL = (GPIOE->CRL & ~0xF0000000) | 0x30000000; \
GPIOE->CRH = (GPIOE->CRH & ~0x00000FFF) | 0x00000333; }
// datapins setting to input (data direction: STM32 <- LCD)
#define LCD_DIRREAD { /* D0..D1, D14..D15, E7..E10 <- 0x4 */ \
GPIOD->CRH = (GPIOD->CRH & ~0xFF000000) | 0x44000000; \
GPIOD->CRL = (GPIOD->CRH & ~0x000000FF) | 0x00000044; \
GPIOE->CRL = (GPIOE->CRL & ~0xF0000000) | 0x40000000; \
GPIOE->CRH = (GPIOE->CRH & ~0x00000FFF) | 0x00000444; }
// datapins write, STM32 -> LCD (write I/O pins from dt data)
#define LCD_WRITE(dt) { /* D14..15 <- dt0..1, D0..1 <- dt2..3, E7..10 <- dt4..7 */ \
GPIOD->ODR = (GPIOD->ODR & ~0b1100000000000011) | (((dt & 0b00000011) << 14) | ((dt & 0b00001100) >> 2)); \
GPIOE->ODR = (GPIOE->ODR & ~0b0000011110000000) | ((dt & 0b11110000) << 3); }
// datapins read, STM32 <- LCD (read from I/O pins and store to dt data)
#define LCD_READ(dt) { /* dt0..1 <- D14..15, dt2..3 <- D0..1, dt4..7 <- E7..10 */ \
dt = ((GPIOD->IDR & 0b1100000000000000) >> 14) | ((GPIOD->IDR & 0b0000000000000011) << 2) | \
     ((GPIOE->IDR & 0b0000011110000000) >> 3); }
#endif
