;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; some basic drawing functions
;

.include "draw.inc"
.include "glcd.inc"
.include "p30fxxxx.inc"


.bss
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; variable for line algorithm
;
x0: .space 2
y0: .space 2
x1: .space 2
y1: .space 2

deltax: .space 2
deltay: .space 2
error: .space 2

ystep: .space 2

steep: .space 2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
side: .space 2
drawaddr: .space 2	;save address for write
drawpage: .space 2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; drawXY
; place a point at the given x-y location
; pass x location in w1, y location in w2,
; pixel on or off in w4 (lsb only)
; 

.text

drawXY:
	mov #64, w0	;check to see which half is needed
	cp w1, w0
	bra geu, drawRight	;if greater than center value, draw on right side
drawLeft:
	bclr side, #0		;left side means side = 0
	mov w1, w0			;move deisred location into w0
	mov #LCD_addr, w3
	ior w3, w0, w0
	bset w0, #_cs1		;select the left side
	bclr w0, #_cs2		;
	mov w0, drawaddr	;save address for later use
	call gLCDcmd
	call checkBusy
	goto drawSetAddr	;set the addresses
drawRight:
	bset side, #0		;side is one if right side
	mov w1, w0			;
	sub #64, w0			;adjust for the side of the screen
	mov #LCD_addr, w3
	ior w3, w0, w0
	bset w0, #_cs2
	bclr w0, #_cs1
	mov w0, drawaddr	;save address for later use
	call gLCDcmd
	call checkBusy

drawSetAddr:

	lsr w2, w0			;get the y address
	lsr w0, w0
	lsr w0, w0			;divide by 8 to get page address

	mov #LCD_page, w3	;lcd page command
	ior w3, w0, w0		;ior in the command for setting the page
	
	btss side, #0
	bset w0, #_cs1		;left side if side = 0
	btsc side, #0
	bset w0, #_cs2		;right side if side = 1

	call gLCDcmd		;set the page of the lcd
	call checkBusy		;right on

drawRead:
	mov #0, w0
	btss side, #0
	bset w0, #_cs1		;left side if side = 0
	btsc side, #0
	bset w0, #_cs2		;right side if side = 1

	call gLCDread		;read the data
						;now low byte of w0 has data
 
	and #0x07, w2		;get pixel location
	mov #0x01, w5		;
	repeat w2			;shift left a few times to
	sl w5, w5			;get bit into proper place
	lsr w5, w5			;and move back once to adj for loop
	btsc w4, #0			;if bit0 of w4 is not clear
	goto drawSet		;then turn a pixel on
drawClear:				;otherwise turn it off
	com w5, w5			;invert w5
	and w5, w0, w0		;get rid of bit
	goto drawWrite
drawSet:
	ior w5, w0, w0		;set the bit
drawWrite:	
	push w0				;save w0 for now
	mov drawaddr, w0	;reset address to proper location
	call gLCDcmd		;
	call checkBusy		;
	pop w0				;retrieve w0
	
	btss side, #0
	bset w0, #_cs1		;left side if side = 0
	btsc side, #0
	bset w0, #_cs2		;right side if side = 1

	call gLCDdata		;finally, set the pixel		
	call checkBusy

	return				;done!



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; drawLine
;
; draw a line connecting the two (x,y) points
; (w1, w2) and (w3, w4) (in lcd coords).
; Uses Bresenham's line algorithm to connect
; the endpoints
;
drawLine:
	mov w1, x0
	mov w2, y0
	mov w3, x1
	mov w4, y1

	sub w4, w2, w0		;do y1-y0 store in w0
	btsc w0, #15		;check sign bit
	neg w0, w0			;get abs value if negative

	sub w3, w1, w1		;do x1-x0, store in w1
	btsc w1, #15		;check sign bit
	neg w1, w1			;get abs value if negative

	mov #0, w2
	mov w2, steep		;set steep to 0 initially
	cp w0, w1			;compare (checking for ydiff > xdiff)
	bra le, drawLcheckX ;if (y1-y0)<=(x1-x0)

drawLsteepCheck:
	bset steep, #0		;else line is steep
	mov x0, w0			;so swap x0, y0
	mov y0, w1
	mov w0, y0
	mov w1, x0

	mov x1, w0			;and swap x1, y1
	mov y1, w1
	mov w1, x1
	mov w0, y1

drawLcheckX:
	mov x0, w0
	mov x1, w1
	cp w0, w1
	bra le, drawLdiffs
	
	mov w0, x1		;swap x0, x1
	mov w1, x0

	mov y0, w0		;swap y0, y1
	mov y1, w1
	mov w1, y0
	mov w0, y1

drawLdiffs:
	mov x1, w1
	mov x0, w0
	sub w1, w0, w0
	mov w0, deltax		;save the x difference

	mov y1, w1
	mov y0, w0
	sub w1, w0, w0
	btsc w0, #15		;check the sign bit
	neg w0, w0			;if neg, get abs value
	mov w0, deltay		;

	mov deltax, w0
	asr w0, w0			;divide w0 by 2		
	neg w0, w0			;get -deltax
	mov w0, error		;save the error

	mov #1, w0
	mov w0, ystep		;set step to +1
	mov y0, w0			;
	mov y1, w1			;
	cpslt w0, w1		;compare, don't negate if y0<y1
	neg ystep			;

drawLinitLoop:
	mov y0, w2
	mov x0, w1

drawLloop:		;use w2 as y, use w1 as x
	push w2
	push w1
	cp0 steep
	bra z, drawLnorm

drawLsteep:
	bset w4, #0
	mov w2, w0		;hold y
	mov w1, w2		;move x to y
	mov w0, w1		;move y to x
	call drawXY		;put the point
	goto drawLerrorCalc	;

drawLnorm:
	bset w4, #0
	call drawXY
	;goto drawLerrorCalc

drawLerrorCalc:
	mov error, w0
	mov deltay, w1
	add w0, w1, w1
	mov w1, error

	pop w1			;retrieve x
	pop w2			;retrieve y
	
	cp0 error		;check for sign of error
	bra le, drawLloopCheck

	mov ystep, w0
	add w0, w2, w2	;add ystep to y
	mov deltax, w0	;
	sub error		;get new error

drawLloopCheck:
	inc w1, w1		;move to next x
	mov x1, w0
	cp w1, w0		;check to see if x > x1
	bra le, drawLloop 	;if less than or equal, do loop again

drawLdone:
	return				;otherwise done :)






;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; clearLine
;
; clear a line connecting the two (x,y) points
; (w1, w2) and (w3, w4) (in lcd coords).
; Uses Bresenham's line algorithm to connect
; the endpoints
;
clearLine:
	mov w1, x0
	mov w2, y0
	mov w3, x1
	mov w4, y1

	sub w4, w2, w0		;do y1-y0 store in w0
	btsc w0, #15		;check sign bit
	neg w0, w0			;get abs value if negative

	sub w3, w1, w1		;do x1-x0, store in w1
	btsc w1, #15		;check sign bit
	neg w1, w1			;get abs value if negative

	mov #0, w2
	mov w2, steep		;set steep to 0 initially
	cp w0, w1			;compare (checking for ydiff > xdiff)
	bra le, clearLcheckX ;if (y1-y0)<=(x1-x0)

clearLsteepCheck:
	bset steep, #0		;else line is steep
	mov x0, w0			;so swap x0, y0
	mov y0, w1
	mov w0, y0
	mov w1, x0

	mov x1, w0			;and swap x1, y1
	mov y1, w1
	mov w1, x1
	mov w0, y1

clearLcheckX:
	mov x0, w0
	mov x1, w1
	cp w0, w1
	bra le, clearLdiffs
	
	mov w0, x1		;swap x0, x1
	mov w1, x0

	mov y0, w0		;swap y0, y1
	mov y1, w1
	mov w1, y0
	mov w0, y1

clearLdiffs:
	mov x1, w1
	mov x0, w0
	sub w1, w0, w0
	mov w0, deltax		;save the x difference

	mov y1, w1
	mov y0, w0
	sub w1, w0, w0
	btsc w0, #15		;check the sign bit
	neg w0, w0			;if neg, get abs value
	mov w0, deltay		;

	mov deltax, w0
	asr w0, w0			;divide w0 by 2		
	neg w0, w0			;get -deltax
	mov w0, error		;save the error

	mov #1, w0
	mov w0, ystep		;set step to +1
	mov y0, w0			;
	mov y1, w1			;
	cpslt w0, w1		;compare, don't negate if y0<y1
	neg ystep			;

clearLinitLoop:
	mov y0, w2
	mov x0, w1

clearLloop:		;use w2 as y, use w1 as x
	push w2
	push w1
	cp0 steep
	bra z, clearLnorm

clearLsteep:
	bclr w4, #0
	mov w2, w0		;hold y
	mov w1, w2		;move x to y
	mov w0, w1		;move y to x
	call drawXY		;put the point
	goto clearLerrorCalc	;

clearLnorm:
	bclr w4, #0
	call drawXY
	;goto clearLerrorCalc

clearLerrorCalc:
	mov error, w0
	mov deltay, w1
	add w0, w1, w1
	mov w1, error

	pop w1			;retrieve x
	pop w2			;retrieve y
	
	cp0 error		;check for sign of error
	bra le, clearLloopCheck

	mov ystep, w0
	add w0, w2, w2	;add ystep to y
	mov deltax, w0	;
	sub error		;get new error

clearLloopCheck:
	inc w1, w1		;move to next x
	mov x1, w0
	cp w1, w0		;check to see if x > x1
	bra le, clearLloop 	;if less than or equal, do loop again

clearLdone:
	return				;otherwise done :)	
	