;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; icon functions
;
; 

.include "icons.inc"
.include "glcd.inc"
.include "p30fxxxx.inc"


.bss
page:		.space 2
addr:		.space 2
iconTbl:	.space 2
right:		.space 2



.text

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; putIcon
;
; takes icon number in w1, y start
; page in w2, x position
; in w3
;

putIcon:
	mov w2, w0			;put page into w0
	mov #LCD_page, w4	;make w0 a page setting command
	ior w4, w0, w0		;
	bset w0, #_cs1		;set this page on both chips
	bset w0, #_cs2		;
	mov w0, page		;save the page command for later use
iconPageSet:
	call gLCDcmd		;send the command
	call checkBusy		;wait for chips to be done
iconSideCheck:
	mov #64, w4
	mov w3, w0
	cp w3, w4				;see which side of screen to start on
	bra geu, iconRightSide	;start on right side
iconLeftSide:
	bclr right, #0
	mov #LCD_addr, w4
	ior w4, w0, w0			;set starting address command
	bset w0, #_cs1			;select cs1
	bclr w0, #_cs2			;
	mov w0, addr			;save the starting address
	call gLCDcmd
	call checkBusy
	goto iconLoop
iconRightSide:
	bset right, #0			;its the right side, so remember
	sub #64, w0				;subtract to correct address for r side
	mov #LCD_addr, w4
	ior w4, w0, w0
	bset w0, #_cs2
	bclr w0, #_cs1
	mov w0, addr
	call gLCDcmd
	call checkBusy
	;goto iconLoop
iconLoop:
	mov #tblpage(iconTable), w0
	mov w0, TBLPAG					;set up table
	mov #tbloffset(iconTable), w0	;
	sl w1, w1						;multiply icon number...
	sl w1, w1						;by 4
	add w1, w0, w0					;location of addr of table to read from
	tblrdl [w0], w6					;get offset of table (coolies)
	inc2 w0, w0
	tblrdl [w0], w0
	mov w0, TBLPAG					;set address for icon data
	mov #0, w7						;use as a counter for the page-turning loop
									
iconLoop1:
	mov #31, w0						;do the loop ten times
	do w0, iconLoopEnd				;stop loop at iconLoopEnd
	tblrdl [w6], w0					;get first two bytes
	and #0xff, w0
	
	btsc right, #0					;if on right side
	bset w0, #_cs2					;select chip 2
	btss right, #0					;if on left side
	bset w0, #_cs1					;then select chip 1
	
	call gLCDdata					;send the byte
	call checkBusy					;

	inc2 w6, w6						;move to next data

iconLoopEnd:
	nop

iconTurnPage:
	inc page
	mov page, w0
	inc w7, w7						;inc the loop counter
	cp w7, #4
	bra geu, iconDone

	btsc right, #0					;if on right side
	bset w0, #_cs2					;select chip 2
	btss right, #0					;if on left side
	bset w0, #_cs1					;then select chip 1

	call gLCDcmd
	call checkBusy

	mov addr, w0
	call gLCDcmd
	call checkBusy
	
	goto iconLoop1
iconDone:
	return
	