/* 
 * File:   rtc.h
 * Author: Zoli
 * Comments:
 * Revision history: 
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef DS1307_RTC_H
#define	DS1307_RTC_H

#include <xc.h> // include processor files - each processor file is guarded.  

// TODO Insert appropriate #include <>
#include <stdint.h>
#include <string.h>
#include <time.h>
#include "../mcc_generated_files/mcc.h" 
#include "../globals.h"
#include "../BitManipulation.h"
#include "rtc.h"
#include "i2c.h"
#include "lcd.h" 

// TODO Insert C++ class definitions if appropriate
typedef enum
{
    RTC_DISPLAY_LCD,
    RTC_DISPLAY_UART,
    RTC_DISPLAY_DATE,
    RTC_DISPLAY_TIME,
    RTC_DISPLAY_DATETIME,
} RTC_DISPLAY;


typedef union
{
    uint8_t v[7];
    struct
    {
        uint8_t sec;
        uint8_t min;
        uint8_t hour;
        uint8_t wday;
        uint8_t mday;
        uint8_t mon;
        uint8_t year;
    };
} RTC_TIME;

// TODO Insert declarations
#define RTC_ADDRESS             0x68

#define RTC_ADDRESS_SECONDS     0x00
#define RTC_ADDRESS_MINUTES     0x01
#define RTC_ADDRESS_HOURS       0x02
#define RTC_ADDRESS_DAY         0x03            // weekday
#define RTC_ADDRESS_DATE        0x04
#define RTC_ADDRESS_MONTH       0x05
#define RTC_ADDRESS_YEAR        0x06

#define RTC_HALT_BIT            0b10000000
#define RTC_24HOUR_BIT          0b01000000
#define RTC_12HOUR_PM_BIT       0b00100000
#define RTC_EPOCH               2000

#define RTC_ADDRESS_CONTROL     0x07
#define RTC_ADDRESS_RAM         0x08
#define RTC_ADDRESS_RAMEND      0x3F            // 0x08-0x3F
#define RTC_ADDRESS_VCARD       RTC_ADDRESS_RAM

// control
#define RTC_CONTROL_1HZ         0x00
#define RTC_CONTROL_4096HZ      0x01
#define RTC_CONTROL_8192HZ      0x02
#define RTC_CONTROL_32768HZ     0x03
#define RTC_CONTROL_SQWE_ON     0x10
#define RTC_CONTROL_SQWE_OFF    0x00
#define RTC_CONTROL_OUT_HIGH    0x80
#define RTC_CONTROL_OUT_LOW     0x00

// rtc requestblock bytes
#define RTCRB_SECONDS           0
#define RTCRB_MINUTES           1
#define RTCRB_HOURS             2
#define RTCRB_DAY               3
#define RTCRB_DATE              4
#define RTCRB_MONTH             5    
#define RTCRB_YEAR              6
#define RTCRB_CONTROL           7

// setting
#define RTC_USE_12HOURS

#define USE_DS1307_VCARD
#define RTC_VCARD_SIZE          25

// macros
#define Dec2Bcd(val)            ((val/10*16) + (val%10))        // (((val/10)<<4)|(val%10))
#define Bcd2Dec(val)            ((val/16*10) + (val%16))        // (((val>>4)*10)+(val&0xF))
#define weekDay(y, m, d)        (((23*m/9+d+4+y/4-y/100+y/400)%7)+1)
#define isLeapYear(y)           (((y%4==0)&&(y%100!=0))||(y%400==0))

typedef enum
{
    RTCMODE_24HOURS,
    RTCMODE_12HOURS
} RTC_MODE_T;

// struct tm rtcTime;
// RTC_MODE_T rtc_mode;
const uint8_t DayofMonth[13] = { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
char weekDayName[7][18] = { "vas\0xE1rnap", "h\0xE9tf\0xF5", "kedd",
    "szerda", "cs\0xFCt\0xF6rt\0xF6k", "p\0xE9ntek", "szombat" };


// Comment a function and leverage automatic documentation with slash star star
/**
    <p><b>Function prototype:</b></p>
    <p><b>Summary:</b></p>
    <p><b>Description:</b></p>
    <p><b>Precondition:</b></p>
    <p><b>Parameters:</b></p>
    <p><b>Returns:</b></p>
    <p><b>Example:</b></p>
    <code>
    </code>
    <p><b>Remarks:</b></p>
 */
// TODO Insert declarations or function prototypes (right here) to leverage 
// live documentation
void RTC_reset(void);
void RTC_initialize(bool);
void RTC_Start(bool);
void  RTC_setMode(RTC_MODE_T mode);
void RTC_setControl(uint8_t ctrlByte);
void RTC_setDateTime(struct tm dateTime);
void RTC_getDateTime(void);
void RTC_writeVcard(uint8_t*);
void RTC_getVcard(uint8_t*);
// in rtc_functions
void RTC_shiftRtc(void);
void RTC_display_to_LCD( RTC_DISPLAY );
void RTC_display_to_UART( RTC_DISPLAY );


#endif	/* DS1307_RTC_H */

