/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.77
        Device            :  PIC18F25K50
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.05 and above
        MPLAB 	          :  MPLAB X 5.20	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set SDA1 aliases
#define SDA1_TRIS                 TRISBbits.TRISB0
#define SDA1_LAT                  LATBbits.LATB0
#define SDA1_PORT                 PORTBbits.RB0
#define SDA1_WPU                  WPUBbits.WPUB0
#define SDA1_ANS                  ANSELBbits.ANSB0
#define SDA1_SetHigh()            do { LATBbits.LATB0 = 1; } while(0)
#define SDA1_SetLow()             do { LATBbits.LATB0 = 0; } while(0)
#define SDA1_Toggle()             do { LATBbits.LATB0 = ~LATBbits.LATB0; } while(0)
#define SDA1_GetValue()           PORTBbits.RB0
#define SDA1_SetDigitalInput()    do { TRISBbits.TRISB0 = 1; } while(0)
#define SDA1_SetDigitalOutput()   do { TRISBbits.TRISB0 = 0; } while(0)
#define SDA1_SetPullup()          do { WPUBbits.WPUB0 = 1; } while(0)
#define SDA1_ResetPullup()        do { WPUBbits.WPUB0 = 0; } while(0)
#define SDA1_SetAnalogMode()      do { ANSELBbits.ANSB0 = 1; } while(0)
#define SDA1_SetDigitalMode()     do { ANSELBbits.ANSB0 = 0; } while(0)

// get/set SCL1 aliases
#define SCL1_TRIS                 TRISBbits.TRISB1
#define SCL1_LAT                  LATBbits.LATB1
#define SCL1_PORT                 PORTBbits.RB1
#define SCL1_WPU                  WPUBbits.WPUB1
#define SCL1_ANS                  ANSELBbits.ANSB1
#define SCL1_SetHigh()            do { LATBbits.LATB1 = 1; } while(0)
#define SCL1_SetLow()             do { LATBbits.LATB1 = 0; } while(0)
#define SCL1_Toggle()             do { LATBbits.LATB1 = ~LATBbits.LATB1; } while(0)
#define SCL1_GetValue()           PORTBbits.RB1
#define SCL1_SetDigitalInput()    do { TRISBbits.TRISB1 = 1; } while(0)
#define SCL1_SetDigitalOutput()   do { TRISBbits.TRISB1 = 0; } while(0)
#define SCL1_SetPullup()          do { WPUBbits.WPUB1 = 1; } while(0)
#define SCL1_ResetPullup()        do { WPUBbits.WPUB1 = 0; } while(0)
#define SCL1_SetAnalogMode()      do { ANSELBbits.ANSB1 = 1; } while(0)
#define SCL1_SetDigitalMode()     do { ANSELBbits.ANSB1 = 0; } while(0)

// get/set RB2 procedures
#define RB2_SetHigh()            do { LATBbits.LATB2 = 1; } while(0)
#define RB2_SetLow()             do { LATBbits.LATB2 = 0; } while(0)
#define RB2_Toggle()             do { LATBbits.LATB2 = ~LATBbits.LATB2; } while(0)
#define RB2_GetValue()              PORTBbits.RB2
#define RB2_SetDigitalInput()    do { TRISBbits.TRISB2 = 1; } while(0)
#define RB2_SetDigitalOutput()   do { TRISBbits.TRISB2 = 0; } while(0)
#define RB2_SetPullup()             do { WPUBbits.WPUB2 = 1; } while(0)
#define RB2_ResetPullup()           do { WPUBbits.WPUB2 = 0; } while(0)
#define RB2_SetAnalogMode()         do { ANSELBbits.ANSB2 = 1; } while(0)
#define RB2_SetDigitalMode()        do { ANSELBbits.ANSB2 = 0; } while(0)

// get/set LED_GREEN aliases
#define LED_GREEN_TRIS                 TRISBbits.TRISB4
#define LED_GREEN_LAT                  LATBbits.LATB4
#define LED_GREEN_PORT                 PORTBbits.RB4
#define LED_GREEN_WPU                  WPUBbits.WPUB4
#define LED_GREEN_ANS                  ANSELBbits.ANSB4
#define LED_GREEN_SetHigh()            do { LATBbits.LATB4 = 1; } while(0)
#define LED_GREEN_SetLow()             do { LATBbits.LATB4 = 0; } while(0)
#define LED_GREEN_Toggle()             do { LATBbits.LATB4 = ~LATBbits.LATB4; } while(0)
#define LED_GREEN_GetValue()           PORTBbits.RB4
#define LED_GREEN_SetDigitalInput()    do { TRISBbits.TRISB4 = 1; } while(0)
#define LED_GREEN_SetDigitalOutput()   do { TRISBbits.TRISB4 = 0; } while(0)
#define LED_GREEN_SetPullup()          do { WPUBbits.WPUB4 = 1; } while(0)
#define LED_GREEN_ResetPullup()        do { WPUBbits.WPUB4 = 0; } while(0)
#define LED_GREEN_SetAnalogMode()      do { ANSELBbits.ANSB4 = 1; } while(0)
#define LED_GREEN_SetDigitalMode()     do { ANSELBbits.ANSB4 = 0; } while(0)

// get/set LED_RED aliases
#define LED_RED_TRIS                 TRISCbits.TRISC1
#define LED_RED_LAT                  LATCbits.LATC1
#define LED_RED_PORT                 PORTCbits.RC1
#define LED_RED_SetHigh()            do { LATCbits.LATC1 = 1; } while(0)
#define LED_RED_SetLow()             do { LATCbits.LATC1 = 0; } while(0)
#define LED_RED_Toggle()             do { LATCbits.LATC1 = ~LATCbits.LATC1; } while(0)
#define LED_RED_GetValue()           PORTCbits.RC1
#define LED_RED_SetDigitalInput()    do { TRISCbits.TRISC1 = 1; } while(0)
#define LED_RED_SetDigitalOutput()   do { TRISCbits.TRISC1 = 0; } while(0)

// get/set LED_YELLOW aliases
#define LED_YELLOW_TRIS                 TRISCbits.TRISC2
#define LED_YELLOW_LAT                  LATCbits.LATC2
#define LED_YELLOW_PORT                 PORTCbits.RC2
#define LED_YELLOW_ANS                  ANSELCbits.ANSC2
#define LED_YELLOW_SetHigh()            do { LATCbits.LATC2 = 1; } while(0)
#define LED_YELLOW_SetLow()             do { LATCbits.LATC2 = 0; } while(0)
#define LED_YELLOW_Toggle()             do { LATCbits.LATC2 = ~LATCbits.LATC2; } while(0)
#define LED_YELLOW_GetValue()           PORTCbits.RC2
#define LED_YELLOW_SetDigitalInput()    do { TRISCbits.TRISC2 = 1; } while(0)
#define LED_YELLOW_SetDigitalOutput()   do { TRISCbits.TRISC2 = 0; } while(0)
#define LED_YELLOW_SetAnalogMode()      do { ANSELCbits.ANSC2 = 1; } while(0)
#define LED_YELLOW_SetDigitalMode()     do { ANSELCbits.ANSC2 = 0; } while(0)

// get/set RC6 procedures
#define RC6_SetHigh()            do { LATCbits.LATC6 = 1; } while(0)
#define RC6_SetLow()             do { LATCbits.LATC6 = 0; } while(0)
#define RC6_Toggle()             do { LATCbits.LATC6 = ~LATCbits.LATC6; } while(0)
#define RC6_GetValue()              PORTCbits.RC6
#define RC6_SetDigitalInput()    do { TRISCbits.TRISC6 = 1; } while(0)
#define RC6_SetDigitalOutput()   do { TRISCbits.TRISC6 = 0; } while(0)
#define RC6_SetAnalogMode()         do { ANSELCbits.ANSC6 = 1; } while(0)
#define RC6_SetDigitalMode()        do { ANSELCbits.ANSC6 = 0; } while(0)

// get/set RC7 procedures
#define RC7_SetHigh()            do { LATCbits.LATC7 = 1; } while(0)
#define RC7_SetLow()             do { LATCbits.LATC7 = 0; } while(0)
#define RC7_Toggle()             do { LATCbits.LATC7 = ~LATCbits.LATC7; } while(0)
#define RC7_GetValue()              PORTCbits.RC7
#define RC7_SetDigitalInput()    do { TRISCbits.TRISC7 = 1; } while(0)
#define RC7_SetDigitalOutput()   do { TRISCbits.TRISC7 = 0; } while(0)
#define RC7_SetAnalogMode()         do { ANSELCbits.ANSC7 = 1; } while(0)
#define RC7_SetDigitalMode()        do { ANSELCbits.ANSC7 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/