/* 
 * File:   BitManipulation.h
 * Author: Ponicsn Zoltn
 * Comments: 
 * Revision history: 
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef _BITMANIPULATON_H
#define	_BITMANIPULATON_H

#include <xc.h> // include processor files - each processor file is guarded.  

#define BitSet( val, bitnum )       ( val |= 1UL << bitnum )
#define BitClear( val, bitnum )     ( val &= 1UL << bitnum )
#define BitToggle( val, bitnum )    ( val ^= 1UL << bitnum )
#define BitTest( val, bitnum )      ( val >> bitnum ) & 1UL
//!!!!!!
#define BitCange( val, bitnum )     ( val ^= (-bitnum ^ val ) & ( 1UL << bitnum ) )

#endif	/* _BITMANIPULATON_H */

