/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.77
        Device            :  PIC18F25K50
        Driver Version    :  2.00
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

/*
 * jra gondolt verzi 
 */
#include <stdlib.h>
#include <string.h>
#include "mcc_generated_files/mcc.h"
#include "globals.h"
#include "modules/lcd.h"
#include "modules/rtc.h"
#include "modules/am2320.h"

#define AM2320_READ_FREQUENCY       6


bool RTC_DateTimeChanged;
uint8_t EXT_INT2_Count = 0;
// ms C vagy H file-ban deklarlva
extern uint8_t ustomChar[];     // lcd.h
extern float fTemperature;
extern float fHumidity;


void EXT_INT2_Main_ISR()
{
    LED_RED_Toggle();
    // RTC_shiftRtc();
    RTC_DateTimeChanged = true;
}

/*
                         Main application
 */
void main(void)
{
    char TemperatureStr[ LCD_COLS + 1 ] = { 0 };
    char HumidityStr[ LCD_COLS + 1 ] = { 0 };
    char Am2320Str[ LCD_COLS +1 ] = { 0 };
    
    // Initialize the device
    SYSTEM_Initialize();
    // Disable the Global Interrupts
    INTERRUPT_GlobalInterruptDisable();
    // Enable the peripherial Interrupss
    INTERRUPT_PeripheralInterruptEnable();

    // LCD initialize
    LCD_initialize( LCD_ADDRESS, LCD_COLS, LCD_ROWS );
    __delay_ms(200);
    LCD_backlight( true );
//    LCD_load_customchars( customChar, 0, 8 );
    __delay_ms(100);
    LCD_clear();
    LCD_backlight( true );
    LCD_send_string( "|d|90|....................", 1 );
    __delay_ms(400);
    LCD_send_string( "|c|Ponics\0xE1n Zolt\0xE1n", 2 );
    __delay_ms(200);
    LCD_send_string( "|c|ZSoft  2019", 4 );
    __delay_ms(3000);

    // initialize RTC
    RTC_initialize( false );
    RTC_reset();
    rtcTime.tm_sec  = 0;
    rtcTime.tm_min  = 50;
    rtcTime.tm_hour = 23;
    rtcTime.tm_mday = 8;
    rtcTime.tm_mon  = 12;
    rtcTime.tm_year = 2019;
    rtcTime.tm_wday = weekDay( rtcTime.tm_year, rtcTime.tm_mon, rtcTime.tm_mday );
    RTC_setDateTime( rtcTime );    //    RTC_setMode( RTCMODE_24HOURS );    
    RTC_setControl( RTC_CONTROL_1HZ | RTC_CONTROL_SQWE_ON );

    INT2_SetInterruptHandler( EXT_INT2_Main_ISR );
    INTERRUPT_GlobalInterruptEnable();
    
    LCD_clearLine(1);
    LCD_clearLine( 2 );
    
    while (1)
    {
        if( RTC_DateTimeChanged ) 
        {
            RTC_DateTimeChanged = false;
            EXT_INT2_Count++;
/*
            LED_YELLOW_SetHigh();
            RTC_getDateTime();
            LED_YELLOW_SetLow();
            LED_RED_SetHigh();
            RTC_display_to_LCD( RTC_DISPLAY_DATETIME );
            LED_RED_SetLow();
 */
            if( EXT_INT2_Count == 5 ) 
            {
                LED_GREEN_SetHigh();
                AM2320_read( AM2320_READ_TEMP_HUM );
                sprintf( Am2320Str, "Hum  : %5.1f %% RH", fHumidity );
                LCD_send_string( Am2320Str, 3 );
                sprintf( Am2320Str, "Temp : %5.1f C", fTemperature );
                LCD_send_string( Am2320Str, 4 );
                LED_GREEN_SetLow();
            }
            else if( EXT_INT2_Count == 6 ) 
            {
                AM2320_read( AM2320_READ_DEVICEID );
                sprintf( Am2320Str, "ID: %d", AM2320_model );
                LCD_send_string( Am2320Str, 1 );
                sprintf( Am2320Str, "Ver: %d", AM2320_version );
                LCD_send_string( Am2320Str, 2 );
                EXT_INT2_Count = 0;
            }
        }
        // Add your application code
    }
}

/**
 End of File
*/