/*
   File:    AM2320.c
   Author: 
   Description: AOSONG AM2320 digital Temperature & Humidity sensor I2C
                i2c maximum rate 100kHz (standard mode)
 * https://github.com/adafruit/Adafruit_AM2320/blob/master/Adafruit_AM2320.cpp
 */

#include "am2320.h"
#include "lcd.h"


void AM2320_initialize( void )
{
    // mivel nem kell inicializlni, elg csak a kezdrtkeket kinullzni
    // ha mindkett 0, nincs kirtkelhet adat
    // hogy mndkett 0 legyen annak a relis eslye is 0 :-)
    fHumidity = 0.0;
    fTemperature = 0.0;
}


bool AM2320_read( AM2320_READ_T readdata )
{
    I2C1_MESSAGE_STATUS status = I2C1_MESSAGE_PENDING;
    uint8_t wdata[3] = { AM2320_READ_REGISTER, 0, 4 };
    uint8_t *p = 0; 
    uint8_t i = 0;
    uint16_t CRC;
    AM2320_RESPONSE rdata;
    
    switch( readdata ) {
        case AM2320_READ_TEMP_HUM:  
            wdata[1] = AM2320_HUMIDIY_HIGH;
            break;
        case AM2320_READ_DEVICEID:  
            wdata[1] = AM2320_DEVICE_ID1;
            break;
        case AM2320_READ_MODELINFO: 
            wdata[1] = AM2320_MODEL_HIGH; 
            wdata[2] = 3; 
            break;
        case AM2320_READ_USERDATA:
            wdata[1] = AM2320_USER_REG1_HIGH; 
            break;
        default: ;
    };
        
    // AM232x specialits
    // Mindg alv mdban van, ezrt breszteni kell
    for( i = 0; i < AM2320_WAKEUP_RETRY_MAX; i++ ) {
        I2C1_MasterWrite( p, 0, AM2320_ADDRESS, &status );
        __delay_us( WAIT_FOR_WAKEUP_US );
        while( status == I2C1_MESSAGE_PENDING );
        if( status == I2C1_MESSAGE_COMPLETE ) break;
    }
    // ha eddig nem vlaszolt valszn mr nem is fog
    if( status == I2C1_MESSAGE_COMPLETE ) {
        __delay_us( WAIT_AFTER_SEND_COMMAND_US );
        for( i = 0; i < AM2320_RETRY_MAX; i++ ) {
            I2C1_MasterWrite( wdata, 3, AM2320_ADDRESS, &status );
            while( status == I2C1_MESSAGE_PENDING );
            if( status == I2C1_MESSAGE_COMPLETE )
            {
                __delay_us( WAIT_AFTER_SEND_COMMAND_US );
                I2C1_MasterRead( rdata.v, 8, AM2320_ADDRESS, &status );
                while( status == I2C1_MESSAGE_PENDING );
                if( status == I2C1_MESSAGE_COMPLETE )
                {
                    if( readdata == AM2320_READ_MODELINFO ) // 6-7. byte
                        CRC = rdata.MODEL.CRC;
                    else                                    // 7-8. byte
                        CRC = rdata.TEMP_HUM.CRC;
                    if ( CRC == AM2320_calcCRC( rdata.v, wdata[2] + 2 ) )
                    {
                        switch( readdata ) {
                            case AM2320_READ_TEMP_HUM:
                                rdata.TEMP_HUM.Temperature = swap_byte( rdata.TEMP_HUM.Temperature );
                                if(rdata.TEMP_HUM.Temperature & 0x8000){
                                    fTemperature = -rdata.TEMP_HUM.Temperature & 0x7fff;
                                }
                                else 
                                {
                                    fTemperature = rdata.TEMP_HUM.Temperature;
                                }
                                fTemperature = (float)rdata.TEMP_HUM.Temperature / 10.0;

                                rdata.TEMP_HUM.Humidity = swap_byte( rdata.TEMP_HUM.Humidity );
                                fHumidity = (float)rdata.TEMP_HUM.Humidity / 10.0;
                                break;    

                            case AM2320_READ_DEVICEID:
                                AM2320_id = rdata.DEV_ID.DeviceID;
                                break;
                            case AM2320_READ_MODELINFO:
                                AM2320_model = rdata.MODEL.Model;
                                AM2320_version = rdata.MODEL.Version;
                                break;
                            case AM2320_READ_USERDATA:
                                AM2320_userdata = rdata.USER_DATA.UserData;
                                break;
                            default: ;                                
                        }
                        return true;
                    }
                }
            }
        }
    }
    return false;
}

/**
uint32_t AM2320_getDeviceID( void )
{
    I2C1_MESSAGE_STATUS status = I2C1_MESSAGE_PENDING;
    //                   function code,        starting address,    read number of register
    uint8_t wdata[3] = { AM2320_READ_REGISTER, AM2320_DEVICE_ID1, 8 }; 
    AM2320_RESPONSE rdata;
    
    I2C1_MasterWrite( &wdata[0], 3, AM2320_ADDRESS, &status );
    while( status == I2C1_MESSAGE_PENDING );
    if( status == I2C1_MESSAGE_COMPLETE )
    {
        I2C1_MasterRead( rdata.v, 7, AM2320_ADDRESS, &status );
        while( status == I2C1_MESSAGE_PENDING );
        if( status == I2C1_MESSAGE_COMPLETE ) 
        {
            if ( rdata.DEV_ID.CRC == AM2320_calcCRC( rdata.v, 6 ) )
            {
                AM2320_id = rdata.DEV_ID.DeviceID;
                return rdata.DEV_ID.DeviceID;
            }
        }
    }
    return 0;
}
**/

uint16_t AM2320_calcCRC( uint8_t *ptr, uint8_t length )
{
    uint16_t crc = 0xFFFF;
    uint8_t s = 0x00;

    while( length-- )
    {
        crc ^= *ptr++;
        for( s = 0; s < 8; s++ )
        {
            if((crc & 0x01) != 0)
            {
                crc >>= 1;
                crc ^= 0xA001;
            }
            else
            {
                crc >>= 1;
            }
        }
    }

    return crc;
}


void AM2320_display( bool newdata )
{
    // char lcdtext[ 25 ];
    
    //LCD_clearLine( 3 );
    // sprintf( lcdtext, "%3.1f  %5.1f", Temperature, Humidity );
    // LCD_send_string( "|c|T  H", 4 );
    //LCD_clearLine( 4 );
    //__delay_ms( 3000 );
}