/* 
 * File:   
 * Author: 
 * Comments:
 * Revision history: 
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef AM2320_SENSOR_H
#define	AM2320_SENSOR_H

#include <xc.h> // include processor files - each processor file is guarded.  

// TODO Insert appropriate #include <>
#include <stdint.h>
#include "../mcc_generated_files/mcc.h"

typedef union
{
    uint16_t Val;
    uint8_t v[2];
    struct
    {
        uint8_t HighByte;
        uint8_t LowByte;
    };
} WORD;


typedef union
{
    uint32_t Val;
    uint8_t v[4];
    struct
    {
        WORD HighWord;
        WORD LowWord;
    };
} DWORD;


typedef union
{
    uint8_t v[8];
    struct
    {
        uint8_t  FunctionCode;
        uint8_t  DataLenght;
        uint16_t Humidity;
        uint16_t Temperature;
        uint16_t CRC;
    } TEMP_HUM;
    struct
    {
        uint8_t  FunctionCode;
        uint8_t  DataLenght;
        uint32_t DeviceID;
        uint16_t CRC;
    } DEV_ID;
    struct
    {
        uint8_t  FunctionCode;
        uint8_t  DataLenght;
        uint16_t Model;
        uint8_t  Version;
        uint16_t CRC;
        uint8_t  unused;
    } MODEL;
    struct
    {
        uint8_t  FunctionCode;
        uint8_t  DataLenght;
        uint32_t UserData;
        uint16_t CRC;
    } USER_DATA;
} AM2320_RESPONSE;


typedef enum 
{
    AM2320_READ_TEMP_HUM,
    AM2320_READ_DEVICEID,
    AM2320_READ_MODELINFO,
    AM2320_READ_USERDATA
} AM2320_READ_T;


// TODO Insert C++ class definitions if appropriate

// TODO Insert declarations
#define AM2320_ADDRESS              0x5C    // 0xB8


#define WAIT_FOR_WAKEUP_US          800
#define WAIT_AFTER_SEND_COMMAND_US  1500
#define WAIT_FOR_ANSWER_US          30           

#define AM2320_WAKEUP_RETRY_MAX     3
#define AM2320_RETRY_MAX            5

// function code
#define AM2320_READ_REGISTER        0x03
#define AM2320_WRITE_REGISTER       0x10

// register address
#define AM2320_HUMIDIY_HIGH         0x00
#define AM2320_HUIDITY_LOW          0x01
#define AM2320_TEMP_HIGH            0x02
#define AM2320_TEMP_LOW             0x03
#define AM2320_MODEL_HIGH           0x08
#define AM2320_MODEL_LOW            0x09
#define AM2320_MODEL_VERSION        0x0A
#define AM2320_DEVICE_ID1           0x0B
#define AM2320_DEVICE_ID2           0x0C
#define AM2320_DEVICE_ID3           0x0D
#define AM2320_DEVICE_ID4           0x0E
#define AM2320_STATUS               0x0F
#define AM2320_USER_REG1_HIGH       0x10
#define AM2320_USER_REG1_LOW        0x11
#define AM2320_USER_REG2_HIGH       0x12
#define AM2320_USER_REG2_LOW        0x13
// RESERVED                         0x04-0x07, 0x14-0x1C

// macro
#define swap_byte( b16 )            ((( b16 << 8) & 0xFFFF ) | (( b16 >> 8 ) & 0xFFFF ))


float fTemperature;
float fHumidity;
uint16_t AM2320_crc;
uint16_t AM2320_model;
uint8_t  AM2320_version;
uint32_t AM2320_id;
uint32_t AM2320_userdata;

// Comment a function and leverage automatic documentation with slash star star
/**
    <p><b>Function prototype:</b></p>
    <p><b>Summary:</b></p>
    <p><b>Description:</b></p>
    <p><b>Precondition:</b></p>
    <p><b>Parameters:</b></p>
    <p><b>Returns:</b></p>
    <p><b>Example:</b></p>
    <code>
 
    </code>

    <p><b>Remarks:</b></p>
 */
// TODO Insert declarations or function prototypes (right here) to leverage 
// live documentation


/**
    <p><b>Function prototype:</b></p>
 
    <p><b>Summary:</b></p>

    <p><b>Description:</b></p>

    <p><b>Precondition:</b></p>

    <p><b>Parameters:</b></p>

    <p><b>Returns:</b></p>

    <p><b>Example:</b></p>
    <code>
 
    </code>

    <p><b>Remarks:</b></p>
 */

uint32_t AM2320_getDeviceID( void );

/**
    <p><b>Function prototype:</b></p>
 
    <p><b>Summary:</b></p>

    <p><b>Description:</b></p>

    <p><b>Precondition:</b></p>

    <p><b>Parameters:</b></p>

    <p><b>Returns:</b></p>

    <p><b>Example:</b></p>
    <code>
 
    </code>

    <p><b>Remarks:</b></p>
 */

bool AM2320_read( AM2320_READ_T readdata );

uint16_t AM2320_calcCRC( uint8_t *ptr, uint8_t length );

uint32_t AM2320_displayID( void );


#endif	/* AM2320_SENSOR_H */

