; Source created with Parsic Version 4.16.9.22

; at              : 2019.12.04. 16:32:08


; Project File    : C:\2018pic\AKKUTOLTKST\5PWM\5PWM.pic

; Project Version : 1.0.2

; Created         : 2019.12.04. 13:33:18

; Last change     : 2019.12.04. 15:37:42

	PROCESSOR 18F25K80
	INCLUDE P18F25K80.INC
	RADIX DEC
	__IDLOCS _IDLOC0,H'01'
	__IDLOCS _IDLOC1,H'00'
	__IDLOCS _IDLOC2,H'02'
	ERRORLEVEL -230
	__CONFIG _CONFIG1L,H'B3';179
	__CONFIG _CONFIG1H,H'28';40
	__CONFIG _CONFIG2L,H'86';134
	__CONFIG _CONFIG2H,H'90';144
	__CONFIG _CONFIG3H,H'FE';254
	__CONFIG _CONFIG4L,H'EE';238
	__CONFIG _CONFIG5L,H'FF';255
	__CONFIG _CONFIG5H,H'FF';255
	__CONFIG _CONFIG6L,H'FF';255
	__CONFIG _CONFIG6H,H'FF';255
	__CONFIG _CONFIG7L,H'FF';255
	__CONFIG _CONFIG7H,H'FF';255
	ERRORLEVEL +230
; missing constants

ZERO	EQU Z	; ZERO-Flag
CARRY	EQU C	; CARRY-Flag
SYSTICKS	EQU	1000000

; variable

SYS_FSAV	EQU 0	; located in Bank ACCESS BANK
SYS_FSAV_1	EQU 1	; located in Bank ACCESS BANK
_FD1	EQU 2	; located in Bank ACCESS BANK
ADC0	EQU 3	; located in Bank ACCESS BANK
ADC1	EQU 4	; located in Bank ACCESS BANK
ADC1_1	EQU 5	; located in Bank ACCESS BANK
ADC2	EQU 6	; located in Bank ACCESS BANK
ADC2_1	EQU 7	; located in Bank ACCESS BANK
ADC3	EQU 8	; located in Bank ACCESS BANK
ADC3_1	EQU 9	; located in Bank ACCESS BANK
ADC4	EQU 10	; located in Bank ACCESS BANK
ADC4_1	EQU 11	; located in Bank ACCESS BANK
SYS_TMP1	EQU 12	; located in Bank ACCESS BANK
SYS_TMP2	EQU 13	; located in Bank ACCESS BANK
S0	EQU 14	; located in Bank ACCESS BANK
TR32	EQU 15	; located in Bank ACCESS BANK
TR32_1	EQU 16	; located in Bank ACCESS BANK
MF75	EQU 17	; located in Bank ACCESS BANK
MF75_1	EQU 18	; located in Bank ACCESS BANK

; disable warning for Bankswitching
	ERRORLEVEL -302
; disable warning for Pageswitching
	ERRORLEVEL -306
; disable warning HIGH operator was larger than 0xFFFF
	ERRORLEVEL -311

;------------------------------------------------------------------------------
; Program start
;------------------------------------------------------------------------------
	ORG 0

	GOTO SYS_INIT
	NOP
	NOP

;------------------------------------------------------------------------------
; Interrupt-address
;------------------------------------------------------------------------------

	BTFSS INTCON,T0IF,A
	BRA NOTIMERINTERRUPT

	BCF INTCON,T0IF,A
; add 9 to timer0, so the interrupt occures after 250 ticks, instead 256
	MOVLW 9
	ADDWF TMR0,F,A	; W + f -> f

	INCFSZ TR32,F,A	; f + 1 -> f
	BRA TR32_NEXT

	INCF TR32_1,F,A	; f + 1 -> f

TR32_NEXT

	INCFSZ MF75,F,A	; f + 1 -> f
	BRA MF75_NEXT

	INCF MF75_1,F,A	; f + 1 -> f

MF75_NEXT



NOTIMERINTERRUPT


EXITINT

	RETFIE FAST	; FAST = restore STATUS,BSR,W-register, enable GIE/GIEH, PEIE/GIEL

;------------------------------------------------------------------------------
; Subroutines
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Read  -> AN0
;------------------------------------------------------------------------------

READ_AN0

	MOVLB 15	; bank 15
	BSF ANCON0,0
	MOVLW B'00000000'
	MOVWF ADCON1,A
	MOVLW B'00000011'
	MOVWF ADCON2,A

	MOVLW B'00000001'
	MOVWF ADCON0,A



	MOVLW 7
	MOVWF SYS_TMP1,A

SYS_ADC0_0

	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA SYS_ADC0_0

; start convert
	BSF ADCON0,GO,A

SYS_ADC1_0

	BTFSC ADCON0,GO,A
	BRA SYS_ADC1_0

	MOVF ADRESH,W,A
	MOVWF ADC0,A

; Shut-off
	CLRF ADCON0,A	; 0 -> f

	RETURN

;------------------------------------------------------------------------------
; Read  -> AN1
;------------------------------------------------------------------------------

READ_AN1

	MOVLB 15	; bank 15
	BSF ANCON0,1
	MOVLW B'00000000'
	MOVWF ADCON1,A
	MOVLW B'00000011'
	MOVWF ADCON2,A

	MOVLW B'00000101'
	MOVWF ADCON0,A

; Right Justified
	BSF ADCON2,ADFM,A


	MOVLW 7
	MOVWF SYS_TMP1,A

SYS_ADC0_1

	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA SYS_ADC0_1

; start convert
	BSF ADCON0,GO,A

SYS_ADC1_1

	BTFSC ADCON0,GO,A
	BRA SYS_ADC1_1

	MOVF ADRESL,W,A
	MOVWF ADC1,A
	MOVF ADRESH,W,A
	MOVWF ADC1_1,A

; Shut-off
	CLRF ADCON0,A	; 0 -> f

	RETURN

;------------------------------------------------------------------------------
; Read  -> AN2
;------------------------------------------------------------------------------

READ_AN2

	MOVLB 15	; bank 15
	BSF ANCON0,2
	MOVLW B'00000000'
	MOVWF ADCON1,A
	MOVLW B'00000011'
	MOVWF ADCON2,A

	MOVLW B'00001001'
	MOVWF ADCON0,A

; Right Justified
	BSF ADCON2,ADFM,A


	MOVLW 7
	MOVWF SYS_TMP1,A

SYS_ADC0_2

	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA SYS_ADC0_2

; start convert
	BSF ADCON0,GO,A

SYS_ADC1_2

	BTFSC ADCON0,GO,A
	BRA SYS_ADC1_2

	MOVF ADRESL,W,A
	MOVWF ADC2,A
	MOVF ADRESH,W,A
	MOVWF ADC2_1,A

; Shut-off
	CLRF ADCON0,A	; 0 -> f

	RETURN

;------------------------------------------------------------------------------
; Read  -> AN3
;------------------------------------------------------------------------------

READ_AN3

	MOVLB 15	; bank 15
	BSF ANCON0,3
	MOVLW B'00000000'
	MOVWF ADCON1,A
	MOVLW B'00000011'
	MOVWF ADCON2,A

	MOVLW B'00001101'
	MOVWF ADCON0,A

; Right Justified
	BSF ADCON2,ADFM,A


	MOVLW 7
	MOVWF SYS_TMP1,A

SYS_ADC0_3

	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA SYS_ADC0_3

; start convert
	BSF ADCON0,GO,A

SYS_ADC1_3

	BTFSC ADCON0,GO,A
	BRA SYS_ADC1_3

	MOVF ADRESL,W,A
	MOVWF ADC3,A
	MOVF ADRESH,W,A
	MOVWF ADC3_1,A

; Shut-off
	CLRF ADCON0,A	; 0 -> f

	RETURN

;------------------------------------------------------------------------------
; Read  -> AN4
;------------------------------------------------------------------------------

READ_AN4

	MOVLB 15	; bank 15
	BSF ANCON0,4
	MOVLW B'00000000'
	MOVWF ADCON1,A
	MOVLW B'00000011'
	MOVWF ADCON2,A

	MOVLW B'00010001'
	MOVWF ADCON0,A

; Right Justified
	BSF ADCON2,ADFM,A


	MOVLW 7
	MOVWF SYS_TMP1,A

SYS_ADC0_4

	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA SYS_ADC0_4

; start convert
	BSF ADCON0,GO,A

SYS_ADC1_4

	BTFSC ADCON0,GO,A
	BRA SYS_ADC1_4

	MOVF ADRESL,W,A
	MOVWF ADC4,A
	MOVF ADRESH,W,A
	MOVWF ADC4_1,A

; Shut-off
	CLRF ADCON0,A	; 0 -> f

	RETURN

;------------------------------------------------------------------------------
; Initialisation
;------------------------------------------------------------------------------

SYS_INIT

	CLRF INTCON,A	; 0 -> f

; Set internal oscillator
	MOVF OSCCON,W,A
	ANDLW 143
	IORLW 80
	MOVWF OSCCON,A

; A/D off
	MOVLW 0
	MOVWF ADCON1,A
	CLRF ADCON2,A	; 0 -> f
	MOVLB 15	; bank 15
	CLRF ANCON0	; 0 -> f
	CLRF ANCON1	; 0 -> f


; Set output before direction

	MOVLW B'00000000'
	MOVWF PORTA,A

	MOVLW B'00000000'
	MOVWF PORTB,A

	MOVLW B'00000000'
	MOVWF PORTC,A

; set direction

	MOVLW B'11101111'
	MOVWF TRISA,A

	MOVLW B'11000001'
	MOVWF TRISB,A

	MOVLW B'00111011'
	MOVWF TRISC,A


; init some registers

; Timer 0
	MOVLW 223
	MOVWF T0CON,A
	BSF INTCON,T0IE,A

	CLRF BAUDCON1,A	; 0 -> f

	CLRF BAUDCON2,A	; 0 -> f

;------------------------------------------------------------------------------
; Clear RAM
;------------------------------------------------------------------------------

; Clear from $000 to $E40

	LFSR 0,0

SYSClearRAM1

	CLRF POSTINC0,A	; 0 -> f
	MOVLW 14
	SUBWF FSR0H,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA SYSClearRAM1
	MOVLW 65
	SUBWF FSR0L,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA SYSClearRAM1

;------------------------------------------------------------------------------

; init vars



	MOVLW 255
	MOVWF PR2,A
	MOVLW 12
	MOVLB 15	; bank 15
	MOVWF CCP5CON
	CLRF CCPR5L	; 0 -> f
	MOVLW 4
	MOVWF T2CON,A


	MOVLW 255
	MOVWF PR2,A
	MOVLW 12
	MOVWF CCP1CON,A
	CLRF CCPR1L,A	; 0 -> f
	MOVLW 4
	MOVWF T2CON,A


	MOVLW 255
	MOVWF PR2,A
	MOVLW 12
	MOVWF CCP4CON
	CLRF CCPR4L	; 0 -> f
	MOVLW 4
	MOVWF T2CON,A


	MOVLW 255
	MOVWF PR2,A
	MOVLW 12
	MOVWF CCP3CON
	CLRF CCPR3L	; 0 -> f
	MOVLW 4
	MOVWF T2CON,A


	MOVLW 255
	MOVWF PR2,A
	MOVLW 12
	MOVWF CCP2CON
	CLRF CCPR2L	; 0 -> f
	MOVLW 4
	MOVWF T2CON,A

	CLRF TMR0,A	; 0 -> f
; enable interrupts
	BCF INTCON,T0IF,A
	BSF INTCON,GIE,A

;------------------------------------------------------------------------------
; Main program
;------------------------------------------------------------------------------


MAIN

	RCALL READ_AN0
	RCALL READ_AN1
	RCALL READ_AN2
	RCALL READ_AN3
	RCALL READ_AN4

;------------------------------------------------------------------------------
; PO1
;------------------------------------------------------------------------------

; check positive edge

	BTFSC _FD1,0,A
	BRA PO1_SETFD
	BTFSS S0,0,A
	BRA PO1_SETFD
	BSF _FD1,0,A

; Copy the 2 lower bits, and set PWM-mode 
	SWAPF ADC0,W,A
	ANDLW 48
	IORLW 12
	MOVLB 15	; bank 15
	MOVWF CCP5CON

; Copy the 8 higher bits to CCPRxL
	RRCF ADC0_1,W,A
	MOVWF SYS_TMP1,A
	RRCF ADC0,W,A
	MOVWF SYS_TMP2,A
	RRCF SYS_TMP1,W,A
	RRCF SYS_TMP2,W,A
	MOVWF CCPR5L

PO1_SETFD

; check negative

	BTFSC S0,0,A
	BRA PO1_EXIT
	BCF _FD1,0,A

PO1_EXIT



;------------------------------------------------------------------------------
; PO5
;------------------------------------------------------------------------------

; check positive edge

	BTFSC _FD1,1,A
	BRA PO5_SETFD
	BTFSS S0,0,A
	BRA PO5_SETFD
	BSF _FD1,1,A

; Copy the 2 lower bits, and set PWM-mode 
	SWAPF ADC1,W,A
	ANDLW 48
	IORLW 12
	MOVWF CCP1CON,A

; Copy the 8 higher bits to CCPRxL
	RRCF ADC1_1,W,A
	MOVWF SYS_TMP1,A
	RRCF ADC1,W,A
	MOVWF SYS_TMP2,A
	RRCF SYS_TMP1,W,A
	RRCF SYS_TMP2,W,A
	MOVWF CCPR1L,A

PO5_SETFD

; check negative

	BTFSC S0,0,A
	BRA PO5_EXIT
	BCF _FD1,1,A

PO5_EXIT



;------------------------------------------------------------------------------
; PO9
;------------------------------------------------------------------------------

; check positive edge

	BTFSC _FD1,2,A
	BRA PO9_SETFD
	BTFSS S0,0,A
	BRA PO9_SETFD
	BSF _FD1,2,A

; Copy the 2 lower bits, and set PWM-mode 
	SWAPF ADC2,W,A
	ANDLW 48
	IORLW 12
	MOVLB 15	; bank 15
	MOVWF CCP4CON

; Copy the 8 higher bits to CCPRxL
	RRCF ADC2_1,W,A
	MOVWF SYS_TMP1,A
	RRCF ADC2,W,A
	MOVWF SYS_TMP2,A
	RRCF SYS_TMP1,W,A
	RRCF SYS_TMP2,W,A
	MOVWF CCPR4L

PO9_SETFD

; check negative

	BTFSC S0,0,A
	BRA PO9_EXIT
	BCF _FD1,2,A

PO9_EXIT



;------------------------------------------------------------------------------
; PO13
;------------------------------------------------------------------------------

; check positive edge

	BTFSC _FD1,3,A
	BRA PO13_SETFD
	BTFSS S0,0,A
	BRA PO13_SETFD
	BSF _FD1,3,A

; Copy the 2 lower bits, and set PWM-mode 
	SWAPF ADC3,W,A
	ANDLW 48
	IORLW 12
	MOVLB 15	; bank 15
	MOVWF CCP3CON

; Copy the 8 higher bits to CCPRxL
	RRCF ADC3_1,W,A
	MOVWF SYS_TMP1,A
	RRCF ADC3,W,A
	MOVWF SYS_TMP2,A
	RRCF SYS_TMP1,W,A
	RRCF SYS_TMP2,W,A
	MOVWF CCPR3L

PO13_SETFD

; check negative

	BTFSC S0,0,A
	BRA PO13_EXIT
	BCF _FD1,3,A

PO13_EXIT



;------------------------------------------------------------------------------
; PO17
;------------------------------------------------------------------------------

; check positive edge

	BTFSC _FD1,4,A
	BRA PO17_SETFD
	BTFSS S0,0,A
	BRA PO17_SETFD
	BSF _FD1,4,A

; Copy the 2 lower bits, and set PWM-mode 
	SWAPF ADC4,W,A
	ANDLW 48
	IORLW 12
	MOVLB 15	; bank 15
	MOVWF CCP2CON

; Copy the 8 higher bits to CCPRxL
	RRCF ADC4_1,W,A
	MOVWF SYS_TMP1,A
	RRCF ADC4,W,A
	MOVWF SYS_TMP2,A
	RRCF SYS_TMP1,W,A
	RRCF SYS_TMP2,W,A
	MOVWF CCPR2L

PO17_SETFD

; check negative

	BTFSC S0,0,A
	BRA PO17_EXIT
	BCF _FD1,4,A

PO17_EXIT



;------------------------------------------------------------------------------
; TR32
;------------------------------------------------------------------------------

	BCF INTCON,GIE,A
	MOVLW 0
	SUBWF TR32_1,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA TR32_CHECK


	MOVLW 160
	SUBWF TR32,W,A	; f - W -> W

TR32_CHECK

	BTFSS STATUS,CARRY,A
	BRA TR32_END


TR32_RESET

	MOVLW 0
	SUBWF TR32_1,F,A	; f - W -> f
	MOVLW 160
	SUBWF TR32,F,A	; f - W -> f
	BTFSS STATUS,CARRY,A
	DECF TR32_1,F,A	; f - 1 -> f

TR32_SET

	BTFSC S0,0,A
	BRA TR32_CLR

	BSF S0,0,A
	BRA TR32_END


TR32_CLR

	BCF S0,0,A


TR32_END

	BSF INTCON,GIE,A

;------------------------------------------------------------------------------
; LG55
;------------------------------------------------------------------------------


LG55_1

	BTFSS S0,0,A
	BRA LG55_FALSE


LG55_2

	BTFSS S0,1,A
	BRA LG55_FALSE


LG55_TRUE

	BSF PORTA,4,A
	BRA LG55_END


LG55_FALSE

	BCF PORTA,4,A

LG55_END


;------------------------------------------------------------------------------
; MF75
;------------------------------------------------------------------------------

	BTFSC _FD1,6,A
	BRA MF75_CHKTIME

; check negative edge

	BTFSC _FD1,5,A
	BRA MF75_SETFD
	BTFSC S0,2,A
	BRA MF75_SETFD
	BSF _FD1,5,A


MF75_RESET

	CLRF MF75,A	; 0 -> f
	CLRF MF75_1,A	; 0 -> f
	BSF _FD1,6,A
	BSF S0,1,A

MF75_CHKTIME

	BCF INTCON,GIE,A
	MOVLW 7
	SUBWF MF75_1,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA MF75_CHECK

	MOVLW 208
	SUBWF MF75,W,A	; f - W -> W

MF75_CHECK

	BTFSS STATUS,CARRY,A
	BRA MF75_SETFD


MF75_TO

	BCF _FD1,6,A
	BCF S0,1,A

MF75_SETFD

; check positive

	BTFSS S0,2,A
	BRA MF75_EXIT
	BCF _FD1,5,A

MF75_EXIT


	BSF INTCON,GIE,A

;------------------------------------------------------------------------------
; LG81
;------------------------------------------------------------------------------


LG81_1

	BTFSS PORTB,0,A
	BRA LG81_FALSE


LG81_TRUE

	BSF PORTB,1,A
	BRA LG81_END


LG81_FALSE

	BCF PORTB,1,A

LG81_END


;------------------------------------------------------------------------------
; LG101
;------------------------------------------------------------------------------


LG101_1

	BTFSS PORTC,0,A
	BRA LG101_FALSE


LG101_TRUE

	BSF PORTB,2,A
	BRA LG101_END


LG101_FALSE

	BCF PORTB,2,A

LG101_END


;------------------------------------------------------------------------------
; LG121
;------------------------------------------------------------------------------


LG121_1

	BTFSS PORTC,1,A
	BRA LG121_FALSE


LG121_TRUE

	BSF PORTB,3,A
	BRA LG121_END


LG121_FALSE

	BCF PORTB,3,A

LG121_END

;------------------------------------------------------------------------------
	BRA MAIN
;------------------------------------------------------------------------------


	END

