; Source created with Parsic Version 4.19.9.15

; Time            : 2019.12.13. 15:17:09


; Project File    : G:\Documents and Settings\XY\Dokumentumok\Parsic\NEXTION-PIC\NEXTION-PIC.pic

; Project Version : 1.0.4

; Created         : 2019.12.13. 12:40:08

; Last change     : 2019.12.13. 15:13:47

	PROCESSOR 18F2550
	INCLUDE P18F2550.INC
	RADIX DEC
	__IDLOCS _IDLOC0,H'01'
	__IDLOCS _IDLOC1,H'00'
	__IDLOCS _IDLOC2,H'04'
	ERRORLEVEL -230
	__CONFIG _CONFIG1L,H'C0';192
	__CONFIG _CONFIG1H,H'30';48
	__CONFIG _CONFIG2L,H'DE';222
	__CONFIG _CONFIG2H,H'E6';230
	__CONFIG _CONFIG3H,H'79';121
	__CONFIG _CONFIG4L,H'9B';155
	__CONFIG _CONFIG5L,H'FF';255
	__CONFIG _CONFIG5H,H'FF';255
	__CONFIG _CONFIG6L,H'FF';255
	__CONFIG _CONFIG6H,H'FF';255
	__CONFIG _CONFIG7L,H'FF';255
	__CONFIG _CONFIG7H,H'FF';255
	ERRORLEVEL +230
; missing constants

ZERO	EQU Z	; ZERO-Flag
CARRY	EQU C	; CARRY-Flag
SYSTICKS	EQU	1000000

; variable

_FD1	EQU 0	; located in ACCESS BANK
ADC0	EQU 1	; located in ACCESS BANK
ADC0_1	EQU 2	; located in ACCESS BANK
UA1TIMEOUT	EQU 3	; located in ACCESS BANK
UA1RSFLAG	EQU 4	; located in ACCESS BANK
UA1OUTBUF	EQU 5	; located in ACCESS BANK
UA1OUTBUF_1	EQU 6	; located in ACCESS BANK
UA1OUTBUF_2	EQU 7	; located in ACCESS BANK
UA1OUTBUF_3	EQU 8	; located in ACCESS BANK
UA1OUTBUF_4	EQU 9	; located in ACCESS BANK
UA1OUTBUF_5	EQU 10	; located in ACCESS BANK
UA1OUTBUF_6	EQU 11	; located in ACCESS BANK
UA1OUTBUF_7	EQU 12	; located in ACCESS BANK
UA1OUTBUF_8	EQU 13	; located in ACCESS BANK
UA1OUTBUF_9	EQU 14	; located in ACCESS BANK
UA1INBUF	EQU 15	; located in ACCESS BANK
UA1INBUF_1	EQU 16	; located in ACCESS BANK
UA1INBUF_2	EQU 17	; located in ACCESS BANK
UA1INBUF_3	EQU 18	; located in ACCESS BANK
UA1INBUF_4	EQU 19	; located in ACCESS BANK
UA1INBUF_5	EQU 20	; located in ACCESS BANK
UA1INBUF_6	EQU 21	; located in ACCESS BANK
ADC1	EQU 22	; located in ACCESS BANK
ADC1_1	EQU 23	; located in ACCESS BANK
B0	EQU 24	; located in ACCESS BANK
SYS_FSAV	EQU 25	; located in ACCESS BANK
SYS_FSAV_1	EQU 26	; located in ACCESS BANK
SYS_TMP0	EQU 27	; located in ACCESS BANK
SYS_TMP1	EQU 28	; located in ACCESS BANK
SYS_TMP2	EQU 29	; located in ACCESS BANK
SYS_TMP3	EQU 30	; located in ACCESS BANK
SYS_TMP4	EQU 31	; located in ACCESS BANK
SYS_TMP5	EQU 32	; located in ACCESS BANK
SYS_TMP6	EQU 33	; located in ACCESS BANK
SYS_TMP7	EQU 34	; located in ACCESS BANK
SYS_TMP8	EQU 35	; located in ACCESS BANK
SYS_TMP9	EQU 36	; located in ACCESS BANK
SYS_TMP10	EQU 37	; located in ACCESS BANK
SYS_TMP11	EQU 38	; located in ACCESS BANK
SYS_TMP12	EQU 39	; located in ACCESS BANK
SYS_TMP13	EQU 40	; located in ACCESS BANK
S2	EQU 41	; located in ACCESS BANK
TR1	EQU 42	; located in ACCESS BANK
TR1_1	EQU 43	; located in ACCESS BANK
ZV1	EQU 44	; located in ACCESS BANK
MF1	EQU 45	; located in ACCESS BANK
MF1_1	EQU 46	; located in ACCESS BANK
S0	EQU 47	; located in ACCESS BANK
S1	EQU 48	; located in ACCESS BANK
S1_1	EQU 49	; located in ACCESS BANK
UFRML	EQU 3942	; located in ACCESS BANK
UFRMH	EQU 3943	; located in ACCESS BANK
UIR	EQU 3944	; located in ACCESS BANK
UIE	EQU 3945	; located in ACCESS BANK
UEIR	EQU 3946	; located in ACCESS BANK
UEIE	EQU 3947	; located in ACCESS BANK
USTAT	EQU 3948	; located in ACCESS BANK
UCON	EQU 3949	; located in ACCESS BANK
UADDR	EQU 3950	; located in ACCESS BANK
UCFG	EQU 3951	; located in ACCESS BANK
UEP0	EQU 3952	; located in ACCESS BANK
UEP1	EQU 3953	; located in ACCESS BANK
UEP2	EQU 3954	; located in ACCESS BANK
UEP3	EQU 3955	; located in ACCESS BANK
UEP4	EQU 3956	; located in ACCESS BANK
UEP5	EQU 3957	; located in ACCESS BANK
UEP6	EQU 3958	; located in ACCESS BANK
UEP7	EQU 3959	; located in ACCESS BANK
UEP8	EQU 3960	; located in ACCESS BANK
UEP9	EQU 3961	; located in ACCESS BANK
UEP10	EQU 3962	; located in ACCESS BANK
UEP11	EQU 3963	; located in ACCESS BANK
UEP12	EQU 3964	; located in ACCESS BANK
UEP13	EQU 3965	; located in ACCESS BANK
UEP14	EQU 3966	; located in ACCESS BANK
UEP15	EQU 3967	; located in ACCESS BANK
PORTA	EQU 3968	; located in ACCESS BANK
PORTB	EQU 3969	; located in ACCESS BANK
PORTC	EQU 3970	; located in ACCESS BANK
PORTE	EQU 3972	; located in ACCESS BANK
LATA	EQU 3977	; located in ACCESS BANK
LATB	EQU 3978	; located in ACCESS BANK
LATC	EQU 3979	; located in ACCESS BANK
LATE	EQU 3981	; located in ACCESS BANK
TRISA	EQU 3986	; located in ACCESS BANK
TRISB	EQU 3987	; located in ACCESS BANK
TRISC	EQU 3988	; located in ACCESS BANK
OSCTUNE	EQU 3995	; located in ACCESS BANK
PIE1	EQU 3997	; located in ACCESS BANK
PIR1	EQU 3998	; located in ACCESS BANK
IPR1	EQU 3999	; located in ACCESS BANK
PIE2	EQU 4000	; located in ACCESS BANK
PIR2	EQU 4001	; located in ACCESS BANK
IPR2	EQU 4002	; located in ACCESS BANK
EECON1	EQU 4006	; located in ACCESS BANK
EECON2	EQU 4007	; located in ACCESS BANK
EEDATA	EQU 4008	; located in ACCESS BANK
EEADR	EQU 4009	; located in ACCESS BANK
RCSTA	EQU 4011	; located in ACCESS BANK
TXSTA	EQU 4012	; located in ACCESS BANK
TXREG	EQU 4013	; located in ACCESS BANK
RCREG	EQU 4014	; located in ACCESS BANK
SPBRG	EQU 4015	; located in ACCESS BANK
SPBRGH	EQU 4016	; located in ACCESS BANK
T3CON	EQU 4017	; located in ACCESS BANK
TMR3L	EQU 4018	; located in ACCESS BANK
TMR3H	EQU 4019	; located in ACCESS BANK
CMCON	EQU 4020	; located in ACCESS BANK
CVRCON	EQU 4021	; located in ACCESS BANK
ECCP1AS	EQU 4022	; located in ACCESS BANK
ECCP1DEL	EQU 4023	; located in ACCESS BANK
BAUDCTL	EQU 4024	; located in ACCESS BANK
CCP2CON	EQU 4026	; located in ACCESS BANK
CCPR2L	EQU 4027	; located in ACCESS BANK
CCPR2H	EQU 4028	; located in ACCESS BANK
CCP1CON	EQU 4029	; located in ACCESS BANK
CCPR1L	EQU 4030	; located in ACCESS BANK
CCPR1H	EQU 4031	; located in ACCESS BANK
ADCON2	EQU 4032	; located in ACCESS BANK
ADCON1	EQU 4033	; located in ACCESS BANK
ADCON0	EQU 4034	; located in ACCESS BANK
ADRESL	EQU 4035	; located in ACCESS BANK
ADRESH	EQU 4036	; located in ACCESS BANK
SSPCON2	EQU 4037	; located in ACCESS BANK
SSPCON1	EQU 4038	; located in ACCESS BANK
SSPSTAT	EQU 4039	; located in ACCESS BANK
SSPADD	EQU 4040	; located in ACCESS BANK
SSPBUF	EQU 4041	; located in ACCESS BANK
T2CON	EQU 4042	; located in ACCESS BANK
PR2	EQU 4043	; located in ACCESS BANK
TMR2	EQU 4044	; located in ACCESS BANK
T1CON	EQU 4045	; located in ACCESS BANK
TMR1L	EQU 4046	; located in ACCESS BANK
TMR1H	EQU 4047	; located in ACCESS BANK
RCON	EQU 4048	; located in ACCESS BANK
WDTCON	EQU 4049	; located in ACCESS BANK
HLVDCON	EQU 4050	; located in ACCESS BANK
OSCCON	EQU 4051	; located in ACCESS BANK
T0CON	EQU 4053	; located in ACCESS BANK
TMR0	EQU 4054	; located in ACCESS BANK
TMR0H	EQU 4055	; located in ACCESS BANK
STATUS	EQU 4056	; located in ACCESS BANK
FSR2L	EQU 4057	; located in ACCESS BANK
FSR2H	EQU 4058	; located in ACCESS BANK
PLUSW2	EQU 4059	; located in ACCESS BANK
PREINC2	EQU 4060	; located in ACCESS BANK
POSTDEC2	EQU 4061	; located in ACCESS BANK
POSTINC2	EQU 4062	; located in ACCESS BANK
INDF2	EQU 4063	; located in ACCESS BANK
BSR	EQU 4064	; located in ACCESS BANK
FSR1L	EQU 4065	; located in ACCESS BANK
FSR1H	EQU 4066	; located in ACCESS BANK
PLUSW1	EQU 4067	; located in ACCESS BANK
PREINC1	EQU 4068	; located in ACCESS BANK
POSTDEC1	EQU 4069	; located in ACCESS BANK
POSTINC1	EQU 4070	; located in ACCESS BANK
INDF1	EQU 4071	; located in ACCESS BANK
WREG	EQU 4072	; located in ACCESS BANK
FSR0L	EQU 4073	; located in ACCESS BANK
FSR0H	EQU 4074	; located in ACCESS BANK
PLUSW0	EQU 4075	; located in ACCESS BANK
PREINC0	EQU 4076	; located in ACCESS BANK
POSTDEC0	EQU 4077	; located in ACCESS BANK
POSTINC0	EQU 4078	; located in ACCESS BANK
INDF0	EQU 4079	; located in ACCESS BANK
INTCON3	EQU 4080	; located in ACCESS BANK
INTCON2	EQU 4081	; located in ACCESS BANK
INTCON	EQU 4082	; located in ACCESS BANK
PRODL	EQU 4083	; located in ACCESS BANK
PRODH	EQU 4084	; located in ACCESS BANK
TABLAT	EQU 4085	; located in ACCESS BANK
TBLPTRL	EQU 4086	; located in ACCESS BANK
TBLPTRH	EQU 4087	; located in ACCESS BANK
TBLPTRU	EQU 4088	; located in ACCESS BANK
PCL	EQU 4089	; located in ACCESS BANK
PCLATH	EQU 4090	; located in ACCESS BANK
PCLATU	EQU 4091	; located in ACCESS BANK
STKPTR	EQU 4092	; located in ACCESS BANK
TOSL	EQU 4093	; located in ACCESS BANK
TOSH	EQU 4094	; located in ACCESS BANK
TOSU	EQU 4095	; located in ACCESS BANK

; disable warning for Bankswitching
	ERRORLEVEL -302
; disable warning for Pageswitching
	ERRORLEVEL -306
; disable warning HIGH operator was larger than 0xFFFF
	ERRORLEVEL -311

;------------------------------------------------------------------------------
; Program start
;------------------------------------------------------------------------------
	ORG 0

	GOTO SYS_INIT
	NOP
	NOP

;------------------------------------------------------------------------------
; Interrupt-address
;------------------------------------------------------------------------------

	MOVFF FSR0L,SYS_FSAV
	MOVFF FSR0H,SYS_FSAV_1

	BTFSS INTCON,T0IF,A
	BRA NOTIMERINTERRUPT

	BCF INTCON,T0IF,A
; add 9 to timer0, so the interrupt occures after 250 ticks, instead 256
	MOVLW 9
	ADDWF TMR0,F,A	; W + f -> f

	INCFSZ TR1,F,A	; f + 1 -> f
	BRA TR1_NEXT

	INCF TR1_1,F,A	; f + 1 -> f

TR1_NEXT

; time-out enabled ?
	BTFSS UA1RSFLAG,2,A
	BRA UA1_NO_COUNT

; increment time-out counter
	INCF UA1TIMEOUT,F,A	; f + 1 -> f

UA1_NO_COUNT

	INCFSZ MF1,F,A	; f + 1 -> f
	BRA MF1_NEXT

	INCF MF1_1,F,A	; f + 1 -> f

MF1_NEXT



NOTIMERINTERRUPT

; receive enabled ?
	BTFSS PIE1,RCIE,A
	BRA UA1_ENDRX

; timeout ?
	MOVF UA1TIMEOUT,W,A
	SUBLW 8	; k - W -> W
	BTFSS STATUS,CARRY,A
	BRA UA1_READY

; byte arrived ?
	BTFSS PIR1,RCIF,A
	BRA UA1_ENDRX

; reset time-out
	CLRF UA1TIMEOUT,A	; 0 -> f
; enable time-out counting
	BSF UA1RSFLAG,2,A
; check errors ?
	MOVF RCSTA,W,A
	ANDLW 6
	BTFSS STATUS,ZERO,A
	BRA UA1_RCERROR


; setup indirect address
	MOVF UA1INBUF,W,A
	MOVWF FSR0L,A
	MOVLW HIGH UA1INBUF
	MOVWF FSR0H,A
; increment pointer
	INCF UA1INBUF,F,A	; f + 1 -> f

; get received byte
	MOVF RCREG,W,A
; save into the buffer
	MOVWF INDF0,A
; add to checksum
	ADDWF UA1INBUF_2,F,A	; W + f -> f
; length-1
	DECFSZ UA1INBUF_1,F,A	; f - 1 -> f
	BRA UA1_ENDRX


; one too many, correct checksum
	SUBWF UA1INBUF_2,F,A	; f - W -> f

UA1_READY

; set ready
	BSF UA1RSFLAG,0,A
; disable time-out
	BCF UA1RSFLAG,2,A
	CLRF UA1TIMEOUT,A	; 0 -> f
; shut off
	BCF RCSTA,CREN,A
; empty FIFO
	MOVF RCREG,W,A
	MOVF RCREG,W,A
	BCF PIE1,RCIE,A
	BRA UA1_ENDRX


UA1_RCERROR

; set error
	BSF UA1RSFLAG,1,A
	BRA UA1_READY


UA1_ENDRX

;------------------------------------------------------------------------------
; all transmitted ?
	BTFSC UA1RSFLAG,5,A
	BRA UA1_TXINT1

; send byte ?
	BTFSS PIE1,TXIE,A
	BRA UA1_ENDTX

	BTFSS PIR1,TXIF,A
	BRA UA1_ENDTX

; all transmitted ?
	MOVF UA1OUTBUF_1,W,A
	BTFSC STATUS,ZERO,A
	BRA UA1_TXINT1

; length-1
	DECF UA1OUTBUF_1,F,A	; f - 1 -> f
; setup indirect address
	MOVF UA1OUTBUF,W,A
	MOVWF FSR0L,A
	MOVLW HIGH UA1OUTBUF
	MOVWF FSR0H,A
; increment pointer
	INCF UA1OUTBUF,F,A	; f + 1 -> f
; get byte from buffer
	MOVF INDF0,W,A
	MOVWF TXREG,A
	BRA UA1_ENDTX


UA1_TXINT1

; set check TRMT
	BSF UA1RSFLAG,5,A
	BCF PIE1,TXIE,A
; last byte transmitted ?
	BTFSS TXSTA,TRMT,A
	BRA UA1_ENDTX

; set ready
	BSF UA1RSFLAG,4,A
; TRMT is empty
	BCF UA1RSFLAG,5,A

UA1_ENDTX


EXITINT

	MOVFF SYS_FSAV_1,FSR0H
	MOVFF SYS_FSAV,FSR0L

	RETFIE FAST	; FAST = restore STATUS,BSR,W-register, enable GIE/GIEH, PEIE/GIEL

;------------------------------------------------------------------------------
; Subroutines
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Direct jump into a table
;------------------------------------------------------------------------------


SYSTABJMP

	MOVF SYS_TMP3,W,A
	MOVWF PCLATU,A
	MOVF SYS_TMP2,W,A
	MOVWF PCLATH,A
	MOVF SYS_TMP1,W,A
	MOVWF PCL,A

;------------------------------------------------------------------------------
; Read  -> AN0
;------------------------------------------------------------------------------

READ_AN0

	MOVLW B'1110'
	MOVWF ADCON1,A
	MOVLW B'00000011'
	MOVWF ADCON2,A

	MOVLW B'000001'
	MOVWF ADCON0,A

; Right Justified
	BSF ADCON2,ADFM,A


	MOVLW 7
	MOVWF SYS_TMP1,A

SYS_ADC0_0

	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA SYS_ADC0_0

; start convert
	BSF ADCON0,GO,A

SYS_ADC1_0

	BTFSC ADCON0,GO,A
	BRA SYS_ADC1_0

	MOVF ADRESL,W,A
	MOVWF ADC0,A
	MOVF ADRESH,W,A
	MOVWF ADC0_1,A

; Shut-off
	CLRF ADCON0,A	; 0 -> f
	MOVLW 15
	MOVWF ADCON1,A

	RETURN

;------------------------------------------------------------------------------
; Read  -> AN1
;------------------------------------------------------------------------------

READ_AN1

	MOVLW B'1101'
	MOVWF ADCON1,A
	MOVLW B'00000011'
	MOVWF ADCON2,A

	MOVLW B'000101'
	MOVWF ADCON0,A

; Right Justified
	BSF ADCON2,ADFM,A


	MOVLW 7
	MOVWF SYS_TMP1,A

SYS_ADC0_1

	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA SYS_ADC0_1

; start convert
	BSF ADCON0,GO,A

SYS_ADC1_1

	BTFSC ADCON0,GO,A
	BRA SYS_ADC1_1

	MOVF ADRESL,W,A
	MOVWF ADC1,A
	MOVF ADRESH,W,A
	MOVWF ADC1_1,A

; Shut-off
	CLRF ADCON0,A	; 0 -> f
	MOVLW 15
	MOVWF ADCON1,A

	RETURN

;------------------------------------------------------------------------------
; System Delay
;------------------------------------------------------------------------------

SYS_DELAY

	MOVWF SYS_TMP0,A

SYS_DELAY_1

	DECFSZ SYS_TMP0,F,A	; f - 1 -> f
	BRA SYS_DELAY_1

SYS_DELAY_4

	RETURN

;------------------------------------------------------------------------------
; Subroutines for LB1
;------------------------------------------------------------------------------


LB1_INIT

; wait long
	CLRF SYS_TMP1,A	; 0 -> f

LB1_INIT1

	RCALL LB1_OUT4
	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA LB1_INIT1

; Maybe the worst case. The display is already in 4-Bit mode and waits for the second nibble !!
; So we have to reset it back to the 8-Bit mode - three times

; IR-Register
	BCF PORTB,4,A
	NOP
	MOVF PORTB,W,A
	ANDLW 15
	IORLW 48
	MOVWF PORTB,A
	NOP

; 1st
	BSF PORTB,5,A
	NOP
	BCF PORTB,5,A

; wait long

LB1_INIT2

	RCALL LB1_OUT4
	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA LB1_INIT2

; 2nd
	BSF PORTB,5,A
	NOP
	BCF PORTB,5,A

; wait long

LB1_INIT3

	RCALL LB1_OUT4
	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA LB1_INIT3

; 3rd
	BSF PORTB,5,A
	NOP
	BCF PORTB,5,A

; wait long

LB1_INIT4

	RCALL LB1_OUT4
	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA LB1_INIT4

; function set 4-bit, this is the last 8-Bit command
	BCF PORTB,4,A
	NOP
	BSF PORTB,5,A
	NOP
	BCF PORTB,5,A

; wait long

LB1_INIT5

	RCALL LB1_OUT4
	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA LB1_INIT5

; function set 4-bit,2-lines = 00101000
	MOVLW 40
	RCALL LB1_OUT
; display on, cursor off, blink off = 00001100
	MOVLW 12
	RCALL LB1_OUT
; entrymode set = 00000110"
	MOVLW 6
	RCALL LB1_OUT
; entrypoint display clear = 00000001

LB1_CLR

	MOVLW 1
	RCALL LB1_WRITE_IR
; wait long
	CLRF SYS_TMP1,A	; 0 -> f

LB1_INIT6

	RCALL LB1_OUT4
	DECFSZ SYS_TMP1,F,A	; f - 1 -> f
	BRA LB1_INIT6

	BRA LB1_OUT4

;------------------------------------------------------------------------------
; LCD Write DDRAM or CGRAM for 1 Line-Displays
;------------------------------------------------------------------------------

LB1_WRITE_DDRAM

; save char
	MOVWF SYS_TMP13,A
; increment copy of XPOS
	INCF SYS_TMP12,F,A	; f + 1 -> f
; check for middle of the line
	MOVLW 9
	SUBWF SYS_TMP12,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA LB1_OUTZ1

; switch to second line
	MOVLW 64
	RCALL LB1_SET_DDRAM

LB1_OUTZ1

; get saved char
	MOVF SYS_TMP13,W,A
	BSF PORTB,4,A
	BRA LB1_OUT


;------------------------------------------------------------------------------
; LCD Set CGRAM
;------------------------------------------------------------------------------

LB1_SET_CGRAM

	IORLW 64
	BRA LB1_WRITE_IR

;------------------------------------------------------------------------------
; LCD Set DDRAM
;------------------------------------------------------------------------------

LB1_SET_DDRAM

	IORLW 128
;------------------------------------------------------------------------------
; LCD Write IR
;------------------------------------------------------------------------------

LB1_WRITE_IR

; IR-Register
	BCF PORTB,4,A
;------------------------------------------------------------------------------
; LCD Out Bit-7...4 first
; W-Register contains the byte to be written
;------------------------------------------------------------------------------


LB1_OUT

	MOVWF SYS_TMP1,A

LB1_OUT1

	CLRF SYS_TMP3,A	; 0 -> f

LB1_OUT2

	MOVF SYS_TMP1,W,A

LB1_OUT3

	ANDLW 240
	MOVWF SYS_TMP2,A
	MOVF PORTB,W,A
	ANDLW 15
	IORWF SYS_TMP2,W,A
	MOVWF PORTB,A
	NOP

	BSF PORTB,5,A
	NOP
	BCF PORTB,5,A

	BTFSC SYS_TMP3,0,A
	BRA LB1_OUT4

	BSF SYS_TMP3,0,A
	SWAPF SYS_TMP1,W,A
	BRA LB1_OUT3



LB1_OUT4

	MOVLW 17
	MOVWF SYS_TMP3,A

LB1_OUT5

	DECFSZ SYS_TMP3,F,A	; f - 1 -> f
	BRA LB1_OUT5

	RETURN

;------------------------------------------------------------------------------
; GOTOXY - Set Cursor Position
; SYS_TMP1  = X
; SYS_TMP2  = Y
; SYS_TMP12 = copy of X (only if a 1 Line-Display is used)
;------------------------------------------------------------------------------

LB1_GOTOXY

; Ypos bit-0
	MOVLW 64
	BTFSC SYS_TMP2,0,A
	ADDWF SYS_TMP1,F,A	; W + f -> f
	MOVF SYS_TMP1,W,A
	MOVWF SYS_TMP12,A
	BRA LB1_SET_DDRAM


;------------------------------------------------------------------------------


LB1_CONVERTHEX

; only lower nibble
	ANDLW 15
	MOVWF SYS_TMP1,A
; add asc'0', if greater or equal 10 add asc'7'
	MOVLW 10
	SUBWF SYS_TMP1,W,A	; f - W -> W
	MOVLW 55
	BTFSS STATUS,CARRY,A
	MOVLW 48
	ADDWF SYS_TMP1,F,A	; W + f -> f
	MOVF SYS_TMP1,W,A
	BRA LB1_WRITE_DDRAM

;------------------------------------------------------------------------------
; Write String
;------------------------------------------------------------------------------


LB1_WRITESTR

	RCALL LB1_GETROMCHAR
; last is zero
	ANDLW 255
	BTFSC STATUS,ZERO,A
	RETURN

	RCALL LB1_WRITE_DDRAM
; next char
	INCF SYS_TMP5,F,A	; f + 1 -> f
	INCFSZ SYS_TMP5,F,A	; f + 1 -> f
	BRA LB1_WRITESTR

; next page
	INCF SYS_TMP6,F,A	; f + 1 -> f
	BRA LB1_WRITESTR

; direct jump into the table

LB1_GETROMCHAR

	MOVF SYS_TMP6,W,A
	MOVWF PCLATH,A
	MOVF SYS_TMP5,W,A
	MOVWF PCL,A

;------------------------------------------------------------------------------


LB1_WRITE_DEZ

; test zero
	ANDLW 255
	BTFSS STATUS,ZERO,A
	BCF SYS_TMP9,0,A
	BTFSS SYS_TMP9,0,A
	ADDLW 48	; k + W -> W
	BTFSC SYS_TMP9,0,A
	ADDLW 32	; k + W -> W
	BRA LB1_WRITE_DDRAM

;------------------------------------------------------------------------------


LB1_CONVERTDEZ

	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	DECF SYS_TMP10,F	; f - 1 -> f
	CLRF SYS_TMP11,A	; 0 -> f

LB1_CONVERTDEZ2

	INCF SYS_TMP11,F,A	; f + 1 -> f

	MOVF SYS_TMP1,W,A
	SUBWF SYS_TMP5,F,A	; f - W -> f

	MOVF SYS_TMP2,W,A
	BTFSS STATUS,CARRY,A
	INCFSZ SYS_TMP2,W,A	; f + 1 -> w
	SUBWF SYS_TMP6,F,A	; f - W -> f

	MOVF SYS_TMP3,W,A
	BTFSS STATUS,CARRY,A
	INCFSZ SYS_TMP3,W,A	; f + 1 -> w
	SUBWF SYS_TMP7,F,A	; f - W -> f

	MOVF SYS_TMP4,W,A
	BTFSS STATUS,CARRY,A
	INCFSZ SYS_TMP4,W,A	; f + 1 -> w
	SUBWF SYS_TMP8,F,A	; f - W -> f

	BTFSC STATUS,CARRY,A
	BRA LB1_CONVERTDEZ2

	MOVF SYS_TMP1,W,A
	ADDWF SYS_TMP5,F,A	; W + f -> f

	MOVF SYS_TMP2,W,A
	BTFSC STATUS,CARRY,A
	INCFSZ SYS_TMP2,W,A	; f + 1 -> w
	ADDWF SYS_TMP6,F,A	; W + f -> f

	MOVF SYS_TMP3,W,A
	BTFSC STATUS,CARRY,A
	INCFSZ SYS_TMP3,W,A	; f + 1 -> w
	ADDWF SYS_TMP7,F,A	; W + f -> f

	MOVF SYS_TMP4,W,A
	BTFSC STATUS,CARRY,A
	INCFSZ SYS_TMP4,W,A	; f + 1 -> w
	ADDWF SYS_TMP8,F,A	; W + f -> f

	DECF SYS_TMP11,W	; f + 1 -> w
	RETURN

;------------------------------------------------------------------------------

LB1_1000000000


	MOVLW 0
	MOVWF SYS_TMP1,A
	MOVLW 202
	MOVWF SYS_TMP2,A
	MOVLW 154
	MOVWF SYS_TMP3,A
	MOVLW 59
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_100000000

	RCALL LB1_WRITE_DEZ

LB1_100000000


	MOVLW 0
	MOVWF SYS_TMP1,A
	MOVLW 225
	MOVWF SYS_TMP2,A
	MOVLW 245
	MOVWF SYS_TMP3,A
	MOVLW 5
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_10000000

	RCALL LB1_WRITE_DEZ

LB1_10000000


	MOVLW 128
	MOVWF SYS_TMP1,A
	MOVLW 150
	MOVWF SYS_TMP2,A
	MOVLW 152
	MOVWF SYS_TMP3,A
	MOVLW 0
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_1000000

	RCALL LB1_WRITE_DEZ

LB1_1000000


	MOVLW 64
	MOVWF SYS_TMP1,A
	MOVLW 66
	MOVWF SYS_TMP2,A
	MOVLW 15
	MOVWF SYS_TMP3,A
	MOVLW 0
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_100000

	RCALL LB1_WRITE_DEZ

LB1_100000


	MOVLW 160
	MOVWF SYS_TMP1,A
	MOVLW 134
	MOVWF SYS_TMP2,A
	MOVLW 1
	MOVWF SYS_TMP3,A
	MOVLW 0
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_10000

	RCALL LB1_WRITE_DEZ

LB1_10000


	MOVLW 16
	MOVWF SYS_TMP1,A
	MOVLW 39
	MOVWF SYS_TMP2,A
	MOVLW 0
	MOVWF SYS_TMP3,A
	MOVLW 0
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_1000

	RCALL LB1_WRITE_DEZ

LB1_1000


	MOVLW 232
	MOVWF SYS_TMP1,A
	MOVLW 3
	MOVWF SYS_TMP2,A
	MOVLW 0
	MOVWF SYS_TMP3,A
	MOVLW 0
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_100

	RCALL LB1_WRITE_DEZ

LB1_100


	MOVLW 100
	MOVWF SYS_TMP1,A
	MOVLW 0
	MOVWF SYS_TMP2,A
	MOVLW 0
	MOVWF SYS_TMP3,A
	MOVLW 0
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_10

	RCALL LB1_WRITE_DEZ

LB1_10


	MOVLW 10
	MOVWF SYS_TMP1,A
	MOVLW 0
	MOVWF SYS_TMP2,A
	MOVLW 0
	MOVWF SYS_TMP3,A
	MOVLW 0
	MOVWF SYS_TMP4,A

	RCALL LB1_CONVERTDEZ
	MOVF SYS_TMP10,F,A
	BTFSS STATUS,ZERO,A
	BRA LB1_1

	RCALL LB1_WRITE_DEZ

LB1_1

	BCF SYS_TMP9,0,A
	MOVF SYS_TMP5,W,A
	BRA LB1_WRITE_DEZ

;------------------------------------------------------------------------------
; Initialisation
;------------------------------------------------------------------------------

SYS_INIT

	CLRF INTCON,A	; 0 -> f

; A/D off
	MOVLW 15
	MOVWF ADCON1,A
	CLRF ADCON2,A	; 0 -> f


; Set output before direction

	MOVLW B'00000000'
	MOVWF PORTA,A

	MOVLW B'00000000'
	MOVWF PORTB,A

	MOVLW B'00000000'
	MOVWF PORTC,A

; set direction

	MOVLW B'01111111'
	MOVWF TRISA,A

	MOVLW B'00001011'
	MOVWF TRISB,A

	MOVLW B'11111111'
	MOVWF TRISC,A


; init some registers

; Timer 0
	MOVLW 223
	MOVWF T0CON,A
	BSF INTCON,T0IE,A

;------------------------------------------------------------------------------
	MOVLW 8
	MOVWF UCFG,A

;------------------------------------------------------------------------------
; Clear RAM
;------------------------------------------------------------------------------

; Clear from $000 to $7FF

	LFSR 0,0

SYSClearRAM1

	CLRF POSTINC0,A	; 0 -> f
	MOVLW 8
	SUBWF FSR0H,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA SYSClearRAM1
	MOVLW 0
	SUBWF FSR0L,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA SYSClearRAM1

;------------------------------------------------------------------------------

; init vars



; SERIAL ENABLED, 8-bit
	MOVLW 128
	MOVWF RCSTA,A

; set baudrate
	MOVLW 25
	MOVWF SPBRG,A
; 8-Bit,TRANSMIT ENABLED,ASYNCHRON,BRGH=1=HIGH SPEED
	MOVLW 36
	MOVWF TXSTA,A

; PERIPHERIE INT ENABLE
	BSF INTCON,PEIE,A

;------------------------------------------------------------------------------
; Init LCD-module -> LB1
;------------------------------------------------------------------------------
	RCALL LB1_INIT
	CLRF TMR0,A	; 0 -> f
; enable interrupts
	BCF INTCON,T0IF,A
	BSF INTCON,GIE,A

;------------------------------------------------------------------------------
; Main program
;------------------------------------------------------------------------------


MAIN

	RCALL READ_AN0
	RCALL READ_AN1

;------------------------------------------------------------------------------
; TR1
;------------------------------------------------------------------------------

	BCF INTCON,GIE,A
	MOVLW 0
	SUBWF TR1_1,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA TR1_CHECK


	MOVLW 20
	SUBWF TR1,W,A	; f - W -> W

TR1_CHECK

	BTFSS STATUS,CARRY,A
	BRA TR1_END


TR1_RESET

	MOVLW 0
	SUBWF TR1_1,F,A	; f - W -> f
	MOVLW 20
	SUBWF TR1,F,A	; f - W -> f
	BTFSS STATUS,CARRY,A
	DECF TR1_1,F,A	; f - 1 -> f

TR1_SET

	BTFSC S2,1,A
	BRA TR1_CLR

	BSF S2,1,A
	BRA TR1_END


TR1_CLR

	BCF S2,1,A


TR1_END

	BSF INTCON,GIE,A

;------------------------------------------------------------------------------
; ZV1
;------------------------------------------------------------------------------

	BTFSS S2,3,A
	BRA ZV1_COUNT

	CLRF ZV1,A	; 0 -> f
	BRA ZV1_SETOUT


ZV1_COUNT

; check positive edge

	BTFSC _FD1,0,A
	BRA ZV1_SETFD
	BTFSS S2,0,A
	BRA ZV1_SETFD
	BSF _FD1,0,A

	BTFSC S2,2,A
	BRA ZV1_BACKWARD

	INCF ZV1,F,A	; f + 1 -> f
	BRA ZV1_SETOUT


ZV1_BACKWARD

	DECF ZV1,F	; f - 1 -> f

ZV1_SETOUT


ZV1_SETFD

; check negative

	BTFSC S2,0,A
	BRA ZV1_EXIT
	BCF _FD1,0,A

ZV1_EXIT



;------------------------------------------------------------------------------
; OS1
;------------------------------------------------------------------------------

	BTFSC _FD1,1,A
	BRA OS1_2

	BTFSS S2,1,A
	BRA OS1_SETFD

	BSF _FD1,1,A
	BRA OS1_EXIT


OS1_2

	BTFSC _FD1,2,A
	BRA OS1_SETFD

	BSF _FD1,2,A
	BSF S2,0,A
	BRA OS1_EXIT


OS1_SETFD

	BCF S2,0,A
	BTFSC S2,1,A
	BRA OS1_EXIT


	BCF _FD1,1,A
	BCF _FD1,2,A

OS1_EXIT


;------------------------------------------------------------------------------
; IF1
;------------------------------------------------------------------------------

	MOVLW 10
	SUBWF ZV1,W,A	; f - W -> W

IF1_CHECK

; check greater
	BTFSS STATUS,CARRY,A
	BRA IF1_FALSE

	BTFSC STATUS,ZERO,A
	BRA IF1_FALSE


IF1_TRUE

	BSF S2,3,A
	BRA IF1_EXIT


IF1_FALSE

	BCF S2,3,A

IF1_EXIT


;------------------------------------------------------------------------------
; UA1
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
; UD1
;------------------------------------------------------------------------------

; active ?
	BTFSC S2,4,A
	BRA UD1_1


; check positive edge

	BTFSC _FD1,3,A
	BRA UD1_SETFD
	BTFSS S2,3,A
	BRA UD1_SETFD
	BSF _FD1,3,A


; OUTBUF+0 = address
; OUTBUF+1 = length
; OUTBUF+2...8 = data
; OUTBUF+9 = checksum

; set pointer (address)
	MOVLW LOW UA1OUTBUF_2
	MOVWF UA1OUTBUF,A

; init checksum
	MOVLW 170
	MOVWF UA1OUTBUF_9,A
; length = 8 bytes
	MOVLW 8
	MOVWF UA1OUTBUF_1,A

; copy data to OUTBUF
	MOVF ZV1,W,A
	MOVWF UA1OUTBUF_2,A
	ADDWF UA1OUTBUF_9,F,A	; W + f -> f
	MOVF ADC0,W,A
	MOVWF UA1OUTBUF_3,A
	ADDWF UA1OUTBUF_9,F,A	; W + f -> f
	MOVF ADC0_1,W,A
	MOVWF UA1OUTBUF_4,A
	ADDWF UA1OUTBUF_9,F,A	; W + f -> f
	MOVF S1,W,A
	MOVWF UA1OUTBUF_5,A
	ADDWF UA1OUTBUF_9,F,A	; W + f -> f
	MOVF ADC1,W,A
	MOVWF UA1OUTBUF_6,A
	ADDWF UA1OUTBUF_9,F,A	; W + f -> f
	MOVF ADC1_1,W,A
	MOVWF UA1OUTBUF_7,A
	ADDWF UA1OUTBUF_9,F,A	; W + f -> f
	MOVF S0,W,A
	MOVWF UA1OUTBUF_8,A
	ADDWF UA1OUTBUF_9,F,A	; W + f -> f


; set not ready
	BCF UA1RSFLAG,4,A
; set not transmitted
	BCF UA1RSFLAG,5,A
; activate
	BSF S2,4,A
; enable INTERRUPT for transmit
	BSF PIE1,TXIE,A

UD1_1

; transmit ready ?
	BTFSS UA1RSFLAG,4,A
	BRA UD1_2

; not active
	BCF S2,4,A


UD1_2


UD1_SETFD

; check negative

	BTFSC S2,3,A
	BRA UD1_EXIT
	BCF _FD1,3,A

UD1_EXIT



;------------------------------------------------------------------------------
; LB1
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
; UD2
;------------------------------------------------------------------------------

; active ?
	BTFSC S2,5,A
	BRA UD2_1


; check negative edge

	BTFSC _FD1,4,A
	BRA UD2_SETFD
	BTFSC S2,5,A
	BRA UD2_SETFD
	BSF _FD1,4,A


; INBUF+0 = address
; INBUF+1 = length
; INBUF+2 = checksum
; INBUF+3...5 = data
; INBUF+6 = received checksum

; clear ready-flag
	BCF UA1RSFLAG,0,A
; clear error-flag
	BCF UA1RSFLAG,1,A
; clear time-out
	BCF UA1RSFLAG,2,A
	BSF S2,5,A
; set pointer (address)
	MOVLW LOW UA1INBUF_3
	MOVWF UA1INBUF,A
; init checksum
	MOVLW 170
	MOVWF UA1INBUF_2,A
; 4 bytes
	MOVLW 4
	MOVWF UA1INBUF_1,A
; enable INTERRUPT for receive
	BSF RCSTA,CREN,A
	BSF PIE1,RCIE,A
	BRA UD2_SETFD


UD2_1

; received ?
	BTFSS UA1RSFLAG,0,A
	BRA UD2_2


; error ? -> then do nothing
	BTFSC UA1RSFLAG,1,A
	BRA UD2_3


; test checksum
	MOVF UA1INBUF_2,W,A
	SUBWF UA1INBUF_6,F,A	; f - W -> f
; not equal -> then do nothing
	BTFSS STATUS,ZERO,A
	BRA UD2_3


; all ok, -> copy data
	MOVF UA1INBUF_3,W,A
	MOVWF MF1,A
	MOVF UA1INBUF_4,W,A
	MOVWF MF1_1,A
	MOVF UA1INBUF_5,W,A
	MOVWF B0,A

UD2_3

	BCF S2,5,A

UD2_2


UD2_SETFD

; check positive

	BTFSS S2,5,A
	BRA UD2_EXIT
	BCF _FD1,4,A

UD2_EXIT



;------------------------------------------------------------------------------
; LT1
;------------------------------------------------------------------------------

; check positive edge

	BTFSC _FD1,5,A
	BRA LT1_SETFD
	BTFSS S2,1,A
	BRA LT1_SETFD
	BSF _FD1,5,A


	MOVLW 0
	MOVWF SYS_TMP1,A
	MOVLW 0
	MOVWF SYS_TMP2,A
	RCALL LB1_GOTOXY
	MOVF ZV1,W,A
	MOVWF SYS_TMP5,A
	CLRF SYS_TMP6,A	; 0 -> f
	CLRF SYS_TMP7,A	; 0 -> f
	CLRF SYS_TMP8,A	; 0 -> f

	BSF SYS_TMP9,0,A
	CLRF SYS_TMP10,A	; 0 -> f
	RCALL LB1_100

LT1_SETFD

; check negative

	BTFSC S2,1,A
	BRA LT1_EXIT
	BCF _FD1,5,A

LT1_EXIT



;------------------------------------------------------------------------------
; MF1
;------------------------------------------------------------------------------

	BTFSC _FD1,7,A
	BRA MF1_CHKTIME

; check positive edge

	BTFSC _FD1,6,A
	BRA MF1_SETFD
	BTFSS S2,6,A
	BRA MF1_SETFD
	BSF _FD1,6,A


MF1_RESET

	CLRF MF1,A	; 0 -> f
	CLRF MF1_1,A	; 0 -> f
	BSF _FD1,7,A
	BSF PORTB,2,A

MF1_CHKTIME

	BCF INTCON,GIE,A
	MOVLW 9
	SUBWF MF1_1,W,A	; f - W -> W
	BTFSS STATUS,ZERO,A
	BRA MF1_CHECK

	MOVLW 96
	SUBWF MF1,W,A	; f - W -> W

MF1_CHECK

	BTFSS STATUS,CARRY,A
	BRA MF1_SETFD


MF1_TO

	BCF _FD1,7,A
	BCF PORTB,2,A

MF1_SETFD

; check negative

	BTFSC S2,6,A
	BRA MF1_EXIT
	BCF _FD1,6,A

MF1_EXIT


	BSF INTCON,GIE,A

;------------------------------------------------------------------------------
; TAB1
;------------------------------------------------------------------------------


; copy index
	MOVFF ZV1,SYS_TMP1
	CLRF SYS_TMP2,A	; 0 -> f
	CLRF SYS_TMP3,A	; 0 -> f

; multiplicate with 2
	BCF STATUS,CARRY,A
	RLCF SYS_TMP1,F,A
	RLCF SYS_TMP2,F,A

; add table address to index
	MOVLW LOW TAB1
	ADDWF SYS_TMP1,F,A	; W + f -> f
	MOVLW HIGH TAB1
	ADDWFC SYS_TMP2,F,A	; W + f + c -> f
	MOVLW UPPER TAB1
	ADDWFC SYS_TMP3,F,A	; W + f + c -> f


; get value from table
	RCALL SYSTABJMP

	MOVWF S0,A


;------------------------------------------------------------------------------
; TAB2
;------------------------------------------------------------------------------

; copy index
	MOVFF ADC0,SYS_TMP1
	CLRF SYS_TMP2,A	; 0 -> f
	CLRF SYS_TMP3,A	; 0 -> f

; multiplicate with 4
	BCF STATUS,CARRY,A
	RLCF SYS_TMP1,F,A
	RLCF SYS_TMP2,F,A
	BCF STATUS,CARRY,A
	RLCF SYS_TMP1,F,A
	RLCF SYS_TMP2,F,A

; add table address to index
	MOVLW LOW TAB2
	ADDWF SYS_TMP1,F,A	; W + f -> f
	MOVLW HIGH TAB2
	ADDWFC SYS_TMP2,F,A	; W + f + c -> f
	MOVLW UPPER TAB2
	ADDWFC SYS_TMP3,F,A	; W + f + c -> f


; get value from table
	RCALL SYSTABJMP

	MOVWF S1,A

	MOVLW 2
	ADDWF SYS_TMP1,F,A	; W + f -> f
	MOVLW 0
	ADDWFC SYS_TMP2,F,A	; W + f + c -> f
	MOVLW 0
	ADDWFC SYS_TMP3,F,A	; W + f + c -> f

; get high value from table
	RCALL SYSTABJMP
	MOVWF S1_1,A


;------------------------------------------------------------------------------
; IF2
;------------------------------------------------------------------------------

	MOVLW 1
	SUBWF B0,W,A	; f - W -> W

IF2_CHECK

; check equal
	BTFSS STATUS,ZERO,A
	BRA IF2_FALSE


IF2_TRUE

	BSF S2,6,A
	BRA IF2_EXIT


IF2_FALSE

	BCF S2,6,A

IF2_EXIT

;------------------------------------------------------------------------------
	BRA MAIN
;------------------------------------------------------------------------------




TAB1

	RETLW 110	; // INDEX 0
	RETLW 48	; // INDEX 1
	RETLW 46	; // INDEX 2
	RETLW 116	; // INDEX 3
	RETLW 120	; // INDEX 4
	RETLW 116	; // INDEX 5
	RETLW 34	; // INDEX 6
	RETLW 122	; // INDEX 7
	RETLW 118	; // INDEX 8
	RETLW 49	; // INDEX 9
	RETLW 34	; // INDEX 10
	RETLW 92	; // INDEX 11
	RETLW 50	; // INDEX 12
	RETLW 53	; // INDEX 13
	RETLW 53	; // INDEX 14
	RETLW 92	; // INDEX 15
	RETLW 50	; // INDEX 16
	RETLW 53	; // INDEX 17
	RETLW 53	; // INDEX 18
	RETLW 92	; // INDEX 19
	RETLW 50	; // INDEX 20
	RETLW 53	; // INDEX 21
	RETLW 53	; // INDEX 22
	RETLW 34	; // INDEX 23
	RETLW 0	; // INDEX 24


TAB2

	RETLW 110	; // INDEX 0
	RETLW 0	; // INDEX 0
	RETLW 49	; // INDEX 1
	RETLW 0	; // INDEX 1
	RETLW 46	; // INDEX 2
	RETLW 0	; // INDEX 2
	RETLW 116	; // INDEX 3
	RETLW 0	; // INDEX 3
	RETLW 120	; // INDEX 4
	RETLW 0	; // INDEX 4
	RETLW 116	; // INDEX 5
	RETLW 0	; // INDEX 5
	RETLW 34	; // INDEX 6
	RETLW 0	; // INDEX 6
	RETLW 65	; // INDEX 7
	RETLW 0	; // INDEX 7
	RETLW 68	; // INDEX 8
	RETLW 0	; // INDEX 8
	RETLW 67	; // INDEX 9
	RETLW 0	; // INDEX 9
	RETLW 48	; // INDEX 10
	RETLW 0	; // INDEX 10
	RETLW 34	; // INDEX 11
	RETLW 0	; // INDEX 11
	RETLW 92	; // INDEX 12
	RETLW 0	; // INDEX 12
	RETLW 50	; // INDEX 13
	RETLW 0	; // INDEX 13
	RETLW 53	; // INDEX 14
	RETLW 0	; // INDEX 14
	RETLW 53	; // INDEX 15
	RETLW 0	; // INDEX 15
	RETLW 92	; // INDEX 16
	RETLW 0	; // INDEX 16
	RETLW 50	; // INDEX 17
	RETLW 0	; // INDEX 17
	RETLW 53	; // INDEX 18
	RETLW 0	; // INDEX 18
	RETLW 53	; // INDEX 19
	RETLW 0	; // INDEX 19
	RETLW 92	; // INDEX 20
	RETLW 0	; // INDEX 20
	RETLW 50	; // INDEX 21
	RETLW 0	; // INDEX 21
	RETLW 53	; // INDEX 22
	RETLW 0	; // INDEX 22
	RETLW 53	; // INDEX 23
	RETLW 0	; // INDEX 23
	RETLW 0	; // INDEX 24
	RETLW 0	; // INDEX 24


	END

