

#include <ESP8266WiFi.h>

const char* ssid     = "****";     //change this as per yours
const char* password = "**********"; //change this as per yours

WiFiServer server(8083);
IPAddress ip(192, 168, 1, 99); // where xx is the desired IP Address
IPAddress gateway(192, 168, 1, 1); // set gateway to match your network


uint8_t board_farenheit;
float board_celsius;
int relay=0;  //0;

unsigned long int x=0; //set refresh counter to 0
float y=0;
String readString; 
String state="";

void setup(){
    Serial.begin(115200);
    pinMode(relay, OUTPUT);      // set the LED pin mode
digitalWrite(relay, INPUT_PULLUP);  
    delay(10);

    // We start by connecting to a WiFi network

    Serial.println();
    Serial.println();
    Serial.print("Connecting to ");
    Serial.println(ssid);
 
  IPAddress subnet(255, 255, 255, 0); // set subnet mask to match your network
  WiFi.config(ip, gateway, subnet); 
 
    WiFi.begin(ssid, password);

    while (WiFi.status() != WL_CONNECTED) {
        delay(500);
        Serial.print(".");
    }

    Serial.println("");
    Serial.println("WiFi connected.");
    Serial.println("IP address: ");
    Serial.println(WiFi.localIP());
    
    server.begin();

}

int value = 0;

void loop(){
 WiFiClient client = server.available();   // listen for incoming clients

 
  if (client) {                             // if you get a client,
    Serial.println("New Client.");           // print a message out the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected()) {            // loop while the client's connected
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
         readString += c; 
    
        
        if (c == '\n') {                    // if the byte is a newline character

           if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println();
            client.println("Welcome to Bera's mini WiFi switch<p>");
            client.print("Press Button Now");
            client.println("<p>");
             // the content of the HTTP response follows the header:
            client.print("<input type=submit value=ON style=width:100px;height:45px onClick=location.href='/H'>");
            client.print("<input type=submit value=OFF style=width:100px;height:45px onClick=location.href='/L'>");


           break;
          } else {    // if you got a newline, then clear currentLine:
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }

        // Check to see if the client request was "GET /H" or "GET /L":
        if (currentLine.endsWith("GET /H")) {
         digitalWrite(relay, LOW);               // GET /H turns the LED on
         state=" On";
         }
        if (currentLine.endsWith("GET /L")) {
          digitalWrite(relay, HIGH);                // GET /L turns the LED off
          state=" Off";
        }
      }
    }



            client.print("<HTML><HEAD>");
            y=y+0.5;
            client.print("<title>Welcome to Bera's mini WiFi switch</title></head><BODY><br>");
            client.print("<p>page refresh number: ");
            client.print((int)y); //current refresh count
            client.print("<p>");
            client.print("The relay is:");
            client.print(state);
            client.print("<br><br>");
            client.println("</BODY>");
            client.println("</HTML>");
            client.println();
    // close the connection:
    client.stop();
    Serial.println("Client Disconnected.");
  }
}
