#include "BluetoothSerial.h" 
#include "EEPROM.h"
#include <MD_Parola.h>
#include <MD_MAX72xx.h>
#include <SPI.h>
#include "Font_Data.h"

#define DEBUG 0

// Define the number of devices we have in the chain and the hardware interface
// NOTE: These pin numbers will probably not work with your hardware and may
// need to be adapted
#define HARDWARE_TYPE MD_MAX72XX::FC16_HW
#define MAX_ZONES 2
#define ZONE_SIZE 8
#define MAX_DEVICES (MAX_ZONES * ZONE_SIZE)


#define ZONE_UPPER  1
#define ZONE_LOWER  0
//#define SCROLL_SPEED  sp
#define CLK_PIN   19 // or SCK
#define DATA_PIN  23 // or MOSI
#define CS_PIN    5 // or SS

BluetoothSerial ESP_BT;
#define EEPROM_SIZE 512
int m=0, sp=0,contrast=0,state=0;
int SCROLL_SPEED=0;
char incoming;
String readString1="",readString2,lastvalue;
// HARDWARE SPI
MD_Parola P = MD_Parola(HARDWARE_TYPE, CS_PIN, MAX_DEVICES);
// SOFTWARE SPI
//MD_Parola P = MD_Parola(HARDWARE_TYPE, DATA_PIN, CLK_PIN, CS_PIN, MAX_DEVICES);

// Hardware adaptation parameters for scrolling
bool invertUpperZone = false;

#define ARRAY_SIZE(a) (sizeof(a)/sizeof(a[0]))

 char msg[50] =
{
  "Create double height displays ",
  
};

void setup(void)
{

   EEPROM.begin(EEPROM_SIZE);
  Serial.begin(115200);
   ESP_BT.begin("LED MATRIX DISPLAY");
 // Serial.println(blue1);
  invertUpperZone = (HARDWARE_TYPE == MD_MAX72XX::GENERIC_HW || HARDWARE_TYPE == MD_MAX72XX::PAROLA_HW);

#if DEBUG
  //Serial.begin(57600);
  //Serial.println("[Double Height demo start]");
#endif

  // initialise the LED display
  P.begin(MAX_ZONES);

  // Set up zones for 2 halves of the display
  // Each zone gets a different font, making up the top
  // and bottom half of each letter
  P.setZone(ZONE_LOWER, 0, ZONE_SIZE - 1);
  P.setFont(ZONE_LOWER, BigFontLower);

  P.setZone(ZONE_UPPER, ZONE_SIZE, MAX_DEVICES-1);
  P.setFont(ZONE_UPPER, BigFontUpper);
  P.setCharSpacing(P.getCharSpacing() * 2); // double height --> double spacing
  if (invertUpperZone)
  {
    P.setZoneEffect(ZONE_UPPER, true, PA_FLIP_UD);
    P.setZoneEffect(ZONE_UPPER, true, PA_FLIP_LR);
  }
  String str1=EEPROM.readString(50);
  if(str1==""){
       str1="Please Enter Your Text";
  }
  strcpy(msg,str1.c_str());

  //strcat(msg,",");
 // strcat(msg,str1.c_str());
Serial.println("Text: " +str1);
SCROLL_SPEED=100-EEPROM.readInt(20);
delay(200);
Serial.print("Speed: ");
Serial.println(SCROLL_SPEED);
delay(200);
contrast=EEPROM.readInt(25)/20;
delay(200);
 Serial.print("Brightness " );
 Serial.println(contrast);
}

void loop(void)
{
 
        lastvalue="";
        currentstatus();
       
          
  if(ESP_BT.available()){
     while (ESP_BT.available()) //Check if we receive anything from Bluetooth
     {
      incoming = ESP_BT.read(); //Read what we recevive 
       Serial.print("Received:"); Serial.println(incoming); 
           if(incoming=='R'){
            ESP.restart();
         }
          if(incoming=='w'){
             ESP_BT.print(lastvalue);
            
          }
     if(m>=1 && incoming!='/')
      {
         if (incoming == ',') {
             m=0;
             break;
            } //breaks out of capture loop to print readstring
         if(m==1){
            readString2+=incoming;
           }
        }
       //breaks out of capture loop to print readstring
       else{
        if (incoming == '/') {
          m=m+1;
         }
        else
         {
           //Serial.println("data");
            readString1+=incoming;
              
            }       
          }
          
        }
  }
        
       
      
      if(readString2!=""){
          EEPROM.writeString(50, readString2);
         EEPROM.commit();
         strcpy(msg,readString2.c_str());
         P.displayClear();
         // ESP.restart();

        // Serial.println(EEPROM.readString(50));
      }
    if(readString1!=""){
      
      int val=readString1.toInt();
     //  Serial.print("Speed: ");
       // Serial.println(val);
        if(val>=1 && val<=100)
        {
          P.displayClear();
          SCROLL_SPEED=100-val;
          EEPROM.writeInt(20,val);
          EEPROM.commit();
        
        }

        if(val>=101 && val<=201){
          int val1=val-101;
          contrast=val1/20;
          EEPROM.writeInt(25,val1);
          EEPROM.commit();
          P.displayClear();
          P.setIntensity(contrast);
        
          
        }

      
    }
        P.setIntensity(contrast);
        printdis();
 
}

void printdis()
{
 // static uint8_t cycle = 0;
    P.displayAnimate();

  if (P.getZoneStatus(ZONE_LOWER) && P.getZoneStatus(ZONE_UPPER))
  {
#if DEBUG
    Serial.println(cycle);
#endif

      P.setFont(ZONE_LOWER, BigFontLower);
      P.setFont(ZONE_UPPER, BigFontUpper);
      P.displayZoneText(ZONE_LOWER, msg, PA_RIGHT, SCROLL_SPEED, 0, PA_SCROLL_LEFT, PA_SCROLL_LEFT);
      P.displayZoneText(ZONE_UPPER, msg, PA_LEFT, SCROLL_SPEED, 0, PA_SCROLL_LEFT, PA_SCROLL_LEFT);
    //cycle = (cycle + 1) % ARRAY_SIZE(msg);

    // synchronise the start
    P.displayClear();
    P.synchZoneStart();
    readString1="";
    readString2="";
    m=0;
  }
}

void currentstatus()
{
String sp="",con="";
  lastvalue+=EEPROM.readString(50);
  lastvalue+="/";
  int  ma=EEPROM.readInt(20);
       sp=String(ma);
       lastvalue+=sp;
       lastvalue+="/";
 int  ma1=EEPROM.readInt(25);
       con=String(ma1);
       lastvalue+=con;
       lastvalue+="/";
}
