;--------------------------
; THIS IS RX
; PROJECT :8 channel remote control
; CRYSTAL 4 MHz
; RC5 FORMAT @38KHz , 35% duty cycle
; ADDRESS = 0X0B
; ch1  = 0X01
; ch2  = 0X02
; ch3  = 0X03
; ch4  = 0X04
; ch5  = 0X05
; ch6  = 0X06
; ch7  = 0X07
; ch8  = 0X08

; NOT USE TOGGLE ALWAY = 1
; start date : 16 Dec 2005
;--------------------------

	list P=16F630
	#include <P16F630.INC>
	__config _WDT_OFF & _XT_OSC & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON


#DEFINE IR		PORTA,3	; IR LED input with R10K pull-up to vcc
#DEFINE OUT1	PORTA,2	; Drive output 1
#DEFINE OUT2	PORTC,0	; Drive output 2
#DEFINE OUT3	PORTC,1	; Drive output 3
#DEFINE OUT4	PORTC,2	; Drive output 4
#DEFINE OUT5	PORTA,1	; Drive output 5
#DEFINE OUT6	PORTC,5	; Drive output 6
#DEFINE OUT7	PORTC,4	; Drive output 7
#DEFINE OUT8	PORTC,3	; Drive output 8

#DEFINE SP  	PORTA,0	; Speaker

#DEFINE OUT1_M	0x01
#DEFINE OUT2_M	0x02
#DEFINE OUT3_M	0x04

#DEFINE TOG_BIT TOGGLE,1
#DEFINE ADDRS	0X0B        ; 0000 1011        ; 0000 1110 

#DEFINE CH1_CMD	0X01
#DEFINE CH2_CMD	0X02
#DEFINE CH3_CMD	0X03
#DEFINE CH4_CMD	0X04
#DEFINE CH5_CMD	0X05
#DEFINE CH6_CMD	0X06
#DEFINE CH7_CMD	0X07
#DEFINE CH8_CMD	0X08

CNT1	EQU	20H
CNT2	EQU	21H
CNT3	EQU	22H
CNT4	EQU	23H
TEMP	EQU	24H
TOGGLE	EQU	25H
ADDR	EQU	26H
CMD		EQU	27H
IO		EQU	28H



	ORG	000

	
	CLRF	PORTA
	MOVLW	0X07
	MOVWF	CMCON	; MAKE ALL GPIO TO DIGITAL I/O	
	CLRF	PORTC
	CALL	DEBOUNCE	
	
	BSF		STATUS,RP0	
	MOVLW	0X01	; enable RA pull-up	AND T0 PRESCALER = 4
	MOVWF	OPTION_REG   		
	CLRF	TRISC	
	MOVLW	B'00001000'
	MOVWF	TRISA	        
    BCF		WPUA,2
    BCF		WPUA,1
    BCF		WPUA,0
	BCF		STATUS,RP0
	
	BCF		INTCON,GIE			
	CLRF	IO
	;	

MAIN:

	CALL	DELAY3500
	CALL	GET_RC5	
	BTFSC	STATUS,C
	GOTO	MAIN
	;				
	MOVF	ADDR,W	
	XORLW	ADDRS
	BTFSS	STATUS,Z
	GOTO	MAIN		; ADDRESS ERROR
	;	
	BSF		SP
	CALL	DEBOUNCE
	CALL	DEBOUNCE
	CALL	DEBOUNCE
	CALL	DEBOUNCE
	BCF		SP
	;
    
	DECF	CMD,W			; DECREATE RANK TO 0-7 ONLY
	ANDLW	0X07		; MASK 3 LSB
	ADDWF	PCL,F
	GOTO	DO_CH1
	GOTO	DO_CH2
	GOTO	DO_CH3
	GOTO	DO_CH4
	GOTO	DO_CH5
	GOTO	DO_CH6
	GOTO	DO_CH7
	GOTO	DO_CH8

DO_CH1:
	BTFSC	IO,0 
	GOTO	SETIO1	
	BSF		OUT1
	BSF		IO,0	
	GOTO	MAIN
SETIO1:
	BCF		OUT1
	BCF		IO,0	
	GOTO	MAIN	
	;
DO_CH2:	
	BTFSC	IO,1 
	GOTO	SETIO2	
	BSF		OUT2
	BSF		IO,1	
	GOTO	MAIN
SETIO2:
	BCF		OUT2
	BCF		IO,1	
	GOTO	MAIN		
	;
DO_CH3:	
	BTFSC	IO,2 
	GOTO	SETIO3
	BSF		OUT3
	BSF		IO,2	
	GOTO	MAIN
SETIO3:
	BCF		OUT3
	BCF		IO,2	
	GOTO	MAIN		
	;
DO_CH4:	
	BTFSC	IO,3 
	GOTO	SETIO4
	BSF		OUT4
	BSF		IO,3	
	GOTO	MAIN
SETIO4:
	BCF		OUT4
	BCF		IO,3	
	GOTO	MAIN		
	;
DO_CH5:	
	BTFSC	IO,4 
	GOTO	SETIO5
	BSF		OUT5
	BSF		IO,4	
	GOTO	MAIN
SETIO5:
	BCF		OUT5
	BCF		IO,4	
	GOTO	MAIN			

	;
DO_CH6:	
	BTFSC	IO,5 
	GOTO	SETIO6
	BSF		OUT6
	BSF		IO,5	
	GOTO	MAIN
SETIO6:
	BCF		OUT6
	BCF		IO,5	
	GOTO	MAIN			

	;
DO_CH7:	
	BTFSC	IO,6 
	GOTO	SETIO7
	BSF		OUT7
	BSF		IO,6	
	GOTO	MAIN
SETIO7:
	BCF		OUT7
	BCF		IO,6	
	GOTO	MAIN			
	
	;
DO_CH8:	
	BTFSC	IO,7 
	GOTO	SETIO8
	BSF		OUT8
	BSF		IO,7	
	GOTO	MAIN
SETIO8:
	BCF		OUT8
	BCF		IO,7	
	GOTO	MAIN			
	
	;

;======================================
; READ RC5 Format
; OUTPUT : TOGGLE.7 = TOGGLE BIT
;	       ADDR = ADDRESS 5 BIT 
;	        CDM = COMMAND 6 BIT
;	          C = 0 READ OK
;		    = 1 READ ERROR
;======================================
GET_RC5:
	BTFSC	IR
	GOTO	GET_RC5		; WAIT IR LOW
	CLRF	TMR0		; clear timer 0
    
	BCF		INTCON,T0IF	; CLR timer 0 flag

	;
	BTFSC	INTCON,T0IF     
	GOTO	ERR1		
	;
	BTFSS	IR
	GOTO	$-3
	;	
	MOVF	TMR0,W		
	;MOVLW	0xC8		; FOR TEST
	MOVWF	TEMP
	MOVLW	0XFF		; 1020 mS = 255*4
	SUBWF	TEMP,W
	BTFSC	STATUS,C
	GOTO	ERR1		; ERROR IF Time > 1020 uS
	MOVLW	0XC8		; 800 mS
	SUBWF	TEMP,W
	BTFSS	STATUS,C
	GOTO	ERR1		; ERROR IF Time < 800 uS  (C8h * TM0 Prescaler = 800 uS )
	;
	BTFSC	IR  		; Time validate 800uS-1020uS
	GOTO	$-1		; WAIT TO LOW (Syn BIT)
	CALL	DELAY1252	; DELAY 3/4 BIT LENGHT=1252 uS
	;
	BTFSS	IR
	BCF		TOGGLE,7	
	BTFSC	IR
	BSF		TOGGLE,7	
	;		
	BTFSS	IR
	GOTO	$+4
	BTFSC	IR
	GOTO	$-1
	GOTO	READ	
	;
	BTFSS	IR
	GOTO	$-1

;====== READ ADDRESS 5 BIT ===========
; READ MSB FIRST
;	
READ:	
	MOVLW	5
	MOVWF	TEMP	; LOOP COUNTER
	CLRF	ADDR
	;	
READ1:	
	CALL	DELAY1252
	BTFSS	IR
	BCF		STATUS,C
	BTFSC	IR
	BSF		STATUS,C
	RLF		ADDR,F	; SHIFT LEFT ADDRESS
	;
	BTFSS	IR
	GOTO	$+4
	BTFSC	IR	; WAIT LOW
	GOTO	$-1
	GOTO	$+3
	;
	BTFSS	IR
	GOTO	$-1
	;
	DECFSZ	TEMP,F
	GOTO	READ1
	;
;====== READ COMMAND 6 BIT ===========	
; READ MSB FIRST
;
	MOVLW	6
	MOVWF	TEMP	; LOOP COUNTER
	CLRF	CMD
	;	
CMD1:	
	CALL	DELAY1252
	BTFSS	IR
	BCF		STATUS,C
	BTFSC	IR
	BSF		STATUS,C
	RLF		CMD,F	; SHIFT LEFT COMMAND
	;
	BTFSS	IR
	GOTO	$+4
	BTFSC	IR
	GOTO	$-1
	GOTO	$+3
	;
	BTFSS	IR
	GOTO	$-1
	;
	DECFSZ	TEMP,F
	GOTO	CMD1
	;	
	MOVLW	0X3F	; 0011 1111
	ANDWF	CMD,F
	MOVLW	0X1F	; 0001 1111
	ANDWF	ADDR,F
	BCF		STATUS,C	; C=0 NO ERROR
	RETURN
	;
ERR1:	
	BSF	STATUS,C	; C=1 HAVE ERROR	
	RETURN	
;======================================
; DEBOUNCE SWITCH
; DELAY 15 mS
;======================================
DEBOUNCE:
	MOVLW	.1		; 1
	MOVWF	CNT1		; 1
DEL_1:	MOVLW	.20
	MOVWF	CNT2		; 1
DEL_2:	CLRF	CNT3		; 1
DEL_3:	DECFSZ	CNT3,F		; 1/2
	GOTO	DEL_3		; 2
	DECFSZ	CNT2,F		; 1/2
	GOTO	DEL_2		; 2
	DECFSZ	CNT1,F		; 1/2
	GOTO	DEL_1		; 2
	RETLW	0		; 2

;======================================
; DELAY 1.252mS
;======================================
DELAY1252: 
	MOVLW	.1		; 1
	MOVWF	CNT1		; 1
REP_1:	MOVLW	.5
	MOVWF	CNT2		; 1
REP_2:	MOVLW	.81
	MOVWF	CNT3		; 1
REP_3:	DECFSZ	CNT3,F		; 1/2
	GOTO	REP_3	; 2
	DECFSZ	CNT2,F		; 1/2
	GOTO	REP_2	; 2
	DECFSZ	CNT1,F		; 1/2
	GOTO	REP_1	; 2
	GOTO	$+1	
	GOTO	$+1	
	GOTO	$+1	
	GOTO	$+1	
	RETURN			; 2



DELAY3500:	
	MOVLW	.1		; 1
	MOVWF	CNT1		; 1
	MOVLW	.23
	MOVWF	CNT2		; 1
	MOVLW	.50
	MOVWF	CNT3
	DECFSZ	CNT3,F		; 1/2
	GOTO	$-1		; 2
	DECFSZ	CNT2,F		; 1/2
	GOTO	$-5		; 2
	DECFSZ	CNT1,F		; 1/2
	GOTO	$-9		; 2
	RETLW	0		; 2

DELAY1S:
	MOVLW	.6		; 1
	MOVWF	CNT1		; 1
	MOVLW	.0
	MOVWF	CNT2		; 1
	MOVLW	.0
	MOVWF	CNT3
	DECFSZ	CNT3,F		; 1/2
	GOTO	$-1		; 2
	DECFSZ	CNT2,F		; 1/2
	GOTO	$-5		; 2
	DECFSZ	CNT1,F		; 1/2
	GOTO	$-9		; 2
	RETLW	0		; 2
	
	END
	
	
		
