;------------------------------------------------------
; PROJECT : 8 CHANNEL TX IR REMOTE
; CRYSTAL 4 MHz
; MPLAB : 7.11 , Assembly
; RC5 FORMAT @38KHz , 35% DUTY CYCLE
; ADDRESS = 0X0b
; CH1  = 0X01
; CH2  = 0X02
; CH3  = 0X03
; CH4  = 0X04
; CH5  = 0X05
; CH6  = 0X06
; CH7  = 0X07
; CH8  = 0X08

; NOT USE TOGGLE ALWAY = 1

; 16 Dec 2005
; 
; FREE TO USE FOR PERSONAL OR EVEN COMERCIAL PRODUCT
;------------------------------------------------------

	list P=16F630
	#include <P16F630.INC>
	__config _WDT_OFF & _XT_OSC & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON


#DEFINE IR      PORTC,4
#DEFINE TOG_BIT TOGGLE,1 ; TOGLE BIT NOT USE FOR THIS PROJECT	
#DEFINE CH1_CMD	0X01	; CHANNEL 1 COMMAND
#DEFINE CH2_CMD	0X02	; CHANNEL 2 COMMAND
#DEFINE CH3_CMD	0X03	; CHANNEL 3 COMMAND
#DEFINE CH4_CMD	0X04	; CHANNEL 4 COMMAND
#DEFINE CH5_CMD	0X05	; CHANNEL 5 COMMAND
#DEFINE CH6_CMD	0X06	; CHANNEL 6 COMMAND
#DEFINE CH7_CMD	0X07	; CHANNEL 7 COMMAND
#DEFINE CH8_CMD	0X08	; CHANNEL 8 COMMAND


CNT1	EQU	20H
CNT2	EQU	21H
CNT3	EQU	22H
CNT4	EQU	23H
TOGGLE	EQU	24H
CMD		EQU	25H	; IR COMMAND BUFFER
PREV_PORTA EQU	26H
Temp	EQU	27H


	ORG		000
	GOTO	START
	
	ORG		004H
	GOTO	ISR
	
START:	
	BCF		IR
	CLRF	PORTC
	CALL	DEBOUNCE
	;
	MOVLW	0X07
	MOVWF	CMCON	; MAKE ALL GPIO TO DIGITAL I/O
	
	BSF		STATUS,RP0
	
	BCF		OPTION_REG,7    ; ENABLE WEAK PULL-UP
	BSF		WPUA,1			; ENABLE WEAK PULL-UP FOR RA1
	BSF		WPUA,2			; ENABLE WEAK PULL-UP FOR RA2
	BSF		TRISA,1
	BSF		TRISA,2
	BSF		IOCA,1
	BSF		IOCA,2
	CLRF	TRISC
	
	BCF		STATUS,RP0	
	
	BCF		INTCON,RAIE	
	MOVF	PORTA,W
	BSF		INTCON,RAIE	
	BSF		INTCON,GIE	
	
	
	MOVLW	0X00
	MOVWF	PREV_PORTA
	BCF		TOG_BIT
	
;------------------------------------
; MAIN LOOP	
MAIN:	
	SLEEP	; GOTO SLEEP MODE(I a sleepy! and need to save my energy)
	GOTO	MAIN	

	;	
;======================================
; SEND LOGIC 0
;======================================
LOGIC0:	MOVLW	.32		; 1
	MOVWF	CNT1		; 1
	;
LOG0_1:	BSF	IR		; 1 MAKE IR HIGH 35% Duty cycle = 9 uS
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	;
	;===================================
	BCF	IR		; 1 MAKE IR LOW 17 uS
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	NOP			; 1
	;
	DECFSZ	CNT1,F		; 1/2
	GOTO	LOG0_1		; 2    26 uS
	;
	CALL	DELAY_OFF
	RETURN			; 2
	;
;======================================
; SEND LOGIC 1
;======================================
LOGIC1:	CALL	DELAY_OFF	; DELAY 899 uS
	MOVLW	.32		; 1
	MOVWF	CNT1		; 1
	;
LOG1_1:	BSF	IR		; 1 MAKE IR HIGH 35% Duty cycle = 9 uS
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	;
	;===================================
	BCF	IR		; 1 MAKE IR LOW 17 uS
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	NOP			; 1
	;
	DECFSZ	CNT1,F		; 1/2
	GOTO	LOG1_1		; 2
	;
	RETURN			; 2
	;
;======================================
; DELAY FOR NO CARRAIR
; DELAY ABOUT 835 uS
;======================================
DELAY_OFF:
	MOVLW	5		; 1
	MOVWF	CNT3		; 1	
	MOVLW	.54		; 1
	MOVWF	CNT4		; 1
	DECFSZ	CNT4,F		; 1/2
	GOTO	$-1		; 2	
	DECFSZ	CNT3,F  	; 1/2
	GOTO	$-5		; 2
	RETURN			; 2
	
;======================================
; SEND RC5 TO REMOTE
; INPUT : CMD (6 BIT IR COMMAND)
;======================================
SEND_RC5:
	; SEND 2 START  BIT
	CALL	LOGIC1
	CALL	LOGIC1
	; SEND TOGGLE BIT
	BTFSS	TOG_BIT
	GOTO	$+3
	CALL	LOGIC1
	GOTO	$+2
	CALL	LOGIC0

	; SEND ADDRESS 5 BIT FIX AT 01011 (0X0B) IT MAY BE CHANGED BY YOU
	CALL	LOGIC0	; 0  MSB FIRST BIT 4
	CALL	LOGIC1	; 1
	CALL	LOGIC0	; 0
	CALL	LOGIC1	; 1
	CALL	LOGIC1	; 1  LSB BIT 0
	;
	; SEND COMMAND 6 BIT(00HH LLLL) MSB FIRST
	BCF	STATUS,C
	RLF	CMD,F	; AFTER FIRST ROTAGE 0HHL LLL0
	RLF	CMD,F	; AFTER SECOND ROTAGE HHLL LL00
	;
	MOVLW	6
	MOVWF	CNT2
	;
	RLF	CMD,F    	; SEND MSB FIRST
	BTFSS	STATUS,C
	GOTO	$+3
	CALL	LOGIC1
	GOTO	$+2
	;
	CALL	LOGIC0
	DECFSZ	CNT2,F
	GOTO	$-7
	;
	RETLW	0		
	;	
	
;======================================
; DEBOUNCE SWITCH
; DELAY 15 mS
;======================================
DEBOUNCE:
	MOVLW	.1		; 1
	MOVWF	CNT1		; 1
DEL_1:	MOVLW	.20
	MOVWF	CNT2		; 1
DEL_2:	CLRF	CNT3		; 1
DEL_3:	DECFSZ	CNT3,F		; 1/2
	GOTO	DEL_3		; 2
	DECFSZ	CNT2,F		; 1/2
	GOTO	DEL_2		; 2
	DECFSZ	CNT1,F		; 1/2
	GOTO	DEL_1		; 2
	RETLW	0		    ; 2



;=======================================
; INTERRUPT SERVICE ROUTINE
; FOR RA PIN CHANGED
;=======================================
ISR:	
	BTFSS	INTCON,RAIF
	GOTO	END_ISR

	BCF		INTCON,RAIE	
	MOVF	PORTA,F    
	BCF		INTCON,RAIF    
	CALL	DEBOUNCE		; DEBOUNCE SWITCH
    ;
    MOVF	PREV_PORTA,W
    XORWF	PORTA,W
    XORLW	2
    BTFSC	STATUS,Z
    BTFSC	PORTA,1    
    GOTO	ISR2
    ;
    MOVLW	0XFE
    MOVWF	PORTC
    BTFSC	PORTA,1
    GOTO	ISR3
    MOVLW	7
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X1
    ;
ISR3:
	MOVLW	0XFD
    MOVWF	PORTC
    BTFSC	PORTA,1
    GOTO	ISR4
    MOVLW	5
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X1
    ;    
ISR4:
	MOVLW	0XFB
    MOVWF	PORTC
    BTFSC	PORTA,1
    GOTO	ISR5
    MOVLW	3
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X1
    ;    	    
ISR5:
	MOVLW	0XF7
    MOVWF	PORTC
    BTFSC	PORTA,1
    GOTO	END_ISR
    MOVLW	1
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X1
	;	    
;------------------------------------
ISR2:    
    MOVF	PREV_PORTA,W
    XORWF	PORTA,W
    XORLW	4
    BTFSC	STATUS,Z
    BTFSC	PORTA,2    
    GOTO	END_ISR
    ;
    MOVLW	0XFE
    MOVWF	PORTC
    BTFSC	PORTA,2
    GOTO	ISR6
    MOVLW	8
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X2
    ;
ISR6:    
    MOVLW	0XFD
    MOVWF	PORTC
    BTFSC	PORTA,2
    GOTO	ISR7
    MOVLW	6
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X2
    ;
ISR7:    
    MOVLW	0XFB
    MOVWF	PORTC
    BTFSC	PORTA,2
    GOTO	ISR8
    MOVLW	4
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X2
    ;    
ISR8:    
    MOVLW	0XF7
    MOVWF	PORTC
    BTFSC	PORTA,2
    GOTO	END_ISR
    MOVLW	2
    MOVWF	CMD
    CALL	SEND_RC5
    GOTO	END_ISR_X2
    ;    
END_ISR_X1:
	BTFSS	PORTA,1	
	GOTO	$-1
	CALL	DEBOUNCE
	GOTO	END_ISR
	;
END_ISR_X2:
	BTFSS	PORTA,2	
	GOTO	$-1
	CALL	DEBOUNCE
	GOTO	END_ISR
	;
;-------------------------------------    
	;	
END_ISR:	

	;BTFSS	PORTA,1
	;GOTO	END_ISR
	;BTFSS	PORTA,2
	;GOTO	END_ISR		
	
	CLRF	PORTC
	MOVF	PORTA,W
	MOVWF	PREV_PORTA
	BCF		INTCON,RAIF	
	BSF		INTCON,RAIE	
	RETFIE
	
	END
	
