#ifndef _MCP2515_H_
#define _MCP2515_H_

#include "types.h"

#define	RXF0SIDH	0x00
#define	RXF0SIDL	0x01
#define	RXF0EID8	0x02
#define	RXF0EID0	0x03
#define	RXF1SIDH	0x04
#define	RXF1SIDL	0x05
#define	RXF1EID8	0x06
#define	RXF1EID0	0x07
#define	RXF2SIDH	0x08
#define	RXF2SIDL	0x09
#define	RXF2EID8	0x0A
#define	RXF2EID0	0x0B
#define	BFPCTRL		0x0C
#define	TXRTSCTRL	0x0D
#define	CANSTAT		0x0E
#define	CANCTRL		0x0F

#define	RXF3SIDH	0x10
#define	RXF3SIDL	0x11
#define	RXF3EID8	0x12
#define	RXF3EID0	0x13
#define	RXF4SIDH	0x14
#define	RXF4SIDL	0x15
#define	RXF4EID8	0x16
#define	RXF4EID0	0x17
#define	RXF5SIDH	0x18
#define	RXF5SIDL	0x19
#define	RXF5EID8	0x1A
#define	RXF5EID0	0x1B
#define	TEC		0x1C
#define	REC		0x1D
#define	CANSTAT1	0x1E
#define	CANCTRL1	0x1F

#define	RXM0SIDH	0x20
#define	RXM0SIDL	0x21
#define	RXM0EID8	0x22
#define	RXM0EID0	0x23
#define	RXM1SIDH	0x24
#define	RXM1SIDL	0x25
#define	RXM1EID8	0x26
#define	RXM1EID0	0x27
#define	CNF3		0x28
#define	CNF2		0x29
#define	CNF1		0x2A
#define	CANINTE		0x2B
#define	CANINTF		0x2C
#define	EFLG		0x2D
#define	CANSTAT2	0x2E
#define	CANCTRL2	0x2F

#define	TXB0CTRL	0x30
#define	TXB0SIDH	0x31
#define	TXB0SIDL	0x32
#define	TXB0EID8	0x33
#define	TXB0EID0	0x34
#define	TXB0DLC		0x35
#define	TXB0D0		0x36
#define	TXB0D1		0x37
#define	TXB0D2		0x38
#define	TXB0D3		0x39
#define	TXB0D4		0x3A
#define	TXB0D5		0x3B
#define	TXB0D6		0x3C
#define	TXB0D7		0x3D
#define	CANSTAT3	0x3E
#define	CANCTRL3	0x3F

#define	TXB1CTRL	0x40
#define	TXB1SIDH	0x41
#define	TXB1SIDL	0x42
#define	TXB1EID8	0x43
#define	TXB1EID0	0x44
#define	TXB1DLC		0x45
#define	TXB1D0		0x46
#define	TXB1D1		0x47
#define	TXB1D2		0x48
#define	TXB1D3		0x49
#define	TXB1D4		0x4A
#define	TXB1D5		0x4B
#define	TXB1D6		0x4C
#define	TXB1D7		0x4D
#define	CANSTAT4	0x4E
#define	CANCTRL4	0x4F

#define	TXB2CTRL	0x50
#define	TXB2SIDH	0x51
#define	TXB2SIDL	0x52
#define	TXB2EID8	0x53
#define	TXB2EID0	0x54
#define	TXB2DLC		0x55
#define	TXB2D0		0x56
#define	TXB2D1		0x57
#define	TXB2D2		0x58
#define	TXB2D3		0x59
#define	TXB2D4		0x5A
#define	TXB2D5		0x5B
#define	TXB2D6		0x5C
#define	TXB2D7		0x5D
#define	CANSTAT5	0x5E
#define	CANCTRL5	0x5F

#define	RXB0CTRL	0x60
#define	RXB0SIDH	0x61
#define	RXB0SIDL	0x62
#define	RXB0EID8	0x63
#define	RXB0EID0	0x64
#define	RXB0DLC		0x65
#define	RXB0D0		0x66
#define	RXB0D1		0x67
#define	RXB0D2		0x68
#define	RXB0D3		0x69
#define	RXB0D4		0x6A
#define	RXB0D5		0x6B
#define	RXB0D6		0x6C
#define	RXB0D7		0x6D
#define	CANSTAT6	0x6E
#define	CANCTRL6	0x6F

#define	RXB1CTRL	0x70
#define	RXB1SIDH	0x71
#define	RXB1SIDL	0x72
#define	RXB1EID8	0x73
#define	RXB1EID0	0x74
#define	RXB1DLC		0x75
#define	RXB1D0		0x76
#define	RXB1D1		0x77
#define	RXB1D2		0x78
#define	RXB1D3		0x79
#define	RXB1D4		0x7A
#define	RXB1D5		0x7B
#define	RXB1D6		0x7C
#define	RXB1D7		0x7D
#define	CANSTAT7	0x7E
#define	CANCTRL7	0x7F

/*
 * CANCTRL
 */
#define	MODE_NORMAL		0x00
#define	MODE_SLEEP		0x20
#define	MODE_LOOPBACK	0x40
#define	MODE_LISTENONLY	0x60
#define	MODE_CONFIG		0x80
#define	MODE_POWERUP	0xE0
#define	MODE_MASK		0xE0
#define	ABORT_TX		0x10
#define	ONESHOT_ENABLE	0x08
#define	ONESHOT_DISABLE	0x00
#define	CLKOUT_ENABLE	0x04
#define	CLKOUT_DISABLE	0x00
#define	CLKOUT_PS1		0x00
#define	CLKOUT_PS2		0x01
#define	CLKOUT_PS4		0x02
#define	CLKOUT_PS8		0x03

/*
 * CANSTAT
 */
#define	IS_IN_MODE_NORMAL		0x00
#define	IS_IN_MODE_SLEEP		0x20
#define	IS_IN_MODE_LOOPBACK		0x40
#define	IS_IN_MODE_LISTENONLY	0x60
#define	IS_IN_MODE_CONFIG		0x80

/*
 * CANINTE
 */
#define	MERRE					BIT(7)
#define	WAKIE					BIT(6)
#define	ERRIE					BIT(5)
#define	TX2IE					BIT(4)
#define	TX1IE					BIT(3)
#define	TX0IE					BIT(2)
#define	RX1IE					BIT(1)
#define	RX0IE					BIT(0)
#define	ALL_INTERRUPTS_DISABLE	(0x00)

/*
 * CANINTF
 */
#define	MERRF			BIT(7)
#define	WAKIF			BIT(6)
#define	ERRIF			BIT(5)
#define	TX2IF			BIT(4)
#define	TX1IF			BIT(3)
#define	TX0IF			BIT(2)
#define	RX1IF			BIT(1)
#define	RX0IF			BIT(0)
#define	NO_INTERRUPTS	0x00

/*
 EFLG
*/
#define	RX1OVR		BIT(7)
#define	RX0OVR		BIT(6)
#define	TXBO		BIT(5)	// Bus-Off Error Flag, TEC == 255
#define	TXEP		BIT(4)	// Trasmit Error-Passive Flag, TEC >= 128
#define	RXEP		BIT(3)	// Receive	Error-Passive Flag, REC >= 128
#define	TXWAR		BIT(2)	// Trasmit Error Warning Flag, TEC >= 96
#define	RXWAR		BIT(1)	// Receive Error Warning Flag, REC >= 96
#define	EWARN		BIT(0)	// Error Warning Flag, TXWAR == 1 || RXWAR == 1
#define	NO_ERROR	0x00

/*
 CNF1
*/
#define	SJW1	0x00
#define	SJW2	0x40
#define	SJW3	0x80
#define	SJW4	0xC0

/*
 CNF2
*/
#define	BTLMODE		0x80
#define	SAMPLE_1X	0x00
#define	SAMPLE_3X	0x40

/*
 CNF3
*/
#define	SOF_ENABLE		0x80
#define	SOF_DISABLE		0x00
#define	WAKFIL_ENABLE	0x40
#define	WAKFIL_DISABLE	0x00

/*
 TXBnCTRL
*/
#define	ABTF			0x40
#define	MLOA			0x20
#define	TXERR			0x10
#define	TXREQ			0x08
#define	HIGH_PRIO		0x03
#define	HIGH_IMM_PRIO	0x02
#define	LOW_IMM_PRIO	0x01
#define	LOW_PRIO		0x00

/*
 TXBnSIDL
*/
#define	EXIDE	0x08

/*
 TXBnDLC
*/
#define	RTR_MASK	0x40

/*
 RXB0CTRL
*/
#define	RXB0CTRL_RXM_OFF		0x60
#define	RXB0CTRL_RXM_EXT		0x40
#define	RXB0CTRL_RXM_STD		0x20
#define	RXB0CTRL_RXM_ALL		0x00
//#define	RXB0CTRL_RXM_MASK		0x60
#define	RXRTR					0x08
#define	RXB0CTRL_BUKT			0x04
#define	RXB0CTRL_BUKT1			0x02
#define	RXB0CTRL_FILHIT_RXF1	0x01
#define	RXB0CTRL_FILHIT_RXF0	0x00

/*
 RXB1CTRL
*/
#define	RXB1CTRL_RXM_OFF		0x60
#define	RXB1CTRL_RXM_EXT		0x40
#define	RXB1CTRL_RXM_STD		0x20
#define	RXB1CTRL_RXM_ALL		0x00
//#define	RXB1CTRL_RXM_MASK		0x60
//#define	RXRTR		0x08
#define	RXB1CTRL_FILHIT_RXF5	0x05
#define	RXB1CTRL_FILHIT_RXF4	0x04
#define	RXB1CTRL_FILHIT_RXF3	0x03
#define	RXB1CTRL_FILHIT_RXF2	0x02
#define	RXB1CTRL_FILHIT_RXF1	0x01
#define	RXB1CTRL_FILHIT_RXF0	0x00

/*
 BFPCTRL
*/
#define	B1BFS	BIT(5)
#define	B0BFS	BIT(4)
#define	B1BFE	BIT(3)
#define	B0BFE	BIT(2)
#define	B1BFM	BIT(1)
#define	B0BFM	BIT(0)

#define	SIDH	0
#define	SIDL	1
#define	EID8	2
#define	EID0	3

// 20Kbps, 16MHz
#define SPEED_20_16_CNF1 (0x0F)
#define SPEED_20_16_CNF2 (0x3F)
#define SPEED_20_16_CNF3 (0x00)

// 50Kbps, 16MHz
#define SPEED_50_16_CNF1 (0x07)
#define SPEED_50_16_CNF2 (0x3A)
#define SPEED_50_16_CNF3 (0x00)

// 125Kbps, 16MHz
#define SPEED_125_16_CNF1 (0x03)
#define SPEED_125_16_CNF2 (0x30)
#define SPEED_125_16_CNF3 (0x00)

/*
 az MCP2515 SPI-n kldhet utastsai
*/
#define	MCP_RESET		0xC0
#define	MCP_READ			0x03

#define	MCP_READ_RX0	0x90
#define	MCP_READ_RX1	0x94

#define	MCP_WRITE		0x02

#define	MCP_LOAD_TX0	0x40
#define	MCP_LOAD_TX1	0x42
#define	MCP_LOAD_TX2	0x44

#define	MCP_RTS_TX0		0x81
#define	MCP_RTS_TX1		0x82
#define	MCP_RTS_TX2		0x84
#define	MCP_RTS_ALL		0x87

#define	MCP_READ_STATUS	0xA0
#define	MCP_RX_STATUS		0xB0
#define	MCP_BITMOD			0x05

typedef struct {
	BYTE type;
	DWORD id;
	BYTE rtr;
	BYTE data[8];
	BYTE dlc;
} CAN_message_t;

struct CANStatus {
	unsigned RxBufferEmpty:1;		// 1, ha a puffer res
	unsigned RxBufferFull:1;		// 1, ha a puffer megtelt
	unsigned RxOverFlow:1;	// 1, ha rfuts trtnt
	unsigned CAN_ERROR:1;
	unsigned CAN_SEND_TIMEOUT;
};

extern struct CANStatus CANStatus;

#define CAN_EXT_ID (1)
#define CAN_STD_ID (0)

#define RTR_PACKET (1)
#define DATA_PACKET (0)

void CAN_Init(BYTE CNF1_data, BYTE CNF2_data, BYTE CNF3_data);
void CANRTRPacket(DWORD id);
void CANDATAPacket(DWORD id, BYTE *ptr, BYTE len);
unsigned char CANIntGetPacket(CAN_message_t *ret);

#endif
