/*
 * drv_spi.c
 */

#include <p18cxxx.h>

#include "types.h"
#include "drv_spi.h"

/*
 * SPI_task
 */
void SPI_Task(SPI_message_t *ref)
{
	ram char *SPI_CS_port;
	BYTE SPI_CS_bit;
	BYTE i, temp;
	ram unsigned char *addr;
	int len;
	bool expected_char_mode;
	BYTE expected_char, SDIChar;

	SSPCON1 &= 0xF0;
	SSPCON1 |= (ref->SpeedBits & 0x0F);
	SPI_CS_port = ref->CS_address;
	SPI_CS_bit = ref->CS_bit;
	if (SPI_CS_port) {	/* if != NULL */
		*(SPI_CS_port+0x12) &= ~BIT(SPI_CS_bit);	/* Set CS pin as output */
		*(SPI_CS_port+0x09) &= ~BIT(SPI_CS_bit);	/* Chip select pin goes low */
	}

	/* first, middle, last */
	for (i = 0; i < 3; i++) {
		addr = ref->SDO[i].addr;
		len = ref->SDO[i].len;
		while (len--) {
			SSPBUF = *addr++;
			while (!SSPSTATbits.BF);
			temp = SSPBUF;				/* need clear the BF bit in SSPSTAT register */
		}
	}

	/* Receive data if necessary */
	expected_char_mode = ref->expected_char_mode;
	expected_char = ref->expected_char;
	SDIChar = ref->SDIChar;
	if (expected_char_mode) {
		do {
			SSPBUF = SDIChar;
			while (!SSPSTATbits.BF);
		} while(SSPBUF != expected_char);
	}

	addr = ref->SDI.addr;
	len = ref->SDI.len;
	while (len-- > 0) {
		SSPBUF = SDIChar;
		while (!SSPSTATbits.BF);
		*addr++ = SSPBUF;
	}

	if (SPI_CS_port)	/* if != NULL */
		*(SPI_CS_port+0x09) |= BIT(SPI_CS_bit);		/* Chip select pin goes high */
}
