/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */
#define USE_OR_MASKS
#include "piccolo_all.h"
#include "adc.h"
/** \file
 * Mintaprogram a Microchip C18 perifriaknyvtrnak hasznlatra.
 * Kt bemen ADC csatornt figyelnk. 
 * Az elsn a ksrleti ramkr potmtern leosztott feszltsget
 * mrjk, az eredmnyt voltra tszmtva rjuk ki. A msik csatornn egy TC1047A
 * tpus analg hmr jelt mrjk, az eredmnyt Celsius fokokra
 * tszmtva rjuk ki.  
 *
 * Hardver igny:
 *   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
 *     esetleg a Microchip Low Pin Count USB, vagy FSUSB demkrtyja
 *   - USB kapcsolat
 *   - TC1047A analg hmr 
 *
 * Projekt konfigurci: A program mkdshez a HID_BOOTLOADER szimblumon kvl  
 * az USE_INTERRUPT s az USE_USB szimblumokat is definilni kell!  
 */

//-- Projekt konfigurci ellenrzse 
#if !defined(USE_INTERRUPT) 
	#error "Nincs definilva az USE_INTERRUPT szimblum!"
#endif //USE_INTERRUPT
#if !defined(USE_USB)
	#error "Nincs definilva az USE_USB szimblum!"
#endif //USE_USB

#if defined(__18F14K50)
	#define CH_POT 		ADC_CH10	//a potmter AN10-re csatlakozik
	#define CH_THERMO	ADC_CH11	//a hmr AN11-re csatlakozik
	#define VREF_IN_mV	3300		//VDD = 3,3 V milivoltokban
//	#define VREF_IN_mV	5000		//VDD = 5,0 V milivoltokban
	#define vref		0x3FF		//A VDD-hez tartoz ADC rtk
#elif defined(__18F4550)
	#define CH_POT 		ADC_CH0		//a potmter AN0-ra csatlakozik
	#define CH_THERMO	ADC_CH1		//a hmr AN1-re csatlakozik
	#define VREF_IN_mV	5000		//VDD = 5,0 V milivoltokban
	#define vref		0x3FF		//A VDD-hez tartoz ADC rtk
#else
   #error "A vlasztott mikrovezrlt nem tmogatja a PICCOLO project!"  
#endif

//-- Magas priorits programmegszakts kiszolglsa
#pragma interrupt hi_isr
void hi_isr() {
    USBDeviceTasks(); 				//--- USB programmegszakts kiszolglsa
}
//-- Alacsony priorits programmegszakts kiszolglsa
#pragma interruptlow lo_isr
void lo_isr() {
}

/** Kt analg csatorna engedlyezse
 *  A PIC18F14K50 mikrovezrl esetn ezek AN10 s AN11 
 *  a PIC18F4550 mikrovezrl esetn pedig AN0 s AN1
 *  ADC inicializlshoz (rajel FOSC/64, TACQ = 20TAD,
 *  konverzis eredmny jobbra igaztsa) a C18 perifriaknyvtr
 *  makrit s az OpenADC() fggvnyt hasznljuk. 
 */  
void Init_ADC(void)  {
#if defined(__18F14K50)
	TRISBbits.TRISB4 = 1;			//RB4/AN10 legyen bemenet
	TRISBbits.TRISB5 = 1;			//RB5/AN11 legyen bemenet
	OpenADC(ADC_FOSC_64 | ADC_RIGHT_JUST | ADC_20_TAD,
			CH_POT | ADC_INT_OFF,
			ADC_REF_VDD_VSS,
			ENABLE_AN10 | ENABLE_AN11);
#elif defined(__18F4550)
	TRISAbits.TRISA0 = 1;			//RA0/AN0 legyen bemenet
	TRISAbits.TRISA1 = 1;			//RA1/AN1 legyen bemenet
	OpenADC(ADC_FOSC_64 | ADC_RIGHT_JUST | ADC_20_TAD,
			CH_POT | ADC_INT_OFF | ADC_REF_VDD_VSS,
			ADC_2ANA);				//Az els kt csatorna (AN0 s AN1) legyen analg
#else
   #error "A vlasztott mikrovezrlt nem tmogatja a PICCOLO project!"  
#endif
}

/** Egy analg csatorna kivlasztsa, s megmrse. Az ADC kezelshez
 *  a C18 perifriaknyvtr fggvnyeit hasznljuk.
 *  A Read_ADC() fggvny blokkol tpus: kivrja a mrs vgt (~46 us).
 * \param chan a kivlasztott csatorna ADC_CH0, ADC_CH1, ... elre definilt makrja
 *    (valjban a csatorna sorszmnak nyolcszorosa)
 */ 
unsigned int read_ADC(unsigned char chan) { 
	SelChanConvADC(chan);				//Csatorna kivlaszts s konverzi indtsa
	while (BusyADC());    				//Megvrja a konverzi vgt
	return ReadADC();					//Visszatrsi rtk a konverzi eredmnye
}

void main(void) {
	long a,b;							//sszegzre hasznlt 32 bites vltozk
	int i;
	InitializeSystem();
	Init_ADC();							//CH_POT kivlasztsa, 20TAD, FOSC/64, jobbra igazts
    while (!usb_cdc_kbhit()) {
        ProcessIO();                	//-- Megvrjuk az els karakter rkezst
    }
#if defined(__18F14K50)
	outString("PICCOLO-14K50 adclib.c program\n");
#else
	outString("PICCOLO-4550 adclib.c program\n");
#endif
    while (1) {
		a=0L; b=0L;					//Nullzzuk az sszegzsre hasznlt vltozkat
		for(i=0; i<VREF_IN_mV; i++) {
			a+=read_ADC(CH_POT);	//A potmterrl jv feszltsg mrse
			b+=read_ADC(CH_THERMO);	//A hmr kimen jelnek mrse
		}		
		a=a/vref;					//A potmter feszltsge mV-ba tszmtva
		outString(" Vpot = ");
		outdec(a,3);				//Hrom tizedesre rjuk ki Vpot-ot
		outString(" V  Hmrsklet = "); 
		b=b/vref-500L;				//konvertls tizedfok egysgekbe
		outdec(b,1); 				//Egy tizedesre rjuk ki a hmrskletet
		outString(" C \n");
		delay_ms(2000);				//2 s vrakozs s ProcessIO hvogatsa
    } //while
}     //main
