/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */
#include "piccolo_all.h"
#define USE_OR_MASKS  								//"VAGY" mvelettel egyesthet makrk legyenek
#include "timers.h"   								//TIMER0 makrit s tmogati fggvnyeit hasznljuk

/** \file
 * Mintaprogram analg jellel trtn vezrlsre.
 * A potmter leosztott jelt figyeljk s eszerint szablyozzuk a LED-es futfny sebessgt. 
 *
 * Hardver igny:
 *   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC4550 mikrovezrlvel,
 *     esetleg a Microchip Low Pin Count USB, vagy FSUSB demkrtyja
 *
 * Projekt konfigurci: A program mkdshez a HID_BOOTLOADER szimblumon kvl  
 * az USE_INTERRUPT szimblumot is definilni kell! Az USB kapcsolatot nem hasznljuk.
 */

//-- Projekt konfigurci ellenrzse 
#if !defined(USE_INTERRUPT) 
	#error "Nincs definilva az USE_INTERRUPT szimblum!"
#endif //USE_INTERRUPT
#if defined(USE_USB)
	#error "Ehhez a projekthez nem kell USB kapcsolat!"
#endif //USE_USB

volatile unsigned int speed;
volatile unsigned char display;

//-- Magas priorits programmegszakts kiszolglsa
#pragma interrupt hi_isr
void hi_isr() {
	if(INTCONbits.TMR0IF) {							//TIMER0 megszakts kiszolglsa
		INTCONbits.TMR0IF = 0;  					//trli az interrupt jelzbitet
		if(speed) {									//ha a ksleltetsi ciklus mg nem jrt le...
			if(--speed==0) {						//ha ppen most jrt le a ksleltets
				display = (LEDport & 0x0F)>>1;		//jobbra lpteti a LED-ek llapott
				if(!display) display=0x8;			//ha az '1'-es kicsordult, akkor LED4-et bekapcsoljuk 
				ChangeBits(LEDport,display,0x0F);	//a kiszmolt bitkp kirsa
			}
		} //if speed
	} //if TMR0IF
}
//-- Alacsony priorits programmegszakts kiszolglsa
#pragma interruptlow lo_isr
void lo_isr() {
}

/** Az elzetesen kivlasztott csatorna jelnek megmrse.
 *  A fggvny blokkol tpus: kivrja a mrs vgt (~46 us).
 *  A formtum belltstl fggetlenl helyirtkhelyesen 
 *  olvassuk ki az eredmnyt. 
 */
unsigned int ADC_meas(void) { 
	ADCON0bits.GO = 1;              // AD konverzi indtsa
	while (ADCON0bits.NOT_DONE);    // konverzi vgre vr
	if ( ADCON2bits.ADFM )
		return (((unsigned int)ADRESH)<<8)|(ADRESL);
	else
		return ((((unsigned int)ADRESH) << 2) | (ADRESL>>6)) ;
}


void main(void) {
//-- A megszaktsi rendszer belltsa --------
    RCONbits.IPEN=1;				//Ktszint megszaktsi md belltsa
    INTCONbits.GIEH=1;				//A magas priorits interrupt engedlyezse
    INTCONbits.GIEL=0;				//Az alacsony priorits interrupt tiltsa
//-- Timer0 konfigurlsa ~11 ms-os periodikus interrupthoz
    INTCON2bits.TMR0IP=1;			//Timer0 megszakts magas priorits legyen
    OpenTimer0(TIMER_INT_ON 
	     | T0_16BIT 
	     | T0_SOURCE_INT 
	     | T0_PS_1_2 );
    mInitAllLEDs();					//LED1 - LED4 kofigurlsa
    mInitSwitch1();					//SW1 nyomgomb konfigurlsa
	mInitPOT();						//Az ADC konfigurlsa
	mLED_4_On();					//Kezdllapot = LED4 g
	speed=0;						//Nincs rotls az els ADC konverziig
    while (1) {
		speed = (1100 - ADC_meas()) >> 4;
		while(speed); 
		if(SW1==0) Reset();			//Szoftveres reset gombknt hasznljuk SW1-et!
    } //while
}     //main
