/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
/** \file
 * Mintaprogram az ADC hasznlatra, tlagolssal. Kt bemen csatornt figyelnk. 
 * Az elsn a ksrleti ramkr potmtern leosztott feszltsget
 * mrjk, az eredmnyt voltra tszmtva rjuk ki. A msik csatornn egy TC1047A
 * tpus analg hmr jelt mrjk, az eredmnyt Celsius fokokra
 * tszmtva rjuk ki. 
 *
 * Hardver igny:
 *   - PICCOLO projekt alapkapcsols PIC18F14K50 mikrovezrlvel,
 *     esetleg a Microchip Low Pin Count USB demkrtya
 *   - USB kapcsolat
 *   - TC1047A analg hmr, az AN11 (RB5) bemenetre kapcsolva
 *
 *
 *  Projekt konfigurci: A program mkdshez a HID_BOOTLOADER szimblumon kvl  
 *  az USE_INTERRUPT s az USE_USB szimblumokat is definilni kell!  
 */

//-- Projekt konfigurci ellenrzse 
#if !defined(USE_INTERRUPT) 
	#error "Nincs definilva az USE_INTERRUPT szimblum!"
#endif //USE_INTERRUPT
#if !defined(USE_USB)
	#error "Nincs definilva az USE_USB szimblum!"
#endif //USE_USB
#if !defined(__18F14K50) 
	#error "Ez a program PIC18F14K50 mikrovezrlre kszlt!"
#endif //__18F14K50


//-- Magas priorits programmegszakts kiszolglsa
#pragma interrupt hi_isr
void hi_isr() {
    USBDeviceTasks(); //--- USB programmegszakts kiszolglsa
}
//-- Alacsony priorits programmegszakts kiszolglsa
#pragma interruptlow lo_isr
void lo_isr() {
}

/** A PIC18F14K50 mikrovezrl AN10 s AN11 csatornjnak engedlyezses, s az
 *  ADC inicializlsa (AN10 kivlasztsa, rajel FOSC/64, TACQ = 20TAD,
 *  konverzis eredmny jobbra igaztsa). 
 */  
void InitADC(void)  {
	CONFIG_AN10_AS_ANALOG();		//AN10(RB4) analg bemenet belltsa 
	CONFIG_AN11_AS_ANALOG();		//AN11(RB5) analg bemenet belltsa 
	ADCON0=0x28;					//AN10 kivlaszts, ADC mg letiltva
	ADCON1=0;						//VREF+ = VDD, VREF- = VSS
	ADCON2=0xBE;					//20TAD, FOSC/64, jobbra igazts		
	ADCON0bits.ADON=1;				//Az ADC engedlyezse
}

/** Egy analg csatorna kivlasztsa, s megmrse.
 *  A fggvny blokkol tpus: kivrja a mrs vgt (~46 us).
 * \param chan a kivlasztott csatorna AN0, AN1, ... stb. jells szerinti sorszma
 */ 
unsigned int ReadADC(unsigned char chan) { 
	ChangeBits(ADCON0, chan<<2, 0b00111100); 
	ADCON0bits.GO = 1;              // AD konverzi indts
	while (ADCON0bits.NOT_DONE);    // Megvrja a konverzi vgt
	return (((unsigned int)ADRESH)<<8)|(ADRESL);
}

void main(void) {
    unsigned int vref,vpot,vthermo,j;
	long a,b,c;
	InitializeSystem();
	REFCON0=FVR_ENABLE|FVR1S_2048;	//FVR inicializlsa 2.048 V-ra
	while(!FVR_STATUS);				//kivrjuk, amg FVR stabil lesz
	InitADC();						//AN10 kivlasztsa, 20TAD, FOSC/64, jobbra igazts
    while (!usb_cdc_kbhit()) {
        ProcessIO();                //-- Megvrjuk az els karakter rkezst
    }
	outString("PICCOLO-14K50 themometer2.c program\n");
    while (1) {
		a=0; b=0; c=0;
		for(j=0; j<2048; j++) {
			a += ReadADC(15);		//FVR mrse				
			b += ReadADC(10);		//A potmterrl jv feszltsget mri
			c += ReadADC(11);		//hmr mrse	
		}
		vref=a>>11;					//Vref = a / 1024
		a=1023L*2048L/vref;			//VDD mV-okra tszmtva
		outString(" Vdd = ");
		outdec(a,3);				//Hrom tizedesre rjuk ki VDD-t
		b=b/vref;					//A feszltsg mV-ba tszmtva
		outString(" V Vpot = ");
		outdec(b,3);				//Hrom tizedesre rjuk ki Vpot-ot
		outString(" V  Hmrsklet = "); 
		c=c/vref-500L;				//konvertls tizedfok egysgekbe
		outdec(c,1); 				//Egy tizedesre rjuk ki a hmrskletet
		outString(" C \n");
		delay_ms(2000);				//2 s vrakozs s ProcessIO hvogatsa
    } //while
}     //main
