;------------------------------------------------------
; PICCOLO project
; Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
; A programhoz Karl Lunt FOR-NEXT makrit adaptltuk
; Forrs: "A High-Power PIC Macro Library" by Karl Lunt,
;          Nuts & Volts Magazine, July 1999
;------------------------------------------------------
#include "..\include\p18_all.inc"
;------------------------------------------------------
;   Helyfoglals a vltozk szmra
;------------------------------------------------------
mydata     UDATA_ACS 
i		res 1		;ciklusvltoz
j		res 1		;ciklusvltoz
a		res 2		;16 bites eredmny

	variable	_for_cnt=0
	variable	_nxt_cnt=0

;------------------------------------------------------
;  FOR (a FOR-NEXT ciklus fejrsze)
;
;  Szintaxis:
;		FOR	var,kezd,veg
;
;  A FOR makr egy FOR-NEXT ciklust indt.  
;  A paramterek:
;    var: a ciklusvlt (8-bites RAM vltoz)
;   kezd: szmkonstans, a ciklusvltoz kezdeti rtke
;    veg: szmkonstans, a ciklusvltoz vgs rtke
;------------------------------------------------------
FOR		macro	var,kezd,veg
		movlw	kezd
		movwf	var
_for#v(_for_cnt):
		movf	var,W
		sublw	veg
		bnc	_next#v(_for_cnt)
_for_cnt	set	_for_cnt+1
_nxt_cnt	set	_for_cnt
		endm
;------------------------------------------------------
;  NEXT (a FOR-NEXT ciklus vge)
;
;  Szintaxis:
;		NEXT	var
;
;  A NEXT macro lezrja a FOR-NEXT ciklust.
;  A paramterek:
;    var: a ciklusvlt (8-bites RAM vltoz)
;
;  A NEXT blokkban a var vltoz rtke inkrementldik, 
;  azutn a vezrls visszakerl a FOR ciklus elejre, 
;  a vltoz tesztelshez.
;  Fontos, hogy a paramterknt megadott ciklusvltoz 
;  egyezzen meg a FOR makr ciklusvltozjnak nevvel!
;------------------------------------------------------
NEXT	macro	var
_nxt_cnt	set	_nxt_cnt-1
		incf	var,f
		bra	_for#v(_nxt_cnt)
_next#v(_nxt_cnt):
		endm
	
PGM		CODE
;--- A fprogram ktelezen a main cmknl kezddik!-
main:
;------------------------------------------------------
; Szmok ngyzetnek kiszmtsa (90-110 kztti szmokra)
; egyszer FOR-NEXT ciklus felhasznlsval
;------------------------------------------------------
		FOR i,D'90',D'110'		;for ciklus szervezse
			movf 	i,W		
			mulwf 	i			; i*i kiszmolsa
			movff 	PRODL,a		; az eredmny eltrolsa
			movff 	PRODH,a+1
		NEXT	i				;ciklus vge
;------------------------------------------------------
; Szorztbla kiszmtsa (1x1 - tl 10x10-ig)
; egymsba gyazott FOR-NEXT ciklusok segtsgvel 
;------------------------------------------------------
		FOR i,1,D'10'
			FOR j,1,D'10'
				movf	i,W
				mulwf	j		; i*j kiszmtsa
				movff	PRODL,a
				movff	PRODH,a+1
			NEXT	j
		NEXT	i
		goto $
		end