/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include "delays.h"

char c;

/** \file
 *  Pldaprogram az alvs zemmdbl a vltozsjelz interruptal trtn bresztsre.
 *  Az SW1 nyomgombhoz tartoz bemeneten a bemeneti szint megvltozsra 
 *  bekvetkez programmegszaktst engedlyezzk. A CPU megszaktst 
 *  azonban letiltva hagyjuk, gy az interrupt krelem nem okoz megszaktst, csupn
 *  bresztst vgez.
 * 
 *  Hardver kvetelmnyek: a program az "A ksrleti ramkr" cm fejezetben bemutatott referencia 
 *  ramkrkn fut, az ramkr kiegsztsre/bvtsre nincs szksg.

 *  Projekt konfigurci: Csak a HID_BOOTLOADER szimblumot definiljuk 
 */

 ///Az SW1 nyomgombhoz tartoz vltozsjelz megszakts engedlyezse 
void initIOC(void) {
	#if defined(__18F4550)
		TRISB=0xFF;					//legyen a B port minden lba digitlis bemenet
		INTCON2bits.RBPU=0;			//legyen B port minden lba felhzva (ne lebegjen)
		c = PORTB;					//PORTB olvassa trli a korbbi bellst
		INTCONbits.RBIF=0;			//az IOCB interrupt jelzbit trlse
		INTCON2bits.RBIP=0;			//RBIF legyen alacsony priorits 
		INTCONbits.RBIE=1;			//a vltozsjelz interrupt engedlyezse		
	#elif defined(__18F14K50)
		IOCAbits.IOCA3=1;			//RA3 vltozsjelz interrupt engedlyezse
		c = PORTA;					//PORTA olvassa trli a korbbi aktivldst
		INTCONbits.RABIF=0;			//az interrupt jelzbit trlse
		INTCON2bits.RABIP=0;		//RABIF legyen alacsony priorits 
		INTCONbits.RABIE=1;			//a vltozsjelz interrupt engedlyezse
	#endif
}

///Az SW1 vltozsjelz megszaktsa jelzbitjnek trlse
void clearIOCflag(void) {
	#if defined(__18F4550)
		c=PORTB;				//PORTB jraolvassa sznteti meg a kivlt okot
		INTCONbits.RBIF=0;		//az interrupt jelzbit trlse
	#elif defined(__18F14K50)
		c=PORTA;				//PORTA jraolvassa sznteti meg a kivlt okot
		INTCONbits.RABIF=0;		//az interrupt jelzbit trlse
	#endif
}

/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja.
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param d az elrt vrakozsi id, 1 ms egysgekben
 */
void delay_ms(unsigned int d) {
unsigned int i;
	for(i=0; i<d; i++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

//-- A fprogram -------------------------------------------
void main(void) {
unsigned int i;
	mInitAllLEDs();				//LED-ek inicializlsa
	mInitSwitch1();				//SW1 inicializlsa
	RCONbits.IPEN=1;			//Ktszint megszaktsi md belltsa
	INTCONbits.GIEL=0;			//Alacsony priorits interrupt tiltsa
	initIOC();				//Interrupt-on-Change inicializlsa

	while (1) {
		for(i=0; i<20; i++) { 
	    	delay_ms(250);		//villogtatshoz ksleltets
			mLED_1_Toggle();	//LED1 llapotvlts
		}
		clearIOCflag();			//trljk az interrupt jelzbitet
		mLED_1_Off();			//Lehunyja ngy szemt a LEDport
		Sleep();				//a j CPU is aluszik...
		Nop();	
   }
}

