; PICCOLO project
; Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
;
; Ez a header llomny gondoskodik a RESET s az interupt vektorok
; thelyezsrl, s a PIC18F14K50 s a PIC18F4550 ksrleti ramkrk 
; kztti trivilis eltrsek feloldsrl. 
;
;=== BECSATOLSOK  ====================================================
#include <p18cxxx.inc> 	

;=== KONFIGURCIS BITEK BELLTSA ===================================
#ifdef __18F4550                    ; Konfigurcis bitek PIC18F4550-hez
        config PLLDIV   = 5         ; PLL oszt 20 MHz-es kristlyhoz
        config CPUDIV   = OSC1_PLL2 ; CPU rajel forrsa a 96MHz PLL/2 
        config USBDIV   = 2         ; USB rajel forrsa a 96MHz PLL/2
        config FOSC     = HSPLL_HS  ; HS oszcilltor s PLL a jelforrs
        config FCMEN    = OFF       ; Fail Safe Clock Monitor tiltsa
        config IESO     = OFF       ; Bels/kls oszcilltor tiltsa
        config PWRT     = ON        ; Bekapcsolskor 62 ms vrakozs
        config BOR      = ON        ; Brown our Reset engedlyezve
        config BORV     = 1         ; Reset szint = 2,7 V
        config VREGEN   = ON        ; VUSB bels stabiliztorrl megy 
        config WDT      = OFF       ; Watchdog timer letiltva
        config WDTPS    = 256       ; Watchdog utszmll belltsa
        config MCLRE    = ON        ; MCLR (reset) bemenet engedlyezve
        config LPT1OSC  = OFF       ; T1OSC nagyobb teljestmny zemmd
        config PBADEN   = OFF       ; PORTB<4:0> digitlis I/O-knt inicializldik
        config CCP2MX   = ON        ; RC1 legyen a CCP2 kimenet
        config STVREN   = ON        ; A verem tlcsordulsa RESET-et okoz
        config LVP      = OFF       ; Alacsonyfeszltsg programozs letiltva
        config ICPRT    = OFF       ; Dediklt programozi kivezets nincs
        config XINST    = OFF       ; Extended Instruction Set
        config DEBUG    = OFF       ; Httr nyomkvets letiltva, RB6/7 norml I/O
        config CP0      = OFF       ; Kdvdelem kikapcsolva
        config CP1      = OFF
        config CP2      = OFF
        config CP3      = OFF
        config CPB      = OFF
        config CPD      = OFF
        config WRT0     = OFF       ; rsvdelem kikapcsolva
        config WRT1     = OFF
        config WRT2     = OFF
        config WRT3     = OFF
        config WRTB     = OFF       ; Boot Blokk rsvdelem kikapcsolva
        config WRTC     = OFF       ; Konfigurcis blokk rsvdelem kikapcsolva
        config WRTD     = OFF       ; EEPROM adattr rsvdelme kikapcsolva
        config EBTR0    = OFF       ; Tblzatolvass ne legyen letiltva
        config EBTR1    = OFF
        config EBTR2    = OFF
        config EBTR3    = OFF
        config EBTRB    = OFF       ; Boot blokk tblaolvassa ne legyen letiltva

#else
  #ifdef __18F14K50                 ; PIC18F14K50 konfigurci 12 MHz-es kristlyhoz
        config CPUDIV   = NOCLKDIV  ; Nem osztjuk le az rajelet (48 MHz)  
        config USBDIV   = OFF       ; USB-hez nem osztjuk le az rajelet
        config FOSC     = HS        ; HS oszcilltor (12 MHz)
        config PLLEN    = ON        ; 4x PLL engedlyezs (4x12 = 48 MHz)
        config PCLKEN   = ON        ; Elsdleges rajelgenertor engedlyezve 
        config FCMEN    = OFF       ; Fail Safe Clock Monitor tiltsa
        config IESO     = OFF       ; Bels/kls oszcilltor tkapcsols tiltsa
        config PWRTEN   = ON        ; Bekapcsolskor 62 ms vrakozs
        config BOREN    = SBORDIS   ; Brown-out Reset hardveresen engedlyezve
        config BORV     = 27        ; Reset szint = 2,7 V
        config WDTEN    = OFF       ; Watchdog timer letiltva
        config WDTPS    = 256       ; Watchdog utszmll belltsa
        config MCLRE    = OFF       ; MCLR (reset) bemenet letiltva, RA3 bemenet
        config HFOFST   = ON        ; Rendszer ra nem vr HFINTOSC-ra
        config STVREN   = ON        ; A verem tlcsordulsa RESET-et okoz
        config LVP      = OFF       ; Alacsonyfeszltsg programozs letiltva
        config XINST    = OFF       ; Extended Instruction Set
        config BBSIZ    = ON        ; 4 kB boot blokk mret (HID bootloaderhez)
        config CP0      = OFF       ; Kdvdelem kikapcsolva
        config CP1      = OFF
        config CPB      = OFF
        config WRT0     = OFF       ; rsvdelem kikapcsolva
        config WRT1     = OFF
        config WRTB     = ON        ; Boot Blokk rsvdelem bekapcsolva
        config WRTC     = OFF       ; Konfigurcis blokk rhat
        config EBTR0    = OFF       ; Tblzatolvass ne legyen letiltva
        config EBTR1    = OFF
        config EBTRB    = ON        ; Boot Blokk tblaolvass letiltva  
  #else
        error "A vlasztott mikrovezrl tpust nem tmogatja a PICCOLO project!"
  #endif
#endif  
	 
;=== VEKTOROK THELYEZSE =============================================
; Ha a felhasznli programban hasznlja a programmegszaktsokat, akkor
; a program legelejn definilni kell az "USE_INTERRUPT" szimblumot
; s gondoskodni kell a programmegszaktsokat kiszolgl eljrsokrl
; hi_isr s lo_isr nev belpsi pontokkal!
; 
; Ha a USE_INTERRUPT szimblum nincs definilva, akkor az albbi kd
; egy-egy "return" utastst rak be az interrupt vektorok helyre, ami
; egy vletlenl elszabadult s lekezeletlen programmegszakts
; esetn visszatr a fprogramhoz, de letiltva hagyja a 
; programmegszaktst. 
;----------------------------------------------------------------------
RST     CODE
        goto   main      ; RESET vektor: ugrs a fprogramhoz
        fill   0,4
  #IFDEF USE_INTERRUPT
        extern hi_isr    ; Magas priorits interrupt vektor:
        goto   hi_isr	 ; ugrs az interrupt kiszolgl eljrshoz
  #ELSE
	return           ; Letiltva hagyjuk az interruptot!!!
        nop
  #ENDIF		
        fill 0,0xc
  #IFDEF USE_INTERRUPT
        extern lo_isr    ; Alacsony priorits interrupt vektor:
        goto lo_isr      ; ugrs az interrupt kiszolgl eljrshoz
  #ELSE
	return           ; Letiltva hagyjuk az interruptot!!!
  #ENDIF		

;=== DEFINCIK =======================================================
#ifdef __18F14K50
  #define LEDport LATC
  #define LEDtris TRISC
  #define LED1 LATC,LATC0
  #define LED2 LATC,LATC1
  #define LED3 LATC,LATC2
  #define LED4 LATC,LATC3
  #DEFINE SW1  PORTA,RA3 
#else 
  #ifdef __18F4550
    #define LEDport LATD
    #define LEDtris TRISD
    #define LED1 LATD,LATD0
    #define LED2 LATD,LATD1
    #define LED3 LATD,LATD2
    #define LED4 LATD,LATD3
    #DEFINE SW1  PORTB,RB4
  #else
    error "A vlasztott mikrovezrl tpust nem tmogatja a PICCOLO project!" 
  #endif 
#endif
