/* PICCOLO project
 * Copyright (c) 2009-2010 Istvan Cserny (cserny@atomki.hu)
 *
 */

#include "piccolo_all.h"
#include  <stdio.h>  
#include  <delays.h>

/** \file
Az ipari szabvnynak tekinthet prhuzamos illesztvel elltott 2x16 karakateres 
LCD kijelz hasznlatt mutatja be, 8 bites mdban, printf hasznlattal. 


Hardver igny:
   - PICCOLO projekt alapkapcsols PIC18F14K50 vagy PIC18F4550 mikrovezrlvel,
     esetleg a Microchip Low Pin Count USB vagy a PICDEM Full Speed USB demkrtya
   - 2x16 karakteres LCD kijelz. Az adatvonalak a LEDport-ra legyenek ktve, 
     a vezrl vonalak pedig a B portra (E = RB7, R/W = RB6, RS = RB5) 

*/

//-- A hardverfgg rszletek elklntse ------------------
#if defined(__18F14K50)
	#define BUSY_FLAG 	PORTCbits.RC7;		// foglaltsg figyelse
#elif  defined(__18F4550)
	#define BUSY_FLAG 	PORTDbits.RD7;
#endif 

#define RSHIGH()		LATBbits.LATB5=1;	// RS vezrlse
#define RSLOW()			LATBbits.LATB5=0;
#define RS_init()		TRISBbits.TRISB5=0;
#define RWHIGH()		LATBbits.LATB6=1;	// R/W vezrlse
#define RWLOW()			LATBbits.LATB6=0;
#define RW_init()		TRISBbits.TRISB6=0;
#define EHIGH()			LATBbits.LATB7=1;	// E vezrlse
#define ELOW()			LATBbits.LATB7=0;
#define E_init()		TRISBbits.TRISB7=0;

#define DATA_DIR_RD()	LEDtris = 0xFF;		// adatvonalak belltsa olvassra
#define DATA_DIR_WR()	LEDtris = 0x00;		// adatvonalak belltsa rsra
#define OUTPUT_DATA(x) {LEDport = x;}  		//adat kikldsa

/** Ksleltet eljrs, amely a Microchip PIC18 knyvtri eljrsait hasznlja.
 * A bels ciklus kb. 1 ms ksleltetst vgez. 
 * \param d az elrt vrakozsi id, 1 ms egysgekben
 */
void delay_ms(unsigned int d) {
unsigned int i;
	for(i=0; i<d; i++) {
		Delay1KTCYx(12);		//12 000 TCY ksleltets (~ 1ms)
	}
}

//-- Az E vezrljel pulzlsa 
void epulse(void){
    Delay10TCYx(2);  
    EHIGH();  Delay10TCYx(2); 
    ELOW(); Delay10TCYx(1);
}

//-- egy karakter vagy utasts kikldse az LCD-nek 
void lcd8_write( unsigned char cmd,          //parancs vagy karakterkd  
                 unsigned char data_flag,    //1: adat, 0: parancs
                 unsigned char chk_busy)     //1: foglaltsg ellenrzse, 0: csak ksleltets
{
  char bflag;
  if (chk_busy) {
    RSLOW();					//RS = 0 az ellenrzshez
    DATA_DIR_RD();				//adatvonalaket bemenetnek lltja
    RWHIGH();					//R/W = 1, az olvasshoz
    do {
      EHIGH(); 					//adatbjt olvassa   
      Delay10TCYx(2); 
      bflag = BUSY_FLAG;		//bflag = 1 lesz foglaltsg esetn   
      ELOW(); Delay10TCYx(2);
    } while(bflag);
  } else {
    Delay1KTCYx(12);			//nem figyel foglaltsgot, csak vr 1 ms-ot  
  }
  DATA_DIR_WR();                //Az adatvonalakat rsra lltja
  if (data_flag) { RSHIGH()}	//RS=1, adatklds
  else    RSLOW();				//RS=0, parancsklds
  RWLOW();                      //R/W = 0, a kldshez
  OUTPUT_DATA(cmd);             //Adatvonalak belltsa
  epulse();                     //E vonalpulzlsa
} 

//-- Az LCD modul inicializlsa 8 bites mdban
void lcd8_init(void) {
	ELOW();						//vezrl vonalak inicializlsa
	RSLOW();  
	RWLOW(); 
	RW_init();
	RS_init();
	E_init();
	DATA_DIR_WR();				//adatvonalak belltsa kimenetnek
//-- Szoftver reset --------------------
	Delay10KTCYx(60);			//50 ms (>40 ms) vrakozs az eszkz felledsre
 	lcd8_write(0x30,0,0);		//szoftveres reset 1.
 	Delay10KTCYx(6);			//5 ms vrakozs (> 4.1 ms)
 	lcd8_write(0x30,0,0);		//szoftveres reset 2.
 	Delay1KTCYx(2);				//166 us vrakozs (> 100 us)
 	lcd8_write(0x30,0,0);		//szoftveres reset 3.
//-- Inicializls --------------------
	lcd8_write(0x38,0,0);		//8 bites md, 2 sor, 5x7 font
//-- Innen kezdve figyelhetjk a foglaltsgot
	lcd8_write(0x08,0,1);		//display off
	lcd8_write(0x01,0,1);		//kpernytrls, kurzor kezdhelyre klds
	lcd8_write(0x0C,0,1);		//megjelents engedlyezse, kurzor letiltsa
    stdout = _H_USER;           // a felhasznli fggvny legyen a
                                // standard kimenet, ami az LCD-re r
}    

//-- karakterkir fggvny, amit a stdio.h-ban deklarlt kimeneti
//-- fggvnyek (putc, puts, fprintf, printf) meghvhatnak.
void _user_putc (auto char c) {   
    lcd8_write(c,1,1);
}

const rom char line1[] = "<== 2x16 LCD ==>";
const rom char line2[] = "Now in 8bit mode";

void main(void){
unsigned char i,k;
  DISABLE_ALL_ANALOG();         //Minden analg bemenet tiltsa
  lcd8_init();                  //Az LCD modul inicializlsa
  while(1) {
      lcd8_write(0x01,0,1);     //kpernytrls
      delay_ms(500);
      printf(line1);            //Szvegkirs az els sorba
      delay_ms(500);
      for(i=0; i<16; i++) {
        k = (i*7) & 0x0F;       //"vletlen" szm ellltsa
        lcd8_write(0xC0+k,0,1); //Kurzor pozicionlsa
        putc(line2[k],stdout);  //szvegkirs a msodik sorba
        delay_ms(120);
      } 
      delay_ms(2000);
  }
}
